/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupportFactory;

public class SoapServerSupport {
    private static final String CACHED_REQ_ATTR_NAME = SoapServerSupport.class.getName();
    protected XmlObject envelope;
    protected XmlObject header;
    protected XmlObject body;
    protected List<XmlObject> headers = Collections.emptyList();
    protected List<XmlObject> bodyElements;
    protected InvalidRequestException invalidRequestException;

    public SoapServerSupport(InvalidRequestException invalidRequestException, XmlObject xml) {
        this.invalidRequestException = invalidRequestException;
        this.envelope = xml;
    }

    public XmlObject getFirstElementInBody() throws InvalidRequestException {
        this.checkThrow();
        XmlObject obj = null;
        try {
            obj = this.bodyElements.iterator().next();
        }
        catch (NoSuchElementException e) {
            throw new InvalidRequestException("SOAP body contains no content.", e);
        }
        return obj;
    }

    public List<XmlObject> getBodyElements() {
        return this.bodyElements;
    }

    public List<XmlObject> getHeaderMessages() throws InvalidRequestException {
        this.checkThrow();
        return this.headers;
    }

    public List<XmlObject> getHeaderMessagesUnchecked() {
        return this.headers;
    }

    public XmlObject getHeader() throws InvalidRequestException {
        this.checkThrow();
        return this.header;
    }

    public XmlObject getBody() throws InvalidRequestException {
        this.checkThrow();
        return this.body;
    }

    public XmlObject getEnvelope() throws InvalidRequestException {
        this.checkThrow();
        return this.envelope;
    }

    public String getXmlNamespaceURI() throws InvalidRequestException {
        return this.getEnvelope().schemaType().getDocumentElementName().getNamespaceURI();
    }

    protected void checkThrow() throws InvalidRequestException {
        if (this.invalidRequestException != null) {
            throw this.invalidRequestException;
        }
    }

    public static SoapServerSupport getSupport(HttpServletRequest req) {
        SoapServerSupport soapServerSupport = (SoapServerSupport)req.getAttribute(CACHED_REQ_ATTR_NAME);
        if (soapServerSupport == null) {
            soapServerSupport = SoapServerSupport.parseFromRequest(req);
            req.setAttribute(CACHED_REQ_ATTR_NAME, (Object)soapServerSupport);
        }
        return soapServerSupport;
    }

    private static SoapServerSupport parseFromRequest(HttpServletRequest request) {
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((InputStream)request.getInputStream(), XmlObject.class);
            return SoapServerSupportFactory.createSupport(xmlObject);
        }
        catch (Exception e) {
            return new SoapServerSupport(new InvalidRequestException(e), null);
        }
    }
}

