/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.common.soap.soap11.Soap11ServerSupport;
import org.sourceid.common.soap.soap12.Soap12ServerSupport;

public abstract class SoapServerSupportFactory {
    private static final Map<String, SoapServerSupportFactory> factories = new HashMap<String, SoapServerSupportFactory>();

    static SoapServerSupport createSupport(XmlObject env) {
        String namespaceURI = XmlBeansUtil.getNamespaceUri(env);
        SoapServerSupportFactory soapServerSupportFactory = factories.get(namespaceURI);
        if (soapServerSupportFactory == null) {
            return new SoapServerSupport(new InvalidRequestException("Unkown soap namespace: " + namespaceURI), env);
        }
        return soapServerSupportFactory.create(env);
    }

    abstract SoapServerSupport create(XmlObject var1);

    static {
        factories.put("http://schemas.xmlsoap.org/soap/envelope/", new SoapServerSupportFactory(){

            @Override
            SoapServerSupport create(XmlObject soapEnvelope) {
                return new Soap11ServerSupport(soapEnvelope);
            }
        });
        factories.put("http://www.w3.org/2003/05/soap-envelope", new SoapServerSupportFactory(){

            @Override
            SoapServerSupport create(XmlObject soapEnvelope) {
                return new Soap12ServerSupport(soapEnvelope);
            }
        });
    }
}

