/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap.soap11;

import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.util.tls.SingleClientX509KeyManager;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.sourceid.config.ConfigurationException;

public class SoapClientSocketFactory {
    private static Log logger = LogFactory.getLog(SoapClientSocketFactory.class);
    private SSLSocketFactory socketFactory = null;
    private SSLConnectionSocketFactory sslConnSocketFactory = null;
    private static final boolean VERIFY_HOSTNAME_DEFAULT = true;

    public SoapClientSocketFactory(boolean disableCertChainValidation) {
        this(null, disableCertChainValidation, true);
    }

    public SoapClientSocketFactory(boolean disableCertChainValidation, boolean verifyHostname) {
        this(null, disableCertChainValidation, verifyHostname);
    }

    public SoapClientSocketFactory(String alias, boolean disableCertChainValidation) {
        this(alias, disableCertChainValidation, true);
    }

    public SoapClientSocketFactory(String alias, boolean disableServerCertChainValidation, boolean verifyHostname) {
        try {
            SSLContext sslcontext = this.getContext(alias, disableServerCertChainValidation);
            HostnameVerifier verifier = verifyHostname ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
            this.sslConnSocketFactory = new SSLConnectionSocketFactory(sslcontext, verifier);
            this.socketFactory = sslcontext.getSocketFactory();
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Could not initialize SSL socket factory due to error.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize SSL socket factory due to error.", (Throwable)e);
            throw new ConfigurationException("Unable to initialize SSL socket factory.", e);
        }
    }

    public SSLConnectionSocketFactory getSSLConnSocketFactory() {
        return this.sslConnSocketFactory;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    private SSLContext getContext(String alias, boolean disableCertChainValidation) throws GeneralSecurityException {
        KeyManager[] km = alias != null ? new KeyManager[]{new SingleClientX509KeyManager(alias)} : new KeyManager[]{};
        TrustManager[] trustManagers = new TrustManager[]{new TrustManagerWrapper(PingSslClientTrustManager.getInstance(), disableCertChainValidation)};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(km, trustManagers, null);
        return context;
    }

    private static class TrustManagerWrapper
    implements X509TrustManager {
        private X509TrustManager delegate;
        private boolean disableServerCertChainValidation;

        public TrustManagerWrapper(X509TrustManager trustManager, boolean disableServerCertChainValidation) {
            this.delegate = trustManager;
            this.disableServerCertChainValidation = disableServerCertChainValidation;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.delegate.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (this.disableServerCertChainValidation) {
                    logger.debug((Object)("Bad server cert - ignoring: " + e));
                }
                throw e;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }
}

