/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap.soap11;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.common.soap.soap11.Soap11ServerSupport;
import org.sourceid.protocol.soap11.xml.Body;
import org.sourceid.protocol.soap11.xml.EnvelopeDocument;
import org.sourceid.protocol.soap11.xml.Fault;
import org.sourceid.protocol.soap11.xml.FaultDocument;

public class SoapEndpointUtility {
    public static final QName CLIENT_FAULT_CODE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    public static final QName SERVER_FAULT_CODE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static Log logger = LogFactory.getLog(SoapEndpointUtility.class);

    public static XmlObject getProtocolMessage(HttpServletRequest request) throws InvalidRequestException {
        return SoapServerSupport.getSupport(request).getFirstElementInBody();
    }

    public static EnvelopeDocument getSoapEnvelope(HttpServletRequest request) throws InvalidRequestException {
        SoapServerSupport support = SoapServerSupport.getSupport(request);
        Soap11ServerSupport oneoneSupport = (Soap11ServerSupport)support;
        return oneoneSupport.getEnvelopeDocument();
    }

    public static List<XmlObject> getHeaderMessages(HttpServletRequest request) throws InvalidRequestException {
        return SoapServerSupport.getSupport(request).getHeaderMessages();
    }

    public static List<XmlObject> getHeaderMessagesUnchecked(HttpServletRequest request) {
        return SoapServerSupport.getSupport(request).getHeaderMessagesUnchecked();
    }

    public static void writeSoapFault(HttpServletResponse response, QName faultCode, String faultString) throws IOException {
        logger.warn((Object)("Writing SOAP fault response " + faultString + " " + faultCode));
        EnvelopeDocument soapResponse = EnvelopeDocument.Factory.newInstance();
        Body responseBody = soapResponse.addNewEnvelope().addNewBody();
        Fault fault = Fault.Factory.newInstance();
        fault.setFaultcode(faultCode);
        fault.setFaultstring(faultString);
        FaultDocument faultDoc = FaultDocument.Factory.newInstance();
        faultDoc.setFault(fault);
        responseBody.set((XmlObject)faultDoc);
        response.setStatus(500);
        response.setContentType("text/xml");
        XmlBeansUtil.save((XmlObject)soapResponse, response.getWriter());
        response.flushBuffer();
    }
}

