/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common.soap.soap11;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sourceid.common.soap.soap11.SoapClientSocketFactory;
import org.sourceid.common.soap.soap11.SoapHttpConnectionPoolingManagerException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.SoapAuthStoreFactory;

public class SoapHttpConnectionPoolingManager {
    private static final String CONNECT_TIMEOUT = "ConnectionTimeOut";
    private static final String REQUEST_TIMEOUT = "RequestTimeOut";
    private static final String MAX_DEFAULT_CONNECTIONS_PER_ROUTE = "MaxHostConnections";
    private static final String CONN_IDLE_TIMEOUT = "ConnectionIdleTimeout";
    private static final String DEFAULT_KEEP_ALIVE_TIMEOUT = "KeepaliveTimeout";
    private static final String VERIFY_HOSTNAME = "VerifyHostname";
    private static final String CLEANUP_DELAY_SECS = "CleanupDelaySecs";
    private static int DEFAULT_CONNECT_TIMEOUT;
    private static int DEFAULT_REQUEST_TIMEOUT;
    private static long IDLE_TIMEOUT;
    private static int DEFAULT_KEEP_ALIVE;
    private boolean verifyHostname;
    private static Log log;
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.common.SoapClient");
    private final Map<CacheKey, Client> clients = new ConcurrentHashMap<CacheKey, Client>();
    private final Timer cleanupTimer = new Timer(this.getClass().getName(), true);

    private SoapHttpConnectionPoolingManager() {
        this.verifyHostname = this.configStore.getBooleanValue(VERIFY_HOSTNAME, true);
        DEFAULT_CONNECT_TIMEOUT = this.configStore.getIntValue(CONNECT_TIMEOUT, (int)TimeUnit.SECONDS.toMillis(60L));
        DEFAULT_REQUEST_TIMEOUT = this.configStore.getIntValue(REQUEST_TIMEOUT, (int)TimeUnit.SECONDS.toMillis(120L));
        IDLE_TIMEOUT = this.configStore.getLongValue(CONN_IDLE_TIMEOUT, (int)TimeUnit.SECONDS.toMillis(30L));
        DEFAULT_KEEP_ALIVE = this.configStore.getIntValue(DEFAULT_KEEP_ALIVE_TIMEOUT, (int)TimeUnit.SECONDS.toMillis(1L));
        log.info((Object)("ConnectionTimeOut " + DEFAULT_CONNECT_TIMEOUT));
        log.info((Object)("RequestTimeOut " + DEFAULT_REQUEST_TIMEOUT));
        log.info((Object)("VerifyHostname " + this.verifyHostname));
        IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread();
        Executors.newSingleThreadExecutor(new DaemonThreadFactory()).submit(monitor);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.clear()));
    }

    private Client getClient(String providerId, URI url) {
        CacheKey key = new CacheKey(providerId, url);
        Client client = this.clients.get(key);
        if (client != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reusing existing client for endpoint " + url + " / " + providerId));
            }
            return client;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new client for endpoint " + url + " / " + providerId + ", connect timeout = " + DEFAULT_CONNECT_TIMEOUT + ", request timeout = " + DEFAULT_REQUEST_TIMEOUT));
        }
        String protocol = url.getScheme();
        String host = url.getHost();
        int port = url.getPort();
        SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
        SoapAuthInfo outgoingAuth = soapAuthStore.getOutgoing(providerId);
        boolean isHttps = "https".equals(protocol);
        boolean disableCertChainValidation = outgoingAuth.isDisableCertChainValidation();
        SoapClientSocketFactory sslSocketFactory = null;
        HttpHost targetHost = new HttpHost(host, port, protocol);
        HttpClientContext context = HttpClientContext.create();
        if (outgoingAuth.isHasBasicEntry()) {
            SoapAuthInfo.OutgoingBasicAuthInfo basicInfo = (SoapAuthInfo.OutgoingBasicAuthInfo)outgoingAuth.getBasicAuthInfo();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication type = basic, username = " + basicInfo.getUsername()));
            }
            SystemDefaultCredentialsProvider credsProvider = new SystemDefaultCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(basicInfo.getUsername(), basicInfo.getPassword()));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
        }
        if (outgoingAuth.isHasCertEntry()) {
            if (!isHttps) {
                log.info((Object)("Cannot use outgoing cert auth for non https url: " + url));
            } else {
                SoapAuthInfo.CertAuthInfo certInfo = outgoingAuth.getCertAuthInfo();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authentication type = cert, alias = " + certInfo.getAlias()));
                }
                boolean verifyHostname = this.verifyHostname && !disableCertChainValidation;
                sslSocketFactory = new SoapClientSocketFactory(certInfo.getAlias(), disableCertChainValidation, verifyHostname);
            }
        }
        if (outgoingAuth.isHasNoneEntry() && log.isDebugEnabled()) {
            log.debug((Object)"Authentication type = none.");
        }
        if (isHttps && sslSocketFactory == null) {
            boolean verifyHostname = this.verifyHostname && !disableCertChainValidation;
            sslSocketFactory = new SoapClientSocketFactory(disableCertChainValidation, verifyHostname);
        }
        DefaultProxyRoutePlanner routePlanner = null;
        List<Proxy> proxies = ProxySelector.getDefault().select(url);
        Proxy proxy = null;
        for (Proxy p : proxies) {
            switch (p.type()) {
                case HTTP: {
                    proxy = p;
                    break;
                }
            }
        }
        if (proxy != null) {
            if (!(proxy.address() instanceof InetSocketAddress)) {
                log.error((Object)("Unable to handle non-Inet proxy address: " + proxy.address()));
            } else {
                InetSocketAddress isa = (InetSocketAddress)proxy.address();
                String proxyHost = isa.isUnresolved() ? isa.getHostName() : isa.getAddress().getHostAddress();
                HttpHost httpProxyHost = new HttpHost(proxyHost, isa.getPort());
                routePlanner = new DefaultProxyRoutePlanner(httpProxyHost);
            }
        }
        SSLConnectionSocketFactory socketFactory = null;
        PoolingHttpClientConnectionManager connMgr = null;
        if (isHttps) {
            socketFactory = sslSocketFactory.getSSLConnSocketFactory();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)socketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        } else {
            connMgr = new PoolingHttpClientConnectionManager();
        }
        int maxPerRoute = this.configStore.getIntValue(MAX_DEFAULT_CONNECTIONS_PER_ROUTE, 32);
        connMgr.setMaxTotal(maxPerRoute);
        connMgr.setDefaultMaxPerRoute(maxPerRoute);
        log.info((Object)("MaxHostConnections " + connMgr.getDefaultMaxPerRoute()));
        log.info((Object)("KeepaliveTimeout " + DEFAULT_KEEP_ALIVE));
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(DEFAULT_REQUEST_TIMEOUT).setConnectTimeout(DEFAULT_CONNECT_TIMEOUT).setSocketTimeout(DEFAULT_CONNECT_TIMEOUT).build();
        ConnectionKeepAliveStrategy keepAliveStrategy = (response, httpContext) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return DEFAULT_KEEP_ALIVE;
        };
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setUserAgent("PingFederate").setConnectionManager((HttpClientConnectionManager)connMgr).setKeepAliveStrategy(keepAliveStrategy).setDefaultRequestConfig(defaultRequestConfig).setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        this.clients.putIfAbsent(key, new Client(httpClient, context, connMgr));
        return this.clients.get(key);
    }

    public static SoapHttpConnectionPoolingManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    public String doRequest(String providerId, URL endpoint, HttpRequestBase request) throws IOException, SoapHttpConnectionPoolingManagerException {
        int statusCode;
        CloseableHttpResponse response;
        String responseContent;
        block7: {
            String string;
            Client client = this.getClient(providerId, request.getURI());
            if (client == null || client.getHttpClient() == null) {
                throw new IOException("No Client for (" + providerId + ", " + endpoint + ")");
            }
            CloseableHttpClient httpClient = client.getHttpClient();
            responseContent = "";
            response = null;
            HttpEntity entity = null;
            try {
                response = httpClient.execute((HttpUriRequest)request, (HttpContext)client.getContext());
                statusCode = response.getStatusLine().getStatusCode();
                entity = response.getEntity();
                if (entity != null) {
                    responseContent = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                }
                if (200 != statusCode) break block7;
                string = responseContent;
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(entity);
                if (response != null) {
                    response.close();
                }
                throw throwable;
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
            if (response != null) {
                response.close();
            }
            return string;
        }
        throw new SoapHttpConnectionPoolingManagerException(String.valueOf(statusCode), response.getStatusLine().getReasonPhrase(), responseContent);
    }

    public void delayedClear() {
        log.info((Object)"Clearing HTTP client cache");
        final List<Client> removedClients = this.removeClients();
        this.cleanupTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                int clientsToCleanup = removedClients.size();
                if (clientsToCleanup > 0) {
                    log.debug((Object)("Cleaning up " + clientsToCleanup + " HTTP clients"));
                }
                removedClients.forEach(client -> SoapHttpConnectionPoolingManager.this.clearClient((Client)client));
            }
        }, 1000L * (long)this.configStore.getIntValue(CLEANUP_DELAY_SECS, 10));
    }

    public void clear() {
        log.info((Object)("Shutting down the " + this.getClass().getSimpleName()));
        this.removeClients().forEach(client -> this.clearClient((Client)client));
        log.info((Object)(this.getClass().getSimpleName() + " shut down"));
    }

    private List<Client> removeClients() {
        HashSet<CacheKey> keysToRemove = new HashSet<CacheKey>(this.clients.keySet());
        ArrayList<Client> removedClients = new ArrayList<Client>();
        for (CacheKey key : keysToRemove) {
            Client client = this.clients.remove(key);
            if (client == null) continue;
            removedClients.add(client);
        }
        return removedClients;
    }

    private void clearClient(Client client) {
        try {
            PoolingHttpClientConnectionManager connMgr;
            CloseableHttpClient httpClient = client.getHttpClient();
            if (httpClient != null) {
                httpClient.close();
            }
            if ((connMgr = client.getConnMgr()) != null) {
                connMgr.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"could not close httpClient");
        }
    }

    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    static {
        log = LogFactory.getLog(SoapHttpConnectionPoolingManager.class);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class Client {
        private final CloseableHttpClient httpClient;
        private final HttpClientContext context;
        private final PoolingHttpClientConnectionManager connMgr;

        public Client(CloseableHttpClient client, HttpClientContext context, PoolingHttpClientConnectionManager connMgr) {
            this.httpClient = client;
            this.context = context;
            this.connMgr = connMgr;
        }

        public CloseableHttpClient getHttpClient() {
            return this.httpClient;
        }

        public HttpClientContext getContext() {
            return this.context;
        }

        public PoolingHttpClientConnectionManager getConnMgr() {
            return this.connMgr;
        }
    }

    private static class CacheKey {
        String id;
        URI url;

        public CacheKey(String id, URI url) {
            this.id = id;
            this.url = url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public class IdleConnectionMonitorThread
    extends Thread {
        private volatile boolean shutdown;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        for (Client client : SoapHttpConnectionPoolingManager.this.clients.values()) {
                            PoolingHttpClientConnectionManager connMgr = client.getConnMgr();
                            connMgr.closeExpiredConnections();
                            connMgr.closeIdleConnections(IDLE_TIMEOUT, TimeUnit.MILLISECONDS);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.shutdown = true;
                this.notifyAll();
            }
        }
    }

    private static class LazyHolder {
        private static final SoapHttpConnectionPoolingManager INSTANCE = new SoapHttpConnectionPoolingManager();

        private LazyHolder() {
        }
    }
}

