/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.config;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.configservice.impl.ConfigStoreFactoryImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.mina.util.ConcurrentHashSet;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFactory;
import org.sourceid.config.ConfigStoreLocation;

public class ConfigStoreFarm {
    private static ConfigStoreFactory factory = new ConfigStoreFactoryImpl();
    private static Collection<Reloadable> reloadables = new LinkedList<Reloadable>();
    private static final Set<String> apiDenySet = new ConcurrentHashSet();

    public static ConfigStore getConfig(Class c) {
        return ConfigStoreFarm.getConfig(c, false);
    }

    public static ConfigStore getConfig(Class c, boolean addToDenySet) {
        String name = c.getName();
        return ConfigStoreFarm.getConfig(name, addToDenySet);
    }

    public static ConfigStore getConfig(String name) {
        return ConfigStoreFarm.getConfig(name, false);
    }

    public static ConfigStore getConfig(String name, boolean addToDenySet) {
        return ConfigStoreFarm.getConfig(ConfigStoreLocation.DEFAULT, name, addToDenySet);
    }

    public static ConfigStore getConfig(ConfigStoreLocation location, String name) {
        return ConfigStoreFarm.getConfig(location, name, false);
    }

    public static ConfigStore getConfig(ConfigStoreLocation location, String name, boolean addToDenySet) {
        ConfigStore result = factory.getConfig(location, name);
        if (addToDenySet) {
            ConfigStoreFarm.addToApiDenySet(name);
        }
        return result;
    }

    public static Set<String> getStoreNameSet(ConfigStoreLocation location) {
        File file = new File(location.getDirectory());
        String[] stores = file.list();
        HashSet<String> set = new HashSet<String>();
        if (stores != null) {
            for (String store : stores) {
                if (!store.endsWith(".xml")) continue;
                store = store.substring(0, store.lastIndexOf(".xml"));
                set.add(store);
            }
        }
        return set;
    }

    public static void reloadAll() {
        for (Reloadable r : reloadables) {
            r.reload();
        }
    }

    public static void registerForReloadEvents(Reloadable reloadable) {
        reloadables.add(reloadable);
    }

    public static void unregisterForReloadEvents(Reloadable reloadable) {
        reloadables.remove(reloadable);
    }

    public static void addToApiDenySet(String name) {
        apiDenySet.add(name.toLowerCase());
    }

    public static boolean isInApiDenySet(String name) {
        return apiDenySet.contains(name.toLowerCase());
    }

    private static void fillApiDenySet() {
        ConfigStoreFarm.addToApiDenySet("adapter-selectors");
        ConfigStoreFarm.addToApiDenySet("bearer-access-token-management-plugins");
        ConfigStoreFarm.addToApiDenySet("identity-store-provisioners");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.AdapterManagerImpl");
        ConfigStoreFarm.addToApiDenySet("password-credential-validators");
        ConfigStoreFarm.addToApiDenySet("token-generators");
        ConfigStoreFarm.addToApiDenySet("token-processors");
        ConfigStoreFarm.addToApiDenySet("notification-sender");
        ConfigStoreFarm.addToApiDenySet("oob-auth-plugins");
        ConfigStoreFarm.addToApiDenySet("dynamic-client-registration");
        ConfigStoreFarm.addToApiDenySet("com.pingidentity.page.Login");
        ConfigStoreFarm.addToApiDenySet("oauth-authz-server-settings.xml");
        ConfigStoreFarm.addToApiDenySet("oauth-scope-policy");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.config.CoreConfig");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.DSigPkCertManager");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.SslAuthPkCertManager");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.SslServerPkCertManagerImpl");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateScheduleManagerImpl");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.NotificationManager");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.saml20.domain.mgmt.impl.TargetResourceValidationMgrImpl");
        ConfigStoreFarm.addToApiDenySet("revocation-checking-config");
        ConfigStoreFarm.addToApiDenySet("session-mgmt-settings");
        ConfigStoreFarm.addToApiDenySet("wstrust-basic-auth");
        ConfigStoreFarm.addToApiDenySet("wstrust-client-cert-auth");
        ConfigStoreFarm.addToApiDenySet("com.pingidentity.draft.mgmt.DraftManagerImpl");
        ConfigStoreFarm.addToApiDenySet("org.sourceid.util.license.Synchronizer");
        ConfigStoreFarm.addToApiDenySet("virtual-host-names");
        ConfigStoreFarm.addToApiDenySet("com.pingidentity.crypto.jwk.MasterKeySet");
        ConfigStoreFarm.addToApiDenySet("secret-managers");
        ConfigStoreFarm.addToApiDenySet("authorization-detail-processors");
        ConfigStoreFarm.addToApiDenySet("captcha-providers");
    }

    static {
        ConfigStoreFarm.fillApiDenySet();
    }
}

