/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.config;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.HashedPassword;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ByteUtil;
import org.sourceid.common.Util;

public class SoapAuthInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String entityId;
    private BasicAuthInfo basicAuthInfo;
    private CertAuthInfo certAuthInfo;
    private boolean hasNoneEntry;
    private boolean ssl;
    private boolean disableCertChainValidation;

    public SoapAuthInfo(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public BasicAuthInfo getBasicAuthInfo() {
        return this.basicAuthInfo;
    }

    public void setBasicAuthInfo(BasicAuthInfo basicAuthInfo) {
        this.basicAuthInfo = basicAuthInfo;
    }

    public CertAuthInfo getCertAuthInfo() {
        return this.certAuthInfo;
    }

    public void setCertAuthInfo(CertAuthInfo certAuthInfo) {
        this.certAuthInfo = certAuthInfo;
    }

    public boolean isHasCertEntry() {
        return this.certAuthInfo != null;
    }

    public boolean isHasBasicEntry() {
        return this.basicAuthInfo != null;
    }

    public boolean isHasNoneEntry() {
        return this.hasNoneEntry;
    }

    public void setHasNoneEntry(boolean hasNoneEntry) {
        this.hasNoneEntry = hasNoneEntry;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isDisableCertChainValidation() {
        return this.disableCertChainValidation;
    }

    public void setDisableCertChainValidation(boolean disableCertChainValidation) {
        this.disableCertChainValidation = disableCertChainValidation;
    }

    public SoapAuthInfo clone() {
        SoapAuthInfo clone = new SoapAuthInfo(this.entityId);
        clone.basicAuthInfo = this.basicAuthInfo != null ? this.basicAuthInfo.clone() : null;
        clone.certAuthInfo = this.certAuthInfo != null ? this.certAuthInfo.clone() : null;
        clone.hasNoneEntry = this.hasNoneEntry;
        clone.ssl = this.ssl;
        clone.disableCertChainValidation = this.disableCertChainValidation;
        return clone;
    }

    public static class CertAuthInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private String subjectDN;
        private String issuerDN;
        protected X509Certificate cert;
        protected String alias;

        public CertAuthInfo(String subjectDN, String issuerDN, X509Certificate cert, String alias) {
            this.subjectDN = subjectDN;
            this.issuerDN = issuerDN;
            this.cert = cert;
            this.alias = alias;
        }

        public String getSubjectDN() {
            return this.subjectDN;
        }

        public String getIssuerDN() {
            return this.issuerDN;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isAnchored() {
            return StringUtils.isBlank((String)this.alias) && this.cert == null;
        }

        public CertAuthInfo clone() {
            try {
                super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            CertAuthInfo clone = new CertAuthInfo(this.subjectDN, this.issuerDN, this.cert, this.alias);
            return clone;
        }
    }

    public static class IncomingBasicAuthInfo
    extends BasicAuthInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private String newPassword;

        public IncomingBasicAuthInfo(String username, String encodedPassword) {
            super(username, encodedPassword);
        }

        public boolean checkSecret(String password) {
            if (HashedPassword.isEncodedText(this.getEncodedPassword())) {
                HashedPassword hashedPassword = HashedPassword.fromEncodedText(this.getEncodedPassword());
                return hashedPassword.checkSecret(password);
            }
            String expectedSecretVal = Obfuscator.deobfuscate(this.getEncodedPassword());
            byte[] sharedSecretBytes = password.getBytes(Util.UTF8CS);
            byte[] expectedSharedSecretBytes = expectedSecretVal.getBytes(Util.UTF8CS);
            return ByteUtil.secureEquals(sharedSecretBytes, expectedSharedSecretBytes);
        }

        @Override
        public IncomingBasicAuthInfo clone() {
            return new IncomingBasicAuthInfo(this.getUsername(), this.getEncodedPassword());
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }

    public static class OutgoingBasicAuthInfo
    extends BasicAuthInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;

        public static OutgoingBasicAuthInfo fromClearPassword(String username, String clearPassword) {
            String encryptedPassword = Obfuscator.obfuscate(clearPassword);
            return new OutgoingBasicAuthInfo(username, encryptedPassword);
        }

        public OutgoingBasicAuthInfo(String username, String encryptedPassword) {
            super(username, encryptedPassword);
        }

        public String getPassword() {
            return Obfuscator.deobfuscate(this.getEncodedPassword());
        }

        @Override
        public OutgoingBasicAuthInfo clone() {
            return new OutgoingBasicAuthInfo(this.getUsername(), this.getEncodedPassword());
        }
    }

    public static abstract class BasicAuthInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private final String username;
        private final String encodedPassword;

        public abstract BasicAuthInfo clone();

        public BasicAuthInfo(String username, String encodedPassword) {
            this.username = username;
            this.encodedPassword = encodedPassword;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEncodedPassword() {
            return this.encodedPassword;
        }
    }
}

