/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.jose.jwk;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.jose.jwk.AccessTokenMgmtJwkPublishUtil;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class JwkHandler
implements BasicHttpRequestHandler {
    private final SimpleJsonRespWriter simpleJsonRespWriter = new SimpleJsonRespWriter();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private final JWKSEndpointManager jwksEndpointManager;
    private static final Log log = LogFactory.getLog(JwkHandler.class);

    public JwkHandler(JWKSEndpointManager jwksEndpointManager) {
        this.jwksEndpointManager = jwksEndpointManager;
    }

    @Override
    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException, HttpStatusCodeException {
        this.simpleJsonRespWriter.prepHeaders(resp);
        PrintWriter writer = resp.getWriter();
        JsonWebKeySet oAuthOidcJwks = this.oAuthIssuerUtils.getIssuersJsonWebKeySet(req);
        JsonWebKeySet accessTokenManagementJwks = AccessTokenMgmtJwkPublishUtil.getAllAccessTokenManagementJWKSToPublish();
        LinkedList jwks = new LinkedList();
        List oAuthOidcJsonWebKeys = null;
        if (oAuthOidcJwks != null && oAuthOidcJwks.getJsonWebKeys() != null && !oAuthOidcJwks.getJsonWebKeys().isEmpty()) {
            oAuthOidcJsonWebKeys = oAuthOidcJwks.getJsonWebKeys();
            jwks.addAll(oAuthOidcJsonWebKeys);
        }
        if (accessTokenManagementJwks != null && accessTokenManagementJwks.getJsonWebKeys() != null && !accessTokenManagementJwks.getJsonWebKeys().isEmpty()) {
            jwks.addAll(accessTokenManagementJwks.getJsonWebKeys());
            this.handleCollidingKeyIds(oAuthOidcJsonWebKeys);
        }
        JsonWebKeySet jwksToPublish = new JsonWebKeySet(jwks);
        writer.write(jwksToPublish.toJson());
        this.simpleJsonRespWriter.finish(resp);
    }

    private void handleCollidingKeyIds(List<JsonWebKey> oidcOAuthJwks) {
        if (oidcOAuthJwks == null || oidcOAuthJwks.isEmpty()) {
            return;
        }
        if (!this.jwksEndpointManager.getSetting().isEnableStaticKeys()) {
            HashSet<String> keyIds = new HashSet<String>();
            for (JsonWebKey jsonWebKey : oidcOAuthJwks) {
                String pluginId;
                String keyId = jsonWebKey.getKeyId();
                if (keyId == null || keyIds.contains(keyId) || (pluginId = AccessTokenMgmtJwkPublishUtil.getAtmInstanceIdForKeyId(jsonWebKey.getKeyId(), null)) == null) continue;
                String errorMessage = "The generated Key identifier: '%s' for an OpenId Connect & OAuth key is colliding with key identifier configured for Access Token Management plugin with id '%s'. This will result in failure of access or ID token verification.";
                log.error((Object)String.format(errorMessage, keyId, pluginId));
                keyIds.add(keyId);
            }
        }
    }
}

