/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity;

import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.attrupdates.AuthSourceAttributes;
import com.unboundid.ldap.sdk.DN;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManagerLdapPingDirectoryImpl;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.domain.LocalIdentityManagementResult;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public interface LocalIdentityStorageManager<Identifier> {
    public static final Log log = LogFactory.getLog(LocalIdentityStorageManager.class);

    public static LocalIdentityStorageManager<DN> getInstance(LdapInfo.LdapType ldapType) {
        switch (ldapType) {
            case PingDirectory: 
            case UnboundID: {
                return new LocalIdentityStorageManagerLdapPingDirectoryImpl();
            }
        }
        log.error((Object)("Invalid LDAP Type" + ldapType.getDescription()));
        String message = ldapType.getDescription() + " is not a supported LDAP data store";
        throw new LocalIdentityStorageTypeNotSupportedException(message);
    }

    public LocalIdentityDTO<Identifier> addIdentity(LocalIdentityProfile var1, Map<String, FieldData<?>> var2, String var3, String var4, String var5, String var6) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> getIdentityByLink(LocalIdentityProfile var1, String var2, String var3) throws LocalIdentityStorageManagementException;

    public boolean identityExists(LocalIdentityProfile var1, String var2, String var3) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> getIdentityByDn(LocalIdentityProfile var1, DN var2) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> addConnectedIdentity(LocalIdentityProfile var1, DN var2, String var3, String var4, String var5) throws LocalIdentityStorageManagementException;

    public void removeConnectedIdentity(LocalIdentityProfile var1, DN var2, String var3, String var4) throws LocalIdentityStorageManagementException;

    public void deleteIdentity(LocalIdentityProfile var1, DN var2) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> updateIdentity(LocalIdentityProfile var1, DN var2, Map<String, FieldData<?>> var3) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> updateAuthSourceAttributes(LocalIdentityProfile var1, DN var2, LocalIdentityDTO<?> var3, AuthSourceAttributes var4) throws LocalIdentityStorageManagementException;

    public List<String> getAvailableCustomAttributes();

    public LocalIdentityDTO<Identifier> changePassword(LocalIdentityProfile var1, DN var2, String var3, String var4) throws LocalIdentityStorageManagementException;

    public LocalIdentityDTO<Identifier> setPassword(LocalIdentityProfile var1, DN var2, String var3) throws LocalIdentityStorageManagementException;

    public static class LocalIdentityStorageTypeNotSupportedException
    extends RuntimeException {
        public LocalIdentityStorageTypeNotSupportedException(String message, Throwable cause) {
            super(message, cause);
        }

        public LocalIdentityStorageTypeNotSupportedException(String message) {
            super(message);
        }

        public LocalIdentityStorageTypeNotSupportedException(Throwable cause) {
            super(cause);
        }

        public LocalIdentityStorageTypeNotSupportedException() {
        }
    }

    public static class IdentityNotFoundException
    extends LocalIdentityStorageManagementException {
        public IdentityNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public IdentityNotFoundException(String message) {
            super(message);
        }

        public IdentityNotFoundException(Throwable cause) {
            super(cause);
        }
    }

    public static class LocalIdentityStorageManagementException
    extends Exception {
        LocalIdentityManagementResult result;

        public LocalIdentityStorageManagementException(String message, Throwable cause) {
            super(message, cause);
        }

        public LocalIdentityStorageManagementException(String message) {
            super(message);
        }

        public LocalIdentityStorageManagementException(Throwable cause, LocalIdentityManagementResult result) {
            super(cause);
            this.result = result;
        }

        public LocalIdentityStorageManagementException(Throwable cause) {
            super(cause);
        }

        public LocalIdentityManagementResult getResult() {
            return this.result;
        }
    }
}

