/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity;

import com.pingidentity.common.util.ldap.LDAPCrudHelper;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.unboundidds.controls.NameWithEntryUUIDRequestControl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.localidentity.LocalIdentityStorageManagerLdapODBase;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.domain.AttributeSource;

public class LocalIdentityStorageManagerLdapPingDirectoryImpl
extends LocalIdentityStorageManagerLdapODBase {
    private static final String ENTRY_UUID_NAME = "entryUUID";
    private static final String ENTRY_UUID_NAME_TEMPLATE = "${entryUUID}";
    private static final String ENTRY_UUID_DEFAULT_VALUE = "11111111-1111-1111-1111-111111111111";
    private static final String CONFIG_FILE = "local-identity-storage-manage-ldap-ping-directory";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("local-identity-storage-manage-ldap-ping-directory");

    @Override
    protected Map<String, Object> getWriteSubstitutionValueMap(Map<String, FieldData<?>> fieldValues) {
        Map<String, Object> result = fieldValues.entrySet().stream().filter(entry -> entry.getValue() != null && ((FieldData)entry.getValue()).getFirstValue() != null).collect(Collectors.toMap(Map.Entry::getKey, o -> ((FieldData)o.getValue()).getFirstValue()));
        result.put(ENTRY_UUID_NAME, ENTRY_UUID_DEFAULT_VALUE);
        return result;
    }

    @Override
    public List<String> getAvailableCustomAttributes() {
        return Collections.singletonList(ENTRY_UUID_NAME);
    }

    @Override
    protected void addCustomLdapControl(LDAPCrudHelper ldapCrudHelper, LocalIdentityProfile localIdentityProfile) {
        DataStoreConfig dataStoreConfig = localIdentityProfile.getDataStoreConfig();
        AttributeSource attributeSource = dataStoreConfig.getAttributeSource();
        String createPattern = attributeSource.getParameter("create_pattern");
        if (createPattern != null && createPattern.contains(ENTRY_UUID_NAME_TEMPLATE)) {
            ldapCrudHelper.addControl((Control)new NameWithEntryUUIDRequestControl());
        }
    }

    @Override
    public String getConnectedIdentitiesObjectClass() {
        return this.configStore.getStringValue("connectedIdentitiesObjectClass", "pf-connected-identities");
    }

    @Override
    public String getConnectedIdentityAttributeName() {
        return this.configStore.getStringValue("connectedIdentityAttributeName", "pf-connected-identity");
    }

    @Override
    protected String getConnectedIdentityAttributeStorageName() {
        return this.configStore.getStringValue("connectedIdentityAttributeStorageName", "pf-connected-identity-attributes");
    }
}

