/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity;

import com.pingidentity.common.util.OtpUtils;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityAuditLogger;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import com.pingidentity.localidentity.type.EmailVerificationType;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import com.unboundid.ldap.sdk.DN;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.token.PFInternalTokenGenerator;
import org.sourceid.token.jwt.JwtTokenGeneratorImpl;
import org.sourceid.token.jwt.LocalIdentityJwtClaimName;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.PFLocalIdentityToJwtTranslator;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class SendEmailVerification {
    private static final Log log = LogFactory.getLog(SendEmailVerification.class);
    private final PFInternalTokenGenerator<String, AttributeValue> pfInternalTokenGenerator = new JwtTokenGeneratorImpl(new PFLocalIdentityToJwtTranslator());

    public void sendEmail(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, Map<String, Object> inParameters) {
        Map<String, String[]> ldapAttributes = dto.getAttributes();
        Map<String, Object> attributesForMapping = dto.getAttributesForMapping();
        String email = SendEmailVerification.getEmail(lip, attributesForMapping);
        HashMap<String, Object> templateData = new HashMap<String, Map<String, Object>>();
        if (inParameters != null) {
            templateData = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        }
        templateData.put(AdapterDefaultTemplateParams.USER_ATTRIBUTES.getParamName(), attributesForMapping);
        if (StringUtils.isBlank((CharSequence)email)) {
            return;
        }
        Optional<String> optUniqueFieldId = Optional.of(lip).map(LocalIdentityProfile::getFieldConfig).map(FieldConfig::getUniqueIdField).map(LocalIdentityField::getData).map(LocalIdentityFieldData::getId);
        String uniqueFieldValue = optUniqueFieldId.filter(id -> ldapAttributes.containsKey(id) && ArrayUtils.isNotEmpty((Object[])((String[])ldapAttributes.get(id)))).map(id -> ((String[])ldapAttributes.get(id))[0]).orElse("");
        try {
            if (EmailVerificationType.OTP.equals((Object)lip.getEmailOwnershipVerificationConfig().getEmailVerificationType())) {
                this.sendOtpEmail(req, resp, lip, uniqueFieldValue, email, templateData);
            } else {
                this.sendOtlEmail(req, lip, uniqueFieldValue, email, templateData);
            }
        }
        catch (PFInternalTokenException e) {
            throw new InvalidRequestParameterException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while sending email ownership verification email", (Throwable)e);
            return;
        }
        LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.EMAIL_ADDRESS_VERIFICATION_SEND, dto, lip, null, req, resp);
        LocalIdentityAuditLogger.log();
    }

    private void sendOtlEmail(HttpServletRequest req, LocalIdentityProfile lip, String username, String email, Map<String, Object> templateData) throws PFInternalTokenException {
        Locale locale = LocaleUtil.getUserLocale(req);
        String lipId = lip.getId();
        HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>(LocalIdentityJwtClaimName.values().length);
        String code = lipId + ":" + IDGenerator.rndNumeric(22);
        attrs.put(LocalIdentityJwtClaimName.LIP_ID.getLocalIdentityAttributeName(), new AttributeValue(lipId));
        attrs.put(LocalIdentityJwtClaimName.CODE.getLocalIdentityAttributeName(), new AttributeValue(code));
        attrs.put(LocalIdentityJwtClaimName.EMAIL.getLocalIdentityAttributeName(), new AttributeValue(email));
        attrs.put(LocalIdentityJwtClaimName.CREATION_TIME.getLocalIdentityAttributeName(), new AttributeValue(String.valueOf(new Date().getTime())));
        String referenceId = this.pfInternalTokenGenerator.encrypt(attrs);
        String linkResumeUrl = LocalIdentityUtils.getVerifyEmailPath();
        String emailTemplate = lip.getEmailOwnershipVerificationConfig().getVerifyEmailTemplateName();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        notificationSupportHelper.sendEmailOwnershipVerificationOneTimeLink(email, username, referenceId, linkResumeUrl, locale, emailTemplate, lip, templateData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Email verification OTL email queued to be sent to " + username + " at " + email));
        }
    }

    private void sendOtpEmail(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile lip, String username, String email, Map<String, Object> templateData) {
        Locale locale = LocaleUtil.getUserLocale(req);
        OtpUtils otpUtils = new OtpUtils();
        otpUtils.removeAllOtpAttributes(req, resp);
        String otpCode = otpUtils.setStoredOtpAttributes(req, resp, lip.getEmailOwnershipVerificationConfig().getOtpLength(), lip.getEmailOwnershipVerificationConfig().getAllowedOtpCharacterSet(), email);
        String emailTemplate = lip.getEmailOwnershipVerificationConfig().getVerifyEmailTemplateName();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        notificationSupportHelper.sendEmailOwnershipVerificationOneTimePasscode(email, username, otpCode, locale, emailTemplate, lip, templateData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Email verification OTP email queued to be sent to " + username + " at " + email));
        }
    }

    public static String getEmail(LocalIdentityProfile lip, Map<String, Object> ldapAttributes) {
        String emailField = lip.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification();
        AttributeValue emailValues = (AttributeValue)ldapAttributes.get(emailField);
        if (emailValues == null || emailValues.getValue() == null) {
            log.debug((Object)"No email value found. Not sending an email.");
            return "";
        }
        return emailValues.getValue();
    }
}

