/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.localidentity.data;

import java.io.Serializable;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.sourceid.localidentity.data.BaseFieldData;
import org.sourceid.localidentity.data.FieldData;

public class BooleanFieldData
extends BaseFieldData<Boolean>
implements Serializable {
    private Boolean[] values;

    public BooleanFieldData() {
    }

    public BooleanFieldData(String name, boolean multiValue, Boolean[] values) {
        super(name, multiValue);
        this.setValues(values);
    }

    @Override
    public FieldData.Type getFieldDataType() {
        return FieldData.Type.BOOLEAN;
    }

    @Override
    public Boolean getFirstValue() {
        if (this.values != null && this.values.length > 0) {
            return this.values[0];
        }
        return Boolean.FALSE;
    }

    public Boolean[] getValues() {
        return (Boolean[])this.values.clone();
    }

    public void setValues(Boolean[] t) {
        this.values = t != null ? (this.isMultiValue() ? (Boolean[])t.clone() : new Boolean[]{t[0]}) : null;
    }

    @Override
    public Attribute toAttribute(String name) {
        BasicAttribute attribute = new BasicAttribute(name);
        if (this.isMultiValue()) {
            if (this.getValues() != null) {
                for (Boolean b : this.getValues()) {
                    attribute.add(String.valueOf(b).toUpperCase());
                }
            }
        } else if (this.getFirstValue() != null) {
            attribute.add(String.valueOf(this.getFirstValue()).toUpperCase());
        }
        return attribute;
    }
}

