/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jetty.util.StringUtil;
import org.sourceid.admin.api.xmlbinding.AdminApiConfigs;
import org.sourceid.admin.api.xmlbinding.AdminApiConfigsDocument;
import org.sourceid.admin.api.xmlbinding.AllowedOriginsType;
import org.sourceid.mgmt.AdminApiCorsSettingsManager;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.util.AdminApiCorsSettings;

public class AdminApiCorsSettingsManagerImpl
implements AdminApiCorsSettingsManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(AdminApiCorsSettingsManagerImpl.class);
    public static final String FILENAME = "admin-api-config.xml";
    private static final String URL_PATTERN = "/pf-admin-api(/*)?";
    private final XmlLoader xmlLoader;
    private final String directory;
    private AdminApiCorsSettings adminApiCorsSettings;

    public AdminApiCorsSettingsManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
    }

    private synchronized AdminApiConfigsDocument getAdminApiConfigsDocument() {
        AdminApiConfigsDocument doc = null;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            try {
                doc = (AdminApiConfigsDocument)this.xmlLoader.load(this.directory, FILENAME);
            }
            catch (Exception e) {
                log.warn((Object)"Error trying to load file admin-api-config.xml", (Throwable)e);
            }
        } else {
            doc = AdminApiConfigsDocument.Factory.newInstance();
            doc.addNewAdminApiConfigs();
        }
        return doc;
    }

    private synchronized void loadConfig() {
        AdminApiConfigsDocument doc = this.getAdminApiConfigsDocument();
        AdminApiConfigs adminApiConfigs = doc.getAdminApiConfigs();
        AdminApiCorsSettings setting = new AdminApiCorsSettings();
        setting.setEnabled(adminApiConfigs.getCorsSettings().getEnabled());
        if (adminApiConfigs.getCorsSettings().getAllowedOrigins() != null) {
            setting.setAllowedOriginsList(Arrays.asList(adminApiConfigs.getCorsSettings().getAllowedOrigins().getOriginArray()));
        } else {
            setting.setAllowedOriginsList(Arrays.asList(new String[0]));
        }
        setting.setAllowedHeaders(Arrays.asList(StringUtil.csvSplit((String)adminApiConfigs.getCorsSettings().getAllowedHeaders())));
        setting.setAllowedMethods(Arrays.asList(StringUtil.csvSplit((String)adminApiConfigs.getCorsSettings().getAllowedMethods())));
        setting.setPreflightMaxAge(adminApiConfigs.getCorsSettings().getPreflightMaxAge());
        setting.setUrlPatterns(Arrays.asList(URL_PATTERN));
        this.adminApiCorsSettings = setting;
    }

    @Override
    public AdminApiCorsSettings getAdminApiCorsSettings() {
        if (this.adminApiCorsSettings == null) {
            this.loadConfig();
        }
        return this.adminApiCorsSettings;
    }

    @Override
    public synchronized void save(AdminApiCorsSettings adminApiCorsSettings) {
        AdminApiConfigsDocument doc = this.getAdminApiConfigsDocument();
        AdminApiConfigs adminApiConfigs = doc.getAdminApiConfigs();
        adminApiConfigs.getCorsSettings().setEnabled(adminApiCorsSettings.isEnabled());
        AllowedOriginsType allowedOrigins = AllowedOriginsType.Factory.newInstance();
        if (adminApiConfigs.getCorsSettings().getAllowedOrigins() != null) {
            allowedOrigins = adminApiConfigs.getCorsSettings().getAllowedOrigins();
        }
        allowedOrigins.setOriginArray(adminApiCorsSettings.getAllowedOriginsList().toArray(new String[0]));
        adminApiConfigs.getCorsSettings().setAllowedOrigins(allowedOrigins);
        this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
        this.loadConfig();
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            scope.log(AdminAuditLogger.Component.ADMIN_API_CORS_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }
}

