/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigProps;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigStoreLocation;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.adminstate.ConfigSyncStatus;
import org.sourceid.saml20.service.adminstate.SynchronizationState;
import org.sourceid.saml20.service.adminstate.errors.AdminNodeStateConfigErrors;
import org.sourceid.util.ObjectMapperFactory;

public class AdminNodeConfigManagerImpl
implements AdminNodeConfigManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(AdminNodeConfigManagerImpl.class);
    private final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS z").withZone(ZoneOffset.UTC);
    public static final String DATE_FORMAT_STR = "yyyy-MM-dd HH:mm:ss,SSS z";
    public static final AdminNodeRole DEFAULT_ADMIN_ROLE = AdminNodeRole.PASSIVE;
    private static final String CONFIG_PROPS_NAME = "cluster-admin-nodes-sync.conf";
    private static final String CONFIG_STORE_NAME = "admin-node-mode";
    private static final String SYNC_STATE_FILENAME = "synchronization-state.json";
    public static final String ENABLED = "enabled";
    public static final String PASSIVE_NODE_DATA_SYNC_INTERVAL_SECS = "passive.node.data.sync.interval.secs";
    public static final int DEFAULT_SYNC_INTERVAL_SEC = 10;
    public static final String RPC_SYNCHRONIZATION_DATA_TIMEOUT = "rpc.synchronization.data.timeout.milliseconds";
    public static final int DEFAULT_SYNC_TIMEOUT_MILLISEC = 20000;
    public static final String ACTIVE_LAST_SUCCESSFUL_SYNC_WARNING_SECS = "active.node.last.successful.sync.warning.secs";
    public static final int DEFAULT_ACTIVE_LAST_SUCCESSFUL_SYNC_WARNING_SECS = 25;
    public static final String PASSIVE_NODE_CONFIG_RELOAD_INTERVAL_SECS = "passive.node.configuration.reload.interval.secs";
    public static final int DEFAULT_PASSIVE_NODE_CONFIG_RELOAD_INTERVAL_SECS = 300;
    public static final String CONSOLE_ROLE = "AdminConsoleRole";
    public static final String CONSOLE_ROLE_LAST_ACTIVITY = "RoleLastActivityTimestamp";
    public static final String SYNC_STATUS = "SyncStatus";
    public static final String SYNC_LAST_ACTIVITY = "SyncLastActivityTimestamp";
    private final ConfigStore configStore;
    private final ObjectMapper objectMapper;
    private final File syncStateFile;
    private boolean enabled = false;
    private int passiveNodeDataSyncIntervalSecs = -1;
    private int synchronizationDataTimeoutMillis = -1;
    private int activeLastSuccessfulSyncWarningSecs = -1;
    private int passiveNodeConfigReloadIntervalSecs = -1;
    private volatile AdminNodeRole role = null;
    private volatile Instant roleLastUpdateDate = null;
    private SynchronizationState syncState = null;

    public AdminNodeConfigManagerImpl(SysDirInfo sysDirInfo) {
        this(new ConfigProps(CONFIG_PROPS_NAME), ConfigStoreFarm.getConfig(ConfigStoreLocation.INSTANCE, CONFIG_STORE_NAME), ObjectMapperFactory.buildObjectMapper(), new File(sysDirInfo.getInstanceDataDirectory(), SYNC_STATE_FILENAME));
    }

    public AdminNodeConfigManagerImpl(ConfigProps configProps, ConfigStore configStore, ObjectMapper objectMapper, File syncStateFile) {
        this.configStore = configStore;
        this.objectMapper = objectMapper;
        this.syncStateFile = syncStateFile;
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.init(configProps);
    }

    void init(ConfigProps configProps) {
        if (ModeSupport.isConsole() && !ModeSupport.isStandalone()) {
            this.loadAndValidateConfigFile(configProps);
            if (this.enabled) {
                this.processConfigStoreFile(this.configStore);
                this.loadSyncStateToFile();
            }
        }
    }

    void processConfigStoreFile(ConfigStore configStore) {
        this.role = this.processRole(configStore);
        this.roleLastUpdateDate = this.processRoleLastActivity(configStore, this.role);
        AdminAuditLogger.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.IMPORT, "Admin console role loaded from config-store file 'admin-node-mode.xml' as '" + this.role + "'");
        this.saveRoleInfoToFile(configStore);
    }

    private void saveRoleInfoToFile(ConfigStore configStore) {
        configStore.setStringValue(CONSOLE_ROLE, this.role.toString());
        configStore.setStringValue(CONSOLE_ROLE_LAST_ACTIVITY, this.roleLastUpdateDate == null ? null : this.DATE_TIME_FORMATTER.format(this.roleLastUpdateDate));
    }

    void loadSyncStateToFile() {
        if (this.syncStateFile.exists()) {
            try {
                this.syncState = (SynchronizationState)this.objectMapper.readValue(this.syncStateFile, SynchronizationState.class);
            }
            catch (IOException e) {
                log.error((Object)("Error loading file " + this.syncStateFile), (Throwable)e);
            }
        } else {
            this.syncState = new SynchronizationState();
            this.saveSyncStateToFile();
        }
    }

    private void saveSyncStateToFile() {
        try {
            this.objectMapper.writeValue(this.syncStateFile, (Object)this.syncState);
        }
        catch (IOException e) {
            log.error((Object)"Unable to save the synchronization state.", (Throwable)e);
        }
    }

    AdminNodeRole processRole(ConfigStore configStore) {
        try {
            return AdminNodeRole.valueOf(configStore.getStringValue(CONSOLE_ROLE));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Unrecognized admin node role in 'cluster-admin-nodes-sync.conf.xml'. Defaulting to " + DEFAULT_ADMIN_ROLE + " role."));
            return DEFAULT_ADMIN_ROLE;
        }
        catch (NoSuchValueException e) {
            log.info((Object)("No admin node role in 'cluster-admin-nodes-sync.conf.xml'. Defaulting to " + DEFAULT_ADMIN_ROLE + " role."));
            return DEFAULT_ADMIN_ROLE;
        }
    }

    Instant processRoleLastActivity(ConfigStore configStore, AdminNodeRole role) {
        try {
            return Instant.from(this.DATE_TIME_FORMATTER.parse(configStore.getStringValue(CONSOLE_ROLE_LAST_ACTIVITY)));
        }
        catch (DateTimeException e) {
            Instant timestamp = this.generateNewRoleUpdateDate(role);
            log.info((Object)String.format("Error parsing the admin node role last update timestamp in '%s'. Defaulting to '%s'", "cluster-admin-nodes-sync.conf.xml", this.DATE_TIME_FORMATTER.format(timestamp)));
            return timestamp;
        }
        catch (NoSuchValueException e) {
            Instant timestamp = this.generateNewRoleUpdateDate(role);
            log.info((Object)String.format("No admin node role last update timestamp in '%s'. Defaulting to '%s'", "cluster-admin-nodes-sync.conf.xml", this.DATE_TIME_FORMATTER.format(timestamp)));
            return timestamp;
        }
    }

    private Instant generateNewRoleUpdateDate(AdminNodeRole role) {
        if (AdminNodeRole.ACTIVE == role) {
            return Instant.EPOCH;
        }
        return Instant.now();
    }

    void loadAndValidateConfigFile(ConfigProps props) {
        this.enabled = props.getBoolean(ENABLED, false);
        this.passiveNodeDataSyncIntervalSecs = props.getInt(PASSIVE_NODE_DATA_SYNC_INTERVAL_SECS, 10);
        this.synchronizationDataTimeoutMillis = props.getInt(RPC_SYNCHRONIZATION_DATA_TIMEOUT, 20000);
        this.activeLastSuccessfulSyncWarningSecs = props.getInt(ACTIVE_LAST_SUCCESSFUL_SYNC_WARNING_SECS, 25);
        this.passiveNodeConfigReloadIntervalSecs = props.getInt(PASSIVE_NODE_CONFIG_RELOAD_INTERVAL_SECS, 300);
        this.validateConfig().throwExceptionIfErrors(log, CONFIG_PROPS_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded admin node state manager properties file [%s] containing values:%n%s", CONFIG_PROPS_NAME, props));
        }
    }

    private AdminNodeStateConfigErrors validateConfig() {
        AdminNodeStateConfigErrors errors = new AdminNodeStateConfigErrors();
        this.checkMinimum(errors, this.passiveNodeDataSyncIntervalSecs, PASSIVE_NODE_DATA_SYNC_INTERVAL_SECS);
        this.checkMinimum(errors, this.synchronizationDataTimeoutMillis, RPC_SYNCHRONIZATION_DATA_TIMEOUT);
        this.checkMinimum(errors, this.activeLastSuccessfulSyncWarningSecs, ACTIVE_LAST_SUCCESSFUL_SYNC_WARNING_SECS);
        if (this.passiveNodeDataSyncIntervalSecs >= this.activeLastSuccessfulSyncWarningSecs) {
            errors.add(String.format("'%s' cannot be greater than or equal to '%s'.", PASSIVE_NODE_DATA_SYNC_INTERVAL_SECS, ACTIVE_LAST_SUCCESSFUL_SYNC_WARNING_SECS));
        }
        return errors;
    }

    private void checkMinimum(AdminNodeStateConfigErrors errors, int fieldValue, String configParameterName) {
        if (fieldValue < 1) {
            errors.add(String.format("'%s' cannot be less than 1.", configParameterName));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isActiveNode() {
        return this.role == AdminNodeRole.ACTIVE;
    }

    @Override
    public boolean isPassiveNode() {
        return this.role == AdminNodeRole.PASSIVE;
    }

    @Override
    public boolean isEnabledAndPassiveNode() {
        return this.isEnabled() && this.isPassiveNode();
    }

    @Override
    public AdminNodeRole getRole() {
        return this.role;
    }

    @Override
    public Instant getRoleLastUpdateDate() {
        return this.roleLastUpdateDate;
    }

    @Override
    public SynchronizationState getSyncState() {
        return this.syncState == null ? null : new SynchronizationState(this.syncState);
    }

    @Override
    public int getPassiveNodeDataSyncIntervalSecs() {
        return this.passiveNodeDataSyncIntervalSecs;
    }

    @Override
    public int getSynchronizationDataTimeoutMillis() {
        return this.synchronizationDataTimeoutMillis;
    }

    @Override
    public int getPassiveNodeConfigReloadIntervalSecs() {
        return this.passiveNodeConfigReloadIntervalSecs;
    }

    @Override
    public int getActiveLastSuccessfulSyncWarningSecs() {
        return this.activeLastSuccessfulSyncWarningSecs;
    }

    @Override
    public void updateRole(AdminNodeRole role) {
        AdminAuditLogger.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.MODIFY, "Admin console role modified from '" + this.role + "' to '" + role + "'");
        this.role = role;
        this.roleLastUpdateDate = Instant.now();
        this.saveRoleInfoToFile(this.configStore);
        this.syncState.setConfigSyncStatus(ConfigSyncStatus.NONE);
        this.syncState.setConfigSyncTimestamp(null);
        this.saveSyncStateToFile();
    }

    @Override
    public void setSyncStatus(ConfigSyncStatus syncStatus) {
        Objects.requireNonNull(syncStatus, "syncStatus");
        if (this.syncState != null) {
            this.syncState.setConfigSyncStatus(syncStatus);
            this.syncState.setConfigSyncTimestamp(new Date());
            this.saveSyncStateToFile();
        }
    }
}

