/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.google.common.annotations.VisibleForTesting;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.common.util.zip.UnzipUtil;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.mgmt.DataDirectoryManager;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.impl.DeploymentOption;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.util.license.LicenseManager;

public class DataDirectoryManagerImpl
implements DataDirectoryManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(DataDirectoryManagerImpl.class);
    private static final String INDEX_DIR_NAME = "/index";
    private final SysDirInfo sysDirInfo;
    private final Mediator mediator;
    private final DeltaReplicationProviderManager replProviderManager;

    public DataDirectoryManagerImpl(SysDirInfo sysDirInfo, Mediator mediator, DeltaReplicationProviderManager replProviderManager) {
        this.sysDirInfo = sysDirInfo;
        this.mediator = mediator;
        this.replProviderManager = replProviderManager;
    }

    @Override
    public boolean clearIndexDirectory() {
        log.debug((Object)"clearing Index directory");
        String indexDirStr = this.sysDirInfo.getDataDirectory() + INDEX_DIR_NAME;
        File indexDir = new File(indexDirStr);
        if (!indexDir.exists()) {
            log.debug((Object)"Index directory not found");
            return true;
        }
        try {
            FileUtils.cleanDirectory((File)indexDir);
            log.debug((Object)"Index directory content removed");
            return true;
        }
        catch (IOException e) {
            String msg = "Index directory cleanup operation failed";
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    @Override
    public void clearDataDirectory(EnumSet<DeploymentOption> options) {
        List<String> deleteFileExceptions = this.createDeleteFileExceptionsList(options);
        SimpleFileUtil.deleteDirectoryFiles(this.sysDirInfo.getDataDirectory(), false, deleteFileExceptions);
        if (options.contains((Object)DeploymentOption.CLEAR_PROVIDER_DIRS)) {
            this.replProviderManager.getReplicationProviders().forEach(DeltaReplicationProvider::beginFullReplication);
        }
    }

    @Override
    public byte[] backup() throws IOException {
        byte[] originalConfig = this.mediator.getZippedConfigFromFileSystem();
        this.mediator.getDataArchiveBackup().backupConfig(originalConfig);
        return originalConfig;
    }

    @Override
    public void restore(byte[] originalConfig) {
        this.deployCoreArchive(originalConfig, EnumSet.of(DeploymentOption.CLEAR_PROVIDER_DIRS, DeploymentOption.ROLLBACK));
        this.mediator.reloadConfiguration();
    }

    @Override
    public void deployCoreArchive(byte[] zippedConfigBytes, EnumSet<DeploymentOption> options) {
        try {
            Map<String, byte[]> unzippedFileMap = UnzipUtil.unzip(zippedConfigBytes);
            this.clearDataDirectory(options);
            this.deployToFilesystem(this.sysDirInfo.getDataDirectory(), unzippedFileMap);
        }
        catch (IOException e) {
            throw new ConfigurationException("Problem writing data for core archive", e);
        }
    }

    @Override
    public Set<String> deploySynchronizationArchive(byte[] zippedConfigBytes, Map<String, Long> fileTimestamps) {
        try {
            Map<String, byte[]> unzippedFileMap = UnzipUtil.unzip(zippedConfigBytes);
            if (unzippedFileMap.size() > 20) {
                log.debug((Object)("Updating " + unzippedFileMap.size() + " core files on file system"));
            } else if (!unzippedFileMap.isEmpty()) {
                log.debug((Object)("Updating core files on file system: " + unzippedFileMap.keySet()));
            }
            for (Map.Entry<String, byte[]> fileEntry : unzippedFileMap.entrySet()) {
                File file = new File(this.sysDirInfo.getDataDirectory(), fileEntry.getKey());
                if (ReplicationRecord.isTombstone(fileEntry.getValue()) && file.exists()) {
                    if (file.delete()) continue;
                    throw new IOException("Failed to delete file: " + fileEntry.getKey());
                }
                if (fileEntry.getKey().equals("pf.jwk") && file.exists() && !file.delete()) {
                    throw new IOException("Failed to delete file: " + fileEntry.getKey());
                }
                log.trace((Object)("Writing file: " + file));
                SimpleFileUtil.writeFile(file, fileEntry.getValue());
                Long timestamp = fileTimestamps.get(fileEntry.getKey());
                if (timestamp == null || file.setLastModified(timestamp)) continue;
                throw new IOException("Failed to set modified time for file: " + fileEntry.getKey());
            }
            return unzippedFileMap.keySet();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error deploying synchronization data", e);
        }
    }

    @Override
    public void deployDeltaArchive(byte[] archive, boolean isBaseArchive, boolean isSelective, boolean createTombstones) {
        this.deployDeltaArchive(archive, isBaseArchive, isSelective, createTombstones, 1000);
    }

    @VisibleForTesting
    void deployDeltaArchive(byte[] archive, boolean isBaseArchive, boolean isSelective, boolean createTombstones, int batchSize) {
        if (isBaseArchive) {
            log.debug((Object)"Deploying base archive");
        } else if (isSelective) {
            log.debug((Object)"Deploying selective replication changes");
        } else {
            log.debug((Object)"Deploying delta archive");
        }
        if (isBaseArchive) {
            for (DeltaReplicationProvider provider : this.replProviderManager.getReplicationProviders()) {
                provider.beginFullReplication();
            }
        }
        HashMap<String, List> recordsBySubdir = new HashMap<String, List>();
        try (ZipInputStream inStream = new ZipInputStream(new ByteArrayInputStream(archive));){
            ZipEntry zipEntry;
            while ((zipEntry = inStream.getNextEntry()) != null) {
                String filePath = zipEntry.getName();
                int slashIndex = filePath.indexOf(47);
                if (slashIndex <= 0 || slashIndex == filePath.length() - 1) {
                    log.warn((Object)("Unexpected zip entry key format: " + filePath));
                    continue;
                }
                String subdir = filePath.substring(0, slashIndex);
                List records = recordsBySubdir.computeIfAbsent(subdir, k -> new ArrayList());
                records.add(new ReplicationRecord(filePath.substring(slashIndex + 1), IOUtils.toByteArray((InputStream)inStream)));
                if (records.size() < batchSize) continue;
                this.importReplicationRecords(subdir, records, isSelective, createTombstones);
                recordsBySubdir.remove(subdir);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error importing archive", e);
        }
        for (Map.Entry entry : recordsBySubdir.entrySet()) {
            this.importReplicationRecords((String)entry.getKey(), (List)entry.getValue(), isSelective, createTombstones);
        }
    }

    private boolean isValidFilePath(String directory, String filePath) {
        if (Paths.get(filePath, new String[0]).isAbsolute()) {
            return false;
        }
        Path path = Paths.get(directory, new String[0]).resolve(filePath).normalize();
        return path.startsWith(Paths.get(directory, new String[0]).normalize());
    }

    private List<String> createDeleteFileExceptionsList(EnumSet<DeploymentOption> deploymentOptions) {
        ArrayList<String> deleteFileExceptions = new ArrayList<String>();
        deleteFileExceptions.add(this.sysDirInfo.getArchiveDir());
        deleteFileExceptions.add(this.sysDirInfo.getConnectionDeployerDir());
        deleteFileExceptions.add(this.sysDirInfo.getDropInDeployerDir());
        deleteFileExceptions.add(this.sysDirInfo.getReplicationDirectory());
        deleteFileExceptions.add(this.sysDirInfo.getDataDirectory() + File.separator + "hypersonic");
        deleteFileExceptions.add(this.sysDirInfo.getDataDirectory() + File.separator + "index");
        if (!deploymentOptions.contains((Object)DeploymentOption.ROLLBACK)) {
            AdminAuthManager adminAuthManager;
            if (!deploymentOptions.contains((Object)DeploymentOption.BULK_IMPORT)) {
                deleteFileExceptions.add(new File(this.sysDirInfo.getConfigStoreDir(), "com.pingidentity.page.Login.xml").getAbsolutePath());
                deleteFileExceptions.add(KerberosConfigUtil.getKrb5ConfFile().getAbsolutePath());
                deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "ping-ssl-client-trust-cas.jks").getAbsolutePath());
            }
            if (!(adminAuthManager = AdminAuthManager.getInstance()).isNative() || !adminAuthManager.getAdminUserManager().getUsers().isEmpty() || deploymentOptions.contains((Object)DeploymentOption.BULK_IMPORT)) {
                deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "pingfederate-admin-user.xml").getAbsolutePath());
            }
            if (deploymentOptions.contains((Object)DeploymentOption.BULK_IMPORT)) {
                deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "pf.jwk").getAbsolutePath());
                deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "hsmpasswd.txt").getAbsolutePath());
                deleteFileExceptions.add(new File(this.sysDirInfo.getConfigStoreDir(), "com.pingidentity.crypto.jwk.MasterKeySet.xml").getAbsolutePath());
            } else if (deploymentOptions.contains((Object)DeploymentOption.REENCRYPT)) {
                deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "pf.jwk").getAbsolutePath());
            }
            if (deploymentOptions.contains((Object)DeploymentOption.REPLICATION)) {
                deleteFileExceptions.add(new File(this.sysDirInfo.getConfigStoreDir(), "org.sourceid.util.license.Synchronizer.xml").getAbsolutePath());
            }
        }
        deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), LicenseManager.FALLBACK_KEY_FILE_NAME).getAbsolutePath());
        deleteFileExceptions.add(new File(this.sysDirInfo.getInstanceDataDirectory()).getAbsolutePath());
        deleteFileExceptions.addAll(this.replProviderManager.getReplicationProviders().stream().map(provider -> this.sysDirInfo.getDataDirectory() + File.separator + provider.getManagedDirectoryName()).collect(Collectors.toSet()));
        deleteFileExceptions.add(new File(this.sysDirInfo.getDataDirectory(), "admin-api-config.xml").getAbsolutePath());
        return deleteFileExceptions;
    }

    private void deployToFilesystem(String directory, Map<String, byte[]> archiveToImport) throws IOException {
        log.debug((Object)"Deploying archive to file system");
        boolean exceptionWritingFile = false;
        archiveToImport.remove("archive-metadata");
        archiveToImport.remove("instance/metadata.xml");
        for (Map.Entry<String, byte[]> archiveFile : archiveToImport.entrySet()) {
            if (this.isValidFilePath(directory, archiveFile.getKey())) {
                File file = new File(directory, archiveFile.getKey());
                if (archiveFile.getValue().length <= 0) continue;
                try {
                    log.trace((Object)("Writing file: " + file));
                    SimpleFileUtil.writeFile(file, archiveFile.getValue());
                }
                catch (IOException e) {
                    exceptionWritingFile = true;
                    log.error((Object)("Cannot write file: " + file.getAbsolutePath()), (Throwable)e);
                }
                continue;
            }
            String msg = String.format("Skipped extracting '%s' entry from the data archive. Normalized file path does not match with '%s' base path.", archiveFile.getKey(), directory);
            log.warn((Object)msg);
        }
        if (exceptionWritingFile) {
            throw new IOException("error writing file(s)");
        }
    }

    private void importReplicationRecords(String subdir, List<ReplicationRecord> records, boolean isSelective, boolean createTombstones) {
        DeltaReplicationProvider provider = this.replProviderManager.getReplicationProvider(subdir);
        if (provider == null) {
            log.warn((Object)("No replication provider found for directory " + subdir));
        } else {
            provider.importReplicationRecords(records, createTombstones);
            if (isSelective) {
                provider.reloadUpdatedEntries();
            }
        }
    }
}

