/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.mgmt.impl;

import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.upgrade.exception.UnsupportedUpgradeVersionException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.mgmt.DataDirectoryManager;
import org.sourceid.mgmt.DataUpgradeManager;
import org.sourceid.mgmt.InstanceMetadataManager;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.domain.mgmt.impl.DataDeployer;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.ConfigReplicationService;
import org.sourceid.saml20.service.ConfigSynchronizationService;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class DataUpgradeManagerImpl
implements DataUpgradeManager,
AutoReloadable {
    private static final Log LOG = LogFactory.getLog(DataUpgradeManagerImpl.class);
    private final InstanceMetadataManager instanceMetadataManager;
    private final SysDirInfo sysDirInfo;
    private final Mediator mediator;
    private final AdminNodeConfigManager adminNodeConfigManager;
    private final DataSourceManager dataSourceManager;
    private final ConfigSynchronizationService configSynchronizationService;
    private final ConfigReplicationService configReplicationService;
    private final NodeIndexRegistry nodeIndexRegistry;
    private final DataDirectoryManager dataDirectoryManager;
    private final IdpAdapterManager idpAdapterManager;
    private final SpAdapterManager spAdapterManager;
    private final TokenProcessorManager tokenProcessorManager;
    private final TokenGeneratorManager tokenGeneratorManager;

    public DataUpgradeManagerImpl(InstanceMetadataManager instanceMetadataManager, SysDirInfo sysDirInfo, Mediator mediator, AdminNodeConfigManager adminNodeConfigManager, DataSourceManager dataSourceManager, ConfigSynchronizationService configSynchronizationService, ConfigReplicationService configReplicationService, NodeIndexRegistry nodeIndexRegistry, DataDirectoryManager dataDirectoryManager, IdpAdapterManager idpAdapterManager, SpAdapterManager spAdapterManager, TokenProcessorManager tokenProcessorManager, TokenGeneratorManager tokenGeneratorManager) {
        this.instanceMetadataManager = instanceMetadataManager;
        this.sysDirInfo = sysDirInfo;
        this.mediator = mediator;
        this.adminNodeConfigManager = adminNodeConfigManager;
        this.dataSourceManager = dataSourceManager;
        this.configSynchronizationService = configSynchronizationService;
        this.configReplicationService = configReplicationService;
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.dataDirectoryManager = dataDirectoryManager;
        this.idpAdapterManager = idpAdapterManager;
        this.spAdapterManager = spAdapterManager;
        this.tokenProcessorManager = tokenProcessorManager;
        this.tokenGeneratorManager = tokenGeneratorManager;
    }

    @Override
    public DataUpgradeManager.UpgradeResult performUpgrade() {
        if (this.isDataZipFileAlreadyPresent()) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SKIPPED, "data.zip file is already present in the drop-in-deployer.");
        }
        String dataVersion = this.instanceMetadataManager.getDataVersion();
        if (dataVersion.equals("unknown")) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SKIPPED, "PingFederate data version not found. Make sure the data directory is not modified manually.");
        }
        if (!VersionUtil.isValidVersion((String)dataVersion)) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Invalid data version found: " + dataVersion);
        }
        String pfVersion = PropertyInfo.getPingFederateVersion();
        try {
            int versionCompare = Version.compare((String)pfVersion, (String)dataVersion);
            if (versionCompare == 0) {
                return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SKIPPED, "The Data and PingFederate version are the same.");
            }
            if (versionCompare < 0) {
                return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, String.format("Data version '%s' is greater than the current PingFederate version '%s'.", dataVersion, pfVersion));
            }
        }
        catch (MigrationException e) {
            LOG.debug((Object)"Error comparing data version with PingFederate version.", (Throwable)e);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Error comparing data version with PingFederate version: " + e.getMessage());
        }
        if (this.mediator.isConsole() && !this.adminNodeConfigManager.isEnabledAndPassiveNode()) {
            return this.performActiveAdminConsoleDataUpgrade(dataVersion, pfVersion);
        }
        if (this.mediator.isConsole() && this.adminNodeConfigManager.isEnabledAndPassiveNode()) {
            return this.performPassiveAdminConsoleDataUpgrade(pfVersion);
        }
        if (this.mediator.isEngine()) {
            return this.performEngineDataUpgrade(pfVersion);
        }
        return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "node type not supported for data upgrade.");
    }

    private DataUpgradeManager.UpgradeResult performActiveAdminConsoleDataUpgrade(String dataVersion, String pfVersion) {
        try {
            Version dataVersionObj = this.getVersionFromStr(dataVersion, "Data Version");
            Version pfVersionObj = this.getVersionFromStr(pfVersion, "PingFederate Version");
            Version closestSupportedSourceVersion = Utils.resolveClosestSupportedSourceVersion((Version)dataVersionObj, (Version)pfVersionObj, (String)this.sysDirInfo.getUpgradeReferenceFilesDir(), (String)"");
            LOG.debug((Object)("Performing upgrade from: " + closestSupportedSourceVersion + " to: " + pfVersionObj));
            boolean cleanIndexDirResult = this.dataDirectoryManager.clearIndexDirectory();
            if (!cleanIndexDirResult) {
                LOG.error((Object)"Error clearing index directory.");
                return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Error clearing index directory.");
            }
            LOG.debug((Object)"Creating and saving zipped config to drop-in-deployer.");
            byte[] data = this.mediator.getZippedConfigFromFileSystem(closestSupportedSourceVersion.toString());
            this.mediator.saveToDropInDeployer(data);
            LOG.debug((Object)"Performing necessary initializations.");
            this.dataSourceManager.initializeJndiLookup();
            this.idpAdapterManager.getInstances();
            this.spAdapterManager.getInstances();
            this.tokenProcessorManager.getInstances();
            this.tokenGeneratorManager.getInstances();
            LOG.debug((Object)"running data upgrade against the archive stored in the drop-in-deployer.");
            DataDeployer initialDeployer = new DataDeployer();
            DataDeployer.DeployDataResult deployDataResult = initialDeployer.attemptDeployData();
            if (deployDataResult == DataDeployer.DeployDataResult.SUCCESS) {
                this.mediator.checkPublishConfig();
                return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SUCCESS, String.format("Upgrade complete, Original pingFederate data version upgraded from: %s", dataVersion));
            }
            LOG.error((Object)"Admin console data upgrade failed.");
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Admin console data upgrade failed.");
        }
        catch (IOException e) {
            LOG.debug((Object)"Error getting zipped config from file system.", (Throwable)e);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Error getting zipped config from file system.");
        }
        catch (MigrationException e) {
            LOG.debug((Object)"invalid version", (Throwable)e);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "invalid version");
        }
        catch (UnsupportedUpgradeVersionException e) {
            LOG.debug((Object)String.format("Reference file supporting '%s' data version not found.", dataVersion), (Throwable)e);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, String.format("Reference file supporting '%s' data version not found.", dataVersion));
        }
    }

    private DataUpgradeManager.UpgradeResult performEngineDataUpgrade(String pfVersion) {
        byte[] backup;
        LOG.debug((Object)"Clearing index directory.");
        boolean cleanIndexDirResult = this.dataDirectoryManager.clearIndexDirectory();
        if (!cleanIndexDirResult) {
            LOG.error((Object)"Error clearing index directory.");
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Error clearing index directory.");
        }
        LOG.debug((Object)"Retrieving cluster state.");
        this.mediator.retrieveClusterState();
        try {
            LOG.debug((Object)"Backing up data.");
            backup = this.dataDirectoryManager.backup();
        }
        catch (IOException e) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Engine node data backup failed.");
        }
        LOG.debug((Object)"Getting admin node.");
        Set<Node> adminNodes = this.nodeIndexRegistry.getAdminNodes();
        if (adminNodes.isEmpty()) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "No admin node found.");
        }
        if (adminNodes.size() > 1) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Multiple admin nodes found.");
        }
        Node node = adminNodes.iterator().next();
        if (node == null) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Admin node is null.");
        }
        LOG.debug((Object)"Updating config from admin node.");
        boolean updateResult = this.configReplicationService.updateConfigFromNode(node.getAddress(), null, null);
        if (updateResult) {
            this.instanceMetadataManager.setDataVersion(pfVersion);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SUCCESS, "Data upgrade is successful for engine nodes.");
        }
        LOG.debug((Object)"Restoring backed up data.");
        this.dataDirectoryManager.restore(backup);
        String msg = "Engine data upgrade failed. failed to retrieve data from admin node.";
        LOG.debug((Object)msg);
        return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, msg);
    }

    private DataUpgradeManager.UpgradeResult performPassiveAdminConsoleDataUpgrade(String pfVersion) {
        byte[] backup;
        LOG.debug((Object)"Clearing index directory.");
        boolean cleanIndexDirResult = this.dataDirectoryManager.clearIndexDirectory();
        if (!cleanIndexDirResult) {
            LOG.error((Object)"Error clearing index directory.");
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Error clearing index directory.");
        }
        LOG.debug((Object)"Retrieving cluster state.");
        this.mediator.retrieveClusterState();
        try {
            LOG.debug((Object)"Backing up data.");
            backup = this.dataDirectoryManager.backup();
        }
        catch (IOException e) {
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, "Passive admin console data backup failed.");
        }
        LOG.debug((Object)"Updating config from admin node.");
        boolean syncResult = this.configSynchronizationService.fullConfigurationSync();
        if (syncResult) {
            this.instanceMetadataManager.setDataVersion(pfVersion);
            return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.SUCCESS, "Data upgrade is successful for passive admin nodes.");
        }
        LOG.debug((Object)"Restoring backed up data.");
        this.dataDirectoryManager.restore(backup);
        String msg = "Passive admin console data upgrade failed. failed to retrieve data from active admin node.";
        LOG.debug((Object)msg);
        return new DataUpgradeManager.UpgradeResult(DataUpgradeManager.Status.FAILURE, msg);
    }

    private boolean isDataZipFileAlreadyPresent() {
        File deployerDir = new File(this.sysDirInfo.getDataDirectory(), "drop-in-deployer");
        File dataFile = new File(deployerDir, "data.zip");
        return dataFile.exists();
    }

    private Version getVersionFromStr(String version, String name) throws MigrationException {
        try {
            return new Version(version);
        }
        catch (MigrationException e) {
            LOG.error((Object)("Error parsing " + name + ": " + e.getMessage()));
            LOG.debug((Object)("Error parsing " + name + "."), (Throwable)e);
            throw e;
        }
    }
}

