/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.authorizationdetails.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailProcessingException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailProcessor;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailValidationResult;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.authorizationdetails.AuthorizationDetailTypesManager;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.AuthorizationDetailProcessorsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public final class AuthorizationDetailsUtil {
    private static final Log log = LogFactory.getLog(AuthorizationDetailsUtil.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
    private static final String AUTHORIZATION_DETAIL_ID_KEY = "authorizationDetailIdentifiers";
    private static final String REQUESTED_AUTHZ_DETAIL_TYPES_NOT_SUPPORTED = "The client does not support the requested authorization detail types.";
    private static final String UNABLE_TO_GET_CONSENT_MESSAGE_FOR_AUTHZ_DETAIL = "Unable to get consent message for authorization detail: %s";
    private static final String ERROR_DURING_ENRICHMENT_OF_AUTHZ_DETAIL = "Error during enrichment of authorization detail: %s";
    private static final String ERROR_DURING_COMPARISON_OF_AUTHZ_DETAILS = "Error during comparison of authorization details: %s";
    private static final String UNABLE_TO_WRITE_AUTHZ_DETAIL_TO_JSON = "unable to write authorization detail of type %s to json, skipping";
    private static final String INVALID_AUTHZ_DETAIL_TYPE = "invalid authorization detail type";
    private static final String UNABLE_TO_FIND_AUTHZ_DETAIL_PROCESSOR = "unable to find authorization detail processor";
    private static final String ERROR_DESERIALIZING_AUTHZ_DETAILS = "Error deserializing authorization details";
    private static final String APPROVED_AUTHZ_DETAILS_GREATER_THAN_REQUESTED = "approved authorization details cannot exceed the requested authorization details";

    private AuthorizationDetailsUtil() {
    }

    public static void validate(AuthorizationDetails authorizationDetails, Client client, HttpServletRequest request, Scope scope) throws InvalidAuthorizationDetailException {
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return;
        }
        try {
            if (!client.isAllowedAuthorizationDetailTypes()) {
                throw new InvalidAuthorizationDetailException(REQUESTED_AUTHZ_DETAIL_TYPES_NOT_SUPPORTED);
            }
            AuthorizationDetailContext context = new AuthorizationDetailContext(request, client.getClientId(), scope);
            authorizationDetails.getDetails().forEach(authorizationDetail -> {
                AuthorizationDetail cloned;
                if (!client.getAuthorizationDetailTypes().contains(authorizationDetail.getType())) {
                    throw new ProcessRuntimeException(REQUESTED_AUTHZ_DETAIL_TYPES_NOT_SUPPORTED);
                }
                AuthorizationDetailProcessor processor = AuthorizationDetailsUtil.getProcessorFromDetail(authorizationDetail);
                AuthorizationDetailValidationResult validationResult = processor.validate(cloned = new AuthorizationDetail(authorizationDetail), context, Collections.emptyMap());
                if (!validationResult.isValid()) {
                    throw new ProcessRuntimeException(validationResult.getReason());
                }
            });
        }
        catch (ProcessRuntimeException e) {
            throw new InvalidAuthorizationDetailException(e.getMessage());
        }
    }

    public static String getDescription(AuthorizationDetail authorizationDetail, HttpServletRequest request, String clientId, Scope scope) {
        AuthorizationDetailContext context = new AuthorizationDetailContext(request, clientId, scope);
        AuthorizationDetailProcessor processor = AuthorizationDetailsUtil.getProcessorFromDetail(authorizationDetail);
        try {
            AuthorizationDetail clone = new AuthorizationDetail(authorizationDetail);
            return processor.getUserConsentDescription(clone, context, Collections.emptyMap());
        }
        catch (AuthorizationDetailProcessingException e) {
            String message = String.format(UNABLE_TO_GET_CONSENT_MESSAGE_FOR_AUTHZ_DETAIL, authorizationDetail.getType());
            log.error((Object)message);
            log.debug((Object)message, (Throwable)e);
            return null;
        }
    }

    public static Map<AuthorizationDetail, String> getDescriptions(AuthorizationDetails authorizationDetails, HttpServletRequest request, String clientId, Scope scope) {
        HashMap<AuthorizationDetail, String> requestedDescriptions = new HashMap<AuthorizationDetail, String>();
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return requestedDescriptions;
        }
        authorizationDetails.getDetails().forEach(authorizationDetail -> {
            String authorizationDetailDescription = AuthorizationDetailsUtil.getDescription(authorizationDetail, request, clientId, scope);
            if (authorizationDetailDescription != null) {
                requestedDescriptions.put((AuthorizationDetail)authorizationDetail, authorizationDetailDescription);
            }
        });
        return requestedDescriptions;
    }

    public static Map<String, String> getDescriptionsWithIdentifiers(AuthorizationDetails authorizationDetails, HttpServletRequest request, String clientId, Scope scope, Map<String, Object> otherState) {
        HashMap<String, String> requestedDescriptions = new HashMap<String, String>();
        HashMap authorizationDetailIdentifiers = new HashMap();
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return requestedDescriptions;
        }
        AuthorizationDetailContext context = new AuthorizationDetailContext(request, clientId, scope);
        authorizationDetails.getDetails().forEach(authorizationDetail -> {
            AuthorizationDetailProcessor processor = AuthorizationDetailsUtil.getProcessorFromDetail(authorizationDetail);
            try {
                AuthorizationDetail clone = new AuthorizationDetail(authorizationDetail);
                String consentDescription = processor.getUserConsentDescription(clone, context, Collections.emptyMap());
                String id = IDGenerator.rndAlphaNumeric(22);
                requestedDescriptions.put(id, consentDescription);
                authorizationDetailIdentifiers.put(id, authorizationDetail);
            }
            catch (AuthorizationDetailProcessingException e) {
                String message = String.format(UNABLE_TO_GET_CONSENT_MESSAGE_FOR_AUTHZ_DETAIL, authorizationDetail.getType());
                log.error((Object)message);
                log.debug((Object)message, (Throwable)e);
            }
        });
        otherState.put(AUTHORIZATION_DETAIL_ID_KEY, authorizationDetailIdentifiers);
        return requestedDescriptions;
    }

    public static AuthorizationDetail[] getDetailsFromIdentifiers(String[] approvedAuthorizationDetailIds, Map<String, Object> otherState) throws AuthorizationRequestException {
        Map authorizationDetailIdentifiers = (Map)otherState.get(AUTHORIZATION_DETAIL_ID_KEY);
        if (approvedAuthorizationDetailIds == null) {
            return null;
        }
        if (authorizationDetailIdentifiers == null) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, APPROVED_AUTHZ_DETAILS_GREATER_THAN_REQUESTED);
        }
        try {
            return (AuthorizationDetail[])Arrays.stream(approvedAuthorizationDetailIds).distinct().map(id -> {
                AuthorizationDetail authorizationDetail = (AuthorizationDetail)authorizationDetailIdentifiers.get(id);
                if (authorizationDetail == null) {
                    String message = "unknown authorization details identifier: " + id;
                    log.debug((Object)message);
                    throw new ProcessRuntimeException(message);
                }
                return authorizationDetail;
            }).toArray(AuthorizationDetail[]::new);
        }
        catch (ProcessRuntimeException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, APPROVED_AUTHZ_DETAILS_GREATER_THAN_REQUESTED);
        }
    }

    public static void enrich(AuthorizationDetails authorizationDetails, HttpServletRequest request, String clientId, Scope scope) throws AuthorizationRequestException {
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return;
        }
        AuthorizationDetailContext context = new AuthorizationDetailContext(request, clientId, scope);
        try {
            authorizationDetails.getDetails().forEach(authorizationDetail -> {
                try {
                    AuthorizationDetailProcessor processor = AuthorizationDetailsUtil.getProcessorFromDetail(authorizationDetail);
                    AuthorizationDetail clone = new AuthorizationDetail(authorizationDetail);
                    AuthorizationDetail enrichedDetail = processor.enrich(clone, context, Collections.emptyMap());
                    authorizationDetail.setDetail(enrichedDetail.getDetail());
                }
                catch (AuthorizationDetailProcessingException e) {
                    String message = String.format(ERROR_DURING_ENRICHMENT_OF_AUTHZ_DETAIL, authorizationDetail.getType());
                    throw new ProcessRuntimeException(message, e);
                }
            });
        }
        catch (ProcessRuntimeException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, e.getMessage(), e);
        }
    }

    public static boolean isEqualOrSubset(AuthorizationDetail authorizationDetail, AuthorizationDetails authorizationDetails, AuthorizationDetailContext context) {
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return false;
        }
        return authorizationDetails.getDetails().stream().filter(authzDetail -> authzDetail.getType().equals(authorizationDetail.getType())).anyMatch(authzDetail -> {
            AuthorizationDetailProcessor processor = AuthorizationDetailsUtil.getProcessorFromDetail(authzDetail);
            try {
                AuthorizationDetail requestedClone = new AuthorizationDetail(authorizationDetail);
                AuthorizationDetail clone = new AuthorizationDetail(authzDetail);
                return processor.isEqualOrSubset(requestedClone, clone, context, Collections.emptyMap());
            }
            catch (AuthorizationDetailProcessingException e) {
                log.debug((Object)String.format(ERROR_DURING_COMPARISON_OF_AUTHZ_DETAILS, authzDetail.getType()), (Throwable)e);
                return false;
            }
        });
    }

    public static void updateOtherState(Map<String, Object> otherState, AuthorizationDetails authorizationDetails) {
        if (authorizationDetails != null && authorizationDetails.getDetails() != null) {
            otherState.put("authorization_details", AuthorizationDetailsUtil.toJson(authorizationDetails));
        }
    }

    public static String toJson(AuthorizationDetails authorizationDetails) {
        if (authorizationDetails == null || authorizationDetails.getDetails() == null) {
            return null;
        }
        return authorizationDetails.getDetails().stream().map(AuthorizationDetailsUtil::toJson).filter(Objects::nonNull).collect(Collectors.joining(",", "[", "]"));
    }

    public static String toJson(AuthorizationDetail authorizationDetail) {
        if (authorizationDetail == null) {
            return null;
        }
        try {
            return mapper.writeValueAsString((Object)authorizationDetail);
        }
        catch (JsonProcessingException e) {
            String message = String.format(UNABLE_TO_WRITE_AUTHZ_DETAIL_TO_JSON, authorizationDetail.getType());
            log.debug((Object)message, (Throwable)e);
            return null;
        }
    }

    private static AuthorizationDetailProcessor getProcessorFromDetail(AuthorizationDetail authorizationDetail) {
        AuthorizationDetailTypesManager typesManager = MgmtFactory.getAuthorizationDetailTypesManager();
        AuthorizationDetailProcessorsManager processorsManager = MgmtFactory.getAuthorizationDetailProcessorsPluginManager();
        AuthorizationDetailType authorizationDetailType = typesManager.getAuthorizationDetailTypeByType(authorizationDetail.getType());
        if (authorizationDetailType == null || !authorizationDetailType.isActive()) {
            throw new ProcessRuntimeException(INVALID_AUTHZ_DETAIL_TYPE);
        }
        String id = authorizationDetailType.getAuthorizationDetailProcessorId();
        AuthorizationDetailProcessor processor = processorsManager.getAuthorizationDetailProcessor(id);
        if (processor == null) {
            throw new ProcessRuntimeException(UNABLE_TO_FIND_AUTHZ_DETAIL_PROCESSOR);
        }
        return processor;
    }

    public static AuthorizationDetails getAuthorizationDetails(String authorizationDetailsJson) {
        if (authorizationDetailsJson != null) {
            try {
                return new AuthorizationDetails(authorizationDetailsJson);
            }
            catch (IOException e) {
                log.error((Object)ERROR_DESERIALIZING_AUTHZ_DETAILS, (Throwable)e);
            }
        }
        return new AuthorizationDetails();
    }

    public static AuthorizationDetails getAuthorizationDetailsFromCollection(Collection<Object> authorizationDetails) throws IOException {
        if (authorizationDetails.isEmpty()) {
            return new AuthorizationDetails(new AuthorizationDetail[0]);
        }
        Object authzDetail = authorizationDetails.iterator().next();
        if (authzDetail instanceof String) {
            String authorizationDetailsJsonArray = authorizationDetails.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            return new AuthorizationDetails(authorizationDetailsJsonArray);
        }
        if (authzDetail instanceof AuthorizationDetail) {
            AuthorizationDetail[] authorizationDetailArray = authorizationDetails.toArray(new AuthorizationDetail[0]);
            return new AuthorizationDetails(authorizationDetailArray);
        }
        log.warn((Object)("Invalid return type of authorization detail in Collection: " + authzDetail.getClass()));
        return new AuthorizationDetails();
    }

    public static AuthorizationDetails getAuthorizationDetailsAttributeValue(AttributeValue attributeValueAuthzDetails) throws IOException {
        if (attributeValueAuthzDetails.isMultiValue()) {
            String authorizationDetailsJsonArray = attributeValueAuthzDetails.getValuesAsCollection().stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            return new AuthorizationDetails(authorizationDetailsJsonArray);
        }
        if (attributeValueAuthzDetails.getValue() == null) {
            return new AuthorizationDetails(new AuthorizationDetail[0]);
        }
        return new AuthorizationDetails(String.format("[%s]", attributeValueAuthzDetails.getValue()));
    }
}

