/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class AbstractJSONEndpointBinding
implements Binding {
    protected ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException {
        this.writeJson(response, msgCtx.getParams());
    }

    private void writeJson(HttpServletResponse resp, Map<String, ?> content) throws IOException {
        if (!content.isEmpty()) {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            PrintWriter writer = resp.getWriter();
            writer.print(this.objectMapper.writeValueAsString(content));
            writer.flush();
        }
        resp.flushBuffer();
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        LinkedHashMap<String, String> jsonRespMap = new LinkedHashMap<String, String>();
        resp.setStatus(500);
        jsonRespMap.put("error", AccessTokenRequestException.Error.server_error.toString());
        jsonRespMap.put("error_description", "Unexpected problem: Server error");
        this.writeJson(resp, jsonRespMap);
    }

    @Override
    public boolean isBackChannel() {
        return true;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }
}

