/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.wwwauth.AccessTokenSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AccessTokenProtectedResourceBinding
implements Binding {
    private static final Log log = LogFactory.getLog(AccessTokenProtectedResourceBinding.class);
    private static final String ACCESS_TOKEN_ATTRS = "attrs";
    private static final String ACCESS_GRANT_GUID = "ag_guid";
    private static final String SCOPE = "scope";
    private final AccessTokenSupport accessTokenSupport;
    protected final BearerAccessTokenMgmtPluginManager tokenManager;

    public AccessTokenProtectedResourceBinding(BearerAccessTokenMgmtPluginManager tokenManager, String realm, Scope requiredScopes, Scope suggestedScopes) {
        this.tokenManager = tokenManager;
        this.accessTokenSupport = new AccessTokenSupport(tokenManager, realm, requiredScopes, suggestedScopes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws HttpStatusCodeException {
        InMessageContext inMessageContext;
        try {
            inMessageContext = this.doReceive(request);
        }
        catch (Throwable throwable) {
            DpopUtil.addDpopNonceToHeader(request, DpopUtil.getAccessTokenFromAuthorizationHeader(request) != null, (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            throw throwable;
        }
        DpopUtil.addDpopNonceToHeader(request, DpopUtil.getAccessTokenFromAuthorizationHeader(request) != null, (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        return inMessageContext;
    }

    private InMessageContext doReceive(HttpServletRequest request) throws HttpStatusCodeException {
        InMessageContext inCtx = new InMessageContext(Role.SP);
        inCtx.setIsRequest(true);
        AccessToken accessToken = this.accessTokenSupport.getAccessToken(request, this.getAtmInstances(), false);
        Collection<BearerAccessTokenMgmtPluginInstance> allowedInstancesForClient = this.getAtmInstancesForClient(accessToken.getClientId());
        boolean foundInstanceUsed = false;
        for (BearerAccessTokenMgmtPluginInstance instance : allowedInstancesForClient) {
            if (!instance.getId().equals(this.accessTokenSupport.getInstanceUsed().getId())) continue;
            foundInstanceUsed = true;
            break;
        }
        if (!foundInstanceUsed) {
            try {
                accessToken = this.accessTokenSupport.getAccessToken(request, allowedInstancesForClient, true);
            }
            catch (HttpStatusCodeException e) {
                log.debug((Object)"An access token manager was able to process the token, but that token manager is not usable by the client referenced in the token");
                throw e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token validated by access token manager '" + this.accessTokenSupport.getInstanceUsed().getId() + "'"));
        }
        inCtx.setEntityId(accessToken.getClientId());
        AccessTokenProtectedResourceBinding.setAccessTokenAttributes(inCtx, accessToken.getAttributes());
        AccessTokenProtectedResourceBinding.setScope(inCtx, Scope.getScope((String)accessToken.getScope()));
        AccessTokenProtectedResourceBinding.setAccessGrantGuid(inCtx, accessToken.getAccessGrantGuid());
        return inCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        throw new ServletException((Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return true;
    }

    @Override
    public String getUri() {
        return "http+access-token";
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transportResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext outCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    protected Collection<BearerAccessTokenMgmtPluginInstance> getAtmInstances() {
        return this.tokenManager.getInstances();
    }

    protected Collection<BearerAccessTokenMgmtPluginInstance> getAtmInstancesForClient(String clientId) {
        ArrayList<BearerAccessTokenMgmtPluginInstance> result = new ArrayList<BearerAccessTokenMgmtPluginInstance>();
        for (BearerAccessTokenMgmtPluginInstance instance : this.getAtmInstances()) {
            if (!instance.isClientAllowed(clientId)) continue;
            result.add(instance);
        }
        return result;
    }

    private static void setAccessTokenAttributes(BaseMessageContext ctx, Map<String, AttributeValue> attrs) {
        ctx.setParam(ACCESS_TOKEN_ATTRS, attrs);
    }

    public static Map<String, AttributeValue> getAccessTokenAttributes(BaseMessageContext ctx) {
        return ctx.getParam(ACCESS_TOKEN_ATTRS, Map.class);
    }

    private static void setAccessGrantGuid(InMessageContext ctx, String accessGrantGuid) {
        if (StringUtils.isNotBlank((String)accessGrantGuid)) {
            ctx.setParam(ACCESS_GRANT_GUID, accessGrantGuid);
        }
    }

    public static String getAccessGrantGuid(InMessageContext ctx) {
        return ctx.getParam(ACCESS_GRANT_GUID);
    }

    private static void setScope(BaseMessageContext ctx, Scope scope) {
        ctx.setParam(SCOPE, scope);
    }

    public static Scope getScope(BaseMessageContext ctx) {
        return ctx.getParam(SCOPE, Scope.class);
    }
}

