/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jwt.NumericDate;
import org.sourceid.oauth20.bindings.AbstractJSONEndpointBinding;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.oauth20.utils.TokenIntrospectionUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class IntrospectEndpointBinding
extends AbstractJSONEndpointBinding {
    private final OAuthJwtTokenService oAuthJwtTokenService;
    private final OAuthIssuerUtils oAuthIssuerUtils;

    public IntrospectEndpointBinding() {
        this(MgmtFactory.getOAuthJwtTokenService(), OAuthIssuerUtils.getInstance());
    }

    public IntrospectEndpointBinding(OAuthJwtTokenService oAuthJwtTokenService, OAuthIssuerUtils oAuthIssuerUtils) {
        this.oAuthJwtTokenService = oAuthJwtTokenService;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException {
        if (TokenIntrospectionUtils.isRequestProcessedSuccessfully(msgCtx) && TokenIntrospectionUtils.isJwtResponseRequested(request)) {
            String responsePayload = this.createJwtResponse(request, msgCtx);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/token-introspection+jwt");
            PrintWriter writer = response.getWriter();
            writer.print(responsePayload);
            writer.flush();
            response.flushBuffer();
        } else {
            super.transportResponse(request, response, msgCtx);
        }
    }

    @Override
    public InMessageContext receive(HttpServletRequest req, HttpServletResponse response, Role partnerRole) throws HttpStatusCodeException, IOException {
        OauthBindingGroup.checkLicense();
        InMessageContext inCtx = new InMessageContext();
        inCtx.setIsRequest(true);
        if ("GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
            throw new HttpStatusCodeException(405);
        }
        OauthBindingGroup.getSetParam(req, "token", inCtx, true);
        OauthBindingGroup.getSetParam(req, "access_token_manager_id", inCtx);
        OauthBindingGroup.getSetParam(req, "aud", inCtx);
        OauthBindingGroup.getSetResourceParam(req, inCtx);
        OauthBindingGroup.getSetParam(req, "token_type_hint", inCtx);
        OauthBindingGroup.getClientIdSetEntityId(req, inCtx);
        return inCtx;
    }

    @Override
    public String getUri() {
        return "oauth:introspect";
    }

    private String createJwtResponse(HttpServletRequest request, OutMessageContext msgCtx) {
        Client client = msgCtx.getSupplementalContext("token_introspection_client", Client.class);
        Map<String, Object> claims = this.createClaimsMap(msgCtx, request, client);
        return this.oAuthJwtTokenService.issueTokenIntrospectionResponse(request, client, claims);
    }

    private Map<String, Object> createClaimsMap(OutMessageContext msgCtx, HttpServletRequest request, Client client) {
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        String issuer = this.oAuthIssuerUtils.getIssuerValue(request);
        claims.put("iss", issuer);
        claims.put("aud", client.getClientId());
        NumericDate date = NumericDate.now();
        long now = date.getValue();
        claims.put("iat", now);
        claims.put("token_introspection", msgCtx.getParams());
        return claims;
    }
}

