/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.oauth20.bindings.AuthorizationEndpointBinding;
import org.sourceid.oauth20.bindings.DeviceAuthorizationEndpointBinding;
import org.sourceid.oauth20.bindings.IntrospectEndpointBinding;
import org.sourceid.oauth20.bindings.PushedAuthorizationRequestBinding;
import org.sourceid.oauth20.bindings.SimpleBindingForGrantManagement;
import org.sourceid.oauth20.bindings.TokenEndpointBinding;
import org.sourceid.oauth20.bindings.UserAuthorizationEndpointBinding;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;
import org.sourceid.websso.bindings.ProtocolBindingGroup;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;

public class OauthBindingGroup
extends ProtocolBindingGroup {
    public static final String OAUTH2_SUFFIX = ".oauth2";
    private final TokenEndpointBinding backChannel = new TokenEndpointBinding();
    private final AuthorizationEndpointBinding frontChannel = new AuthorizationEndpointBinding();
    private final IntrospectEndpointBinding introspectEndpoint = new IntrospectEndpointBinding();
    private final DeviceAuthorizationEndpointBinding deviceAuthzEndpoint = new DeviceAuthorizationEndpointBinding();
    private final UserAuthorizationEndpointBinding userAuthzEndpoint = new UserAuthorizationEndpointBinding();
    private final PushedAuthorizationRequestBinding parBinding = new PushedAuthorizationRequestBinding();
    private final SimpleBindingForGrantManagement simpleBindingForGrantManagement = new SimpleBindingForGrantManagement();

    public OauthBindingGroup() {
        this.bindings = new Binding[]{this.frontChannel, this.backChannel, this.introspectEndpoint, this.deviceAuthzEndpoint, this.userAuthzEndpoint, this.parBinding, this.simpleBindingForGrantManagement};
    }

    @Override
    public String ascertainBindingName(HttpServletRequest req, boolean isPost) throws IOException {
        String contextPath;
        switch (contextPath = req.getServletPath()) {
            case "/as/token.oauth2": 
            case "/as/revoke_token.oauth2": {
                return this.backChannel.getUri();
            }
            case "/as/introspect.oauth2": {
                return this.introspectEndpoint.getUri();
            }
            case "/as/device_authz.oauth2": {
                return this.deviceAuthzEndpoint.getUri();
            }
            case "/as/user_authz.oauth2": {
                return this.userAuthzEndpoint.getUri();
            }
            case "/as/par.oauth2": {
                return this.parBinding.getUri();
            }
            case "/as/authorization.oauth2": {
                return this.frontChannel.getUri();
            }
        }
        return this.simpleBindingForGrantManagement.getUri();
    }

    public static void getSetParam(HttpServletRequest req, String name, InMessageContext inMsgCtx) {
        inMsgCtx.setParam(name, req.getParameter(name), false);
    }

    public static void getSetParam(HttpServletRequest req, String name, InMessageContext inMsgCtx, boolean mask) {
        inMsgCtx.setParam(name, req.getParameter(name), mask);
    }

    public static void getSetResourceParam(HttpServletRequest req, InMessageContext inMsgCtx) {
        Set<String> resources = ResourceIndicatorsUtils.getResourceParams(req);
        inMsgCtx.setParam("resource", resources);
    }

    static String getClientIdSetEntityId(HttpServletRequest req, InMessageContext inMsgCtx) throws IOException {
        String clientId = req.getParameter(Parameters.CLIENT_ID);
        inMsgCtx.setEntityId(clientId);
        return clientId;
    }

    public static void checkLicense() throws HttpStatusCodeException {
        PingLicense license = LicenseManager.getLicense();
        if (!license.isOAuthEnabled()) {
            throw new HttpStatusCodeException("This server is not properly licensed for OAuth functionality.", 503);
        }
    }
}

