/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class SimpleBindingForGrantManagement
implements Binding {
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException {
        StringBuilder msg = new StringBuilder(msgCtx.getParam("error"));
        if (StringUtils.isNotBlank((String)msgCtx.getParam("error_description"))) {
            msg.append(" - ").append(msgCtx.getParam("error_description"));
        }
        response.sendError(403, msg.toString());
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        OauthBindingGroup.checkLicense();
        InMessageContext ctx = new InMessageContext();
        ctx.setIsRequest(true);
        this.oAuthIssuerUtils.setMessageContextOAuthIssuerIfApplicable(request, ctx);
        return ctx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException {
        throw new ServletException((Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return "oauth:manage-grants";
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) {
        throw new UnsupportedOperationException();
    }
}

