/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.client;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jwk.JwkWrapper;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.SigningAlgorithmException;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;

public class ClientAuthSupport {
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(ClientAuthSupport.class);
    private static final float EXPIRATION_TIME_MINS = 5.0f;
    private static final String CONFIG_NAME_NBF = "pastValidityInMinutes";
    private static final String OIDC_IDP_NBF_CONFIG_NAME = "oidcIdpNbfTimeSkewMinutes";
    private static final int CONFIG_DEFAULT_VALUE_NBF = 0;
    private static final String TYPE_HEADER_NAME = "typ";
    private static final long NBF_DEFAULT_OFFSET_SECONDS = 5L;
    private static final Log log = LogFactory.getLog(ClientAuthSupport.class);
    private static final JwkFacilitator jwkFacilitator = GlobalRegistry.getService(JwkFacilitator.class);

    public static void populateClientAuthParam(OIDCSettings settings, String clientId, Map<String, Object> params, HttpPost post) throws BindingException {
        if (settings.isPrivateKeyJwtAuth() || settings.isClientSecretJwtAuth()) {
            ClientAuthSupport.generateJwt(settings, clientId, params);
        } else if (StringUtils.isNotBlank((String)settings.getClientSecret())) {
            String password = Obfuscator.deobfuscate(settings.getClientSecret());
            if (SecretReferenceUtil.isSecretReference((String)password)) {
                try {
                    SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(password);
                    SecretReferenceHelper.Credentials credentials = secretReferenceHelper.getSecretInfo(clientId);
                    password = credentials.getSecret();
                }
                catch (SecretManagerException e) {
                    throw new BindingException("Unable to obtain credentials.", e);
                }
            }
            if (settings.isBasicAuth()) {
                String urlEncodedClient = Util.urlEncodeUTF8(clientId);
                String urlEncodedPassword = Util.urlEncodeUTF8(password);
                String clientIdPassword = urlEncodedClient + ":" + urlEncodedPassword;
                byte[] encodedBase64 = Base64.encodeBase64((byte[])clientIdPassword.getBytes(StandardCharsets.UTF_8));
                String value = "Basic " + new String(encodedBase64, StandardCharsets.UTF_8);
                post.setHeader("Authorization", value);
            } else {
                params.put(Parameters.CLIENT_ID, clientId);
                params.put(Parameters.CLIENT_SECRET, password);
            }
        } else {
            params.put(Parameters.CLIENT_ID, clientId);
        }
    }

    private static void generateJwt(OIDCSettings settings, String clientId, Map<String, Object> params) throws BindingException {
        long nbfSeconds;
        JsonWebSignature jws = new JsonWebSignature();
        log.debug((Object)("client " + clientId + " jws algo is " + settings.getSigningAlgorithm()));
        jws.setAlgorithmHeaderValue(settings.getSigningAlgorithm());
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(clientId);
        claims.setSubject(clientId);
        if (StringUtils.isNotBlank((String)settings.getAudience())) {
            claims.setAudience(settings.getAudience());
        } else {
            claims.setAudience(settings.getTokenEndpoint().getFullLocation());
        }
        claims.setGeneratedJwtId();
        if (StringUtils.isNotBlank((String)settings.getLifetime())) {
            claims.setExpirationTimeMinutesInTheFuture((float)Integer.parseInt(settings.getLifetime()));
        } else {
            claims.setExpirationTimeMinutesInTheFuture(5.0f);
        }
        if (configStore.getIntValue(CONFIG_NAME_NBF, 0) != 0) {
            nbfSeconds = configStore.getLongValue(CONFIG_NAME_NBF, 0L) * 60L;
            claims.setNotBefore(NumericDate.fromMilliseconds((long)(System.currentTimeMillis() - nbfSeconds * 1000L)));
        }
        if (settings.isIncludeNotBeforeClaim()) {
            if (configStore.getIntValue(OIDC_IDP_NBF_CONFIG_NAME, 0) != 0) {
                nbfSeconds = configStore.getLongValue(OIDC_IDP_NBF_CONFIG_NAME, 0L) * 60L;
                claims.setNotBefore(NumericDate.fromMilliseconds((long)(System.currentTimeMillis() - nbfSeconds * 1000L)));
            } else {
                claims.setNotBefore(NumericDate.fromMilliseconds((long)(System.currentTimeMillis() - 5000L)));
            }
        }
        if (StringUtils.isNotBlank((String)settings.getType())) {
            jws.setHeader(TYPE_HEADER_NAME, settings.getType());
        }
        claims.setIssuedAtToNow();
        jws.setPayload(claims.toJson());
        ClientAuthSupport.sign(jws, log, settings.isPrivateKeyJwtAuth(), settings.getClientSecret(), true);
        try {
            String jwt = jws.getCompactSerialization();
            params.put(Parameters.CLIENT_ID, clientId);
            params.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            params.put("client_assertion", jwt);
        }
        catch (JoseException e) {
            log.debug((Object)"Failed to create JWT", (Throwable)e);
            throw new BindingException("Failed to create JWT");
        }
    }

    public static void sign(JsonWebSignature jws, Log log, boolean isAsymmetric, String symmetricKey, boolean isKeyHashed) throws BindingException {
        if (isAsymmetric) {
            ClientAuthSupport.sign(jws, log);
        } else {
            byte[] deObfuscatedBinary = isKeyHashed ? Obfuscator.deobfuscateBinary(symmetricKey) : symmetricKey.getBytes(StandardCharsets.UTF_8);
            jws.setDoKeyValidation(false);
            jws.setKey((Key)new HmacKey(deObfuscatedBinary));
        }
    }

    public static void sign(JsonWebSignature jws, Log log) throws BindingException {
        try {
            JwkWrapper currentSingingKey;
            String keyType;
            switch (keyType = jws.getKeyType()) {
                case "RSA": {
                    currentSingingKey = jwkFacilitator.getCurrentRsaKey(jws.getAlgorithm().getAlgorithmIdentifier());
                    break;
                }
                case "EC": {
                    JsonWebSignatureAlgorithm algorithm = jws.getAlgorithm();
                    EcdsaUsingShaAlgorithm ecdsaAlgorithm = (EcdsaUsingShaAlgorithm)algorithm;
                    currentSingingKey = jwkFacilitator.getCurrentEcKey(ecdsaAlgorithm.getCurveName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown key type: " + keyType);
                }
            }
            if (currentSingingKey == null) {
                throw new SigningAlgorithmException(jws.getAlgorithmHeaderValue());
            }
            jws.setKey((Key)currentSingingKey.getPrivateKey());
            jws.setKeyIdHeaderValue(currentSingingKey.getJwk().getKeyId());
            JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, currentSingingKey);
        }
        catch (InvalidAlgorithmException e) {
            log.debug((Object)"Failed to sign jwt", (Throwable)e);
            throw new BindingException(e.toString());
        }
    }
}

