/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.consent;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class OAuthConsent {
    public static final int CONSENT_DO_NOT_EXPIRE_LIFETIME_DAYS = -1;
    private final String guid;
    private final String userKey;
    private final String clientId;
    private final Scope scope;
    private final AuthorizationDetail authorizationDetail;
    private final long created;
    private final long updated;
    private final Long expires;

    public OAuthConsent(AccessGrant accessGrant) {
        this.guid = accessGrant.getGuid();
        this.userKey = accessGrant.getUniqueUserIdentifer();
        this.clientId = accessGrant.getClientId();
        this.scope = accessGrant.getScope();
        this.authorizationDetail = accessGrant.getAuthorizationDetails() != null && CollectionUtils.isNotEmpty((Collection)accessGrant.getAuthorizationDetails().getDetails()) ? (AuthorizationDetail)accessGrant.getAuthorizationDetails().getDetails().get(0) : null;
        this.created = accessGrant.getIssued();
        this.updated = accessGrant.getUpdated();
        this.expires = accessGrant.getExpires();
    }

    public String getGuid() {
        return this.guid;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public AuthorizationDetail getAuthorizationDetail() {
        return this.authorizationDetail;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public Long getExpires() {
        return this.expires;
    }
}

