/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.consent.impl;

import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.consent.OAuthConsent;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.utils.AccessGrantUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public final class OAuthConsentManagerDefaultImpl
implements OAuthConsentManager,
AutoReloadable {
    private static final Log LOG = LogFactory.getLog(OAuthConsentManagerDefaultImpl.class);
    private static final AttributeMap EMPTY_ATTRIBUTE_MAP = new AttributeMap();
    private static final DateTimeFormatter EXPIRY_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS z").withZone(ZoneId.systemDefault());
    private static final String CREATED_LOG_MSG_SUFFIX = "Created";
    private static final String UPDATED_LOG_MSG_SUFFIX = "Updated";
    private static final String REVOKED_LOG_MSG_SUFFIX = "Revoked";
    static final String DEFAULT_SCOPE_STR = "";
    static final String CONSENT_CONTEXT_QUALIFIER = "authz_req|user_consent";
    private final AuthzServerManager authzServerManager;
    private final AccessGrantManager accessGrantManager;

    public OAuthConsentManagerDefaultImpl() {
        this(MgmtFactory.getAuthzServerManager(), MgmtFactory.getAccessGrantManager());
    }

    public OAuthConsentManagerDefaultImpl(AuthzServerManager authzServerManager, AccessGrantManager accessGrantManager) {
        this.authzServerManager = authzServerManager;
        this.accessGrantManager = accessGrantManager;
    }

    @Override
    public void createOrUpdate(String userKey, String clientId, Scope requestedScope, Scope approvedScope, AuthorizationDetails requestedAuthorizationDetails, AuthorizationDetails approvedAuthorizationDetails) {
        Scope approvedExpandedScope = OAuthConsentManagerDefaultImpl.toExpandedScope(approvedScope);
        Scope deniedExpandedScope = new Scope(new String[0]);
        deniedExpandedScope.getScopeSet().addAll(requestedScope.getScopeSet());
        deniedExpandedScope.getScopeSet().removeAll(approvedScope.getScopeSet());
        deniedExpandedScope = OAuthConsentManagerDefaultImpl.toExpandedScope(deniedExpandedScope);
        deniedExpandedScope.getScopeSet().remove(DEFAULT_SCOPE_STR);
        List<AccessGrant> allConsents = this.getConsentsByUserKeyClientId(userKey, clientId);
        Map<String, AccessGrant> consentScopeMap = OAuthConsentManagerDefaultImpl.buildConsentScopeMap(allConsents);
        Long consentExpiryTimeMillis = this.computeExpiryTimeMillis();
        if (!allConsents.isEmpty()) {
            Object consent2;
            for (String scope : approvedExpandedScope.getScopeSet()) {
                if (deniedExpandedScope.getScopeSet().contains(scope)) continue;
                if (consentScopeMap.containsKey(scope)) {
                    consent2 = consentScopeMap.get(scope);
                    consent2.setExpires(consentExpiryTimeMillis);
                    this.accessGrantManager.updateExpiry((AccessGrant)consent2);
                    this.logAndAuditConsentUpdated((AccessGrant)consent2, clientId, approvedScope);
                    continue;
                }
                consent2 = new AccessGrant(userKey, new Scope(scope), clientId, "user_consent", CONSENT_CONTEXT_QUALIFIER);
                consent2.setExpires(consentExpiryTimeMillis);
                AccessGrantAttributesHolder attributesHolder = new AccessGrantAttributesHolder(EMPTY_ATTRIBUTE_MAP, EMPTY_ATTRIBUTE_MAP);
                this.accessGrantManager.saveGrant((AccessGrant)consent2, attributesHolder);
                this.logAndAuditConsentCreated((AccessGrant)consent2, clientId, approvedScope);
            }
            for (String scope : deniedExpandedScope.getScopeSet()) {
                consent2 = consentScopeMap.remove(scope);
                if (consent2 == null) continue;
                this.accessGrantManager.deleteGrant(consent2.getGuid());
                this.logAndAuditConsentRevoked((AccessGrant)consent2, consent2.getClientId(), approvedScope);
            }
            AuthorizationDetailContext context = new AuthorizationDetailContext(null, clientId, approvedScope);
            if (CollectionUtils.isNotEmpty((Collection)approvedAuthorizationDetails.getDetails())) {
                List authorizationDetailConsents = allConsents.stream().filter(consent -> !OAuthConsentManagerDefaultImpl.isScopeConsent(consent)).collect(Collectors.toList());
                for (AuthorizationDetail authorizationDetail : approvedAuthorizationDetails.getDetails()) {
                    boolean isUpdated = false;
                    for (AccessGrant consent3 : authorizationDetailConsents) {
                        if (!AuthorizationDetailsUtil.isEqualOrSubset(authorizationDetail, consent3.getAuthorizationDetails(), context)) continue;
                        isUpdated = true;
                        consent3.setExpires(consentExpiryTimeMillis);
                        this.accessGrantManager.updateExpiry(consent3);
                        this.logAndAuditConsentUpdated(consent3, clientId, approvedScope);
                        break;
                    }
                    if (isUpdated) continue;
                    AccessGrant consent4 = new AccessGrant(userKey, new Scope(new String[0]), clientId, "user_consent", CONSENT_CONTEXT_QUALIFIER);
                    consent4.setAuthorizationDetails(new AuthorizationDetails(new AuthorizationDetail[]{authorizationDetail}));
                    consent4.setExpires(consentExpiryTimeMillis);
                    AccessGrantAttributesHolder attributesHolder = new AccessGrantAttributesHolder(EMPTY_ATTRIBUTE_MAP, EMPTY_ATTRIBUTE_MAP);
                    this.accessGrantManager.saveGrant(consent4, attributesHolder);
                    this.logAndAuditConsentCreated(consent4, clientId, approvedScope);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)requestedAuthorizationDetails.getDetails()) && CollectionUtils.isNotEmpty((Collection)approvedAuthorizationDetails.getDetails()) && requestedAuthorizationDetails.getDetails().size() != approvedAuthorizationDetails.getDetails().size()) {
                LinkedList<AuthorizationDetail> deniedAuthorizationDetailList = new LinkedList<AuthorizationDetail>();
                for (AuthorizationDetail requestedAuthorizationDetail : requestedAuthorizationDetails.getDetails()) {
                    if (AuthorizationDetailsUtil.isEqualOrSubset(requestedAuthorizationDetail, approvedAuthorizationDetails, context)) continue;
                    deniedAuthorizationDetailList.add(requestedAuthorizationDetail);
                }
                AuthorizationDetails deniedAuthorizationDetails = new AuthorizationDetails(deniedAuthorizationDetailList.toArray(new AuthorizationDetail[0]));
                this.revokeAuthorizationDetails(allConsents, deniedAuthorizationDetails, context);
            }
        } else {
            AccessGrantAttributesHolder attributesHolder;
            AccessGrant consent5;
            for (String scope : approvedExpandedScope.getScopeSet()) {
                if (deniedExpandedScope.getScopeSet().contains(scope)) continue;
                consent5 = new AccessGrant(userKey, new Scope(scope), clientId, "user_consent", CONSENT_CONTEXT_QUALIFIER);
                consent5.setExpires(consentExpiryTimeMillis);
                attributesHolder = new AccessGrantAttributesHolder(EMPTY_ATTRIBUTE_MAP, EMPTY_ATTRIBUTE_MAP);
                this.accessGrantManager.saveGrant(consent5, attributesHolder);
                this.logAndAuditConsentCreated(consent5, clientId, approvedScope);
            }
            if (CollectionUtils.isNotEmpty((Collection)approvedAuthorizationDetails.getDetails())) {
                for (AuthorizationDetail authorizationDetail : approvedAuthorizationDetails.getDetails()) {
                    consent5 = new AccessGrant(userKey, new Scope(new String[0]), clientId, "user_consent", CONSENT_CONTEXT_QUALIFIER);
                    consent5.setAuthorizationDetails(new AuthorizationDetails(new AuthorizationDetail[]{authorizationDetail}));
                    consent5.setExpires(consentExpiryTimeMillis);
                    attributesHolder = new AccessGrantAttributesHolder(EMPTY_ATTRIBUTE_MAP, EMPTY_ATTRIBUTE_MAP);
                    this.accessGrantManager.saveGrant(consent5, attributesHolder);
                    this.logAndAuditConsentCreated(consent5, clientId, approvedScope);
                }
            }
        }
    }

    @Override
    public OAuthConsent getByGuid(String consentGuid) {
        AccessGrant accessGrant = this.accessGrantManager.getByGuid(consentGuid);
        if (accessGrant != null && AccessGrantUtils.isOAuthConsent(accessGrant)) {
            return new OAuthConsent(accessGrant);
        }
        return null;
    }

    @Override
    public List<OAuthConsent> getByUserKey(String userKey) {
        Collection accessGrants = this.accessGrantManager.getByUserKey(userKey);
        return this.deleteDuplicatesAndMapToOAuthConsent(accessGrants, AccessGrant::getClientId);
    }

    @Override
    public List<OAuthConsent> getByClientId(String clientId) {
        Collection accessGrants = this.accessGrantManager.getByClientId(clientId);
        return this.deleteDuplicatesAndMapToOAuthConsent(accessGrants, AccessGrant::getUniqueUserIdentifer);
    }

    private List<OAuthConsent> deleteDuplicatesAndMapToOAuthConsent(Collection<AccessGrant> accessGrants, Function<AccessGrant, String> groupByFunction) {
        Map<String, List<AccessGrant>> consents = accessGrants.stream().filter(AccessGrantUtils::isOAuthConsent).collect(Collectors.groupingBy(groupByFunction));
        LinkedList<OAuthConsent> result = new LinkedList<OAuthConsent>();
        consents.forEach((key, value) -> this.revokeDuplicateConsents((Collection<AccessGrant>)value).stream().map(OAuthConsent::new).collect(Collectors.toCollection(() -> result)));
        return result;
    }

    @Override
    public boolean isGranted(String userKey, String clientId, Scope requestedScope, AuthorizationDetails requestedAuthorizationDetails) {
        List<AccessGrant> allConsents = this.getConsentsByUserKeyClientId(userKey, clientId);
        Scope combinedScopeConsent = new Scope(new String[0]);
        AuthorizationDetails combinedAuthorizationDetailsConsent = new AuthorizationDetails(new AuthorizationDetail[0]);
        for (AccessGrant consent : allConsents) {
            if (OAuthConsentManagerDefaultImpl.isScopeConsent(consent)) {
                if (consent.getScope().getScopeSet().isEmpty()) {
                    combinedScopeConsent.getScopeSet().add(DEFAULT_SCOPE_STR);
                    continue;
                }
                combinedScopeConsent.getScopeSet().addAll(consent.getScope().getScopeSet());
                continue;
            }
            combinedAuthorizationDetailsConsent.getDetails().addAll(consent.getAuthorizationDetails().getDetails());
        }
        Scope requestedExpandedScope = OAuthConsentManagerDefaultImpl.toExpandedScope(requestedScope);
        if (requestedExpandedScope.isEqualOrLesserThan(combinedScopeConsent)) {
            if (requestedAuthorizationDetails == null || CollectionUtils.isEmpty((Collection)requestedAuthorizationDetails.getDetails())) {
                return true;
            }
            AuthorizationDetailContext context = new AuthorizationDetailContext(null, clientId, requestedScope);
            return AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)requestedAuthorizationDetails, (AuthorizationDetails)combinedAuthorizationDetailsConsent, (AuthorizationDetailContext)context);
        }
        return false;
    }

    @Override
    public void deny(String userKey, String clientId, Scope deniedScope, AuthorizationDetails deniedAuthorizationDetails) {
        List<AccessGrant> allConsents = this.getConsentsByUserKeyClientId(userKey, clientId);
        Map<String, AccessGrant> consentScopeMap = OAuthConsentManagerDefaultImpl.buildConsentScopeMap(allConsents);
        Set deniedExpandedScopeSet = OAuthConsentManagerDefaultImpl.toExpandedScope(deniedScope).getScopeSet();
        for (String deniedScopeStr : deniedExpandedScopeSet) {
            AccessGrant consent = consentScopeMap.remove(deniedScopeStr);
            if (consent == null) continue;
            this.accessGrantManager.deleteGrant(consent.getGuid());
            this.logAndAuditConsentRevoked(consent, clientId, deniedScope);
        }
        AuthorizationDetailContext context = new AuthorizationDetailContext(null, clientId, deniedScope);
        this.revokeAuthorizationDetails(allConsents, deniedAuthorizationDetails, context);
    }

    @Override
    public void revoke(String consentGuid) {
        this.accessGrantManager.deleteGrant(consentGuid);
        String message = "Revoked OAuth consent '" + consentGuid + "'.";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
    }

    private static boolean isScopeConsent(AccessGrant consent) {
        return AccessGrantUtils.isOAuthConsent(consent) && (consent.getAuthorizationDetails() == null || CollectionUtils.isEmpty((Collection)consent.getAuthorizationDetails().getDetails()));
    }

    private List<AccessGrant> getConsentsByUserKeyClientId(String userKey, String clientId) {
        Collection allConsents = this.accessGrantManager.getByUserKeyClientIdGrantType(userKey, clientId, "user_consent");
        return this.revokeDuplicateConsents(allConsents);
    }

    private Long computeExpiryTimeMillis() {
        int consentLifeTimeDays = this.authzServerManager.getConsentLifetimeDays();
        if (consentLifeTimeDays == -1) {
            return null;
        }
        return System.currentTimeMillis() + (long)consentLifeTimeDays * 24L * 60L * 60L * 1000L;
    }

    private void revokeAuthorizationDetails(List<AccessGrant> allConsents, AuthorizationDetails deniedAuthorizationDetails, AuthorizationDetailContext context) {
        if (deniedAuthorizationDetails == null || CollectionUtils.isEmpty((Collection)deniedAuthorizationDetails.getDetails())) {
            return;
        }
        List authorizationDetailConsents = allConsents.stream().filter(consent -> !OAuthConsentManagerDefaultImpl.isScopeConsent(consent)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(authorizationDetailConsents)) {
            return;
        }
        HashSet<String> revokedConsents = new HashSet<String>();
        for (AuthorizationDetail deniedAuthorizationDetail : deniedAuthorizationDetails.getDetails()) {
            for (AccessGrant consent2 : authorizationDetailConsents) {
                if (revokedConsents.contains(consent2.getGuid()) || !AuthorizationDetailsUtil.isEqualOrSubset(deniedAuthorizationDetail, consent2.getAuthorizationDetails(), context)) continue;
                revokedConsents.add(consent2.getGuid());
                this.accessGrantManager.deleteGrant(consent2.getGuid());
                this.logAndAuditConsentRevoked(consent2, consent2.getClientId(), new Scope(context.getScope()));
            }
        }
    }

    private static Scope toExpandedScope(Scope scope) {
        LinkedHashSet<String> expandedScopeSet = new LinkedHashSet<String>(scope.expanded().getScopeSet());
        expandedScopeSet.add(DEFAULT_SCOPE_STR);
        return new Scope(expandedScopeSet);
    }

    private static Map<String, AccessGrant> buildConsentScopeMap(List<AccessGrant> allConsents) {
        return allConsents.stream().filter(OAuthConsentManagerDefaultImpl::isScopeConsent).collect(Collectors.toMap(consent -> consent.getScope().getScopeStr(), consent -> consent));
    }

    private List<AccessGrant> revokeDuplicateConsents(Collection<AccessGrant> allConsents) {
        HashSet scopes = new HashSet();
        LinkedList revokedGuids = new LinkedList();
        allConsents.stream().sorted(Comparator.comparingLong(AccessGrant::getUpdated).reversed()).forEach(consent -> {
            if (OAuthConsentManagerDefaultImpl.isScopeConsent(consent)) {
                if (scopes.contains(consent.getScope().getScopeStr())) {
                    this.accessGrantManager.deleteGrant(consent.getGuid());
                    this.logAndAuditConsentRevoked((AccessGrant)consent, consent.getClientId(), consent.getScope());
                    revokedGuids.add(consent.getGuid());
                } else {
                    scopes.add(consent.getScope().getScopeStr());
                }
            }
        });
        if (LOG.isDebugEnabled() && !revokedGuids.isEmpty()) {
            LOG.debug((Object)("Revoked duplicate OAuth consents " + revokedGuids.stream().map(guid -> "'" + guid + "'").collect(Collectors.joining(","))));
        }
        return allConsents.stream().filter(consent -> !revokedGuids.contains(consent.getGuid())).collect(Collectors.toList());
    }

    private void logAndAuditConsentCreated(AccessGrant consent, String clientId, Scope scope) {
        this.logAndAuditConsentEvent(consent, clientId, scope, CREATED_LOG_MSG_SUFFIX);
    }

    private void logAndAuditConsentUpdated(AccessGrant consent, String clientId, Scope scope) {
        this.logAndAuditConsentEvent(consent, clientId, scope, UPDATED_LOG_MSG_SUFFIX);
    }

    private void logAndAuditConsentRevoked(AccessGrant consent, String clientId, Scope scope) {
        this.logAndAuditConsentEvent(consent, clientId, scope, REVOKED_LOG_MSG_SUFFIX);
    }

    private void logAndAuditConsentEvent(AccessGrant consent, String clientId, Scope scope, String logMessageSuffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(logMessageSuffix);
        sb.append(" OAuth consent '");
        sb.append(consent.getGuid());
        if (OAuthConsentManagerDefaultImpl.isScopeConsent(consent)) {
            sb.append("' for scope '");
            sb.append(consent.getScope().getScopeStr());
            sb.append("'.");
        } else {
            Map<AuthorizationDetail, String> descriptions = AuthorizationDetailsUtil.getDescriptions(consent.getAuthorizationDetails(), null, clientId, scope);
            sb.append("' for authorization detail with description '");
            sb.append(descriptions.get(consent.getAuthorizationDetails().getDetails().get(0)));
            sb.append("'.");
        }
        if (CREATED_LOG_MSG_SUFFIX.equals(logMessageSuffix) || UPDATED_LOG_MSG_SUFFIX.equals(logMessageSuffix)) {
            if (consent.getExpires() != null) {
                Instant inst = Instant.ofEpochMilli(consent.getExpires());
                sb.append(" OAuth consent expires at ");
                sb.append(EXPIRY_DATE_TIME_FORMATTER.format(inst));
                sb.append(".");
            } else {
                sb.append(" OAuth consent does not expire.");
            }
        }
        String message = sb.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
        AsAuditLogger.log(message);
    }
}

