/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.base.Enums;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public abstract class AbstractClientManagerImpl
implements ClientManager,
ServiceInformation,
AutoReloadable {
    private static final Comparator<Client> COMPARE_BY_NAME_UP = (client1, client2) -> client1.getName().compareToIgnoreCase(client2.getName()) * -1;
    private static final Comparator<Client> COMPARE_BY_NAME_DOWN = (client1, client2) -> client1.getName().compareToIgnoreCase(client2.getName());
    private static final Comparator<Client> COMPARE_BY_ID_UP = (client1, client2) -> client1.getClientId().compareToIgnoreCase(client2.getClientId()) * -1;
    private static final Comparator<Client> COMPARE_BY_ID_DOWN = (client1, client2) -> client1.getClientId().compareToIgnoreCase(client2.getClientId());
    private static final Comparator<Client> COMPARE_BY_LAST_MODIFIED_UP = (client1, client2) -> ObjectUtils.compare((Comparable)client2.getLastModified(), (Comparable)client1.getLastModified());
    private static final Comparator<Client> COMPARE_BY_LAST_MODIFIED_DOWN = (client1, client2) -> ObjectUtils.compare((Comparable)client1.getLastModified(), (Comparable)client2.getLastModified());
    private static final Comparator<Client> COMPARE_BY_CREATION_DATE_UP = (client1, client2) -> ComparisonChain.start().compare((Comparable)client2.getCreationTime(), (Comparable)client1.getCreationTime()).compare((Object)client1.getName(), (Object)client2.getName(), String::compareToIgnoreCase).result();
    private static final Comparator<Client> COMPARE_BY_CREATION_DATE_DOWN = (client1, client2) -> ComparisonChain.start().compare((Comparable)client1.getCreationTime(), (Comparable)client2.getCreationTime()).compare((Object)client1.getName(), (Object)client2.getName(), String::compareToIgnoreCase).result();
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("admin-client-cache-config");
    private final ConfigStore engineConfigStore = ConfigStoreFarm.getConfig("engine-client-cache-config");
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    private int adminConsoleCacheExpirySecs = this.configStore.getIntValue("expiry", 60);
    private int engineCacheExpirySecs = this.engineConfigStore.getIntValue("cacheExpirySecs", 60);
    private long maximumSize = this.engineConfigStore.getLongValue("maximumSize", 10000L);
    private static final Log log = LogFactory.getLog(AbstractClientManagerImpl.class);
    public static final String OAUTH_CLIENTS_DIRECTORY = "oauth-clients";
    protected static final int DEFAULT_DATABASE_SEARCH_CLIENT_COUNT = 2000;
    private static final String ALL_CLIENTS = "ignored";
    private LoadingCache<String, Collection<Client>> clientsCache = this.buildClientsCache();
    protected LoadingCache<String, Optional<Client>> engineClientsCache = this.buildEngineClientsCache();

    private LoadingCache<String, Collection<Client>> buildClientsCache() {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.adminConsoleCacheExpirySecs, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Collection<Client>>(){

            public Collection<Client> load(String ignored) {
                return AbstractClientManagerImpl.this.doGetClients();
            }
        });
    }

    private LoadingCache<String, Optional<Client>> buildEngineClientsCache() {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.engineCacheExpirySecs, TimeUnit.SECONDS).maximumSize(this.maximumSize).build((CacheLoader)new CacheLoader<String, Optional<Client>>(){

            public Optional<Client> load(String clientId) {
                return Optional.ofNullable(AbstractClientManagerImpl.this.getClient(clientId));
            }
        });
    }

    AbstractClientManagerImpl() {
    }

    protected Client doSanitize(Client client, Sanitizer<Client> sanitizer, Sanitizer<Client> ... sanitizers) {
        client = sanitizer.sanitize(client);
        if (sanitizers != null) {
            for (Sanitizer<Client> s : sanitizers) {
                client = s.sanitize(client);
            }
        }
        return client;
    }

    public String getServiceName() {
        return "client-manager";
    }

    @Override
    public Client getClient(String clientId) {
        if (StringUtils.isBlank((String)clientId)) {
            return null;
        }
        return this.doGetClient(clientId);
    }

    protected abstract Client doGetClient(String var1);

    @Override
    public void addClient(Client client) {
        this.clearCache();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doAddClient(client);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENTS, AdminAuditLogger.Event.CREATE, client.getClientId());
        }
    }

    public abstract void doAddClient(Client var1);

    @Override
    public void addClients(Collection<Client> clients) {
        this.clearCache();
        this.doAddClients(clients);
    }

    protected abstract void doAddClients(Collection<Client> var1);

    @Override
    public synchronized Collection<Client> getClients() {
        try {
            return (Collection)this.clientsCache.get((Object)ALL_CLIENTS);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new ClientManager.ClientManagementException(e.getCause());
        }
    }

    public abstract Collection<Client> doGetClients();

    @Override
    public Collection<String> getValidClients(List<String> clientIds) {
        if (clientIds == null || clientIds.isEmpty()) {
            return new HashSet<String>();
        }
        return clientIds.stream().filter(clientId -> Objects.nonNull(this.getClient((String)clientId))).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public Client updateClient(Client client) {
        this.clearCache();
        this.invalidateClientCache(client.getClientId());
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            Client updatedClient = this.doUpdateClient(client);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENTS, AdminAuditLogger.Event.MODIFY, client.getClientId());
            Client client2 = updatedClient;
            return client2;
        }
    }

    protected abstract Client doUpdateClient(Client var1);

    @Override
    public abstract boolean isDataSourceInUse(String var1);

    @Override
    public Collection<Client> getClientsByPolicyGroupId(String policyGroupId) {
        return this.searchClientsByPolicyGroupId(policyGroupId);
    }

    @Override
    public Collection<Client> getClientsByCIBAPolicyId(String policyId) {
        return this.searchClientsByCIBAPolicyId(policyId);
    }

    @Override
    public Collection<Client> getClientsByTeppId(String teppId) {
        return this.searchClientsByTeppId(teppId);
    }

    @Override
    public Collection<Client> getClientsByAtmId(String atmId) {
        return this.searchClientsByAtmId(atmId);
    }

    @Override
    public Collection<Client> getClientsByTlsCertIssuer(String issuerDn) {
        return this.searchClientsByTlsCertIssuer(issuerDn);
    }

    @Override
    public abstract boolean isBackendDatabase();

    @Override
    public int getClientCount() {
        return -1;
    }

    public abstract int getDatastoreSearchClientCount();

    @Override
    public synchronized SearchResult<Client> search(SearchCriteria searchCriteria) {
        ContainsCriteriaFilter<Client> filter = new ContainsCriteriaFilter<Client>(c -> new ItemMultiValue<Client, String>((Client)c, (K[])new String[]{c.getClientId(), c.getName()}));
        Collection<Client> searchResults = filter.doFilter(searchCriteria.getQuery(), this.getClients());
        searchResults = this.filterClientCollectionByFilterFields(searchResults, searchCriteria);
        if (searchCriteria.getStartIndex() >= searchResults.size()) {
            return new SearchResult<Client>(searchCriteria.getStartIndex(), Collections.emptyList());
        }
        if (searchCriteria.getOrderBy() != null) {
            searchResults = this.sortClients(searchResults, searchCriteria);
        }
        int fromIndex = searchCriteria.getStartIndex();
        int toIndex = searchCriteria.getTargetEndIndex() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
        return new SearchResult<Client>(searchCriteria.getStartIndex(), new ArrayList<Client>(searchResults).subList(fromIndex, toIndex));
    }

    protected Collection<Client> filterClientCollectionByFilterFields(Collection<Client> searchResults, SearchCriteria searchCriteria) {
        Collection<Client> filteredResults = this.filterClientCollectionByGrantType(searchResults, searchCriteria);
        if (filteredResults != null) {
            if (searchCriteria.getFilterBy() != null) {
                return filteredResults.stream().filter(client -> searchCriteria.getFilterBy().stream().allMatch(filterItem -> {
                    switch (FilterableField.valueOf(filterItem.getFieldName())) {
                        case CERT_ISSUER_ID: {
                            return Objects.equals(filterItem.getValue(), client.getClientCertIssuerDn());
                        }
                        case CIBA_POLICY_ID: {
                            return Objects.equals(filterItem.getValue(), client.getCibaPolicyId());
                        }
                        case DEFAULT_ATM_ID: {
                            return Objects.equals(filterItem.getValue(), client.getDefaultAccessTokenManagerId());
                        }
                        case OIDC_POLICY_ID: {
                            return Objects.equals(filterItem.getValue(), client.getPolicyGroupId());
                        }
                        case TEPP_ID: {
                            return Objects.equals(filterItem.getValue(), client.getTokenExchangeProcessorPolicyId());
                        }
                    }
                    return true;
                })).collect(Collectors.toList());
            }
            return filteredResults;
        }
        return new LinkedList<Client>();
    }

    @Override
    public void deleteClient(String clientId) {
        this.clearCache();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doDeleteClient(clientId);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CLIENTS, AdminAuditLogger.Event.DELETE, clientId);
        }
        this.cleanupReferences(clientId);
        this.invalidateClientCache(clientId);
    }

    private synchronized void clearCache() {
        this.clientsCache.invalidateAll();
    }

    protected abstract void doDeleteClient(String var1);

    protected void cleanupReferences(String clientId) {
        BearerAccessTokenMgmtPluginManager mgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        for (BearerAccessTokenMgmtPluginInstance instance : mgr.getInstances()) {
            if (!instance.getOwnAllowedClients().contains(clientId)) continue;
            ArrayList<String> allowedClients = new ArrayList<String>(instance.getOwnAllowedClients());
            allowedClients.remove(clientId);
            instance.setOwnAllowedClients(allowedClients);
            mgr.saveInstance(instance);
        }
    }

    protected synchronized File getClientsDirectory() {
        return new File(this.sysDirInfo.getDataDirectory() + File.separator + OAUTH_CLIENTS_DIRECTORY);
    }

    @Override
    public void cleanOAuthIndexDirectoryAndDatabase() {
        log.debug((Object)"Cleaning clients directory and database");
        File clientsDir = this.getClientsDirectory();
        if (clientsDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)clientsDir);
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to clean directory " + clientsDir);
            }
        }
        MgmtFactory.getOAuthClientIndexDb().deleteAllEntries();
        MgmtFactory.getOAuthClientIndexDb().deleteNewClientFiles();
    }

    protected TreeSet<String> getTargetGrantTypeSet(List<SearchCriteria.FilterItem> filterItemList) {
        TreeSet<String> targetGrantTypes = new TreeSet<String>();
        if (filterItemList != null) {
            for (SearchCriteria.FilterItem item : filterItemList) {
                if (!item.getFieldName().equals(FilterableField.GRANT_TYPE.toString())) continue;
                targetGrantTypes.add(item.getValue().toString().toLowerCase());
            }
        }
        return targetGrantTypes;
    }

    protected Collection<Client> filterClientCollectionByGrantType(Collection<Client> clientCollection, SearchCriteria searchCriteria) {
        TreeSet<String> grantTypeSet = this.getTargetGrantTypeSet(searchCriteria.getFilterBy());
        if (!grantTypeSet.isEmpty() && clientCollection != null) {
            ArrayList<Client> filteredClientCollection = new ArrayList<Client>();
            for (Client client : clientCollection) {
                if (Collections.disjoint(grantTypeSet, client.getGrantTypes())) continue;
                filteredClientCollection.add(client);
            }
            return filteredClientCollection;
        }
        return clientCollection;
    }

    @Override
    public Client getCachedClient(String clientId) {
        if (StringUtils.isBlank((String)clientId)) {
            return null;
        }
        return this.doGetClient(clientId);
    }

    @Override
    public synchronized void reload() {
        this.adminConsoleCacheExpirySecs = this.configStore.getIntValue("expiry", 60);
        this.engineCacheExpirySecs = this.engineConfigStore.getIntValue("cacheExpirySecs", 60);
        this.maximumSize = this.engineConfigStore.getLongValue("maximumSize", 10000L);
        this.clientsCache = this.buildClientsCache();
        this.engineClientsCache = this.buildEngineClientsCache();
    }

    @Override
    public String getManagedDirectoryName() {
        return null;
    }

    @Override
    public Iterator<ReplicationRecord> getReplicationRecords(Date startTime) {
        return null;
    }

    @Override
    public void beginFullReplication() {
    }

    @Override
    public void importReplicationRecords(Collection<ReplicationRecord> records, boolean createTombstones) {
    }

    @Override
    public void reloadUpdatedEntries() {
    }

    @Override
    public void deleteTombstones(Date endTime) {
    }

    @Override
    public Date getLatestUpdateTimestamp() {
        return null;
    }

    @Override
    public void clearReplicationState() {
    }

    @Override
    public boolean isValidPartialEntry(String entryId) {
        return false;
    }

    @Override
    public String extractIdFromEntryId(String entryId) {
        return null;
    }

    @Override
    public byte[] mergePartialEntry(byte[] partialEntry, byte[] entry) {
        return new byte[0];
    }

    @Override
    public boolean selectiveReplicationEnabled() {
        return false;
    }

    @Override
    public Date getTombstoneTrackingStartTime() {
        return null;
    }

    private void invalidateClientCache(String clientId) {
        if (StringUtils.isNotBlank((String)clientId) && this.isStandAloneOrClusteredDual()) {
            this.engineClientsCache.invalidate((Object)clientId);
        }
    }

    private boolean isStandAloneOrClusteredDual() {
        String opMode = System.getProperty("pf.operational.mode", "STANDALONE");
        return "STANDALONE".equals(opMode) || "CLUSTERED_DUAL".equals(opMode);
    }

    protected Collection<Client> searchClientsByPolicyGroupId(String policyGroupId) {
        SearchCriteria searchCriteria = this.getSearchCriteria(FilterableField.OIDC_POLICY_ID, policyGroupId);
        return this.getSearchResultClients(searchCriteria);
    }

    protected Collection<Client> searchClientsByCIBAPolicyId(String policyId) {
        SearchCriteria searchCriteria = this.getSearchCriteria(FilterableField.CIBA_POLICY_ID, policyId);
        return this.getSearchResultClients(searchCriteria);
    }

    protected Collection<Client> searchClientsByTeppId(String teppId) {
        SearchCriteria searchCriteria = this.getSearchCriteria(FilterableField.TEPP_ID, teppId);
        return this.getSearchResultClients(searchCriteria);
    }

    protected Collection<Client> searchClientsByAtmId(String atmId) {
        SearchCriteria searchCriteria = this.getSearchCriteria(FilterableField.DEFAULT_ATM_ID, atmId);
        return this.getSearchResultClients(searchCriteria);
    }

    protected Collection<Client> searchClientsByTlsCertIssuer(String issuerDn) {
        SearchCriteria searchCriteria = this.getSearchCriteria(FilterableField.CERT_ISSUER_ID, issuerDn);
        return this.getSearchResultClients(searchCriteria);
    }

    private SearchCriteria getSearchCriteria(FilterableField filterableField, String id) {
        SearchCriteria.Builder builder = this.getDatastoreSearchClientCount() < 0 ? new SearchCriteria.Builder().setPage(null, null) : new SearchCriteria.Builder(0, this.getDatastoreSearchClientCount() + 1);
        return builder.addFilter(new SearchCriteria.FilterItem(filterableField.toString(), id)).build();
    }

    private Collection<Client> getSearchResultClients(SearchCriteria searchCriteria) {
        SearchResult<Client> searchResult = this.search(searchCriteria);
        if (this.getDatastoreSearchClientCount() < 0) {
            return searchResult.getResults();
        }
        return searchResult.getResults().stream().limit(this.getDatastoreSearchClientCount() + 1).collect(Collectors.toList());
    }

    protected Calendar translateTimestamp(String timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(Long.parseLong(timestamp));
        return cal;
    }

    protected List<Client> sortClients(Collection<Client> searchResults, SearchCriteria searchCriteria) {
        Comparator<Client> clientComparator = COMPARE_BY_ID_DOWN;
        SORT_BY sort_by = (SORT_BY)((Object)Enums.getIfPresent(SORT_BY.class, (String)searchCriteria.getOrderBy()).orNull());
        if (sort_by != null) {
            switch (sort_by) {
                case Id: {
                    if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                        clientComparator = COMPARE_BY_ID_DOWN;
                        break;
                    }
                    clientComparator = COMPARE_BY_ID_UP;
                    break;
                }
                case Name: {
                    if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                        clientComparator = COMPARE_BY_NAME_DOWN;
                        break;
                    }
                    clientComparator = COMPARE_BY_NAME_UP;
                    break;
                }
                case ModificationTime: {
                    if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                        clientComparator = COMPARE_BY_LAST_MODIFIED_DOWN;
                        break;
                    }
                    clientComparator = COMPARE_BY_LAST_MODIFIED_UP;
                    break;
                }
                case CreationTime: {
                    if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                        clientComparator = COMPARE_BY_CREATION_DATE_DOWN;
                        break;
                    }
                    clientComparator = COMPARE_BY_CREATION_DATE_UP;
                    break;
                }
            }
        }
        return searchResults.parallelStream().sorted(clientComparator).collect(Collectors.toList());
    }

    public static enum SORT_BY {
        Name,
        Id,
        ModificationTime,
        CreationTime;

    }

    public static enum FilterableField {
        CERT_ISSUER_ID,
        CIBA_POLICY_ID,
        DEFAULT_ATM_ID,
        GRANT_TYPE,
        OIDC_POLICY_ID,
        TEPP_ID;

    }
}

