/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.Substituter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.log.AttributeMap;

public abstract class AccessTokenMapping
extends AttributeMapping {
    private static final Logger logger = LogManager.getLogger(AccessTokenMapping.class);
    private static final long serialVersionUID = 2017111501L;
    private String contextId;
    private transient ContextUtil.Ctx qualifiedContext;
    private String tokenManagerId = "default";
    public static final String IDP_CONNECTION_CONTEXT_ATTR_PREFIX = "idp";
    public static final String ADAPTER_CONTEXT_ATTR_PREFIX = "adapter";
    public static final String PCV_CONTEXT_ATTR_PREFIX = "pcv";
    public static final String APC_CONTEXT_ATTR_PREFIX = "apc";
    public static final String DEFAULT_CONTEXT_ID = "default";
    public static final String TEPP_CONTEXT_ATTR_PREFIX = "tepp";
    public static final String DELIMITER = "|";
    private static ContextUtil ctxUtil = new ContextUtil();
    private Collection<String> referencedContextAttrs = null;

    public AccessTokenMapping() {
    }

    public AccessTokenMapping(AccessTokenMapping other) {
        super(other);
        this.setContextId(other.getContextId());
        this.tokenManagerId = other.tokenManagerId;
    }

    public String getId() {
        return AccessTokenMapping.makeId(this.contextId, this.tokenManagerId);
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
        this.qualifiedContext = ctxUtil.split(contextId);
    }

    public static String makeId(String contextId, String tokenManagerId) {
        return contextId + DELIMITER + tokenManagerId;
    }

    public boolean isDefaultContextMapping() {
        return DEFAULT_CONTEXT_ID.equals(this.contextId);
    }

    public static String normalizeApiId(String apiId) {
        if (apiId == null) {
            return null;
        }
        String[] elements = apiId.split("\\|");
        if (elements.length == 1 && elements[0].equals(DEFAULT_CONTEXT_ID) || elements.length == 2 && !elements[0].equals(DEFAULT_CONTEXT_ID) && !elements[0].equals("client_credentials")) {
            return apiId + "|default";
        }
        return apiId;
    }

    public String getTokenManagerId() {
        return this.tokenManagerId;
    }

    public void setTokenManagerId(String tokenManagerId) {
        this.tokenManagerId = tokenManagerId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AttributeContract getContextAttributeContract() {
        switch (this.qualifiedContext.getQualifier()) {
            case "password": {
                Object pcvInstance = MgmtFactory.getCredentialValidatorManager().getInstance(this.qualifiedContext.getOAuthSourceId().getRealId());
                if (pcvInstance == null) return null;
                return pcvInstance.getAttributeContract();
            }
            case "urn:ietf:params:oauth:grant-type:token-exchange": {
                TokenExchangeProcessorPolicy policyInstance = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies().getPolicy(this.qualifiedContext.getOAuthSourceId().getRealId());
                if (policyInstance == null) return null;
                return policyInstance.getContract();
            }
            case "authz_req": {
                OAuthSourceId sourceId = this.qualifiedContext.getOAuthSourceId();
                switch (sourceId.getType()) {
                    case IDP_CONNECTION: {
                        IdpConnection conn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(sourceId.getRealId(), false);
                        if (conn == null) return null;
                        return conn.getAttributeContract();
                    }
                    case ADAPTER: {
                        Object adapterInstance = MgmtFactory.getIdpAdapterManager().getInstance(sourceId.getRealId());
                        if (adapterInstance == null) return null;
                        return adapterInstance.getAttributeContract();
                    }
                    case APC: {
                        C2cContract apc = MgmtFactory.getC2cContractManager().getContract(sourceId.getRealId());
                        if (apc == null) return null;
                        return apc;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public String getContextSourceType() {
        switch (this.qualifiedContext.getQualifier()) {
            case "password": {
                return "Password Credential Validator";
            }
            case "urn:ietf:params:oauth:grant-type:token-exchange": {
                return "Processor Policy";
            }
            case "authz_req": {
                OAuthSourceId sourceId = this.qualifiedContext.getOAuthSourceId();
                switch (sourceId.getType()) {
                    case IDP_CONNECTION: {
                        return "IdP Connection";
                    }
                    case ADAPTER: {
                        return "Adapter";
                    }
                    case APC: {
                        return "Authentication Policy Contract";
                    }
                }
                break;
            }
        }
        return null;
    }

    public static String makeContextAttrId(String contextId, String attrName) {
        String prefix = AccessTokenMapping.getContextAttrPrefix(contextId);
        if (prefix == null) {
            return attrName;
        }
        return prefix + "." + attrName;
    }

    public String getContextAttrPrefix() {
        return AccessTokenMapping.getContextAttrPrefix(this.contextId);
    }

    public static String getContextAttrPrefix(String contextId) {
        ContextUtil.Ctx ctx = ctxUtil.split(contextId);
        switch (ctx.getQualifier()) {
            case "password": {
                return PCV_CONTEXT_ATTR_PREFIX;
            }
            case "urn:ietf:params:oauth:grant-type:token-exchange": {
                return TEPP_CONTEXT_ATTR_PREFIX;
            }
            case "authz_req": {
                OAuthSourceId sourceId = ctx.getOAuthSourceId();
                switch (sourceId.getType()) {
                    case IDP_CONNECTION: {
                        return IDP_CONNECTION_CONTEXT_ATTR_PREFIX;
                    }
                    case ADAPTER: {
                        return ADAPTER_CONTEXT_ATTR_PREFIX;
                    }
                    case APC: {
                        return APC_CONTEXT_ATTR_PREFIX;
                    }
                }
                break;
            }
        }
        return null;
    }

    protected synchronized Collection<String> getReferencedContextAttrs() {
        if (this.isDefaultContextMapping()) {
            return Collections.emptySet();
        }
        if (this.referencedContextAttrs != null) {
            return this.referencedContextAttrs;
        }
        HashSet<String> result = new HashSet<String>();
        String contextAttrPrefix = this.getContextAttrPrefix() + ".";
        for (AttributeSource attributeSource : this.attributeSources) {
            for (String referencedAttr : attributeSource.getFilterAttributeReferences()) {
                this.conditionalAddAttr(result, contextAttrPrefix, referencedAttr);
            }
        }
        for (Map.Entry entry : this.attributeMap.entrySet()) {
            for (AttrMappingValue val : (List)entry.getValue()) {
                if (StringUtils.isNotBlank((String)val.getValue())) {
                    if (this.getContextSourceType().equals(val.getTypeString())) {
                        result.add(val.getValue().substring(contextAttrPrefix.length()));
                        continue;
                    }
                    if (val.getType() == SourceType.EXPRESSION) {
                        result.addAll(this.getExpressionAttributeReferences(val.getValue(), contextAttrPrefix));
                        continue;
                    }
                    if (val.getType() != SourceType.TEXT) continue;
                    for (String attr : Substituter.parseReferences((String)val.getValue())) {
                        this.conditionalAddAttr(result, contextAttrPrefix, attr);
                    }
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Empty attribute value for mapping of: " + (String)entry.getKey());
            }
        }
        for (TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion : this.getTokenAuthorizationIssuanceCriteria()) {
            if (this.getContextSourceType().equals(tokenAuthorizationIssuanceCriterion.getAttrSourceTypeAsString())) {
                result.add(tokenAuthorizationIssuanceCriterion.getAttrName().substring(contextAttrPrefix.length()));
                continue;
            }
            if (tokenAuthorizationIssuanceCriterion.getAttrSourceType() != SourceType.EXPRESSION) continue;
            result.addAll(this.getExpressionAttributeReferences(tokenAuthorizationIssuanceCriterion.getExpr(), contextAttrPrefix));
        }
        this.referencedContextAttrs = result;
        return this.referencedContextAttrs;
    }

    public Collection<String> getContextAttributes() {
        AttributeContract contract = this.getContextAttributeContract();
        if (contract == null) {
            return new ArrayList<String>();
        }
        return contract.getAllAttrNamesSorted();
    }

    public Collection<String> getContextAttributeIds() {
        return AccessTokenMapping.getContextAttributeIds(this.contextId, this.getContextAttributeContract());
    }

    public static Collection<String> getContextAttributeIds(String contextId, AttributeContract attrContract) {
        if (attrContract == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String attr : attrContract.getAllAttrNamesSorted()) {
            result.add(AccessTokenMapping.makeContextAttrId(contextId, attr));
        }
        return result;
    }

    protected void conditionalAddAttr(Collection<String> attrs, String prefix, String attr) {
        if (attr != null && attr.startsWith(prefix)) {
            attrs.add(attr.substring(prefix.length()));
        }
    }

    private Set<String> getExpressionAttributeReferences(String expression, String contextAttrPrefix) {
        HashSet<String> result = new HashSet<String>();
        if (!ExpressionManager.getInstance().isEvaluateExpressionsOff()) {
            try {
                Object parsedExpression = Ognl.parseExpression((String)expression);
                OgnlHelper ognlHelper = new OgnlHelper();
                ognlHelper.searchForAllVariableNames(parsedExpression);
                for (String var : ognlHelper.getList()) {
                    this.conditionalAddAttr(result, contextAttrPrefix, var);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames, AttributeMap contextMap) throws AttrLookupException, AuthorizationException {
        AttributeMap attrMap = super.executeMapping(srcAttributes, targetNames, contextMap);
        BearerAccessTokenMgmtPluginInstance inst = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.tokenManagerId);
        if (inst != null) {
            attrMap.keySet().removeIf(attr -> !inst.getAttributeContract().attributeExists((String)attr) && !inst.getTokenEndpointAttributeContract().attributeExists((String)attr));
        }
        return attrMap;
    }
}

