/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.dependency.error.AffectedItemType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.oauth.conf.xmlbinding.ClientCredentialsToAccessTokenMappingType;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigDocument;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigType;
import org.sourceid.oauth.conf.xmlbinding.PersistentGrantAttributesType;
import org.sourceid.oauth.conf.xmlbinding.SourceToUserKeyMappingType;
import org.sourceid.oauth.conf.xmlbinding.UserKeyToAccessTokenMappingType;
import org.sourceid.oauth20.domain.AbstractSourceToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.AuthzServerSettings;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.CorsSettings;
import org.sourceid.oauth20.domain.CorsSettingsUtil;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.openid.connect.domain.ClientRegistrationCoreParameters;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;

public class AuthzServerManagerImpl
implements AuthzServerManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(AuthzServerManagerImpl.class);
    private final XmlLoader xmlLoader;
    private final String directory;
    private final ConnectionUtil connUtil = new ConnectionUtil();
    static final String FILENAME = "oauth-authz-server-settings.xml";
    private final ConfigStore config;
    private AuthzServerSettings authzServerSettings;
    private static final String MIGRATION_DEBUG_LOG_MSG = "Migrating '%s' from config-store file '%s.xml'";
    private static final String CFG_STORE_FILE_NAME = "org.sourceid.oauth20.domain.AuthzServerManagerImpl";
    private static final String CFG_KEY_UNIDENTIFIED_CLIENT_ROCREDS = "UnidentifiedClientROCreds";
    private static final String CFG_KEY_UNIDENTIFIED_EXT_GRANTS = "UnidentifiedClientExtGrants";
    private static final String CFG_KEY_SCOPE_WHITELIST = "scope.whitelist";
    private static final String CFG_KEY_MAX_SECONDARY_CLIENT_SECRETS = "MaximumSecondaryClientSecrets";
    private static final int DEFAULT_MAX_SECONDARY_CLIENT_SECRETS = 5;
    private static final String CFG_KEY_RELAXED_AUDIENCE_VALIDATION = "RelaxedAudienceValidation";
    private static final boolean CFG_KEY_RELAXED_AUDIENCE_VALIDATION_DEFAULT_VALUE = false;
    private static final String NQCHAR_PATTERN = "[a-zA-Z0-9!#$%&'()*+,-./:;<=>?@[]^_`{|}~]+";
    private static final String CFG_KEY_REVOKE_REPLAYED_REFRESH_TOKEN = "RevokeReplayedRefreshToken";
    private static final boolean CFG_KEY_REVOKE_REPLAYED_REFRESH_TOKEN_DEFAULT_VALUE = true;
    private static final String CFG_KEY_REVOKE_REFRESH_TOKEN_FOR_FAILED_ISSUANCE_CRITERIA = "RevokeRefreshTokenForFailedIssuanceCriteria";
    private static final boolean CFG_KEY_REVOKE_REFRESH_TOKEN_FOR_FAILED_ISSUANCE_CRITERIA_DEFAULT_VALUE = false;
    protected static final String EXPIRY_BASED_ON_IDLE_TIMEOUT_FIELD_NAME = "PersistentGrantExpiryBasedOnIdleTimeout";
    protected static final boolean EXPIRY_BASED_ON_IDLE_TIMEOUT_DEFAULT = true;

    AuthzServerManagerImpl(XmlLoader xmlLoader, String directory) {
        this.xmlLoader = xmlLoader;
        this.directory = directory;
        this.config = ConfigStoreFarm.getConfig(CFG_STORE_FILE_NAME);
        this.loadConfig();
    }

    public AuthzServerManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this(xmlLoader, sysDirInfo.getDataDirectory());
    }

    @Override
    public synchronized AuthzServerSettings getAuthzServerSettings() {
        return new AuthzServerSettings(this.authzServerSettings);
    }

    @Override
    public synchronized boolean allowAutoAuthz(String grantType) {
        return this.authzServerSettings.getGrantTypesToAllowAutoAuthzForExistingPersistentGrants().contains(grantType);
    }

    @Override
    public synchronized boolean reuseExistingPersistentGrant(String grantType) {
        return this.authzServerSettings.getGrantTypesToReusePersistentGrants().contains(grantType);
    }

    @Override
    public synchronized boolean isEnableOAuth() {
        return true;
    }

    @Override
    public String getScopeWhitelist() {
        return this.config.getStringValue(CFG_KEY_SCOPE_WHITELIST, NQCHAR_PATTERN);
    }

    @Override
    public synchronized boolean allowUnidentifiedClientROCreds() {
        return this.authzServerSettings.isAllowUnidentifiedClientROCreds();
    }

    @Override
    public synchronized boolean allowUnidentifiedClientExtensionGrants() {
        return this.authzServerSettings.isAllowUnidentifiedClientExtensionGrants();
    }

    @Override
    public synchronized int getAuthzCodeTimeout() {
        return this.authzServerSettings.getAuthzCodeTimeout();
    }

    @Override
    public synchronized boolean isRestrictPlainPKCE() {
        return this.authzServerSettings.isRestrictPlainPkce();
    }

    @Override
    public synchronized boolean isIncludeIssuerInAuthzResponse() {
        return this.authzServerSettings.isIncludeIssuerInAuthzResponse();
    }

    @Override
    public synchronized int getAuthzCodeLength() {
        return this.authzServerSettings.getAuthzCodeLength();
    }

    @Override
    public synchronized ConfigurablePluginInstance getAdminWebServicePcv() {
        return this.authzServerSettings.getAdminWsPcv();
    }

    @Override
    public synchronized String getAtmIdForOAuthGrantManagement() {
        return this.authzServerSettings.getAtmIdForOAuthGrantManagement();
    }

    @Override
    public synchronized String getScopeForOAuthGrantManagement() {
        return this.authzServerSettings.getScopeForOAuthGrantManagement();
    }

    @Override
    public synchronized ParServerPolicy getParServerPolicy() {
        ParServerPolicy parServerPolicy = new ParServerPolicy();
        ParServerPolicy currentParServerPolicy = this.authzServerSettings.getParServerPolicy();
        if (currentParServerPolicy != null) {
            parServerPolicy.setTimeoutSeconds(currentParServerPolicy.getTimeoutSeconds());
            parServerPolicy.setReferenceLength(currentParServerPolicy.getReferenceLength());
            parServerPolicy.setStatus(currentParServerPolicy.getStatus());
        }
        return parServerPolicy;
    }

    @Override
    public synchronized boolean defaultRefreshTokenRollingPolicy() {
        return this.authzServerSettings.isDefaultRefreshTokenRollingPolicy();
    }

    @Override
    public synchronized int getRefreshTokenRollingGracePeriod() {
        return this.authzServerSettings.getRefreshTokenRollingGracePeriod();
    }

    @Override
    public synchronized long getRefreshRollingInterval() {
        return this.authzServerSettings.getRefreshRollingInterval();
    }

    @Override
    public synchronized String getRefreshRollingIntervalTimeUnit() {
        return this.authzServerSettings.getRefreshTokenRollingIntervalTimeUnit();
    }

    @Override
    public synchronized UserKeyToAccessTokenMapping getDefaultUserKeyToAccessTokenMapping(String tokenManagerId) {
        UserKeyToAccessTokenMapping userKeyToAccessTokenMapping = this.authzServerSettings.getUserKeyToAccessTokenMappings().get(UserKeyToAccessTokenMapping.makeId("default", tokenManagerId));
        return userKeyToAccessTokenMapping != null ? new UserKeyToAccessTokenMapping(userKeyToAccessTokenMapping) : null;
    }

    @Override
    public synchronized Collection<UserKeyToAccessTokenMapping> getUserKeyToAccessTokenMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getUserKeyToAccessTokenMappings().values());
    }

    @Override
    public synchronized Collection<UserKeyToAccessTokenMapping> getEnabledUserKeyToAccessTokenMappings() {
        ArrayList<UserKeyToAccessTokenMapping> mappings = new ArrayList<UserKeyToAccessTokenMapping>();
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        boolean isEnableIdp = MetadataLocalHelper.isEnableIdp(localMetaData);
        boolean isEnableSp = MetadataLocalHelper.isEnableSp(localMetaData);
        for (UserKeyToAccessTokenMapping mapping : this.getUserKeyToAccessTokenMappings()) {
            if (mapping.isDefaultContextMapping()) {
                mappings.add(new UserKeyToAccessTokenMapping(mapping));
                continue;
            }
            ContextUtil contextUtil = new ContextUtil();
            ContextUtil.Ctx ctx = contextUtil.split(mapping.getContextId());
            String qualifier = ctx.getQualifier();
            if ("password".equals(qualifier) || "client_credentials".equals(qualifier) || "urn:ietf:params:oauth:grant-type:token-exchange".equals(qualifier)) {
                mappings.add(new UserKeyToAccessTokenMapping(mapping));
                continue;
            }
            if (!"authz_req".equals(qualifier)) continue;
            OAuthSourceId.Type sourceIdType = ctx.getOAuthSourceId().getType();
            if (sourceIdType == OAuthSourceId.Type.IDP_CONNECTION && isEnableSp) {
                mappings.add(new UserKeyToAccessTokenMapping(mapping));
                continue;
            }
            if (sourceIdType == OAuthSourceId.Type.ADAPTER && isEnableIdp) {
                mappings.add(new UserKeyToAccessTokenMapping(mapping));
                continue;
            }
            if (sourceIdType != OAuthSourceId.Type.APC || !isEnableIdp) continue;
            mappings.add(new UserKeyToAccessTokenMapping(mapping));
        }
        return mappings;
    }

    @Override
    public synchronized void deleteUserKeyToAccessTokenMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        UserKeyToAccessTokenMapping toDelete = authzServerSettings.getUserKeyToAccessTokenMappings().remove(mappingId);
        if (toDelete != null) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.doSave(authzServerSettings);
                auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN_MAPPING, AdminAuditLogger.Event.DELETE);
            }
        }
    }

    @Override
    public synchronized void deleteUserKeyToAccessTokenMappingsForContext(String context) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        boolean needsSave = false;
        Iterator<Map.Entry<String, UserKeyToAccessTokenMapping>> iter = authzServerSettings.getUserKeyToAccessTokenMappings().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, UserKeyToAccessTokenMapping> entry = iter.next();
            if (!entry.getValue().getContextId().equals(context)) continue;
            iter.remove();
            needsSave = true;
        }
        if (needsSave) {
            this.save(authzServerSettings);
        }
    }

    @Override
    public synchronized UserKeyToAccessTokenMapping getUserKeyToAccessTokenMapping(String mappingId) {
        UserKeyToAccessTokenMapping userKeyToAccessTokenMapping = this.authzServerSettings.getUserKeyToAccessTokenMappings().get(mappingId);
        return userKeyToAccessTokenMapping != null ? new UserKeyToAccessTokenMapping(userKeyToAccessTokenMapping) : null;
    }

    @Override
    public synchronized UserKeyToAccessTokenMapping getUserKeyToAccessTokenMapping(String context, String tokenManagerId) {
        if (context == null || tokenManagerId == null) {
            return null;
        }
        return this.getUserKeyToAccessTokenMapping(UserKeyToAccessTokenMapping.makeId(context, tokenManagerId));
    }

    @Override
    public synchronized Collection<UserKeyToAccessTokenMapping> getUserKeyToAccessTokenMappingsForContext(String context) {
        ArrayList<UserKeyToAccessTokenMapping> result = new ArrayList<UserKeyToAccessTokenMapping>();
        for (UserKeyToAccessTokenMapping mapping : this.authzServerSettings.getUserKeyToAccessTokenMappings().values()) {
            if (!mapping.getContextId().equals(context)) continue;
            result.add(new UserKeyToAccessTokenMapping(mapping));
        }
        return result;
    }

    @Override
    public synchronized void saveUserKeyToAccessTokenMappings(Collection<UserKeyToAccessTokenMapping> userKeyToAccessTokenMappings) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        authzServerSettings.getUserKeyToAccessTokenMappings().clear();
        for (UserKeyToAccessTokenMapping mapping : userKeyToAccessTokenMappings) {
            authzServerSettings.getUserKeyToAccessTokenMappings().put(mapping.getId(), mapping);
        }
        this.save(authzServerSettings);
    }

    @Override
    public synchronized void saveUserKeyToAccessTokenMapping(String mappingId, UserKeyToAccessTokenMapping userKeyToAccessTokenMapping) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        authzServerSettings.getUserKeyToAccessTokenMappings().put(mappingId, userKeyToAccessTokenMapping);
        UserKeyToAccessTokenMapping existing = this.getUserKeyToAccessTokenMapping(mappingId);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN_MAPPING, existing == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
        MgmtFactory.getDependencyErrorManager().remove(mappingId, AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING);
    }

    @Override
    public synchronized PluginToUserKeyAttrMapping getPwdCredValidatorToUserKeyMapping(String pwdCredValidatorId) {
        PluginToUserKeyAttrMapping pluginToUserKeyAttrMapping = this.authzServerSettings.getValidatorIdToUserKeyMappings().get(pwdCredValidatorId);
        return pluginToUserKeyAttrMapping != null ? new PluginToUserKeyAttrMapping(this.authzServerSettings.getValidatorIdToUserKeyMappings().get(pwdCredValidatorId)) : null;
    }

    @Override
    public synchronized Collection<PluginToUserKeyAttrMapping> getPwdCredValidatorToUserKeyMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getValidatorIdToUserKeyMappings().values());
    }

    @Override
    public synchronized void savePwdCredValidatorToUserKeyMappings(Collection<PluginToUserKeyAttrMapping> mappings, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        this.setSourceToUserKeyMappings(authzServerSettings, mappings, authzServerSettings.getValidatorIdToUserKeyMappings(), "password");
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_RESOURCE_OWNER_CREDS_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void savePwdCredValidatorToUserKeyMapping(PluginToUserKeyAttrMapping mapping, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.savePluginToUserKeyMapping(authzServerSettings, mapping, authzServerSettings.getValidatorIdToUserKeyMappings());
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_RESOURCE_OWNER_CREDS_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void deletePwdCredValidatorToUserKeyMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.deleteSourceToUserKeyMapping(authzServerSettings, mappingId, authzServerSettings.getValidatorIdToUserKeyMappings(), "password");
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_RESOURCE_OWNER_CREDS_MAPPING, AdminAuditLogger.Event.DELETE);
        }
    }

    @Override
    public synchronized UserKeyAttrMapping getAdapterToUserKeyMapping(String adapterInstanceId) {
        PluginToUserKeyAttrMapping pluginToUserKeyAttrMapping = this.authzServerSettings.getAdapterIdToUserKeyMappings().get(adapterInstanceId);
        return pluginToUserKeyAttrMapping != null ? new PluginToUserKeyAttrMapping(pluginToUserKeyAttrMapping) : null;
    }

    @Override
    public synchronized Collection<PluginToUserKeyAttrMapping> getAdapterToUserKeyMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getAdapterIdToUserKeyMappings().values());
    }

    @Override
    public synchronized void saveAdapterToUserKeyMappings(Collection<PluginToUserKeyAttrMapping> mappings, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        this.setSourceToUserKeyMappings(authzServerSettings, mappings, authzServerSettings.getAdapterIdToUserKeyMappings(), "authz_req");
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_IDP_ADAPTER_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void saveAdapterToUserKeyMapping(PluginToUserKeyAttrMapping mapping, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.savePluginToUserKeyMapping(authzServerSettings, mapping, authzServerSettings.getAdapterIdToUserKeyMappings());
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_IDP_ADAPTER_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void deleteAdapterToUserKeyMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.deleteSourceToUserKeyMapping(authzServerSettings, mappingId, authzServerSettings.getAdapterIdToUserKeyMappings(), "authz_req");
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_IDP_ADAPTER_MAPPING, AdminAuditLogger.Event.DELETE);
        }
    }

    @Override
    public synchronized ApcToUserKeyAttrMapping getApcToUserKeyMapping(String apcId) {
        ApcToUserKeyAttrMapping apcToUserKeyAttrMapping = this.authzServerSettings.getApcIdToUserKeyMappings().get(apcId);
        return apcToUserKeyAttrMapping != null ? new ApcToUserKeyAttrMapping(apcToUserKeyAttrMapping) : null;
    }

    @Override
    public synchronized Collection<ApcToUserKeyAttrMapping> getApcToUserKeyMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getApcIdToUserKeyMappings().values());
    }

    @Override
    public synchronized void saveApcToUserKeyMappings(Collection<ApcToUserKeyAttrMapping> mappings, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        this.setSourceToUserKeyMappings(authzServerSettings, mappings, authzServerSettings.getApcIdToUserKeyMappings(), "authz_req");
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_APC_TO_PERS_GRANT_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void saveApcToUserKeyMapping(ApcToUserKeyAttrMapping mapping, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.savePluginToUserKeyMapping(authzServerSettings, mapping, authzServerSettings.getApcIdToUserKeyMappings());
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_APC_TO_PERS_GRANT_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void deleteApcToUserKeyMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.deleteSourceToUserKeyMapping(authzServerSettings, mappingId, authzServerSettings.getApcIdToUserKeyMappings(), "authz_req");
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_APC_TO_PERS_GRANT_MAPPING, AdminAuditLogger.Event.DELETE);
        }
    }

    @Override
    public synchronized TeppToUserKeyAttrMapping getTeppToUserKeyMapping(String teppId) {
        TeppToUserKeyAttrMapping teppToUserKeyAttrMapping = this.authzServerSettings.getTeppToUserKeyAttrMappings().get(teppId);
        return teppToUserKeyAttrMapping != null ? new TeppToUserKeyAttrMapping(teppToUserKeyAttrMapping) : null;
    }

    @Override
    public synchronized Collection<TeppToUserKeyAttrMapping> getTeppToUserKeyMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getTeppToUserKeyAttrMappings().values());
    }

    @Override
    public void saveTeppToUserKeyMappings(Collection<TeppToUserKeyAttrMapping> mappings, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        this.setSourceToUserKeyMappings(authzServerSettings, mappings, authzServerSettings.getTeppToUserKeyAttrMappings(), "authz_req");
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_TEPP_TO_PRES_GRANT_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public void saveTeppToUserKeyMapping(TeppToUserKeyAttrMapping mapping, boolean isCreate) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.savePluginToUserKeyMapping(authzServerSettings, mapping, authzServerSettings.getTeppToUserKeyAttrMappings());
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_TEPP_TO_PRES_GRANT_MAPPING, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public void deleteTeppToUserKeyMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.deleteSourceToUserKeyMapping(authzServerSettings, mappingId, authzServerSettings.getTeppToUserKeyAttrMappings(), "authz_req");
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_TEPP_TO_PRES_GRANT_MAPPING, AdminAuditLogger.Event.DELETE);
        }
    }

    @Override
    public synchronized Collection<ClientCredentialAccessTokenMapping> getClientCredentialsToAccessTokenMappings() {
        return Collections.unmodifiableCollection(this.authzServerSettings.getClientCredsToAccessTokenMappings().values());
    }

    @Override
    public synchronized ClientCredentialAccessTokenMapping getClientCredsToAccessTokenMapping(String mappingId) {
        ClientCredentialAccessTokenMapping clientCredentialAccessTokenMapping = this.authzServerSettings.getClientCredsToAccessTokenMappings().get(mappingId);
        return clientCredentialAccessTokenMapping != null ? new ClientCredentialAccessTokenMapping(clientCredentialAccessTokenMapping) : null;
    }

    @Override
    public synchronized void saveClientCredsToAccessTokenMapping(String mappingId, ClientCredentialAccessTokenMapping clientCredentialsToAccessTokenMapping) {
        if (clientCredentialsToAccessTokenMapping != null) {
            AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
            authzServerSettings.getClientCredsToAccessTokenMappings().put(mappingId, clientCredentialsToAccessTokenMapping);
            ClientCredentialAccessTokenMapping existing = this.getClientCredsToAccessTokenMapping(mappingId);
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.doSave(authzServerSettings);
                auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN_MAPPING, existing == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
            }
            MgmtFactory.getDependencyErrorManager().remove(mappingId, AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING);
        }
    }

    @Override
    public synchronized int getRefreshTokenLength() {
        return this.authzServerSettings.getRefreshTokenLength();
    }

    @Override
    public synchronized Long getGlobalPersistentGrantExpirationTime() {
        return this.authzServerSettings.getGlobalPersistentGrantExpirationTime();
    }

    @Override
    public synchronized String getGlobalPersistentGrantExpirationTimeUnit() {
        return this.authzServerSettings.getGlobalPersistentGrantExpirationTimeUnit();
    }

    @Override
    public synchronized Long getGlobalPersistentGrantIdleTimeout() {
        return this.authzServerSettings.getGlobalPersistentGrantIdleTimeout();
    }

    @Override
    public synchronized String getGlobalPersistentGrantIdleTimeoutTimeUnit() {
        return this.authzServerSettings.getGlobalPersistentGrantIdleTimeoutTimeUnit();
    }

    @Override
    public synchronized List<PersistentGrantAttribute> getPersistentGrantExtendedAttributes() {
        ArrayList<PersistentGrantAttribute> persistentGrantAttributeList = new ArrayList<PersistentGrantAttribute>();
        this.authzServerSettings.getPersistentGrantExtendedAttributes().forEach(pg -> persistentGrantAttributeList.add(new PersistentGrantAttribute(pg.getName())));
        return persistentGrantAttributeList;
    }

    private List<String> getPersistentGrantExtendedAttributeNames(AuthzServerSettings authzServerSettings) {
        ArrayList<String> names = new ArrayList<String>(authzServerSettings.getPersistentGrantExtendedAttributes().size());
        for (PersistentGrantAttribute attr : authzServerSettings.getPersistentGrantExtendedAttributes()) {
            names.add(attr.getName());
        }
        return names;
    }

    private <T extends AbstractSourceToUserKeyAttrMapping> Map<String, T> getMappingsToRemove(Collection<T> mappings, Map<String, T> cache) {
        HashMap<String, T> toRemove = new HashMap<String, T>();
        toRemove.putAll(cache);
        for (AbstractSourceToUserKeyAttrMapping mapping : mappings) {
            toRemove.remove(mapping.getSourceId());
        }
        return toRemove;
    }

    private synchronized <T extends AbstractSourceToUserKeyAttrMapping> void setSourceToUserKeyMappings(AuthzServerSettings authzServerSettings, Collection<T> mappings, Map<String, T> cache, String contextQualifer) {
        Map<String, T> toRemove = this.getMappingsToRemove(mappings, cache);
        for (AbstractSourceToUserKeyAttrMapping sourceToUserKeyAttrMapping : toRemove.values()) {
            ArrayList<String> userKeyToAccessTokenMappingsToRemove = new ArrayList<String>();
            for (UserKeyToAccessTokenMapping userKeyToAccessTokenMapping : authzServerSettings.getUserKeyToAccessTokenMappings().values()) {
                if (userKeyToAccessTokenMapping.isDefaultContextMapping()) continue;
                ContextUtil contextUtil = new ContextUtil();
                ContextUtil.Ctx ctx = contextUtil.split(userKeyToAccessTokenMapping.getContextId());
                String qualifier = ctx.getQualifier();
                String ctxId = ctx.getOAuthSourceId().toString();
                if (!ctxId.equals(sourceToUserKeyAttrMapping.getContextId()) || !qualifier.equals(contextQualifer)) continue;
                userKeyToAccessTokenMappingsToRemove.add(userKeyToAccessTokenMapping.getId());
            }
            for (String userKeyToAccessTokenMappingId : userKeyToAccessTokenMappingsToRemove) {
                authzServerSettings.getUserKeyToAccessTokenMappings().remove(userKeyToAccessTokenMappingId);
            }
        }
        cache.clear();
        for (AbstractSourceToUserKeyAttrMapping mapping : mappings) {
            cache.put(mapping.getSourceId(), mapping);
        }
    }

    private synchronized <T extends AbstractSourceToUserKeyAttrMapping> void savePluginToUserKeyMapping(AuthzServerSettings authzServerSettings, T mapping, Map<String, T> cache) {
        cache.put(mapping.getSourceId(), mapping);
        this.doSave(authzServerSettings);
    }

    private synchronized <T extends AbstractSourceToUserKeyAttrMapping> void deleteSourceToUserKeyMapping(AuthzServerSettings authzServerSettings, String mappingId, Map<String, T> cache, String contextQualifier) {
        ContextUtil ctxUtil = new ContextUtil();
        AbstractSourceToUserKeyAttrMapping mappingToDelete = (AbstractSourceToUserKeyAttrMapping)cache.get(mappingId);
        if (mappingToDelete == null) {
            return;
        }
        Collection<UserKeyToAccessTokenMapping> mappingsToRemove = this.getUserKeyToAccessTokenMappingsForContext(ctxUtil.buildQualifiedId(contextQualifier, OAuthSourceId.fromString(mappingToDelete.getContextId(), contextQualifier)));
        for (UserKeyToAccessTokenMapping userKeyToAccessTokenMapping : mappingsToRemove) {
            authzServerSettings.getUserKeyToAccessTokenMappings().remove(userKeyToAccessTokenMapping.getId());
        }
        cache.remove(mappingId);
        this.doSave(authzServerSettings);
    }

    private synchronized void loadConfig() {
        OAuthConfigType oauthConfig = this.getOAuthConfigType();
        this.authzServerSettings = new AuthzServerSettings();
        this.authzServerSettings.setAuthzCodeTimeout(oauthConfig.getAuthzCodeTimeout());
        this.authzServerSettings.setAuthzCodeLength(oauthConfig.getAuthzCodeLength());
        this.authzServerSettings.setRestrictPlainPkce(oauthConfig.getRestrictPlainPKCE());
        this.authzServerSettings.setIncludeIssuerInAuthzResponse(oauthConfig.getIncludeIssuerInAuthzResponse());
        this.authzServerSettings.setDefaultRefreshTokenRollingPolicy(oauthConfig.getRollRefreshTokens());
        this.authzServerSettings.setRefreshTokenRollingGracePeriod(oauthConfig.getRefreshTokenRollingGracePeriod());
        this.authzServerSettings.setRefreshRollingInterval(oauthConfig.getRollingInterval());
        this.authzServerSettings.setRefreshTokenRollingIntervalTimeUnit(oauthConfig.getRollingIntervalTimeUnit());
        this.authzServerSettings.setRefreshTokenLength(oauthConfig.getRefreshTokenLength());
        this.authzServerSettings.setGrantTypesToReusePersistentGrants(new HashSet<String>(Arrays.asList(oauthConfig.getReuseExistingPersistentGrantForGrantArray())));
        this.authzServerSettings.setGrantTypesToAllowAutoAuthzForExistingPersistentGrants(new HashSet<String>(Arrays.asList(oauthConfig.getAllowAutoAuthzForExistingPersistentGrantArray())));
        this.authzServerSettings.setPersistentGrantExtendedAttributes(this.getPersistentGrantAttributesFromConfig(oauthConfig));
        this.authzServerSettings.setKeyNameContract(this.createKeyNameContract(this.authzServerSettings));
        this.authzServerSettings.setKeyOnlyContract(this.createKeyOnlyContract(this.authzServerSettings));
        this.authzServerSettings.setAdapterIdToUserKeyMappings(this.buildPluginToUserKeyMapFromXmlType(oauthConfig.getAdapterToUserKeyMappingArray()));
        this.authzServerSettings.setValidatorIdToUserKeyMappings(this.buildPluginToUserKeyMapFromXmlType(oauthConfig.getPasswordCredentialValidatorToUserKeyMappingArray()));
        this.authzServerSettings.setApcIdToUserKeyMappings(this.buildApcToUserKeyMapFromXmlType(oauthConfig.getApcToUserKeyMappingArray()));
        this.authzServerSettings.setTeppToUserKeyAttrMappingMap(this.buildTeppToUserKeyMapFromXmlType(oauthConfig.getTeppToUserKeyMappingArray()));
        this.authzServerSettings.setClientSecretRetentionPeriod(oauthConfig.getClientSecretRetentionPeriod());
        if (oauthConfig.getSelectedPcv() != null) {
            PasswordCredentialValidatorManager pcvMgr = MgmtFactory.getCredentialValidatorManager();
            this.authzServerSettings.setAdminWsPcv((ConfigurablePluginInstance)pcvMgr.getInstance(oauthConfig.getSelectedPcv()));
        }
        this.authzServerSettings.setAtmIdForOAuthGrantManagement(oauthConfig.getAtmIdForOAuthGrantManagement());
        this.authzServerSettings.setScopeForOAuthGrantManagement(oauthConfig.getScopeForOAuthGrantManagement());
        HashMap<String, UserKeyToAccessTokenMapping> accessTokenMap = new HashMap<String, UserKeyToAccessTokenMapping>();
        if (oauthConfig.isSetDefaultUserKeyToAccessTokenMapping()) {
            UserKeyToAccessTokenMapping mapping = new UserKeyToAccessTokenMapping();
            this.connUtil.fillAttrMappingFromXml(oauthConfig.getDefaultUserKeyToAccessTokenMapping(), mapping);
            accessTokenMap.put(mapping.getId(), mapping);
        }
        for (UserKeyToAccessTokenMappingType type : oauthConfig.getUserKeyToAccessTokenMappingArray()) {
            UserKeyToAccessTokenMapping mapping = new UserKeyToAccessTokenMapping();
            mapping.setContextId(type.getContextId());
            if (type.getTokenManagerId() != null) {
                mapping.setTokenManagerId(type.getTokenManagerId());
            }
            this.connUtil.fillAttrMappingFromXml((AttributeMappingType)type, mapping);
            accessTokenMap.put(mapping.getId(), mapping);
        }
        this.authzServerSettings.setUserKeyToAccessTokenMappings(accessTokenMap);
        HashMap<String, ClientCredentialAccessTokenMapping> clientCredsToAccessTokenMapping = new HashMap<String, ClientCredentialAccessTokenMapping>();
        for (ClientCredentialsToAccessTokenMappingType type : oauthConfig.getClientCredentialsToAccessTokenMappingArray()) {
            if (!"client_credentials".equals(type.getContextId())) continue;
            ClientCredentialAccessTokenMapping mapping = new ClientCredentialAccessTokenMapping();
            mapping.setContextId(type.getContextId());
            if (type.getTokenManagerId() != null) {
                mapping.setTokenManagerId(type.getTokenManagerId());
            }
            this.connUtil.fillAttrMappingFromXml((AttributeMappingType)type, mapping);
            clientCredsToAccessTokenMapping.put(mapping.getId(), mapping);
        }
        this.authzServerSettings.setClientCredsToAccessTokenMappings(clientCredsToAccessTokenMapping);
        this.authzServerSettings.setGlobalPersistentGrantExpirationTime(oauthConfig.getGlobalPersistentGrantExpirationTime());
        this.authzServerSettings.setGlobalPersistentGrantExpirationTimeUnit(oauthConfig.getGlobalPersistentGrantExpirationTimeUnit());
        this.authzServerSettings.setGlobalPersistentGrantIdleTimeout(oauthConfig.getGlobalPersistentGrantIdleTimeout());
        this.authzServerSettings.setGlobalPersistentGrantIdleTimeoutTimeUnit(oauthConfig.getGlobalPersistentGrantIdleTimeoutTimeUnit());
        List<String> allowedOrigins = Arrays.asList(oauthConfig.getAllowedOriginsArray());
        this.authzServerSettings.setAllowedOrigins(allowedOrigins);
        this.authzServerSettings.setCorsSettings(new CorsSettingsUtil().getCorsSettings("cors-configuration", this.authzServerSettings.getDefaultUrlPatterns(), allowedOrigins));
        this.authzServerSettings.setTokenEndpointBaseUrl(oauthConfig.getTokenEndpointBaseUrl());
        this.authzServerSettings.setUserAuthzUrl(oauthConfig.getUserAuthzUrl());
        this.authzServerSettings.setRegisteredAuthzPath(oauthConfig.getRegisteredAuthzPath());
        this.authzServerSettings.setPendingAuthzTimeout(oauthConfig.getPendingAuthzTimeout());
        this.authzServerSettings.setBypassActivationCodeConfirmation(oauthConfig.getBypassActivationCodeConfirmation());
        this.authzServerSettings.setDevicePollingInterval(oauthConfig.getDevicePollingInterval());
        if (oauthConfig.getActivationCodeCheckMode() != null) {
            this.authzServerSettings.setActivationCodeCheckMode(ActivationCodeCheckMode.valueOf(oauthConfig.getActivationCodeCheckMode()));
        }
        this.authzServerSettings.setEnableCookielessUserAuthzAuthnApi(oauthConfig.getEnableCookielessUserAuthzAuthnApi());
        this.authzServerSettings.setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(oauthConfig.getReturnIdTokenOnOpenIdWithDeviceAuthzGrant());
        this.authzServerSettings.setAuthzConsentSetting(StringUtils.isNotBlank((String)oauthConfig.getAuthzConsentSetting()) ? oauthConfig.getAuthzConsentSetting() : UserAuthorizationConsentPageSetting.INTERNAL.getValue());
        this.authzServerSettings.setExternalConsentAdapterId(oauthConfig.getExternalConsentAdapterId());
        this.authzServerSettings.setReturnedScopeAttributeName(oauthConfig.getReturnedScopeAttributeName());
        this.authzServerSettings.setReturnedAuthorizationDetailsAttributeName(oauthConfig.getReturnedAuthorizationDetailsAttributeName());
        this.authzServerSettings.setAllowUnidentifiedClientROCreds(oauthConfig.getAllowUnidentifiedClientROCreds());
        this.authzServerSettings.setAllowUnidentifiedClientExtensionGrants(oauthConfig.getAllowUnidentifiedClientExtensionGrants());
        ParServerPolicy parServerPolicy = new ParServerPolicy();
        parServerPolicy.setTimeoutSeconds(oauthConfig.getParTimeout());
        parServerPolicy.setReferenceLength(oauthConfig.getParRefLength());
        parServerPolicy.setStatus(oauthConfig.getParStatus());
        this.authzServerSettings.setParServerPolicy(parServerPolicy);
        this.authzServerSettings.setClientSecretRetentionPeriod(oauthConfig.getClientSecretRetentionPeriod());
        this.authzServerSettings.setJwtSecuredAuthorizationResponseModeLifetime(oauthConfig.getJwtSecuredAuthorizationResponseModeLifetime());
        this.authzServerSettings.setDpopProofRequireNonce(oauthConfig.getDpopProofRequireNonce());
        this.authzServerSettings.setDpopProofLifetimeSeconds(oauthConfig.getDpopProofLifetimeSeconds());
        this.authzServerSettings.setDpopProofEnforceReplayPrevention(oauthConfig.getDpopProofEnforceReplayPrevention());
        this.authzServerSettings.setBypassAuthorizationForApprovedConsents(oauthConfig.getBypassAuthorizationForApprovedConsents());
        this.authzServerSettings.setConsentLifetimeDays(oauthConfig.getConsentLifetimeDays());
        this.authzServerSettings.setRequireOfflineAccessScopeToIssueRefreshTokens(oauthConfig.getRequireOfflineAccessScopeToIssueRefreshTokens());
        this.authzServerSettings.setOfflineAccessRequireConsentPrompt(oauthConfig.getOfflineAccessRequireConsentPrompt());
    }

    private OAuthConfigType getOAuthConfigType() {
        OAuthConfigDocument doc;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (OAuthConfigDocument)xmlObject;
        } else {
            doc = OAuthConfigDocument.Factory.newInstance();
            doc.addNewOAuthConfig();
        }
        return doc.getOAuthConfig();
    }

    @Override
    public synchronized void upgradeLegacyUserKeyToAccessTokenMappingIds() {
        List<UserKeyToAccessTokenMapping> newMappings = AuthzServerManagerImpl.upgradeUserKeyToAccessTokenMappingIds(this.authzServerSettings.getUserKeyToAccessTokenMappings().values());
        if (newMappings != null) {
            this.saveUserKeyToAccessTokenMappings(newMappings);
        }
    }

    @Override
    public synchronized void upgradeLegacyConfigStoreSettings() {
        boolean updateRequired;
        OAuthConfigType oAuthConfigType = this.getOAuthConfigType();
        if (oAuthConfigType.isSetAllowUnidentifiedClientROCreds() && oAuthConfigType.isSetAllowUnidentifiedClientExtensionGrants()) {
            return;
        }
        boolean unidentifiedClientROCreds = false;
        boolean unidentifiedClientExtGrants = false;
        boolean deleteOldConfigStoreFile = false;
        String oldConfigStoreFileName = "oauth-authz-server-settings.xml.xml";
        if (this.xmlLoader.xmlExists(MgmtFactory.getSysDirInfo().getConfigStoreDir(), oldConfigStoreFileName)) {
            log.debug((Object)"Migrating settings from legacy config-store file oauth-authz-server-settings.xml.xml");
            ConfigStore legacyConfigStore = ConfigStoreFarm.getConfig(FILENAME);
            unidentifiedClientROCreds = legacyConfigStore.getBooleanValue(CFG_KEY_UNIDENTIFIED_CLIENT_ROCREDS, false);
            unidentifiedClientExtGrants = legacyConfigStore.getBooleanValue(CFG_KEY_UNIDENTIFIED_EXT_GRANTS, false);
            deleteOldConfigStoreFile = true;
        }
        boolean deleteUnidentifiedClientROCredsValue = false;
        boolean deleteUnidentifiedClientExtGrantsValue = false;
        try {
            unidentifiedClientROCreds = this.config.getBooleanValue(CFG_KEY_UNIDENTIFIED_CLIENT_ROCREDS);
            log.debug((Object)String.format(MIGRATION_DEBUG_LOG_MSG, CFG_KEY_UNIDENTIFIED_CLIENT_ROCREDS, CFG_STORE_FILE_NAME));
            deleteUnidentifiedClientROCredsValue = true;
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        try {
            unidentifiedClientExtGrants = this.config.getBooleanValue(CFG_KEY_UNIDENTIFIED_EXT_GRANTS);
            log.debug((Object)String.format(MIGRATION_DEBUG_LOG_MSG, CFG_KEY_UNIDENTIFIED_EXT_GRANTS, CFG_STORE_FILE_NAME));
            deleteUnidentifiedClientExtGrantsValue = true;
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        boolean bl = updateRequired = deleteOldConfigStoreFile || deleteUnidentifiedClientROCredsValue || deleteUnidentifiedClientExtGrantsValue;
        if (updateRequired) {
            oAuthConfigType.setAllowUnidentifiedClientROCreds(unidentifiedClientROCreds);
            oAuthConfigType.setAllowUnidentifiedClientExtensionGrants(unidentifiedClientExtGrants);
            OAuthConfigDocument doc = OAuthConfigDocument.Factory.newInstance();
            doc.setOAuthConfig(oAuthConfigType);
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            this.loadConfig();
            if (deleteOldConfigStoreFile) {
                this.xmlLoader.delete(MgmtFactory.getSysDirInfo().getConfigStoreDir(), oldConfigStoreFileName);
            }
            if (deleteUnidentifiedClientROCredsValue) {
                this.config.clearValue(CFG_KEY_UNIDENTIFIED_CLIENT_ROCREDS);
            }
            if (deleteUnidentifiedClientExtGrantsValue) {
                this.config.clearValue(CFG_KEY_UNIDENTIFIED_EXT_GRANTS);
            }
        }
    }

    static List<UserKeyToAccessTokenMapping> upgradeUserKeyToAccessTokenMappingIds(Collection<UserKeyToAccessTokenMapping> origMappings) {
        boolean saveRequired = false;
        ArrayList<UserKeyToAccessTokenMapping> newMappings = new ArrayList<UserKeyToAccessTokenMapping>(origMappings.size());
        ContextUtil ctxUtil = new ContextUtil();
        for (UserKeyToAccessTokenMapping mapping : origMappings) {
            ContextUtil.Ctx ctx = ctxUtil.split(mapping.getContextId());
            OAuthSourceId sourceId = ctx.getOAuthSourceId();
            if (mapping.isDefaultContextMapping()) {
                newMappings.add(mapping);
                continue;
            }
            if (OAuthSourceId.Type.LEGACY_IDP_CONNECTION == sourceId.getType()) {
                IdpConnection idpConn = OAuthSourceId.getIdpConnFromLegacyId(sourceId);
                if (idpConn == null) {
                    log.debug((Object)("Could not convert legacy mapping context " + mapping.getContextId() + " (the connection entity ID may have changed). The access token mapping " + mapping.getId() + " will be removed."));
                } else {
                    UserKeyToAccessTokenMapping newMapping = new UserKeyToAccessTokenMapping(mapping);
                    newMapping.setContextId(ctxUtil.buildQualifiedId(ctx.getQualifier(), new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, idpConn.getId())));
                    newMappings.add(newMapping);
                    log.debug((Object)("Upgrading access token mapping ID from " + mapping.getId() + " to " + newMapping.getId()));
                }
                saveRequired = true;
                continue;
            }
            newMappings.add(mapping);
        }
        if (saveRequired) {
            return newMappings;
        }
        return null;
    }

    private List<PersistentGrantAttribute> getPersistentGrantAttributesFromConfig(OAuthConfigType oauthConfig) {
        ArrayList<PersistentGrantAttribute> attributes = new ArrayList<PersistentGrantAttribute>(oauthConfig.getPersistentGrantAttributesArray().length);
        for (PersistentGrantAttributesType grantAttributesType : oauthConfig.getPersistentGrantAttributesArray()) {
            PersistentGrantAttribute attribute = new PersistentGrantAttribute(grantAttributesType.getAttributeName());
            attributes.add(attribute);
        }
        return attributes;
    }

    private Map<String, PluginToUserKeyAttrMapping> buildPluginToUserKeyMapFromXmlType(SourceToUserKeyMappingType[] toUserKeyMappingArray) {
        HashMap<String, PluginToUserKeyAttrMapping> idToUserKeyAttrMappings = new HashMap<String, PluginToUserKeyAttrMapping>();
        for (SourceToUserKeyMappingType mapping : toUserKeyMappingArray) {
            AttributeMapping attributeMapping = new AttributeMapping();
            this.connUtil.fillAttrMappingFromXml((AttributeMappingType)mapping, attributeMapping);
            PluginToUserKeyAttrMapping userKeyAttrMapping = new PluginToUserKeyAttrMapping(attributeMapping, this.getKeyNameContract());
            String pluginId = mapping.getSourcePluginId();
            userKeyAttrMapping.setSourcePluginId(pluginId);
            idToUserKeyAttrMappings.put(pluginId, userKeyAttrMapping);
        }
        return idToUserKeyAttrMappings;
    }

    private Map<String, ApcToUserKeyAttrMapping> buildApcToUserKeyMapFromXmlType(SourceToUserKeyMappingType[] toUserKeyMappingArray) {
        HashMap<String, ApcToUserKeyAttrMapping> idToUserKeyAttrMappings = new HashMap<String, ApcToUserKeyAttrMapping>();
        for (SourceToUserKeyMappingType mapping : toUserKeyMappingArray) {
            AttributeMapping attributeMapping = new AttributeMapping();
            this.connUtil.fillAttrMappingFromXml((AttributeMappingType)mapping, attributeMapping);
            ApcToUserKeyAttrMapping userKeyAttrMapping = new ApcToUserKeyAttrMapping(attributeMapping, this.getKeyNameContract());
            String pluginId = mapping.getSourcePluginId();
            userKeyAttrMapping.setSourceId(pluginId);
            idToUserKeyAttrMappings.put(pluginId, userKeyAttrMapping);
        }
        return idToUserKeyAttrMappings;
    }

    private Map<String, TeppToUserKeyAttrMapping> buildTeppToUserKeyMapFromXmlType(SourceToUserKeyMappingType[] toUserKeyMappingArray) {
        HashMap<String, TeppToUserKeyAttrMapping> idToUserKeyAttrMappings = new HashMap<String, TeppToUserKeyAttrMapping>();
        for (SourceToUserKeyMappingType mapping : toUserKeyMappingArray) {
            AttributeMapping attributeMapping = new AttributeMapping();
            this.connUtil.fillAttrMappingFromXml((AttributeMappingType)mapping, attributeMapping);
            TeppToUserKeyAttrMapping userKeyAttrMapping = new TeppToUserKeyAttrMapping(attributeMapping, this.getKeyNameContract());
            String pluginId = mapping.getSourcePluginId();
            userKeyAttrMapping.setSourceId(pluginId);
            idToUserKeyAttrMappings.put(pluginId, userKeyAttrMapping);
        }
        return idToUserKeyAttrMappings;
    }

    private <T extends AbstractSourceToUserKeyAttrMapping> SourceToUserKeyMappingType[] buildXmlTypeArray(Collection<T> mappings) {
        ArrayList<SourceToUserKeyMappingType> mappingList = new ArrayList<SourceToUserKeyMappingType>(mappings.size());
        for (AbstractSourceToUserKeyAttrMapping mapping : mappings) {
            SourceToUserKeyMappingType sourceToUserKeyMappingType = SourceToUserKeyMappingType.Factory.newInstance();
            sourceToUserKeyMappingType.setSourcePluginId(mapping.getSourceId());
            this.connUtil.fillInAttributeMappingType((AttributeMappingType)sourceToUserKeyMappingType, mapping);
            mappingList.add(sourceToUserKeyMappingType);
        }
        return mappingList.toArray(new SourceToUserKeyMappingType[mappingList.size()]);
    }

    private <R extends AttributeMapping> boolean isNewPersistentGrantExtendedAttribute(PersistentGrantAttribute persistentGrantExtendedAttribute, Map.Entry<String, R> attributeMappingEntry) {
        return !((AttributeMapping)attributeMappingEntry.getValue()).getAttributeMapping().keySet().contains(persistentGrantExtendedAttribute.getName());
    }

    private <R extends AttributeMapping> void setNoMappingSourceTypeForNewPersistentGrantExtendedAttributes(PersistentGrantAttribute persistentGrantExtendedAttribute, Map<String, R> attributeMappings) {
        for (Map.Entry<String, R> entry : attributeMappings.entrySet()) {
            if (!this.isNewPersistentGrantExtendedAttribute(persistentGrantExtendedAttribute, entry)) continue;
            ((AttributeMapping)entry.getValue()).addAttributeMapping(persistentGrantExtendedAttribute.getName(), SourceType.NO_MAPPING, SourceType.NO_MAPPING.toString());
        }
    }

    private synchronized void doSave(AuthzServerSettings authzServerSettings) {
        try {
            UserKeyToAccessTokenMappingType accessTokenMappingType;
            OAuthConfigDocument doc = OAuthConfigDocument.Factory.newInstance();
            OAuthConfigType oauthConfigType = doc.addNewOAuthConfig();
            oauthConfigType.setEnableOAuth(authzServerSettings.isEnableOAuth());
            oauthConfigType.setAuthzCodeLength(authzServerSettings.getAuthzCodeLength());
            oauthConfigType.setAuthzCodeTimeout(authzServerSettings.getAuthzCodeTimeout());
            oauthConfigType.setRestrictPlainPKCE(authzServerSettings.isRestrictPlainPkce());
            oauthConfigType.setIncludeIssuerInAuthzResponse(authzServerSettings.isIncludeIssuerInAuthzResponse());
            oauthConfigType.setRollRefreshTokens(authzServerSettings.isDefaultRefreshTokenRollingPolicy());
            oauthConfigType.setRefreshTokenRollingGracePeriod(authzServerSettings.getRefreshTokenRollingGracePeriod());
            oauthConfigType.setRollingInterval(authzServerSettings.getRefreshRollingInterval());
            oauthConfigType.setRollingIntervalTimeUnit(authzServerSettings.getRefreshTokenRollingIntervalTimeUnit());
            oauthConfigType.setRefreshTokenLength(authzServerSettings.getRefreshTokenLength());
            if (authzServerSettings.getAdminWsPcv() != null) {
                oauthConfigType.setSelectedPcv(authzServerSettings.getAdminWsPcv().getId());
            }
            oauthConfigType.setAtmIdForOAuthGrantManagement(authzServerSettings.getAtmIdForOAuthGrantManagement());
            oauthConfigType.setScopeForOAuthGrantManagement(authzServerSettings.getScopeForOAuthGrantManagement());
            oauthConfigType.setReuseExistingPersistentGrantForGrantArray(authzServerSettings.getGrantTypesToReusePersistentGrants().toArray(new String[authzServerSettings.getGrantTypesToReusePersistentGrants().size()]));
            oauthConfigType.setAllowAutoAuthzForExistingPersistentGrantArray(authzServerSettings.getGrantTypesToAllowAutoAuthzForExistingPersistentGrants().toArray(new String[authzServerSettings.getGrantTypesToAllowAutoAuthzForExistingPersistentGrants().size()]));
            ArrayList<IdpConnection> allConnections = new ArrayList<IdpConnection>(MgmtFactory.getConnectionManager().getAllIdpConnections());
            HashSet updatedConnections = new HashSet();
            for (PersistentGrantAttribute attribute : authzServerSettings.getPersistentGrantExtendedAttributes()) {
                PersistentGrantAttributesType persistentGrantAttributesType = oauthConfigType.addNewPersistentGrantAttributes();
                persistentGrantAttributesType.setAttributeName(attribute.getName());
                this.setNoMappingSourceTypeForNewPersistentGrantExtendedAttributes(attribute, authzServerSettings.getAdapterIdToUserKeyMappings());
                this.setNoMappingSourceTypeForNewPersistentGrantExtendedAttributes(attribute, authzServerSettings.getApcIdToUserKeyMappings());
                this.setNoMappingSourceTypeForNewPersistentGrantExtendedAttributes(attribute, authzServerSettings.getTeppToUserKeyAttrMappings());
                this.setNoMappingSourceTypeForNewPersistentGrantExtendedAttributes(attribute, authzServerSettings.getValidatorIdToUserKeyMappings());
                allConnections.stream().filter(connection -> connection.getSsoToOAuthAttrMapping() != null && !connection.getSsoToOAuthAttrMapping().getAttributeMapping().containsKey(attribute.getName())).peek(connection -> connection.getSsoToOAuthAttrMapping().addAttributeMapping(attribute.getName(), SourceType.NO_MAPPING, SourceType.NO_MAPPING.toString())).forEach(updatedConnections::add);
            }
            MgmtFactory.getConnectionManager().saveIdpConnections(new ArrayList<IdpConnection>(updatedConnections));
            authzServerSettings.setKeyOnlyContract(this.createKeyOnlyContract(authzServerSettings));
            authzServerSettings.setKeyNameContract(this.createKeyNameContract(authzServerSettings));
            SourceToUserKeyMappingType[] sourceToUserKeyMappingTypes = this.buildXmlTypeArray(authzServerSettings.getAdapterIdToUserKeyMappings().values());
            oauthConfigType.setAdapterToUserKeyMappingArray(sourceToUserKeyMappingTypes);
            sourceToUserKeyMappingTypes = this.buildXmlTypeArray(authzServerSettings.getValidatorIdToUserKeyMappings().values());
            oauthConfigType.setPasswordCredentialValidatorToUserKeyMappingArray(sourceToUserKeyMappingTypes);
            oauthConfigType.setApcToUserKeyMappingArray(this.buildXmlTypeArray(authzServerSettings.getApcIdToUserKeyMappings().values()));
            oauthConfigType.setTeppToUserKeyMappingArray(this.buildXmlTypeArray(authzServerSettings.getTeppToUserKeyAttrMappings().values()));
            for (UserKeyToAccessTokenMapping userKeyToAccessTokenMapping : authzServerSettings.getUserKeyToAccessTokenMappings().values()) {
                accessTokenMappingType = oauthConfigType.addNewUserKeyToAccessTokenMapping();
                this.populateUserKeyToAccessTokenMappingType(userKeyToAccessTokenMapping, accessTokenMappingType);
            }
            for (ClientCredentialAccessTokenMapping clientCredentialAccessTokenMapping : authzServerSettings.getClientCredsToAccessTokenMappings().values()) {
                accessTokenMappingType = oauthConfigType.addNewClientCredentialsToAccessTokenMapping();
                this.populateClientCredentialsToAccessTokenMappingType(clientCredentialAccessTokenMapping, (ClientCredentialsToAccessTokenMappingType)accessTokenMappingType);
            }
            if (authzServerSettings.getGlobalPersistentGrantExpirationTime() != null && authzServerSettings.getGlobalPersistentGrantExpirationTimeUnit() != null) {
                oauthConfigType.setGlobalPersistentGrantExpirationTime(authzServerSettings.getGlobalPersistentGrantExpirationTime().longValue());
                oauthConfigType.setGlobalPersistentGrantExpirationTimeUnit(authzServerSettings.getGlobalPersistentGrantExpirationTimeUnit());
            }
            if (authzServerSettings.getGlobalPersistentGrantIdleTimeout() != null && authzServerSettings.getGlobalPersistentGrantIdleTimeoutTimeUnit() != null) {
                oauthConfigType.setGlobalPersistentGrantIdleTimeout(authzServerSettings.getGlobalPersistentGrantIdleTimeout().longValue());
                oauthConfigType.setGlobalPersistentGrantIdleTimeoutTimeUnit(authzServerSettings.getGlobalPersistentGrantIdleTimeoutTimeUnit());
            }
            if (authzServerSettings.getAllowedOrigins() != null) {
                oauthConfigType.setAllowedOriginsArray(authzServerSettings.getAllowedOrigins().toArray(new String[authzServerSettings.getAllowedOrigins().size()]));
            }
            oauthConfigType.setTokenEndpointBaseUrl(authzServerSettings.getTokenEndpointBaseUrl());
            oauthConfigType.setUserAuthzUrl(authzServerSettings.getUserAuthzUrl());
            oauthConfigType.setRegisteredAuthzPath(authzServerSettings.getRegisteredAuthzPath());
            oauthConfigType.setPendingAuthzTimeout(authzServerSettings.getPendingAuthzTimeout());
            oauthConfigType.setBypassActivationCodeConfirmation(authzServerSettings.isBypassActivationCodeConfirmation());
            oauthConfigType.setDevicePollingInterval(authzServerSettings.getDevicePollingInterval());
            oauthConfigType.setActivationCodeCheckMode(authzServerSettings.getActivationCodeCheckMode().name());
            oauthConfigType.setEnableCookielessUserAuthzAuthnApi(authzServerSettings.isEnableCookielessUserAuthzAuthnApi());
            oauthConfigType.setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(authzServerSettings.isReturnIdTokenOnOpenIdWithDeviceAuthzGrant());
            oauthConfigType.setClientSecretRetentionPeriod(authzServerSettings.getClientSecretRetentionPeriod());
            if (StringUtils.isNotBlank((String)authzServerSettings.getAuthzConsentSetting())) {
                oauthConfigType.setAuthzConsentSetting(authzServerSettings.getAuthzConsentSetting());
                if (StringUtils.isNotBlank((String)authzServerSettings.getExternalConsentAdapterId())) {
                    oauthConfigType.setExternalConsentAdapterId(authzServerSettings.getExternalConsentAdapterId());
                }
                if (StringUtils.isNotBlank((String)authzServerSettings.getReturnedScopeAttributeName())) {
                    oauthConfigType.setReturnedScopeAttributeName(authzServerSettings.getReturnedScopeAttributeName());
                }
                if (StringUtils.isNotBlank((String)authzServerSettings.getReturnedAuthorizationDetailsAttributeName())) {
                    oauthConfigType.setReturnedAuthorizationDetailsAttributeName(authzServerSettings.getReturnedAuthorizationDetailsAttributeName());
                }
            } else {
                oauthConfigType.setAuthzConsentSetting("");
                oauthConfigType.setExternalConsentAdapterId("");
                oauthConfigType.setReturnedScopeAttributeName("");
                oauthConfigType.setReturnedAuthorizationDetailsAttributeName("");
            }
            if (authzServerSettings.getParServerPolicy().getTimeoutSeconds() != null) {
                oauthConfigType.setParTimeout(authzServerSettings.getParServerPolicy().getTimeoutSeconds().intValue());
            }
            if (authzServerSettings.getParServerPolicy().getReferenceLength() != null) {
                oauthConfigType.setParRefLength(authzServerSettings.getParServerPolicy().getReferenceLength().intValue());
            }
            if (authzServerSettings.getParServerPolicy().getStatus() != null) {
                oauthConfigType.setParStatus(authzServerSettings.getParServerPolicy().getStatus().toString());
            }
            oauthConfigType.setAllowUnidentifiedClientROCreds(authzServerSettings.isAllowUnidentifiedClientROCreds());
            oauthConfigType.setAllowUnidentifiedClientExtensionGrants(authzServerSettings.isAllowUnidentifiedClientExtensionGrants());
            oauthConfigType.setJwtSecuredAuthorizationResponseModeLifetime(authzServerSettings.getJwtSecuredAuthorizationResponseModeLifetime());
            oauthConfigType.setDpopProofRequireNonce(authzServerSettings.isDpopProofRequireNonce());
            oauthConfigType.setDpopProofLifetimeSeconds(authzServerSettings.getDpopProofLifetimeSeconds());
            oauthConfigType.setDpopProofEnforceReplayPrevention(authzServerSettings.isDpopProofEnforceReplayPrevention());
            oauthConfigType.setBypassAuthorizationForApprovedConsents(authzServerSettings.isBypassAuthorizationForApprovedConsents());
            oauthConfigType.setConsentLifetimeDays(authzServerSettings.getConsentLifetimeDays());
            oauthConfigType.setRequireOfflineAccessScopeToIssueRefreshTokens(authzServerSettings.isRequireOfflineAccessScopeToIssueRefreshTokens());
            oauthConfigType.setOfflineAccessRequireConsentPrompt(authzServerSettings.isOfflineAccessRequireConsentPrompt());
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            authzServerSettings.setCorsSettings(new CorsSettingsUtil().getCorsSettings("cors-configuration", authzServerSettings.getDefaultUrlPatterns(), authzServerSettings.getAllowedOrigins()));
            this.loadConfig();
        }
        catch (ConfigurationException e) {
            this.loadConfig();
            throw e;
        }
    }

    @Override
    public synchronized void save(AuthzServerSettings authzServerSettings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.doSave(authzServerSettings);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_SERVER_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    private void populateUserKeyToAccessTokenMappingType(AccessTokenMapping mapping, UserKeyToAccessTokenMappingType accessTokenMappingType) {
        accessTokenMappingType.setContextId(mapping.getContextId());
        accessTokenMappingType.setTokenManagerId(mapping.getTokenManagerId());
        this.connUtil.fillInAttributeMappingType((AttributeMappingType)accessTokenMappingType, mapping);
    }

    private void populateClientCredentialsToAccessTokenMappingType(AccessTokenMapping mapping, ClientCredentialsToAccessTokenMappingType accessTokenMappingType) {
        accessTokenMappingType.setContextId(mapping.getContextId());
        accessTokenMappingType.setTokenManagerId(mapping.getTokenManagerId());
        this.connUtil.fillInAttributeMappingType((AttributeMappingType)accessTokenMappingType, mapping);
    }

    @Override
    public synchronized boolean isDataSourceInUse(String id) {
        return this.isMappingsDataStoreInUse(id, this.authzServerSettings.getValidatorIdToUserKeyMappings()) || this.isMappingsDataStoreInUse(id, this.authzServerSettings.getAdapterIdToUserKeyMappings()) || this.isMappingsDataStoreInUse(id, this.authzServerSettings.getApcIdToUserKeyMappings()) || this.isMappingsDataStoreInUse(id, this.authzServerSettings.getTeppToUserKeyAttrMappings()) || this.isMappingsDataStoreInUse(id, this.getAllUserKeyToAccessTokenMappings());
    }

    private boolean isMappingsDataStoreInUse(String id, Map<String, ? extends AttributeMapping> mappings) {
        boolean inUse = false;
        if (mappings != null) {
            for (AttributeMapping attributeMapping : mappings.values()) {
                inUse = InUseDetectionUtil.getInstance().isDataSourceInUseByAttributeMapping(attributeMapping, id);
                if (!inUse) continue;
                break;
            }
        }
        return inUse;
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getValidatorIdToUserKeyMappingsWithDSInUse(String id) {
        return this.getMappingsWithDataStoreInUse(id, this.authzServerSettings.getValidatorIdToUserKeyMappings());
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getAdapterIdToUserKeyMappingsWithDSInUse(String id) {
        return this.getMappingsWithDataStoreInUse(id, this.authzServerSettings.getAdapterIdToUserKeyMappings());
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getApcToUserKeyMappingsWithDSInUse(String id) {
        return this.getMappingsWithDataStoreInUse(id, this.authzServerSettings.getApcIdToUserKeyMappings());
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getTeppToUserKeyMappingsWithDSInUse(String id) {
        return this.getMappingsWithDataStoreInUse(id, this.authzServerSettings.getTeppToUserKeyAttrMappings());
    }

    @Override
    public Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithDSInUse(String id) {
        return this.getMappingsWithDataStoreInUse(id, this.getAllUserKeyToAccessTokenMappings());
    }

    private Map<String, ? super AttributeMapping> getMappingsWithDataStoreInUse(String id, Map<String, ? extends AttributeMapping> mappings) {
        HashMap<String, AttributeMapping> mappingsUsingDS = new HashMap<String, AttributeMapping>();
        if (mappings != null) {
            for (Map.Entry<String, ? extends AttributeMapping> m : mappings.entrySet()) {
                AttributeMapping mapping = m.getValue();
                for (AttributeSource attributeSource : mapping.getAttributeSources()) {
                    if (attributeSource.getDataSource() == null || !attributeSource.getDataSource().getId().equals(id)) continue;
                    String key = m.getKey();
                    mappingsUsingDS.put(key, new AttributeMapping(mappings.get(key)));
                }
            }
        }
        return mappingsUsingDS;
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithAdapterInUse(String id) {
        return this.getPluginToUserKeyAttrMappingsAdapterInUse(id, this.authzServerSettings.getAdapterIdToUserKeyMappings());
    }

    private Map<String, ? super AttributeMapping> getPluginToUserKeyAttrMappingsAdapterInUse(String id, Map<String, ? extends AttributeMapping> mappings) {
        HashMap<String, AttributeMapping> mappingsUsingAdapter = new HashMap<String, AttributeMapping>();
        if (mappings != null) {
            for (Map.Entry<String, ? extends AttributeMapping> m : mappings.entrySet()) {
                if (!id.equals(m.getKey())) continue;
                String key = m.getKey();
                mappingsUsingAdapter.put(key, new AttributeMapping(m.getValue()));
            }
        }
        return mappingsUsingAdapter;
    }

    @Override
    public synchronized Map<String, ? super AttributeMapping> getUserKeyToAccessTokenMappingsWithPCVInUse(String id) {
        return this.getPluginToUserKeyAttrMappingsAdapterInUse(id, this.authzServerSettings.getValidatorIdToUserKeyMappings());
    }

    private synchronized Map<String, UserKeyToAccessTokenMapping> getAllUserKeyToAccessTokenMappings() {
        HashMap<String, UserKeyToAccessTokenMapping> allUserKeyToAccessTokenMappings = new HashMap<String, UserKeyToAccessTokenMapping>();
        if (this.authzServerSettings.getUserKeyToAccessTokenMappings() != null) {
            allUserKeyToAccessTokenMappings.putAll(this.authzServerSettings.getUserKeyToAccessTokenMappings());
        }
        return allUserKeyToAccessTokenMappings;
    }

    @Override
    public synchronized AttributeContract getKeyNameContract() {
        return new AttributeContract(this.authzServerSettings.getKeyNameContract());
    }

    @Override
    public synchronized AttributeContract getKeyOnlyContract() {
        return new AttributeContract(this.authzServerSettings.getKeyOnlyContract());
    }

    private AttributeContract createKeyOnlyContract(AuthzServerSettings authzServerSettings) {
        HashSet<String> attrs = new HashSet<String>(this.getPersistentGrantExtendedAttributeNames(authzServerSettings));
        attrs.add("USER_KEY");
        return new AttributeContract(attrs);
    }

    private AttributeContract createKeyNameContract(AuthzServerSettings authzServerSettings) {
        HashSet<String> attrs = new HashSet<String>(this.getPersistentGrantExtendedAttributeNames(authzServerSettings));
        attrs.add("USER_KEY");
        attrs.addAll(this.getDefaultPersistentGrantAttributes());
        return new AttributeContract(attrs);
    }

    @Override
    public List<String> getDefaultPersistentGrantAttributes() {
        ArrayList<String> attrs = new ArrayList<String>(2);
        attrs.add("USER_KEY");
        attrs.add("USER_NAME");
        return attrs;
    }

    @Override
    public synchronized boolean isApcInUse(String contractId) {
        return this.authzServerSettings.getApcIdToUserKeyMappings().containsKey(contractId);
    }

    @Override
    public synchronized int getClientSecretRetentionPeriod() {
        return this.authzServerSettings.getClientSecretRetentionPeriod();
    }

    @Override
    public int getMaxRetainedClientSecondarySecrets() {
        return this.config.getIntValue(CFG_KEY_MAX_SECONDARY_CLIENT_SECRETS, 5);
    }

    @Override
    public boolean isRelaxedAudienceValidation() {
        return this.config.getBooleanValue(CFG_KEY_RELAXED_AUDIENCE_VALIDATION, false);
    }

    @Override
    public int getJwtSecuredAuthorizationResponseModeLifetime() {
        return this.authzServerSettings.getJwtSecuredAuthorizationResponseModeLifetime();
    }

    @Override
    public synchronized CorsSettings getCorsSettings() {
        return new CorsSettings(this.authzServerSettings.getCorsSettings());
    }

    @Override
    public synchronized List<String> getAllowedOrigins() {
        return new ArrayList<String>(this.authzServerSettings.getAllowedOrigins());
    }

    @Override
    public synchronized String getTokenEndpointBaseUrl() {
        return this.authzServerSettings.getTokenEndpointBaseUrl();
    }

    @Override
    public synchronized String getUserAuthzUrl() {
        return this.authzServerSettings.getUserAuthzUrl();
    }

    @Override
    public synchronized String getRegisteredAuthzPath() {
        return this.authzServerSettings.getRegisteredAuthzPath();
    }

    @Override
    public synchronized int getPendingAuthzTimeout() {
        return this.authzServerSettings.getPendingAuthzTimeout();
    }

    @Override
    public synchronized int getDevicePollingInterval() {
        return this.authzServerSettings.getDevicePollingInterval();
    }

    @Override
    public synchronized boolean isBypassActivationCodeConfirmation() {
        return this.authzServerSettings.isBypassActivationCodeConfirmation();
    }

    @Override
    public synchronized ActivationCodeCheckMode getActivationCodeCheckMode() {
        return this.authzServerSettings.getActivationCodeCheckMode();
    }

    @Override
    public synchronized boolean isEnableCookielessUserAuthzAuthnApi() {
        return this.authzServerSettings.isEnableCookielessUserAuthzAuthnApi();
    }

    @Override
    public boolean isReturnIdTokenOnOpenIdWithDeviceAuthorizationGrant() {
        return this.authzServerSettings.isReturnIdTokenOnOpenIdWithDeviceAuthzGrant();
    }

    @Override
    public synchronized String getExternalConsentAdapterId() {
        return this.authzServerSettings.getExternalConsentAdapterId();
    }

    @Override
    public synchronized String getReturnedScopeAttributeName() {
        return this.authzServerSettings.getReturnedScopeAttributeName();
    }

    @Override
    public String getReturnedAuthorizationDetailsAttributeName() {
        return this.authzServerSettings.getReturnedAuthorizationDetailsAttributeName();
    }

    @Override
    public synchronized String getAuthzConsentSetting() {
        return this.authzServerSettings.getAuthzConsentSetting();
    }

    @Override
    public AttributeContract getClientCredentialsContract() {
        HashSet<String> clientAttrs = new HashSet<String>(1);
        clientAttrs.add(ClientRegistrationCoreParameters.CLIENT_ID.getName());
        return new AttributeContract(clientAttrs);
    }

    @Override
    public synchronized Collection<AccessTokenMapping> getAccessTokenMappings() {
        ArrayList<AccessTokenMapping> mappings = new ArrayList<AccessTokenMapping>();
        mappings.addAll(this.authzServerSettings.getUserKeyToAccessTokenMappings().values());
        mappings.addAll(this.authzServerSettings.getClientCredsToAccessTokenMappings().values());
        return Collections.unmodifiableCollection(mappings);
    }

    @Override
    public synchronized void saveAccessTokenMappings(Collection<AccessTokenMapping> mappings) {
        if (mappings != null) {
            AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
            authzServerSettings.getUserKeyToAccessTokenMappings().clear();
            authzServerSettings.getClientCredsToAccessTokenMappings().clear();
            for (AccessTokenMapping mapping : mappings) {
                if (mapping instanceof UserKeyToAccessTokenMapping) {
                    authzServerSettings.getUserKeyToAccessTokenMappings().put(mapping.getId(), (UserKeyToAccessTokenMapping)mapping);
                    continue;
                }
                if (!(mapping instanceof ClientCredentialAccessTokenMapping)) continue;
                authzServerSettings.getClientCredsToAccessTokenMappings().put(mapping.getId(), (ClientCredentialAccessTokenMapping)mapping);
            }
            this.save(authzServerSettings);
        }
    }

    @Override
    public synchronized void handleLegacyClientCredentialToAccessTokenMappingIds() {
        OAuthConfigType oauthConfig = this.getOAuthConfigType();
        for (ClientCredentialsToAccessTokenMappingType type : oauthConfig.getClientCredentialsToAccessTokenMappingArray()) {
            if ("client_credentials".equals(type.getContextId())) continue;
            log.warn((Object)("PingFederate will no longer honour Client Credential Grant type added by the administrators to " + this.directory + File.separator + "oauth-authz-server-settings.xml.The Client Credentials Grant type can now be mapped through Administrative Console or Administrative API."));
        }
    }

    @Override
    public synchronized void deleteClientCredentialToAccessTokenMapping(String mappingId) {
        AuthzServerSettings authzServerSettings = new AuthzServerSettings(this.authzServerSettings);
        ClientCredentialAccessTokenMapping toDelete = authzServerSettings.getClientCredsToAccessTokenMappings().remove(mappingId);
        if (toDelete != null) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.doSave(authzServerSettings);
                auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN_MAPPING, AdminAuditLogger.Event.DELETE);
            }
        }
    }

    @Override
    public boolean isRevokeReplayedRefreshToken() {
        return this.config.getBooleanValue(CFG_KEY_REVOKE_REPLAYED_REFRESH_TOKEN, true);
    }

    @Override
    public boolean isDpopProofRequireNonce() {
        return this.authzServerSettings.isDpopProofRequireNonce();
    }

    @Override
    public int getDpopProofLifetimeSeconds() {
        return this.authzServerSettings.getDpopProofLifetimeSeconds();
    }

    @Override
    public boolean isDpopProofEnforceReplayPrevention() {
        return this.authzServerSettings.isDpopProofEnforceReplayPrevention();
    }

    @Override
    public boolean isBypassAuthorizationForApprovedConsents() {
        return this.authzServerSettings.isBypassAuthorizationForApprovedConsents();
    }

    @Override
    public int getConsentLifetimeDays() {
        return this.authzServerSettings.getConsentLifetimeDays();
    }

    @Override
    public boolean isRevokeRefreshTokenForFailedIssuanceCriteria() {
        return this.config.getBooleanValue(CFG_KEY_REVOKE_REFRESH_TOKEN_FOR_FAILED_ISSUANCE_CRITERIA, false);
    }

    @Override
    public boolean isRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.authzServerSettings.isRequireOfflineAccessScopeToIssueRefreshTokens();
    }

    @Override
    public boolean isOfflineAccessRequireConsentPrompt() {
        return this.authzServerSettings.isOfflineAccessRequireConsentPrompt();
    }

    @Override
    public boolean isPersistentGrantExpiryBasedOnIdleTimeout() {
        return this.config.getBooleanValue(EXPIRY_BASED_ON_IDLE_TIMEOUT_FIELD_NAME, true);
    }
}

