/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.util.DateUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ValidationUtil;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.oauth20.domain.ClientSecretRetentionHelper;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.connect.domain.ClientRegistrationParameters;
import org.sourceid.saml20.domain.ItemReplicationStatus;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.websso.profiles.ProcessRuntimeException;

@XmlRootElement
public class Client {
    public static final String ROLL = "true";
    public static final String DONT_ROLL = "false";
    public static final String SERVER_DEFAULT = "SERVER_DEFAULT";
    public static final String OVERRIDE_SERVER_DEFAULT = "OVERRIDE_SERVER_DEFAULT";
    private String clientId;
    private List<String> redirectUris = new ArrayList<String>();
    private Set<String> grantTypes = new HashSet<String>();
    private HashedPassword clientSecret;
    private Long clientSecretChangedTime;
    private ClientSecondarySecretSet secondarySecrets = new ClientSecondarySecretSet();
    private String name;
    private String description;
    private String logoUrl;
    private String refreshRolling;
    private boolean forceSecretChange = false;
    private boolean forceRegistrationAccessTokenChange = false;
    private String persistentGrantExpirationType = "SERVER_DEFAULT";
    private Long persistentGrantExpirationTime;
    private String persistentGrantExpirationTimeUnit;
    private Calendar lastModified = null;
    private boolean bypassApprovalPage;
    private boolean restrictScopes;
    private List<String> restrictedScopes = new ArrayList<String>();
    private String clientCertIssuerDn;
    private String clientCertSubjectDn;
    private String jwksUrl = null;
    private String jwks = null;
    private List<JsonWebKey> jsonWebKeys = null;
    private ClientAuthenticationType authnType = null;
    private Boolean enforceReplayPrevention = false;
    private boolean requireSignedRequests;
    private String refreshTokenRollingIntervalType;
    private Map<String, String> supplementalInfo = new HashMap<String, String>();
    public static final String REVERSIBLE_SECRET = "REVERSIBLE_SECRET";
    private static final String ACCESS_SESSION_REVOCATION_API = "ACCESS_SESSION_REVOCATION_API";
    private static final String ACCESS_SESSION_MANAGEMENT_API = "ACCESS_SESSION_MANAGEMENT_API";
    private static final String PING_ACCESS_LOGOUT_CAPABLE = "PING_ACCESS_LOGOUT_CAPABLE";
    private static final String LOGOUT_MODE = "LOGOUT_MODE";
    private static final String BACK_CHANNEL_LOGOUT_URI = "BACK_CHANNEL_LOGOUT_URI";
    private static final String TOKEN_ENDPOINT_AUTH_SIGNING_ALGORITHM = "TOKEN_ENDPOINT_AUTH_SIGNING_ALGORITHM";
    private static final String REQUEST_OBJECT_SIGNING_ALGORITHM = "REQUEST_OBJECT_SIGNING_ALGORITHM";
    private static final String CIBA_REQUEST_OBJECT_SIGNING_ALGORITHM = "CIBA_REQUEST_OBJECT_SIGNING_ALGORITHM";
    static final String DEFAULT_ATM_ID = "DEFAULT_ATM_ID";
    private static final String RESTRICT_TO_DEFAULT_ATM = "RESTRICT_TO_DEFAULT_ATM";
    private static final String VALIDATE_USING_ALL_ELIGIBLE_ATMS = "VALIDATE_USING_ALL_ELIGIBLE_ATMS";
    private static final String ALLOW_EXCLUSIVE_SCOPES = "ALLOW_EXCLUSIVE_SCOPES";
    private static final String ENABLED = "ENABLED";
    private static final String EXCLUSIVE_SCOPES = "EXCLUSIVE_SCOPES";
    private static final String ALLOW_AUTHORIZATION_DETAIL_TYPES = "ALLOW_AUTHORIZATION_DETAIL_TYPES";
    private static final String AUTHORIZATION_DETAIL_TYPES = "AUTHORIZATION_DETAIL_TYPES";
    private static final String RESTRICT_RESPONSE_TYPES = "RESTRICT_RESPONSE_TYPES";
    private static final String RESTRICTED_RESPONSE_TYPES = "RESTRICTED_RESPONSE_TYPES";
    private static final String DEVICE_FLOW_SETTING = "DEVICE_FLOW_SETTING";
    private static final String USER_AUTHZ_URL_OVERRIDE = "USER_AUTHZ_URL_OVERRIDE";
    private static final String PENDING_AUTHZ_TIMEOUT_OVERRIDE = "PENDING_AUTHZ_TIMEOUT_OVERRIDE";
    private static final String DEVICE_POLLING_INTERVAL_OVERRIDE = "DEVICE_POLLING_INTERVAL_OVERRIDE";
    private static final String BYPASS_ACTIVATION_CODE_CONFIRMATION_OVERRIDE = "BYPASS_ACTIVATION_CODE_CONFIRMATION_OVERRIDE";
    private static final String PERSISTENT_GRANT_IDLE_TIMEOUT_TYPE = "PERSISTENT_GRANT_IDLE_TIMEOUT_TYPE";
    private static final String PERSISTENT_GRANT_IDLE_TIMEOUT = "PERSISTENT_GRANT_IDLE_TIMEOUT";
    private static final String PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT = "PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT";
    private static final String PERSISTENT_GRANT_REUSE_TYPE = "PERSISTENT_GRANT_REUSE_TYPE";
    private static final String PERSISTENT_GRANT_REUSE_GRANT_TYPES = "PERSISTENT_GRANT_REUSE_GRANT_TYPES";
    private static final String REQUIRE_PROOF_KEY_FOR_CODE_EXCHANGE = "REQUIRE_PROOF_KEY_FOR_CODE_EXCHANGE";
    private static final String PAIRWISE_USER_TYPE = "PAIRWISE_USER_TYPE";
    private static final String SECTOR_IDENTIFIER_URI = "SECTOR_IDENTIFIER_URI";
    private static final String ALLOW_AUTHENTICATION_API_INIT = "ALLOW_AUTHENTICATION_API_INIT";
    private static final String ENABLE_COOKIELESS_AUTHENTICATION_API = "ENABLE_COOKIELESS_AUTHENTICATION_API";
    private static final String REFRESH_TOKEN_ROLLING_INTERVAL = "REFRESH_TOKEN_ROLLING_INTERVAL";
    private static final String REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT = "REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT";
    private static final String REFRESH_TOKEN_ROLLING_GRACE_PERIOD = "REFRESH_TOKEN_ROLLING_GRACE_PERIOD";
    private static final String REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE = "REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String SELECTIVE_REPL_TIME = "SELECTIVE_REPLICATION_TIME";
    private static final String CIBA_MODE = "CIBA_MODE";
    private static final String CIBA_NOTIFICATION_ENDPOINT = "CIBA_NOTIFICATION_ENDPOINT";
    private static final String CIBA_REQUIRE_SIGNED_REQUESTS = "CIBA_REQUIRE_SIGNED_REQUESTS";
    private static final String CIBA_USER_CODE_SUPPORTED = "CIBA_USER_CODE_SUPPORTED";
    static final String CIBA_POLICY_ID = "CIBA_POLICY_ID";
    private static final String CIBA_POLLING_INTERVAL = "CIBA_POLLING_INTERVAL";
    private static final String REQUIRE_PAR = "REQUIRE_PAR";
    private static final String REQUIRE_JARM = "REQUIRE_JARM";
    static final String TOKEN_EXCHANGE_PROCESSOR_POLICY_ID = "TOKEN_EXCHANGE_PROCESSOR_POLICY_ID";
    public static final String EXTENDED_CLIENT_PARAM_NAME_PREFIX = "pf_ecm_";
    public static final String EXTENDED_CLIENT_PARAM_INDEX_SUFFIX = "_";
    private static final String REGISTRATION_TOKEN = "REGISTRATION_TOKEN";
    private HashedPassword registrationAccessToken = null;
    private static final String SECONDARY_SECRETS = "SECONDARY_SECRETS";
    private static final String SECONDARY_SECRET_RETENTION_PERIOD = "SECONDARY_SECRET_RETENTION_PERIOD";
    private static final String SECONDARY_SECRET_RETENTION_PERIOD_TYPE = "SECONDARY_SECRET_RETENTION_PERIOD_TYPE";
    private static final String SECRET_CHANGED_TIME = "SECRET_CHANGED_TIME";
    private static final String REQUIRE_DPOP = "REQUIRE_DPOP";
    private static final String POST_LOGOUT_REDIRECT_URIS = "POST_LOGOUT_REDIRECT_URIS";
    private static final String REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS = "REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS";
    public static final String REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS_SERVER_DEFAULT = "SERVER_DEFAULT";
    public static final String REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS_YES = "Yes";
    public static final String REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS_NO = "No";
    private static final String OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT = "OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT";
    public static final String OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT_SERVER_DEFAULT = "SERVER_DEFAULT";
    public static final String OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT_YES = "Yes";
    public static final String OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT_NO = "No";
    private static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE = "LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE";
    private static final String LOCKOUT_MAX_MALICIOUS_ACTIONS = "LOCKOUT_MAX_MALICIOUS_ACTIONS";
    public static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE_DO_NOT_LOCKOUT = "DO_NOT_LOCKOUT";
    public static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE_SERVER_DEFAULT = "SERVER_DEFAULT";
    public static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE_OVERRIDE_SERVER_DEFAULT = "OVERRIDE_SERVER_DEFAULT";
    public static final String COMPACT_DATE_PATTERN = "MM/dd/yyyy";
    private List<String> logoutUris = new ArrayList<String>();
    private List<String> postLogoutRedirectUris;
    private String fileSystemPath;
    private Map<String, ParamValues> extendedParams = new LinkedHashMap<String, ParamValues>();
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.buildObjectMapper();

    public Client() {
    }

    public Client(Client client) {
        this.clientId = client.clientId;
        this.redirectUris = client.redirectUris;
        this.grantTypes = client.grantTypes;
        this.clientSecret = client.clientSecret;
        this.secondarySecrets = client.secondarySecrets;
        this.clientSecretChangedTime = client.clientSecretChangedTime;
        this.name = client.name;
        this.description = client.description;
        this.logoUrl = client.logoUrl;
        this.refreshRolling = client.refreshRolling;
        this.registrationAccessToken = client.registrationAccessToken;
        this.forceSecretChange = client.forceSecretChange;
        this.forceRegistrationAccessTokenChange = client.forceRegistrationAccessTokenChange;
        this.persistentGrantExpirationType = client.persistentGrantExpirationType;
        this.persistentGrantExpirationTime = client.persistentGrantExpirationTime;
        this.persistentGrantExpirationTimeUnit = client.persistentGrantExpirationTimeUnit;
        this.lastModified = client.lastModified;
        this.bypassApprovalPage = client.bypassApprovalPage;
        this.restrictScopes = client.restrictScopes;
        this.restrictedScopes = client.restrictedScopes;
        this.clientCertIssuerDn = client.clientCertIssuerDn;
        this.clientCertSubjectDn = client.clientCertSubjectDn;
        this.jwksUrl = client.jwksUrl;
        this.jwks = client.jwks;
        this.jsonWebKeys = client.jsonWebKeys;
        this.authnType = client.authnType;
        this.enforceReplayPrevention = client.enforceReplayPrevention;
        this.requireSignedRequests = client.requireSignedRequests;
        this.supplementalInfo = client.supplementalInfo;
        this.logoutUris = client.logoutUris;
        this.fileSystemPath = client.fileSystemPath;
        this.extendedParams = client.extendedParams;
        this.refreshTokenRollingIntervalType = client.refreshTokenRollingIntervalType;
    }

    public Client(String clientId, String name, String refreshRolling, String logoUrl, String hashedClientSecret, String description, String persistentGrantExpirationType, long persistentGrantExpirationTime, String selectedPersistentGrantExpirationTimeUnit, Boolean bypassApprovalPage, ClientAuthenticationType clientAuthnType) {
        this.clientId = clientId.trim();
        this.name = name;
        this.refreshRolling = refreshRolling != null ? refreshRolling.trim() : null;
        String string = this.logoUrl = logoUrl != null ? logoUrl.trim() : null;
        if (hashedClientSecret != null) {
            this.clientSecret = HashedPassword.fromEncodedText(hashedClientSecret);
        }
        this.description = description;
        this.persistentGrantExpirationType = persistentGrantExpirationType;
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
        this.persistentGrantExpirationTimeUnit = selectedPersistentGrantExpirationTimeUnit;
        this.bypassApprovalPage = bypassApprovalPage;
        this.authnType = clientAuthnType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId != null ? clientId.trim() : null;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<String> getPostLogoutRedirectUris() {
        if (this.postLogoutRedirectUris != null) {
            return this.postLogoutRedirectUris;
        }
        String postLogoutRedirectUrisJson = this.supplementalInfo.get(POST_LOGOUT_REDIRECT_URIS);
        if (postLogoutRedirectUrisJson == null) {
            this.postLogoutRedirectUris = new ArrayList<String>();
        } else {
            try {
                this.postLogoutRedirectUris = JsonUtils.getInstance().readToList(postLogoutRedirectUrisJson);
            }
            catch (JsonProcessingException e) {
                throw new ProcessRuntimeException("Unexpected error deserializing post-logout redirect URIs", e);
            }
        }
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        if (postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = Collections.emptyList();
            this.supplementalInfo.remove(POST_LOGOUT_REDIRECT_URIS);
        } else {
            this.postLogoutRedirectUris = postLogoutRedirectUris;
            try {
                this.supplementalInfo.put(POST_LOGOUT_REDIRECT_URIS, JsonUtils.getInstance().writeValueAsString(postLogoutRedirectUris));
            }
            catch (JsonProcessingException e) {
                throw new ProcessRuntimeException("Unexpected error serializing post-logout redirect URIs", e);
            }
        }
    }

    public boolean isGrantTypeAllowed(String grantType) {
        return this.grantTypes != null && this.grantTypes.contains(grantType);
    }

    public boolean isExtensionGrantTypeAllowed() {
        return this.grantTypes != null && this.grantTypes.contains("extension");
    }

    public void setGrantTypes(Set<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Set<String> getGrantTypes() {
        return this.grantTypes;
    }

    public boolean checkSecret(String secret) {
        if (this.clientSecret == null && StringUtils.isEmpty((String)secret)) {
            return true;
        }
        if (this.clientSecret != null && this.clientSecret.checkSecret(secret)) {
            return true;
        }
        this.secondarySecrets = this.getSecondarySecrets();
        boolean isValid = this.secondarySecrets.validateSecret(secret);
        if (isValid) {
            ClientSecretUtils.logSecondarySecretUsage(ClientSecretUtils.ActivityType.CLIENT_AUTHENTICATION, this.getClientId());
        }
        return isValid;
    }

    public void setEncodedSecret(String encoded) {
        this.clientSecret = encoded != null ? HashedPassword.fromEncodedText(encoded) : null;
    }

    public void setSecret(String secret) {
        if (!StringUtils.isBlank((String)secret)) {
            if (this.secretChanged(secret)) {
                this.updateClientSecretChangedTime();
            }
            this.clientSecret = HashedPassword.fromClearText(secret);
            String encoded = Obfuscator.obfuscate(secret);
            this.setObfuscatedReversableSecret(encoded);
        } else {
            this.clientSecret = null;
            this.supplementalInfo.remove(REVERSIBLE_SECRET);
        }
    }

    public void updateSecret(String secret) {
        if (ClientSecretRetentionHelper.isRetainClientSecret(this) && this.secretChanged(secret)) {
            this.addCurrentSecretToSecondary();
        }
        this.setSecret(secret);
    }

    public void updateEncodedSecret(String encodedSecret) {
        if (ClientSecretRetentionHelper.isRetainClientSecret(this) && this.encodedSecretChanged(encodedSecret)) {
            this.addCurrentSecretToSecondary();
        }
        this.setEncodedSecret(encodedSecret);
    }

    public boolean secretChanged(String clearText) {
        if (this.clientSecret == null && StringUtils.isNotBlank((String)clearText)) {
            return true;
        }
        return this.clientSecret != null && !this.clientSecret.checkSecret(clearText);
    }

    public boolean encodedSecretChanged(String encoded) {
        if (this.clientSecret == null && StringUtils.isNotBlank((String)encoded)) {
            return true;
        }
        return this.clientSecret != null && !this.clientSecret.toEncodedText().equals(encoded);
    }

    public boolean checkEncodedSecret(String encoded) {
        String clearText;
        if (this.clientSecret != null && StringUtils.isNotBlank((String)encoded) && (clearText = this.clientSecret.getSecret()) != null) {
            return HashedPassword.fromEncodedText(encoded).checkSecret(clearText);
        }
        return false;
    }

    public void addSecondarySecret(String secret, String reversibleSecret, Date expiryTime) {
        this.secondarySecrets.addSecondarySecret(secret, reversibleSecret, expiryTime);
        String serializedSecondarySecrets = this.secondarySecrets.getSerializedSecondarySecrets();
        this.setSupplementalInfo(SECONDARY_SECRETS, serializedSecondarySecrets);
    }

    public void addEncodedSecondarySecret(String encodedSecret, String reversibleSecret, Date expiryTime) {
        this.secondarySecrets.addEncodedSecondarySecret(encodedSecret, reversibleSecret, expiryTime);
        String serializedSecondarySecrets = this.secondarySecrets.getSerializedSecondarySecrets();
        this.setSupplementalInfo(SECONDARY_SECRETS, serializedSecondarySecrets);
    }

    public void addCurrentSecretToSecondary() {
        this.secondarySecrets = this.getSecondarySecrets();
        if (this.clientSecret != null) {
            String encodedSecret = this.clientSecret.toEncodedText();
            Instant expiryTime = ClientSecretRetentionHelper.getExpiryTimeForSecondarySecret(this);
            String reversibleSecret = null;
            if (this.getSupplementalInfo(REVERSIBLE_SECRET) != null) {
                reversibleSecret = this.getSupplementalInfo(REVERSIBLE_SECRET);
            }
            this.secondarySecrets.addEncodedSecondarySecret(encodedSecret, reversibleSecret, Date.from(expiryTime));
            this.setSecondarySecrets(this.secondarySecrets);
        }
    }

    public void addCurrentSecretToSecondary(String encodedOriginalSecret) {
        this.secondarySecrets = this.getSecondarySecrets();
        if (encodedOriginalSecret != null) {
            Instant expiryTime = ClientSecretRetentionHelper.getExpiryTimeForSecondarySecret(this);
            String reversibleSecret = null;
            if (this.getSupplementalInfo(REVERSIBLE_SECRET) != null && this.needReversibleSecret()) {
                reversibleSecret = this.getSupplementalInfo(REVERSIBLE_SECRET);
            }
            this.secondarySecrets.addEncodedSecondarySecret(encodedOriginalSecret, reversibleSecret, Date.from(expiryTime));
            this.setSecondarySecrets(this.secondarySecrets);
        }
    }

    public void copySecondarySecrets(ClientSecondarySecretSet secretSet) {
        ClientSecondarySecretSet secretSetCopy = new ClientSecondarySecretSet();
        for (ClientSecondarySecretSet.ClientSecondarySecret secret : secretSet.getSecondarySecrets()) {
            secretSetCopy.addEncodedSecondarySecret(secret.getSecret(), secret.getReversibleSecret(), secret.getExpiryTime());
        }
        this.setSecondarySecrets(secretSetCopy);
    }

    public void setSecondarySecrets(ClientSecondarySecretSet secondarySecrets) {
        if (secondarySecrets != null) {
            this.secondarySecrets = secondarySecrets;
            String serializedSecondarySecrets = secondarySecrets.getSerializedSecondarySecrets();
            this.setSupplementalInfo(SECONDARY_SECRETS, serializedSecondarySecrets);
        } else {
            this.setSupplementalInfo(SECONDARY_SECRETS, null);
        }
    }

    public void updateClientSecretChangedTime() {
        Instant currentTime = Instant.now();
        String currentTimeAsString = Long.toString(currentTime.getEpochSecond());
        this.setSupplementalInfo(SECRET_CHANGED_TIME, currentTimeAsString);
    }

    public String getClientSecretChangedTime() {
        return this.getSupplementalInfo(SECRET_CHANGED_TIME);
    }

    public void setClientSecretChangedTime(String clientSecretChangedTime) {
        this.setSupplementalInfo(SECRET_CHANGED_TIME, clientSecretChangedTime);
    }

    public String getSecret() {
        return null;
    }

    @XmlTransient
    public String getEncodedSecret() {
        return this.clientSecret == null ? null : this.clientSecret.toEncodedText();
    }

    public boolean hasSecret() {
        return this.clientSecret != null;
    }

    public boolean hasClientCertCredentials() {
        return StringUtils.isNotBlank((String)this.getClientCertIssuerDn()) && StringUtils.isNotBlank((String)this.getClientCertSubjectDn());
    }

    public boolean hasCredentials() {
        return ClientAuthenticationType.NONE != this.getClientAuthnType();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl != null ? logoUrl.trim() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean rollRefresh(boolean serverDefaultPolicy) {
        String refreshRolling = this.getRefreshRolling();
        if (refreshRolling != null) {
            return Boolean.valueOf(refreshRolling);
        }
        return serverDefaultPolicy;
    }

    @XmlTransient
    public boolean isForceRegistrationAccessTokenChange() {
        return this.forceRegistrationAccessTokenChange;
    }

    public void setForceRegistrationAccessTokenChange(boolean forceRegistrationAccessTokenChange) {
        this.forceRegistrationAccessTokenChange = forceRegistrationAccessTokenChange;
    }

    public Boolean isForceSecretChange() {
        return this.forceSecretChange;
    }

    public void setForceSecretChange(Boolean forceSecretChange) {
        this.forceSecretChange = forceSecretChange;
    }

    public String getRefreshRolling() {
        if (this.refreshRolling == null) {
            return null;
        }
        if (this.refreshRolling.equals("0")) {
            return DONT_ROLL;
        }
        if (this.refreshRolling.equals("1")) {
            return ROLL;
        }
        return this.refreshRolling.toLowerCase();
    }

    public void setRefreshRolling(String refreshRolling) {
        this.refreshRolling = refreshRolling != null ? refreshRolling.trim() : null;
    }

    public Long getRefreshTokenRollingInterval() {
        String refreshRollingInterval = this.getSupplementalInfo(REFRESH_TOKEN_ROLLING_INTERVAL);
        if (StringUtils.isNotBlank((String)refreshRollingInterval)) {
            return Long.parseLong(refreshRollingInterval);
        }
        return null;
    }

    public void setRefreshTokenRollingInterval(Long refreshRollingInterval) {
        if (refreshRollingInterval == null) {
            this.setSupplementalInfo(REFRESH_TOKEN_ROLLING_INTERVAL, null);
        } else {
            this.setSupplementalInfo(REFRESH_TOKEN_ROLLING_INTERVAL, Long.toString(refreshRollingInterval));
        }
    }

    public String getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(String persistentGrantExpirationType) {
        this.persistentGrantExpirationType = persistentGrantExpirationType;
    }

    public Long getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(Long persistentGrantExpirationTime) {
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
    }

    public String getPersistentGrantExpirationTimeUnit() {
        return this.persistentGrantExpirationTimeUnit;
    }

    public void setPersistentGrantExpirationTimeUnit(String selectedPersistentGrantExpirationTimeUnit) {
        if ("min".equals(selectedPersistentGrantExpirationTimeUnit)) {
            selectedPersistentGrantExpirationTimeUnit = "n";
        }
        this.persistentGrantExpirationTimeUnit = selectedPersistentGrantExpirationTimeUnit;
    }

    public boolean getAllowAuthenticationApiInit() {
        String allowAuthenticationAPIInit = this.getSupplementalInfo(ALLOW_AUTHENTICATION_API_INIT);
        return !StringUtils.isBlank((String)allowAuthenticationAPIInit) && Boolean.parseBoolean(allowAuthenticationAPIInit);
    }

    public void setAllowAuthenticationApiInit(boolean allowAuthenticationApiInit) {
        this.setSupplementalInfo(ALLOW_AUTHENTICATION_API_INIT, Boolean.toString(allowAuthenticationApiInit));
    }

    public boolean getEnableCookielessAuthenticationApi() {
        String enableCookielessAuthenticationApi = this.getSupplementalInfo(ENABLE_COOKIELESS_AUTHENTICATION_API);
        return StringUtils.isNotBlank((String)enableCookielessAuthenticationApi) && Boolean.parseBoolean(enableCookielessAuthenticationApi);
    }

    public void setEnableCookielessAuthenticationApi(boolean enableCookielessAuthenticationApi) {
        this.setSupplementalInfo(ENABLE_COOKIELESS_AUTHENTICATION_API, Boolean.toString(enableCookielessAuthenticationApi));
    }

    public boolean isBypassApprovalPage() {
        return this.bypassApprovalPage || this.getAllowAuthenticationApiInit();
    }

    public void setBypassApprovalPage(boolean bypassApprovalPage) {
        this.bypassApprovalPage = bypassApprovalPage;
    }

    public boolean isRestrictScopes() {
        return this.restrictScopes || this.getAllowAuthenticationApiInit();
    }

    public void setRestrictScopes(boolean restrictScopes) {
        this.restrictScopes = restrictScopes;
    }

    public List<String> getRestrictedScopes() {
        return this.restrictedScopes;
    }

    @XmlTransient
    public boolean isAllowedExclusiveScopes() {
        String allowExclusiveScopes = this.getSupplementalInfo(ALLOW_EXCLUSIVE_SCOPES);
        if (StringUtils.isNotBlank((String)allowExclusiveScopes)) {
            return Boolean.parseBoolean(allowExclusiveScopes);
        }
        return false;
    }

    public void setAllowedExcludedScopes(boolean allowedExcludedScopes) {
        this.setSupplementalInfo(ALLOW_EXCLUSIVE_SCOPES, Boolean.toString(allowedExcludedScopes));
    }

    public boolean isEnabled() {
        String enabled = this.getSupplementalInfo(ENABLED);
        if (StringUtils.isNotBlank((String)enabled)) {
            return Boolean.parseBoolean(enabled);
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.setSupplementalInfo(ENABLED, Boolean.toString(enabled));
    }

    @XmlTransient
    public boolean isRestrictResponseTypes() {
        String restrictResponseTypes = this.getSupplementalInfo(RESTRICT_RESPONSE_TYPES);
        if (StringUtils.isNotBlank((String)restrictResponseTypes)) {
            return Boolean.parseBoolean(restrictResponseTypes);
        }
        return false;
    }

    public void setRestrictResponseTypes(boolean restrictResponseTypes) {
        this.setSupplementalInfo(RESTRICT_RESPONSE_TYPES, Boolean.toString(restrictResponseTypes));
    }

    public List<String> getRestrictedResponseTypes() {
        try {
            if (StringUtils.isNotBlank((String)this.getSupplementalInfo(RESTRICTED_RESPONSE_TYPES))) {
                return (List)OBJECT_MAPPER.readValue(this.getSupplementalInfo(RESTRICTED_RESPONSE_TYPES), (TypeReference)new TypeReference<List<String>>(){});
            }
            return new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load restricted response types list");
        }
    }

    public void setRestrictedResponseTypes(List<String> restrictedResponseTypes) {
        try {
            if (restrictedResponseTypes != null && restrictedResponseTypes.size() > 0) {
                this.setRestrictResponseTypes(true);
                this.setSupplementalInfo(RESTRICTED_RESPONSE_TYPES, OBJECT_MAPPER.writeValueAsString(restrictedResponseTypes));
            } else {
                this.setSupplementalInfo(RESTRICTED_RESPONSE_TYPES, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("failed to set restricted response types list");
        }
    }

    public List<String> getExclusiveScopes() {
        try {
            if (StringUtils.isNotBlank((String)this.getSupplementalInfo(EXCLUSIVE_SCOPES))) {
                return (List)OBJECT_MAPPER.readValue(this.getSupplementalInfo(EXCLUSIVE_SCOPES), (TypeReference)new TypeReference<List<String>>(){});
            }
            return new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load allowed exclusive scopes list");
        }
    }

    public void setExclusiveScopes(List<String> allowedExclusiveScopes) {
        try {
            if (allowedExclusiveScopes != null && allowedExclusiveScopes.size() > 0) {
                this.setAllowedExcludedScopes(true);
                this.setSupplementalInfo(EXCLUSIVE_SCOPES, OBJECT_MAPPER.writeValueAsString(allowedExclusiveScopes));
            } else {
                this.setSupplementalInfo(EXCLUSIVE_SCOPES, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("failed to set allowed exclusive scopes list");
        }
    }

    @XmlTransient
    public boolean isAllowedAuthorizationDetailTypes() {
        String allowAuthorizationDetailTypes = this.getSupplementalInfo(ALLOW_AUTHORIZATION_DETAIL_TYPES);
        if (StringUtils.isNotBlank((String)allowAuthorizationDetailTypes)) {
            return Boolean.parseBoolean(allowAuthorizationDetailTypes);
        }
        return false;
    }

    public void setAllowedAuthorizationDetailTypes(boolean allowedAuthorizationDetailTypes) {
        this.setSupplementalInfo(ALLOW_AUTHORIZATION_DETAIL_TYPES, Boolean.toString(allowedAuthorizationDetailTypes));
    }

    public List<String> getAuthorizationDetailTypes() {
        try {
            if (StringUtils.isNotBlank((String)this.getSupplementalInfo(AUTHORIZATION_DETAIL_TYPES))) {
                return (List)OBJECT_MAPPER.readValue(this.getSupplementalInfo(AUTHORIZATION_DETAIL_TYPES), (TypeReference)new TypeReference<List<String>>(){});
            }
            return new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load allowed authorization detail types list");
        }
    }

    public void setAuthorizationDetailTypes(List<String> authorizationDetailTypes) {
        try {
            if (authorizationDetailTypes != null && authorizationDetailTypes.size() > 0) {
                this.setAllowedAuthorizationDetailTypes(true);
                this.setSupplementalInfo(AUTHORIZATION_DETAIL_TYPES, OBJECT_MAPPER.writeValueAsString(authorizationDetailTypes));
            } else {
                this.setSupplementalInfo(AUTHORIZATION_DETAIL_TYPES, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("failed to set allowed authorization detail types list");
        }
    }

    public void setRestrictedScopes(List<String> restrictedScopes) {
        this.restrictedScopes = restrictedScopes;
    }

    public String getClientCertIssuerDn() {
        return this.clientCertIssuerDn;
    }

    public void setClientCertIssuerDn(String clientCertIssuerDn) {
        this.clientCertIssuerDn = clientCertIssuerDn;
    }

    public String getClientCertSubjectDn() {
        return this.clientCertSubjectDn;
    }

    public void setClientCertSubjectDn(String clientCertSubjectDn) {
        this.clientCertSubjectDn = clientCertSubjectDn;
    }

    public boolean isClientCertValidationEnabled() {
        return StringUtils.isNotBlank((String)this.clientCertSubjectDn) && StringUtils.isNotBlank((String)this.clientCertIssuerDn);
    }

    public boolean isRequirePushedAuthorizationRequests() {
        String requireParString = this.getSupplementalInfo(REQUIRE_PAR);
        return Boolean.parseBoolean(requireParString);
    }

    public void setRequirePushedAuthorizationRequests(boolean requirePar) {
        if (requirePar) {
            this.supplementalInfo.put(REQUIRE_PAR, ROLL);
        } else {
            this.supplementalInfo.remove(REQUIRE_PAR);
        }
    }

    @XmlTransient
    public Map<String, String> getSupplementalInfo() {
        boolean dynamicClientNeedsReversible;
        boolean bl = dynamicClientNeedsReversible = this.getRegistrationAccessToken() != null && ClientAuthenticationType.SECRET.equals((Object)this.getClientAuthnType());
        if (!this.needReversibleSecret() && !dynamicClientNeedsReversible) {
            this.supplementalInfo.remove(REVERSIBLE_SECRET);
        }
        return this.supplementalInfo;
    }

    public String getSupplementalInfo(String name) {
        return this.supplementalInfo.get(name);
    }

    public void setSupplementalInfo(String name, String value) {
        this.supplementalInfo.put(name, value);
    }

    public void removeSupplementalInfo(String name) {
        this.supplementalInfo.remove(name);
    }

    @XmlTransient
    public byte[] getSecretAsUtf8Bytes() {
        byte[] secret = null;
        String encoded = this.getSupplementalInfo(REVERSIBLE_SECRET);
        if (encoded != null) {
            secret = Obfuscator.deobfuscate(encoded).getBytes(StandardCharsets.UTF_8);
        }
        return secret;
    }

    @XmlTransient
    public String getReversableSecretAsString() {
        String encoded = this.getSupplementalInfo(REVERSIBLE_SECRET);
        if (encoded == null) {
            return null;
        }
        return Obfuscator.deobfuscate(encoded);
    }

    @XmlTransient
    public String getObfuscatedReversableSecret() {
        return this.getSupplementalInfo(REVERSIBLE_SECRET);
    }

    public void setObfuscatedReversableSecret(String obfuscatedReversableSecret) {
        this.setSupplementalInfo(REVERSIBLE_SECRET, obfuscatedReversableSecret);
    }

    @XmlTransient
    public List<byte[]> getAllReversibleSecretsAsUtf8Bytes() {
        List secondaries;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        byte[] primary = this.getSecretAsUtf8Bytes();
        if (primary != null && primary.length > 0) {
            result.add(primary);
        }
        if (!(secondaries = this.getSecondarySecrets().getSecondarySecrets().stream().map(ClientSecondarySecretSet.ClientSecondarySecret::getReversibleSecret).filter(StringUtils::isNotBlank).map(s -> Obfuscator.deobfuscate(s).getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList())).isEmpty()) {
            result.addAll(secondaries);
        }
        return result;
    }

    public String getSecondarySecretRetentionPeriod() {
        return this.getSupplementalInfo(SECONDARY_SECRET_RETENTION_PERIOD);
    }

    public void setSecondarySecretRetentionPeriod(String retentionPeriod) {
        String value = null;
        if (StringUtils.isNotBlank((String)retentionPeriod)) {
            value = retentionPeriod;
        }
        this.setSupplementalInfo(SECONDARY_SECRET_RETENTION_PERIOD, value);
    }

    public String getSecondarySecretRetentionPeriodType() {
        String clientSecretRetentionPeriodType = this.getSupplementalInfo(SECONDARY_SECRET_RETENTION_PERIOD_TYPE);
        if (StringUtils.isBlank((String)clientSecretRetentionPeriodType)) {
            return "SERVER_DEFAULT";
        }
        return clientSecretRetentionPeriodType;
    }

    public void setSecondarySecretRetentionPeriodType(String secondarySecretRetentionPeriodType) {
        String value = StringUtils.isBlank((String)secondarySecretRetentionPeriodType) ? null : secondarySecretRetentionPeriodType;
        this.setSupplementalInfo(SECONDARY_SECRET_RETENTION_PERIOD_TYPE, value);
    }

    @XmlTransient
    public ClientSecondarySecretSet getSecondarySecrets() {
        String serializedSecrets = this.getSupplementalInfo(SECONDARY_SECRETS);
        ClientSecondarySecretSet secondarySecrets = serializedSecrets != null ? new ClientSecondarySecretSet(serializedSecrets) : new ClientSecondarySecretSet();
        this.secondarySecrets = secondarySecrets;
        secondarySecrets.removeExpiredSecondarySecrets();
        return secondarySecrets;
    }

    public boolean needReversibleSecret() {
        AlgorithmFactoryFactory algoFactoryFactory = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory jwsAlgoFactory = algoFactoryFactory.getJwsAlgorithmFactory();
        AlgorithmFactory jweAlgoFactory = algoFactoryFactory.getJweKeyManagementAlgorithmFactory();
        String idTokenSigAlgo = this.getIdTokenSigningAlgorithm();
        String idTokenEncAlgo = this.getIdTokenEncryptionAlgorithm();
        String introspectionSigningAlgo = this.getIntrospectionSigningAlgorithm();
        String introspectionEncryptionAlgo = this.getIntrospectionEncryptionAlgorithm();
        String authorizationResponseSigningAlgorithm = this.getAuthorizationResponseSigningAlgorithm();
        String authorizationResponseEncryptionAlgorithm = this.getAuthorizationResponseEncryptionAlgorithm();
        String userInfoResponseSigningAlgorithm = this.getUserInfoResponseSigningAlgorithm();
        String userInfoResponseEncryptionAlgorithm = this.getUserInfoResponseEncryptionAlgorithm();
        try {
            boolean isSymmetricIdTokenSigning = idTokenSigAlgo != null && ((JsonWebSignatureAlgorithm)jwsAlgoFactory.getAlgorithm(idTokenSigAlgo)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricIdTokenEnc = idTokenEncAlgo != null && ((KeyManagementAlgorithm)jweAlgoFactory.getAlgorithm(idTokenEncAlgo)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricIntrospectionSigning = introspectionSigningAlgo != null && ((JsonWebSignatureAlgorithm)jwsAlgoFactory.getAlgorithm(introspectionSigningAlgo)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricIntrospectionEnc = introspectionEncryptionAlgo != null && ((KeyManagementAlgorithm)jweAlgoFactory.getAlgorithm(introspectionEncryptionAlgo)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricAuthorizationResponseSigning = authorizationResponseSigningAlgorithm != null && ((JsonWebSignatureAlgorithm)jwsAlgoFactory.getAlgorithm(authorizationResponseSigningAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricAuthorizationResponseEncryption = authorizationResponseEncryptionAlgorithm != null && ((KeyManagementAlgorithm)jweAlgoFactory.getAlgorithm(authorizationResponseEncryptionAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricUserInfoResponseSigning = userInfoResponseSigningAlgorithm != null && ((JsonWebSignatureAlgorithm)jwsAlgoFactory.getAlgorithm(userInfoResponseSigningAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            boolean isSymmetricUserInfoResponseEncryption = userInfoResponseEncryptionAlgorithm != null && ((KeyManagementAlgorithm)jweAlgoFactory.getAlgorithm(userInfoResponseEncryptionAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            return isSymmetricIdTokenSigning || isSymmetricIdTokenEnc || isSymmetricIntrospectionSigning || isSymmetricIntrospectionEnc || isSymmetricAuthorizationResponseSigning || isSymmetricAuthorizationResponseEncryption || isSymmetricUserInfoResponseSigning || isSymmetricUserInfoResponseEncryption || this.isClientSecretJwtAuthn();
        }
        catch (JoseException e) {
            return false;
        }
    }

    public String getIdTokenSigningAlgorithm() {
        return this.getIdTokenSigningAlgorithm(false);
    }

    public String getIdTokenSigningAlgorithm(boolean useDefaultIfNoValueFound) {
        String algo = this.getSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_SIGNED_RESPONSE_ALG);
        return algo == null && useDefaultIfNoValueFound ? "RS256" : algo;
    }

    public void setIdTokenSigningAlgorithm(String algo) {
        this.setSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_SIGNED_RESPONSE_ALG, algo);
    }

    public String getIdTokenEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_ENCRYPTED_RESPONSE_ALG);
    }

    public void setIdTokenEncryptionAlgorithm(String algo) {
        this.setSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_ENCRYPTED_RESPONSE_ALG, algo);
    }

    public String getIdTokenContentEncryptionAlgorithm() {
        return this.getIdTokenContentEncryptionAlgorithm(false);
    }

    public String getIdTokenContentEncryptionAlgorithm(boolean useDefaultIfNoValueFound) {
        String algo = this.getSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_ENCRYPTED_RESPONSE_ENC);
        return algo == null && useDefaultIfNoValueFound ? "A128CBC-HS256" : algo;
    }

    public void setIdTokenContentEncryptionAlgorithm(String algo) {
        this.setSupplementalInfo(ClientRegistrationParameters.ID_TOKEN_ENCRYPTED_RESPONSE_ENC, algo);
    }

    public void setPolicyGroupId(String id) {
        this.setSupplementalInfo(ClientRegistrationParameters.PING_POLICY_GROUP_ID, id);
    }

    public String getPolicyGroupId() {
        return this.getSupplementalInfo(ClientRegistrationParameters.PING_POLICY_GROUP_ID);
    }

    public boolean isGrantAccessSessionRevocationApi() {
        String accessString = this.getSupplementalInfo(ACCESS_SESSION_REVOCATION_API);
        if (!StringUtils.isBlank((String)accessString)) {
            return Boolean.parseBoolean(accessString);
        }
        return false;
    }

    public void setGrantAccessSessionManagementApi(boolean grant) {
        this.setSupplementalInfo(ACCESS_SESSION_MANAGEMENT_API, Boolean.toString(grant));
    }

    public boolean isGrantAccessSessionManagementApi() {
        String accessString = this.getSupplementalInfo(ACCESS_SESSION_MANAGEMENT_API);
        if (!StringUtils.isBlank((String)accessString)) {
            return Boolean.parseBoolean(accessString);
        }
        return false;
    }

    public void setGrantAccessSessionRevocationApi(boolean grant) {
        this.setSupplementalInfo(ACCESS_SESSION_REVOCATION_API, Boolean.toString(grant));
    }

    public List<String> getLogoutUris() {
        return this.logoutUris;
    }

    public void setLogoutUris(List<String> endpoints) {
        this.logoutUris = endpoints;
    }

    public boolean isValidateUsingAllEligibleAtms() {
        String validateString = this.getSupplementalInfo(VALIDATE_USING_ALL_ELIGIBLE_ATMS);
        return Boolean.parseBoolean(validateString);
    }

    public void setValidateUsingAllEligibleAtms(boolean validateUsingAllEligibleAtms) {
        this.setSupplementalInfo(VALIDATE_USING_ALL_ELIGIBLE_ATMS, Boolean.toString(validateUsingAllEligibleAtms));
    }

    public boolean isPingAccessLogoutCapable() {
        String accessString = this.getSupplementalInfo(PING_ACCESS_LOGOUT_CAPABLE);
        if (!StringUtils.isBlank((String)accessString)) {
            return Boolean.parseBoolean(accessString);
        }
        return false;
    }

    public void setPingAccessLogoutCapable(boolean pingAccessLogoutCapable) {
        this.setSupplementalInfo(PING_ACCESS_LOGOUT_CAPABLE, Boolean.toString(pingAccessLogoutCapable));
    }

    public ClientLogoutMode getLogoutMode() {
        String logoutMode = this.getSupplementalInfo(LOGOUT_MODE);
        if (StringUtils.isBlank((String)logoutMode)) {
            if (!this.isPingAccessLogoutCapable() && this.logoutUris.isEmpty()) {
                return ClientLogoutMode.NONE;
            }
            return ClientLogoutMode.PING_FRONT_CHANNEL;
        }
        return ClientLogoutMode.valueOf(logoutMode);
    }

    public void setLogoutMode(ClientLogoutMode logoutMode) {
        this.setSupplementalInfo(LOGOUT_MODE, logoutMode.name());
    }

    public String getBackChannelLogoutUri() {
        return this.getSupplementalInfo(BACK_CHANNEL_LOGOUT_URI);
    }

    public void setBackChannelLogoutUri(String backchannelLogoutUri) {
        this.setSupplementalInfo(BACK_CHANNEL_LOGOUT_URI, backchannelLogoutUri);
    }

    public String getDefaultAccessTokenManagerId() {
        return this.getSupplementalInfo(DEFAULT_ATM_ID);
    }

    public void setDefaultAccessTokenManagerId(String defaultAtmId) {
        this.setSupplementalInfo(DEFAULT_ATM_ID, defaultAtmId);
    }

    public boolean isRestrictToDefaultAccessTokenManager() {
        String restrictStr = this.getSupplementalInfo(RESTRICT_TO_DEFAULT_ATM);
        return Boolean.parseBoolean(restrictStr);
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrict) {
        this.setSupplementalInfo(RESTRICT_TO_DEFAULT_ATM, Boolean.toString(restrict));
    }

    public Calendar getLastModified() {
        if (this.lastModified != null) {
            return this.lastModified;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(0L));
        return cal;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    @XmlTransient
    public Calendar getCreationTime() {
        String creationTime = this.getSupplementalInfo(CREATION_TIME);
        Calendar cal = Calendar.getInstance();
        if (StringUtils.isBlank((String)creationTime)) {
            cal.setTime(new Date(0L));
        } else {
            cal.setTime(new Date(Long.parseLong(creationTime)));
        }
        return cal;
    }

    public void setCreationTime(Calendar creationTime) {
        if (creationTime != null) {
            Long creationTimeInMillis = creationTime.getTimeInMillis();
            this.setSupplementalInfo(CREATION_TIME, String.valueOf(creationTimeInMillis));
        }
    }

    @XmlTransient
    public Date getLastModifiedDate() {
        return DateUtil.calendarToDate(this.lastModified);
    }

    @XmlTransient
    public Date getCreationDate() {
        return DateUtil.calendarToDate(this.getCreationTime());
    }

    @XmlTransient
    public String getLastModifiedCompactString() {
        return DateUtil.formatDate(DateUtil.calendarToDate(this.lastModified), COMPACT_DATE_PATTERN);
    }

    @XmlTransient
    public String getCreationTimeCompactString() {
        return DateUtil.formatDate(DateUtil.calendarToDate(this.getCreationTime()), COMPACT_DATE_PATTERN);
    }

    public void setSelectiveReplicationTime(Calendar selectiveReplicationTime) {
        if (selectiveReplicationTime != null) {
            Long selectiveReplicationTimeInMillis = selectiveReplicationTime.getTimeInMillis();
            this.setSupplementalInfo(SELECTIVE_REPL_TIME, String.valueOf(selectiveReplicationTimeInMillis));
        }
    }

    @XmlTransient
    public Date getSelectiveReplicationTime() {
        String selectiveReplTime = this.getSupplementalInfo(SELECTIVE_REPL_TIME);
        if (StringUtils.isBlank((String)selectiveReplTime)) {
            return null;
        }
        return new Date(Long.parseLong(selectiveReplTime));
    }

    @XmlTransient
    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    public void setFileSystemPath(String fileSystemPath) {
        this.fileSystemPath = fileSystemPath;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    @XmlTransient
    public List<JsonWebKey> getJsonWebKeys() {
        return this.jsonWebKeys;
    }

    public void setJsonWebKeys(List<JsonWebKey> jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    @XmlTransient
    public boolean isJwtAuthn() {
        return ClientAuthenticationType.PRIVATE_KEY_JWT == this.authnType;
    }

    @XmlTransient
    public boolean isClientSecretJwtAuthn() {
        return ClientAuthenticationType.CLIENT_SECRET_JWT == this.authnType;
    }

    public boolean isRequireSignedRequests() {
        return this.requireSignedRequests;
    }

    public void setRequireSignedRequests(boolean requireSignedRequests) {
        this.requireSignedRequests = requireSignedRequests;
    }

    public String getRequestObjectSigningAlgorithm() {
        return this.supplementalInfo.get(REQUEST_OBJECT_SIGNING_ALGORITHM);
    }

    public void setRequestObjectSigningAlgorithm(String algorithm) {
        String value = null;
        if (StringUtils.isNotBlank((String)algorithm)) {
            value = algorithm;
        }
        this.supplementalInfo.put(REQUEST_OBJECT_SIGNING_ALGORITHM, value);
    }

    public String getCibaRequestObjectSigningAlgorithm() {
        return this.supplementalInfo.get(CIBA_REQUEST_OBJECT_SIGNING_ALGORITHM);
    }

    public void setCibaRequestObjectSigningAlgorithm(String algorithm) {
        String value = null;
        if (StringUtils.isNotBlank((String)algorithm)) {
            value = algorithm;
        }
        this.supplementalInfo.put(CIBA_REQUEST_OBJECT_SIGNING_ALGORITHM, value);
    }

    public ClientAuthenticationType getClientAuthnType() {
        ClientAuthenticationType clientAuthType = ClientAuthenticationType.NONE;
        if (this.authnType == null) {
            if (StringUtils.isNotBlank((String)this.clientCertIssuerDn) && StringUtils.isNotBlank((String)this.clientCertSubjectDn)) {
                clientAuthType = ClientAuthenticationType.CLIENT_CERT;
            } else if (this.clientSecret != null) {
                clientAuthType = ClientAuthenticationType.SECRET;
            }
        } else {
            clientAuthType = this.authnType;
        }
        return clientAuthType;
    }

    @XmlTransient
    public ClientAuthenticationType getSpecifiedClientAuthnType() {
        return this.authnType;
    }

    public void setClientAuthnType(ClientAuthenticationType authnType) {
        this.authnType = authnType;
    }

    public Boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(Boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    public String getTokenEndpointAuthSigningAlgorithm() {
        return this.getSupplementalInfo(TOKEN_ENDPOINT_AUTH_SIGNING_ALGORITHM);
    }

    public void setTokenEndpointAuthSigningAlgorithm(String algorithm) {
        String value = null;
        if (StringUtils.isNotBlank((String)algorithm)) {
            value = algorithm;
        }
        this.setSupplementalInfo(TOKEN_ENDPOINT_AUTH_SIGNING_ALGORITHM, value);
    }

    public Map<String, ParamValues> getExtendedParams() {
        return this.extendedParams;
    }

    public void setExtendedParams(Map<String, ParamValues> extendedParams) {
        this.extendedParams = extendedParams;
    }

    void addExtendedParam(String key, ParamValues paramValues) {
        this.extendedParams.put(key, paramValues);
    }

    public String getDeviceFlowSettingType() {
        String result = this.getSupplementalInfo(DEVICE_FLOW_SETTING);
        if (StringUtils.isBlank((String)result)) {
            result = "SERVER_DEFAULT";
        }
        return result;
    }

    public void setDeviceFlowSettingType(String deviceFlowSettings) {
        this.setSupplementalInfo(DEVICE_FLOW_SETTING, StringUtils.isNotBlank((String)deviceFlowSettings) ? deviceFlowSettings : null);
    }

    public String getUserAuthzUrlOverride() {
        return this.getSupplementalInfo(USER_AUTHZ_URL_OVERRIDE);
    }

    public void setUserAuthzUrlOverride(String userAuthzBaseUrlOverride) {
        String value = null;
        if (StringUtils.isNotBlank((String)userAuthzBaseUrlOverride)) {
            value = userAuthzBaseUrlOverride;
        }
        this.setSupplementalInfo(USER_AUTHZ_URL_OVERRIDE, value);
    }

    public String getPendingAuthzTimeoutOverride() {
        return this.getSupplementalInfo(PENDING_AUTHZ_TIMEOUT_OVERRIDE);
    }

    public void setPendingAuthzTimeoutOverride(String pendingAuthzTimeoutOverride) {
        String value = null;
        if (StringUtils.isNotBlank((String)pendingAuthzTimeoutOverride)) {
            value = pendingAuthzTimeoutOverride;
        }
        this.setSupplementalInfo(PENDING_AUTHZ_TIMEOUT_OVERRIDE, value);
    }

    public String getDevicePollingIntervalOverride() {
        return this.getSupplementalInfo(DEVICE_POLLING_INTERVAL_OVERRIDE);
    }

    public void setDevicePollingIntervalOverride(String devicePollingIntervalOverride) {
        String value = null;
        if (StringUtils.isNotBlank((String)devicePollingIntervalOverride)) {
            value = devicePollingIntervalOverride;
        }
        this.setSupplementalInfo(DEVICE_POLLING_INTERVAL_OVERRIDE, value);
    }

    public Boolean getBypassActivationCodeConfirmationOverride() {
        Boolean result = null;
        String bypassUserCodeConfirmationOverride = this.getSupplementalInfo(BYPASS_ACTIVATION_CODE_CONFIRMATION_OVERRIDE);
        if (StringUtils.isNotBlank((String)bypassUserCodeConfirmationOverride)) {
            result = Boolean.parseBoolean(bypassUserCodeConfirmationOverride);
        }
        return result;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassUserCodeConfirmationOverride) {
        String value = null;
        if (bypassUserCodeConfirmationOverride != null) {
            value = Boolean.toString(bypassUserCodeConfirmationOverride);
        }
        this.setSupplementalInfo(BYPASS_ACTIVATION_CODE_CONFIRMATION_OVERRIDE, value);
    }

    public String getPersistentGrantIdleTimeoutType() {
        String idleTimeoutType = this.getSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT_TYPE);
        return StringUtils.isBlank((String)idleTimeoutType) ? "SERVER_DEFAULT" : ("INDEFINITE_EXPIRY".equals(idleTimeoutType) ? "NONE" : idleTimeoutType);
    }

    public void setPersistentGrantIdleTimeoutType(String persistentGrantIdleTimeoutType) {
        this.setSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT_TYPE, StringUtils.isBlank((String)persistentGrantIdleTimeoutType) ? "SERVER_DEFAULT" : ("INDEFINITE_EXPIRY".equals(persistentGrantIdleTimeoutType) ? "NONE" : persistentGrantIdleTimeoutType));
    }

    public Long getPersistentGrantIdleTimeout() {
        String idleTimeout = this.getSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT);
        if ("NONE".equals(this.getPersistentGrantIdleTimeoutType())) {
            return -1L;
        }
        if (StringUtils.isBlank((String)idleTimeout) || !ValidationUtil.isValidLong(idleTimeout)) {
            return 0L;
        }
        return Long.parseLong(idleTimeout);
    }

    public void setPersistentGrantIdleTimeout(Long persistentGrantIdleTimeout) {
        this.setSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT, persistentGrantIdleTimeout == null ? "0" : persistentGrantIdleTimeout.toString());
    }

    public String getPersistentGrantIdleTimeoutTimeUnit() {
        String timeUnit = this.getSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT);
        return StringUtils.isBlank((String)timeUnit) ? "d" : timeUnit;
    }

    public void setPersistentGrantIdleTimeoutTimeUnit(String persistentGrantIdleTimeoutTimeUnit) {
        this.setSupplementalInfo(PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT, StringUtils.isBlank((String)persistentGrantIdleTimeoutTimeUnit) ? "d" : persistentGrantIdleTimeoutTimeUnit);
    }

    public boolean isOverrideReusePersistentGrantType() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.getPersistentGrantReuseType());
    }

    public boolean isReusePersistentGrantTypeAllowed(String grantType) {
        Set<String> reuseGrantTypes = this.getPersistentGrantReuseGrantTypes();
        if (reuseGrantTypes != null) {
            return reuseGrantTypes.contains(grantType);
        }
        return false;
    }

    public String getPersistentGrantReuseType() {
        String persistentGrantReuseType = this.getSupplementalInfo(PERSISTENT_GRANT_REUSE_TYPE);
        if (StringUtils.isEmpty((String)persistentGrantReuseType)) {
            persistentGrantReuseType = "SERVER_DEFAULT";
        }
        return persistentGrantReuseType;
    }

    public void setPersistentGrantReuseType(String persistentGrantReuseType) {
        if ("SERVER_DEFAULT".equals(persistentGrantReuseType) || "OVERRIDE_SERVER_DEFAULT".equals(persistentGrantReuseType)) {
            this.setSupplementalInfo(PERSISTENT_GRANT_REUSE_TYPE, persistentGrantReuseType);
        }
    }

    public Set<String> getPersistentGrantReuseGrantTypes() {
        try {
            if (!this.isOverrideReusePersistentGrantType()) {
                return null;
            }
            if (StringUtils.isNotBlank((String)this.getSupplementalInfo(PERSISTENT_GRANT_REUSE_GRANT_TYPES))) {
                return (Set)OBJECT_MAPPER.readValue(this.getSupplementalInfo(PERSISTENT_GRANT_REUSE_GRANT_TYPES), (TypeReference)new TypeReference<Set<String>>(){});
            }
            return new HashSet<String>();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load persistent grant types to reuse");
        }
    }

    public void setPersistentGrantReuseGrantTypes(Set<String> persistentGrantReuseGrantTypes) {
        try {
            if (this.isOverrideReusePersistentGrantType() && persistentGrantReuseGrantTypes != null && !persistentGrantReuseGrantTypes.isEmpty()) {
                this.setSupplementalInfo(PERSISTENT_GRANT_REUSE_GRANT_TYPES, OBJECT_MAPPER.writeValueAsString(persistentGrantReuseGrantTypes));
            } else {
                this.setSupplementalInfo(PERSISTENT_GRANT_REUSE_GRANT_TYPES, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("failed to set persistent grants to reuse");
        }
    }

    public boolean isRequireProofKeyForCodeExchange() {
        String value = this.getSupplementalInfo(REQUIRE_PROOF_KEY_FOR_CODE_EXCHANGE);
        return Boolean.parseBoolean(value);
    }

    public void setRequireProofKeyForCodeExchange(boolean proofKeyForCodeExchangeRequired) {
        this.setSupplementalInfo(REQUIRE_PROOF_KEY_FOR_CODE_EXCHANGE, Boolean.toString(proofKeyForCodeExchangeRequired));
    }

    public CibaDeliveryMode getCibaTokenDeliveryMode() {
        String modeString = this.getSupplementalInfo(CIBA_MODE);
        return modeString != null ? CibaDeliveryMode.valueOf(modeString) : null;
    }

    public void setCibaTokenDeliveryMode(CibaDeliveryMode mode) {
        if (mode == null) {
            this.supplementalInfo.remove(CIBA_MODE);
        } else {
            this.supplementalInfo.put(CIBA_MODE, mode.toString());
        }
    }

    public String getCibaNotificationEndpoint() {
        return this.getSupplementalInfo(CIBA_NOTIFICATION_ENDPOINT);
    }

    public void setCibaNotificationEndpoint(String endpoint) {
        this.setSupplementalInfo(CIBA_NOTIFICATION_ENDPOINT, endpoint);
    }

    public Boolean isCibaRequireSignedRequests() {
        Boolean result = null;
        String value = this.getSupplementalInfo(CIBA_REQUIRE_SIGNED_REQUESTS);
        if (StringUtils.isNotBlank((String)value)) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public void setCibaRequireSignedRequests(Boolean requireSignedRequests) {
        if (requireSignedRequests == null) {
            this.supplementalInfo.remove(CIBA_REQUIRE_SIGNED_REQUESTS);
        } else {
            this.setSupplementalInfo(CIBA_REQUIRE_SIGNED_REQUESTS, Boolean.toString(requireSignedRequests));
        }
    }

    public Boolean isCibaUserCodeSupported() {
        Boolean result = null;
        String value = this.getSupplementalInfo(CIBA_USER_CODE_SUPPORTED);
        if (StringUtils.isNotBlank((String)value)) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public void setCibaUserCodeSupported(Boolean userCodeSupported) {
        if (userCodeSupported == null) {
            this.supplementalInfo.remove(CIBA_USER_CODE_SUPPORTED);
        } else {
            this.setSupplementalInfo(CIBA_USER_CODE_SUPPORTED, Boolean.toString(userCodeSupported));
        }
    }

    public String getCibaPolicyId() {
        return this.getSupplementalInfo(CIBA_POLICY_ID);
    }

    public void setCibaPolicyId(String policyId) {
        this.setSupplementalInfo(CIBA_POLICY_ID, policyId);
    }

    public Integer getCibaPollingInterval() {
        String pollingInterval = this.getSupplementalInfo(CIBA_POLLING_INTERVAL);
        if (StringUtils.isNotBlank((String)pollingInterval)) {
            return Integer.parseInt(pollingInterval);
        }
        return null;
    }

    public void setCibaPollingInterval(Integer pollingInterval) {
        this.setSupplementalInfo(CIBA_POLLING_INTERVAL, pollingInterval == null ? null : String.valueOf(pollingInterval));
    }

    public String getTokenExchangeProcessorPolicyId() {
        return this.getSupplementalInfo(TOKEN_EXCHANGE_PROCESSOR_POLICY_ID);
    }

    public void setTokenExchangeProcessorPolicyId(String policyId) {
        this.setSupplementalInfo(TOKEN_EXCHANGE_PROCESSOR_POLICY_ID, policyId);
    }

    public boolean isPairwiseUserType() {
        String pairwiseUserType = this.getSupplementalInfo(PAIRWISE_USER_TYPE);
        if (!StringUtils.isBlank((String)pairwiseUserType)) {
            return Boolean.parseBoolean(pairwiseUserType);
        }
        return false;
    }

    public void setPairwiseUserType(boolean pairwiseUserType) {
        this.setSupplementalInfo(PAIRWISE_USER_TYPE, Boolean.toString(pairwiseUserType));
    }

    public String getSectorIdentifierUri() {
        return this.getSupplementalInfo(SECTOR_IDENTIFIER_URI);
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.setSupplementalInfo(SECTOR_IDENTIFIER_URI, sectorIdentifierUri);
    }

    public String getSectorIdentifier() {
        if (!this.isPairwiseUserType()) {
            return null;
        }
        try {
            if (StringUtils.isNotBlank((String)this.getSectorIdentifierUri())) {
                return new URI(this.getSectorIdentifierUri()).getHost();
            }
            return new URI(this.getRedirectUris().get(0)).getHost();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to parse the host from the Redirect URI or the Sector Identifier URI.");
        }
    }

    public HashedPassword getRegistrationAccessToken() {
        if (this.registrationAccessToken == null && this.supplementalInfo.containsKey(REGISTRATION_TOKEN)) {
            this.registrationAccessToken = HashedPassword.fromEncodedText(this.supplementalInfo.get(REGISTRATION_TOKEN));
        }
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(HashedPassword registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
        if (registrationAccessToken != null) {
            this.supplementalInfo.put(REGISTRATION_TOKEN, registrationAccessToken.toEncodedText());
        }
    }

    public String getRefreshTokenRollingIntervalType() {
        if (this.refreshTokenRollingIntervalType == null && this.getRefreshTokenRollingInterval() != null) {
            return "OVERRIDE_SERVER_DEFAULT";
        }
        return this.refreshTokenRollingIntervalType;
    }

    public String getRefreshTokenRollingIntervalTimeUnit() {
        return this.getSupplementalInfo(REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT);
    }

    public void setRefreshTokenRollingIntervalTimeUnit(String refreshTokenRollingIntervalTimeUnit) {
        this.setSupplementalInfo(REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT, refreshTokenRollingIntervalTimeUnit);
    }

    public void setRefreshTokenRollingIntervalType(String refreshTokenRollingIntervalType) {
        this.refreshTokenRollingIntervalType = refreshTokenRollingIntervalType;
    }

    public Integer getRefreshTokenRollingGracePeriod() {
        return this.getSupplementalInfoIntegerValue(REFRESH_TOKEN_ROLLING_GRACE_PERIOD);
    }

    public void setRefreshTokenRollingGracePeriod(Integer refreshTokenRollingGracePeriod) {
        this.setSupplementalInfoIntegerValue(REFRESH_TOKEN_ROLLING_GRACE_PERIOD, refreshTokenRollingGracePeriod);
    }

    public String getRefreshTokenRollingGracePeriodType() {
        String refreshTokenRollingGracePeriodType = this.getSupplementalInfo(REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE);
        if (StringUtils.isBlank((String)refreshTokenRollingGracePeriodType)) {
            return "SERVER_DEFAULT";
        }
        return refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(String refreshTokenRollingGracePeriodType) {
        String value = StringUtils.isNotBlank((String)refreshTokenRollingGracePeriodType) ? refreshTokenRollingGracePeriodType : null;
        this.setSupplementalInfo(REFRESH_TOKEN_ROLLING_GRACE_PERIOD_TYPE, value);
    }

    public String getIntrospectionSigningAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_SIGNED_RESPONSE_ALG);
    }

    public String getIntrospectionSigningAlgorithmOrDefault() {
        String signingAlgorithm = this.getIntrospectionSigningAlgorithm();
        if (signingAlgorithm == null) {
            signingAlgorithm = "RS256";
        }
        return signingAlgorithm;
    }

    public void setIntrospectionSigningAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_SIGNED_RESPONSE_ALG, algorithm);
    }

    public String getIntrospectionEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_ENCRYPTED_RESPONSE_ALG);
    }

    public void setIntrospectionEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_ENCRYPTED_RESPONSE_ALG, algorithm);
    }

    public String getIntrospectionContentEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_ENCRYPTED_RESPONSE_ENC);
    }

    public String getIntrospectionContentEncryptionAlgorithmOrDefault() {
        String contentEncryptionAlgorithm = this.getIntrospectionContentEncryptionAlgorithm();
        if (contentEncryptionAlgorithm == null) {
            contentEncryptionAlgorithm = "A128CBC-HS256";
        }
        return contentEncryptionAlgorithm;
    }

    public void setIntrospectionContentEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.INTROSPECTION_ENCRYPTED_RESPONSE_ENC, algorithm);
    }

    private Integer getSupplementalInfoIntegerValue(String name) {
        String value = this.getSupplementalInfo(name);
        if (StringUtils.isNotBlank((String)value) && ValidationUtil.isValidInt(value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    private void setSupplementalInfoIntegerValue(String name, Integer value) {
        String result = null;
        if (value != null) {
            result = String.valueOf(value);
        }
        this.setSupplementalInfo(name, result);
    }

    public boolean isPrimarySecret(String secret) {
        if (this.clientSecret == null && StringUtils.isEmpty((String)secret)) {
            return true;
        }
        return this.clientSecret != null && this.clientSecret.checkSecret(secret);
    }

    public boolean isRequireJwtSecuredAuthorizationResponseMode() {
        String requireParString = this.getSupplementalInfo(REQUIRE_JARM);
        return Boolean.parseBoolean(requireParString);
    }

    public void setRequireJwtSecuredAuthorizationResponseMode(boolean requireJarm) {
        if (requireJarm) {
            this.supplementalInfo.put(REQUIRE_JARM, ROLL);
        } else {
            this.supplementalInfo.remove(REQUIRE_JARM);
        }
    }

    public String getAuthorizationResponseSigningAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_SIGNED_RESPONSE_ALG);
    }

    public String getAuthorizationResponseSigningAlgorithmOrDefault() {
        String signingAlgorithm = this.getAuthorizationResponseSigningAlgorithm();
        if (signingAlgorithm == null) {
            signingAlgorithm = "RS256";
        }
        return signingAlgorithm;
    }

    public void setAuthorizationResponseSigningAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_SIGNED_RESPONSE_ALG, algorithm);
    }

    public String getAuthorizationResponseEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG);
    }

    public void setAuthorizationResponseEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG, algorithm);
    }

    public String getAuthorizationResponseContentEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC);
    }

    public String getAuthorizationResponseContentEncryptionAlgorithmOrDefault() {
        String contentEncryptionAlgorithm = this.getAuthorizationResponseContentEncryptionAlgorithm();
        if (contentEncryptionAlgorithm == null) {
            contentEncryptionAlgorithm = "A128CBC-HS256";
        }
        return contentEncryptionAlgorithm;
    }

    public void setAuthorizationResponseContentEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC, algorithm);
    }

    public String getUserInfoResponseSigningAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.USERINFO_SIGNED_RESPONSE_ALG);
    }

    public void setUserInfoResponseSigningAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.USERINFO_SIGNED_RESPONSE_ALG, algorithm);
    }

    public String getUserInfoResponseEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.USERINFO_ENCRYPTED_RESPONSE_ALG);
    }

    public void setUserInfoResponseEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.USERINFO_ENCRYPTED_RESPONSE_ALG, algorithm);
    }

    public String getUserInfoResponseContentEncryptionAlgorithm() {
        return this.getSupplementalInfo(ClientRegistrationParameters.USERINFO_ENCRYPTED_RESPONSE_ENC);
    }

    public String getUserInfoResponseContentEncryptionAlgorithmOrDefault() {
        String contentEncryptionAlgorithm = this.getUserInfoResponseContentEncryptionAlgorithm();
        if (contentEncryptionAlgorithm == null) {
            contentEncryptionAlgorithm = "A128CBC-HS256";
        }
        return contentEncryptionAlgorithm;
    }

    public void setUserInfoResponseContentEncryptionAlgorithm(String algorithm) {
        this.setSupplementalInfo(ClientRegistrationParameters.USERINFO_ENCRYPTED_RESPONSE_ENC, algorithm);
    }

    public boolean isRequireDpop() {
        String requireParString = this.getSupplementalInfo(REQUIRE_DPOP);
        return Boolean.parseBoolean(requireParString);
    }

    public void setRequireDpop(boolean requireDpop) {
        if (requireDpop) {
            this.supplementalInfo.put(REQUIRE_DPOP, ROLL);
        } else {
            this.supplementalInfo.remove(REQUIRE_DPOP);
        }
    }

    public ItemReplicationStatus getReplicationStatus() {
        Date selectiveReplicationTime = this.getSelectiveReplicationTime();
        Date fullReplicationTime = MgmtFactory.getMediator().getConfigPublishDate();
        Date lastModifiedDate = this.getLastModifiedDate();
        boolean replicated = true;
        if (lastModifiedDate != null) {
            replicated = fullReplicationTime != null && fullReplicationTime.after(lastModifiedDate) || selectiveReplicationTime != null && selectiveReplicationTime.after(lastModifiedDate);
        }
        return replicated ? ItemReplicationStatus.REPLICATED : ItemReplicationStatus.NOT_REPLICATED;
    }

    public String getReplicationStatusString() {
        return this.getReplicationStatus().getId();
    }

    public String getRequireOfflineAccessScopeToIssueRefreshTokens() {
        String result = this.getSupplementalInfo(REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS);
        if (StringUtils.isBlank((String)result)) {
            return "SERVER_DEFAULT";
        }
        return result;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(String requireOfflineAccessScopeToIssueRefreshTokens) {
        if (StringUtils.isNotBlank((String)requireOfflineAccessScopeToIssueRefreshTokens)) {
            this.setSupplementalInfo(REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS, requireOfflineAccessScopeToIssueRefreshTokens);
        } else {
            this.removeSupplementalInfo(REQUIRE_OFFLINE_ACCESS_SCOPE_TO_ISSUE_REFRESH_TOKENS);
        }
    }

    public String getOfflineAccessRequireConsentPrompt() {
        String result = this.getSupplementalInfo(OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT);
        if (StringUtils.isBlank((String)result)) {
            return "SERVER_DEFAULT";
        }
        return result;
    }

    public void setOfflineAccessRequireConsentPrompt(String offlineAccessRequireConsentPrompt) {
        if (StringUtils.isNotBlank((String)offlineAccessRequireConsentPrompt)) {
            this.setSupplementalInfo(OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT, offlineAccessRequireConsentPrompt);
        } else {
            this.removeSupplementalInfo(OFFLINE_ACCESS_REQUIRE_CONSENT_PROMPT);
        }
    }

    public String getLockoutMaxMaliciousActionsType() {
        String maxMaliciousActionsType = this.getSupplementalInfo(LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE);
        if (StringUtils.isBlank((String)maxMaliciousActionsType)) {
            return "SERVER_DEFAULT";
        }
        return maxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(String lockoutMaxMaliciousActionsType) {
        if (StringUtils.isNotBlank((String)lockoutMaxMaliciousActionsType)) {
            this.setSupplementalInfo(LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE, lockoutMaxMaliciousActionsType);
        } else {
            this.setSupplementalInfo(LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE, "SERVER_DEFAULT");
        }
    }

    public Integer getLockoutMaxMaliciousActions() {
        return this.getSupplementalInfoIntegerValue(LOCKOUT_MAX_MALICIOUS_ACTIONS);
    }

    public void setLockoutMaxMaliciousActions(Integer maxMaliciousActions) {
        this.setSupplementalInfoIntegerValue(LOCKOUT_MAX_MALICIOUS_ACTIONS, maxMaliciousActions);
    }

    public boolean canIssueIdToken() {
        if (this.getGrantTypes() == null || this.getGrantTypes().isEmpty()) {
            return false;
        }
        return this.getGrantTypes().contains("authorization_code") || this.getGrantTypes().contains("implicit") || this.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:device_code") || this.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:token-exchange") || this.getGrantTypes().contains("urn:openid:params:grant-type:ciba");
    }
}

