/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.google.common.base.Enums;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.pingidentity.common.util.JDBCHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientAuthorizationDetailTypesSanitizer;
import org.sourceid.oauth20.domain.ClientFieldsSanitizer;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientScopeSanitizer;
import org.sourceid.openid.connect.domain.ClientRegistrationParameters;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ClientManagerTranslator;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientManagerJdbcImpl
extends AbstractClientManagerImpl {
    private final ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final Log log = LogFactory.getLog(ClientManagerJdbcImpl.class);
    private static final int OAUTH_EXT_COLUMN_VALUE_SIZE = 1024;
    private final int MAX_ITEMS_REQUESTED_LIMIT = this.configStore.getIntValue("items-requested-limit", 500);
    private static final String ORACLE_FETCH_SIZE = "oracle-fetch-size";
    private volatile Boolean isOracleDatastore = null;
    private final ClientManagerTranslator translator = new ClientManagerTranslator();
    private final int queryClientCount = this.configStore.getIntValue("query-client-count", 2000);
    private static final String TABLENAME_OAUTH_CLIENTS = "pingfederate_oauth_clients";
    private static final String TABLENAME_OAUTH_CLIENTS_EXT = "pingfederate_oauth_clients_ext";
    private static final String FIELDNAME_CLIENT_ID = "CLIENT_ID";
    private static final String FIELDNAME_NAME = "NAME";
    private static final String FIELDNAME_REFRESH_ROLLING = "REFRESH_ROLLING";
    private static final String FIELDNAME_LOGO = "LOGO";
    private static final String FIELDNAME_HASHED_SECRET = "HASHED_SECRET";
    private static final String FIELDNAME_DESCRIPTION = "DESCRIPTION";
    private static final String FIELDNAME_PERSISTENT_GRANT_EXPIRATION_TIME = "PERSISTENT_GRANT_EXP_TIME";
    private static final String FIELDNAME_PERSISTENT_GRANT_EXPIRATION_TIME_UNIT = "PERSISTENT_GRANT_EXP_TIME_UNIT";
    private static final String FIELDNAME_BYPASS_APPROVAL_PAGE = "BYPASS_APPROVAL_PAGE";
    private static final String FIELDNAME_FIELD_NAME = "NAME";
    private static final String FIELDNAME_FIELD_VALUE = "VALUE";
    private static final String selectStmt = "SELECT CLIENT_ID, NAME, REFRESH_ROLLING, LOGO, HASHED_SECRET, DESCRIPTION, PERSISTENT_GRANT_EXP_TIME, PERSISTENT_GRANT_EXP_TIME_UNIT, BYPASS_APPROVAL_PAGE FROM pingfederate_oauth_clients";
    private static final String selectExtStmtByClientId = String.format("SELECT CLIENT_ID, NAME, VALUE FROM pingfederate_oauth_clients_ext WHERE CLIENT_ID = ?  ORDER BY NAME", new Object[0]);
    private static final String selectExtStmt = String.format("SELECT CLIENT_ID, NAME, VALUE FROM pingfederate_oauth_clients_ext ORDER BY CLIENT_ID , NAME", new Object[0]);
    private static final String selectStmtUserId = String.format("SELECT CLIENT_ID, NAME, REFRESH_ROLLING, LOGO, HASHED_SECRET, DESCRIPTION, PERSISTENT_GRANT_EXP_TIME, PERSISTENT_GRANT_EXP_TIME_UNIT, BYPASS_APPROVAL_PAGE FROM pingfederate_oauth_clients".concat(" WHERE %s = ?"), "CLIENT_ID");
    private static final String selectStmtUserIdOnly = "SELECT CLIENT_ID FROM pingfederate_oauth_clients WHERE CLIENT_ID IN (%s)";
    private static final String insertStmt = String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?,?,?,?)", "pingfederate_oauth_clients", "CLIENT_ID", "NAME", "REFRESH_ROLLING", "LOGO", "HASHED_SECRET", "DESCRIPTION", "PERSISTENT_GRANT_EXP_TIME", "PERSISTENT_GRANT_EXP_TIME_UNIT", "BYPASS_APPROVAL_PAGE");
    private static final String updateStmt = String.format("UPDATE pingfederate_oauth_clients SET NAME= ?, REFRESH_ROLLING = ?, LOGO= ?, DESCRIPTION = ?, PERSISTENT_GRANT_EXP_TIME= ?, PERSISTENT_GRANT_EXP_TIME_UNIT= ?, BYPASS_APPROVAL_PAGE= ? WHERE CLIENT_ID = ?", new Object[0]);
    private static final String updateClientSecret = String.format("UPDATE pingfederate_oauth_clients SET HASHED_SECRET = ? WHERE CLIENT_ID = ?", new Object[0]);
    private static final String insertExtStmt = String.format("INSERT INTO %s (%s,%s,%s) VALUES(?,?,?)", "pingfederate_oauth_clients_ext", "CLIENT_ID", "NAME", "VALUE");
    private static final String deleteAllExtStmt = "DELETE FROM pingfederate_oauth_clients_ext WHERE CLIENT_ID = ?";
    private static final String deleteStmt = String.format("DELETE FROM pingfederate_oauth_clients WHERE CLIENT_ID = ?", new Object[0]);
    private static final String searchStmtWithoutFrom = "SELECT pingfederate_oauth_clients.CLIENT_ID, pingfederate_oauth_clients.NAME, REFRESH_ROLLING, LOGO, HASHED_SECRET, DESCRIPTION, PERSISTENT_GRANT_EXP_TIME, PERSISTENT_GRANT_EXP_TIME_UNIT, BYPASS_APPROVAL_PAGE";
    private static final String searchStmt = "SELECT pingfederate_oauth_clients.CLIENT_ID, pingfederate_oauth_clients.NAME, REFRESH_ROLLING, LOGO, HASHED_SECRET, DESCRIPTION, PERSISTENT_GRANT_EXP_TIME, PERSISTENT_GRANT_EXP_TIME_UNIT, BYPASS_APPROVAL_PAGE FROM pingfederate_oauth_clients";
    private static final String searchExtStmt = "SELECT CLIENT_ID, NAME, VALUE FROM pingfederate_oauth_clients_ext";

    @Override
    public void doAddClients(Collection<Client> clients) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            jdbcHelper.setAutoCommit(false);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(insertStmt);
            PreparedStatement insertExt = jdbcHelper.getPreparedStatement(insertExtStmt);
            for (Client client : clients) {
                stmt = this.getAddClientsStmt(stmt, client);
                stmt.addBatch();
                String clientId = client.getClientId();
                for (String grantType : client.getGrantTypes()) {
                    insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.GRANT.toString(), grantType);
                    insertExt.addBatch();
                }
                for (String redirectUri : client.getRedirectUris()) {
                    insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.REDIRECT_URI.toString(), redirectUri);
                    insertExt.addBatch();
                }
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.RESTRICT_SCOPES.toString(), String.valueOf(client.isRestrictScopes()));
                insertExt.addBatch();
                if (client.isRestrictScopes()) {
                    for (String scope : client.getRestrictedScopes()) {
                        insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.RESTRICTED_SCOPES.toString(), scope);
                        insertExt.addBatch();
                    }
                }
                for (String logoutUri : client.getLogoutUris()) {
                    insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.LOGOUT_URI.toString(), logoutUri);
                    insertExt.addBatch();
                }
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.CLIENT_CERT_ISSUER_DN.toString(), client.getClientCertIssuerDn());
                insertExt.addBatch();
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.CLIENT_CERT_SUBJECT_DN.toString(), client.getClientCertSubjectDn());
                insertExt.addBatch();
                String lastModified = String.valueOf(System.currentTimeMillis());
                if (client.getLastModifiedDate() != null) {
                    lastModified = String.valueOf(client.getLastModified().getTimeInMillis());
                }
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.LAST_MODIFIED.toString(), lastModified);
                insertExt.addBatch();
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.CREATION_TIME.toString(), lastModified);
                insertExt.addBatch();
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.REQUIRE_SIGNED_REQUESTS.toString(), String.valueOf(client.isRequireSignedRequests()));
                insertExt.addBatch();
                ClientAuthenticationType authnType = client.getClientAuthnType();
                String authnTypeName = null;
                if (client.getClientAuthnType() != null) {
                    authnTypeName = authnType.name();
                }
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.AUTHN_TYPE.toString(), authnTypeName);
                insertExt.addBatch();
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.JWKS_URL.toString(), client.getJwksUrl());
                insertExt.addBatch();
                insertExt = this.getInsertExtStmt(insertExt, clientId, ExtName.ENFORCE_ONE_TIME_JWT.toString(), String.valueOf(Boolean.TRUE.equals(client.isEnforceReplayPrevention())));
                insertExt.addBatch();
                String jwksText = client.getJwks();
                boolean executeQuery = false;
                this.handleJwksText(insertExt, clientId, jwksText, executeQuery);
                this.translator.copyExtendedParamsToSupplementalInfo(client);
                for (Map.Entry<String, String> entry : client.getSupplementalInfo().entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    this.handleMultiPartData(insertExt, clientId, name, value, executeQuery);
                }
            }
            stmt.executeBatch();
            insertExt.executeBatch();
            jdbcHelper.commit();
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
        catch (Exception e) {
            this.setAuditLogParams();
            try {
                log.error((Object)e.getMessage());
                if (jdbcHelper != null) {
                    jdbcHelper.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    private void handleJwksText(PreparedStatement insertExt, String clientId, String jwksText, boolean executeQuery) throws SQLException {
        this.handleMultiPartData(insertExt, clientId, this.getJwkNamePrefix(), jwksText, executeQuery);
    }

    private void handleMultiPartData(PreparedStatement insertExt, String clientId, String attributeName, String value, boolean executeQuery) throws SQLException {
        if (StringUtils.isNotEmpty((String)value)) {
            int i = 0;
            if (value.length() > 1024) {
                for (int index = 0; index < value.length(); index += 1024) {
                    int partitionEndIndex = index + 1024;
                    if (partitionEndIndex > value.length()) {
                        partitionEndIndex = value.length();
                    }
                    String partition = value.substring(index, partitionEndIndex);
                    String extName = attributeName + "." + String.format("%02d", i);
                    insertExt = this.getInsertExtStmt(insertExt, clientId, extName, partition);
                    if (executeQuery) {
                        insertExt.execute();
                    } else {
                        insertExt.addBatch();
                    }
                    ++i;
                }
            } else {
                insertExt = this.getInsertExtStmt(insertExt, clientId, attributeName, value);
                if (executeQuery) {
                    insertExt.execute();
                } else {
                    insertExt.addBatch();
                }
            }
        }
    }

    @Override
    public void doAddClient(Client client) {
        this.addClients(Collections.singletonList(client));
    }

    private PreparedStatement getAddClientsStmt(PreparedStatement stmt, Client client) throws SQLException {
        stmt.setString(1, client.getClientId());
        stmt.setString(2, client.getName());
        if (client.getRefreshRolling() == null) {
            stmt.setNull(3, 5);
        } else {
            stmt.setInt(3, Boolean.parseBoolean(client.getRefreshRolling()) ? 1 : 0);
        }
        stmt.setString(4, client.getLogoUrl());
        if (client.getEncodedSecret() != null) {
            stmt.setString(5, client.getEncodedSecret());
        } else {
            stmt.setNull(5, 12);
        }
        stmt.setString(6, client.getDescription());
        this.setPersistentGrantExpirationFields(stmt, client, 7, 8);
        stmt.setBoolean(9, client.isBypassApprovalPage());
        return stmt;
    }

    private PreparedStatement getInsertExtStmt(PreparedStatement stmt, String clientId, String extName, String extValue) throws SQLException {
        stmt.setString(1, clientId);
        stmt.setString(2, extName);
        stmt.setString(3, extValue);
        return stmt;
    }

    @Override
    public Client doUpdateClient(Client client) {
        JDBCHelper jdbcHelper = null;
        String clientId = client.getClientId();
        try {
            jdbcHelper = this.getJDBCHelper();
            jdbcHelper.setAutoCommit(false);
            if (this.getClient(clientId) == null) {
                throw new ClientManager.ClientNonexistentException();
            }
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(updateStmt);
            stmt.setString(1, client.getName());
            if (client.getRefreshRolling() == null) {
                stmt.setNull(2, 5);
            } else {
                stmt.setInt(2, Boolean.parseBoolean(client.getRefreshRolling()) ? 1 : 0);
            }
            stmt.setString(3, client.getLogoUrl());
            stmt.setString(4, client.getDescription());
            this.setPersistentGrantExpirationFields(stmt, client, 5, 6);
            stmt.setBoolean(7, client.isBypassApprovalPage());
            stmt.setString(8, clientId);
            stmt.execute();
            if (client.isForceSecretChange() != null && client.isForceSecretChange().booleanValue()) {
                PreparedStatement updateSecretStmt = jdbcHelper.getPreparedStatement(updateClientSecret);
                String encodedSecret = client.getEncodedSecret();
                if (encodedSecret != null) {
                    updateSecretStmt.setString(1, encodedSecret);
                } else {
                    updateSecretStmt.setNull(1, 12);
                }
                updateSecretStmt.setString(2, clientId);
                updateSecretStmt.execute();
            }
            PreparedStatement deleteGrantsStmt = jdbcHelper.getPreparedStatement(deleteAllExtStmt);
            deleteGrantsStmt.setString(1, clientId);
            deleteGrantsStmt.execute();
            PreparedStatement grantsStmt = jdbcHelper.getPreparedStatement(insertExtStmt);
            for (String string : client.getGrantTypes()) {
                grantsStmt.setString(1, clientId);
                grantsStmt.setString(2, ExtName.GRANT.toString());
                grantsStmt.setString(3, string);
                grantsStmt.execute();
            }
            PreparedStatement redirectUrisStmt = jdbcHelper.getPreparedStatement(insertExtStmt);
            for (String redirectUri : client.getRedirectUris()) {
                redirectUrisStmt.setString(1, clientId);
                redirectUrisStmt.setString(2, ExtName.REDIRECT_URI.toString());
                redirectUrisStmt.setString(3, redirectUri);
                redirectUrisStmt.execute();
            }
            PreparedStatement preparedStatement = jdbcHelper.getPreparedStatement(insertExtStmt);
            preparedStatement.setString(1, clientId);
            preparedStatement.setString(2, ExtName.RESTRICT_SCOPES.toString());
            preparedStatement.setString(3, Boolean.toString(client.isRestrictScopes()));
            preparedStatement.execute();
            if (client.isRestrictScopes()) {
                PreparedStatement restrictedScopesStmt = jdbcHelper.getPreparedStatement(insertExtStmt);
                for (String restrictedScope : client.getRestrictedScopes()) {
                    restrictedScopesStmt.setString(1, clientId);
                    restrictedScopesStmt.setString(2, ExtName.RESTRICTED_SCOPES.toString());
                    restrictedScopesStmt.setString(3, restrictedScope);
                    restrictedScopesStmt.execute();
                }
            }
            PreparedStatement logoutUriStmt = jdbcHelper.getPreparedStatement(insertExtStmt);
            for (String logoutUri : client.getLogoutUris()) {
                logoutUriStmt.setString(1, clientId);
                logoutUriStmt.setString(2, ExtName.LOGOUT_URI.toString());
                logoutUriStmt.setString(3, logoutUri);
                logoutUriStmt.execute();
            }
            PreparedStatement insertClientCertIssuer = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertClientCertIssuer = this.getInsertExtStmt(insertClientCertIssuer, clientId, ExtName.CLIENT_CERT_ISSUER_DN.toString(), client.getClientCertIssuerDn());
            insertClientCertIssuer.execute();
            PreparedStatement insertClientCertSubjectDnStatement = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertClientCertSubjectDnStatement = this.getInsertExtStmt(insertClientCertSubjectDnStatement, clientId, ExtName.CLIENT_CERT_SUBJECT_DN.toString(), client.getClientCertSubjectDn());
            insertClientCertSubjectDnStatement.execute();
            PreparedStatement insertClientUpdateTime = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertClientUpdateTime = this.getInsertExtStmt(insertClientUpdateTime, clientId, ExtName.LAST_MODIFIED.toString(), String.valueOf(System.currentTimeMillis()));
            insertClientUpdateTime.execute();
            PreparedStatement insertRequireRequestObject = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertRequireRequestObject = this.getInsertExtStmt(insertRequireRequestObject, clientId, ExtName.REQUIRE_SIGNED_REQUESTS.toString(), String.valueOf(client.isRequireSignedRequests()));
            insertRequireRequestObject.execute();
            ClientAuthenticationType authnType = client.getClientAuthnType();
            String authnTypeName = null;
            if (authnType != null) {
                authnTypeName = authnType.name();
            }
            PreparedStatement insertExtAuthType = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertExtAuthType = this.getInsertExtStmt(insertExtAuthType, clientId, ExtName.AUTHN_TYPE.toString(), authnTypeName);
            insertExtAuthType.execute();
            PreparedStatement insertExtOneTimeOnly = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertExtOneTimeOnly = this.getInsertExtStmt(insertExtOneTimeOnly, clientId, ExtName.ENFORCE_ONE_TIME_JWT.toString(), String.valueOf(Boolean.TRUE.equals(client.isEnforceReplayPrevention())));
            insertExtOneTimeOnly.execute();
            PreparedStatement insertExtJwksUri = jdbcHelper.getPreparedStatement(insertExtStmt);
            insertExtJwksUri = this.getInsertExtStmt(insertExtJwksUri, clientId, ExtName.JWKS_URL.toString(), client.getJwksUrl());
            insertExtJwksUri.execute();
            PreparedStatement insertExtJwks = jdbcHelper.getPreparedStatement(insertExtStmt);
            this.handleJwksText(insertExtJwks, clientId, client.getJwks(), true);
            this.translator.copyExtendedParamsToSupplementalInfo(client);
            for (Map.Entry<String, String> entry : client.getSupplementalInfo().entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                PreparedStatement insertExtSupplementalInfo = jdbcHelper.getPreparedStatement(insertExtStmt);
                this.handleMultiPartData(insertExtSupplementalInfo, clientId, name, value, true);
            }
            jdbcHelper.commit();
            jdbcHelper.cleanUp();
            Client client2 = this.getClient(clientId);
            return client2;
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
        catch (ClientManager.ClientNonexistentException ne) {
            throw ne;
        }
        catch (Exception e) {
            this.setAuditLogParams();
            try {
                log.error((Object)e.getMessage());
                if (jdbcHelper != null) {
                    jdbcHelper.rollback();
                }
            }
            catch (SQLException e1) {
                throw new ClientManager.ClientManagementException(e1);
            }
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    protected void doDeleteClient(String clientId) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            jdbcHelper.setAutoCommit(false);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(deleteStmt);
            stmt.setString(1, clientId);
            if (stmt.executeUpdate() == 0) {
                throw new ClientManager.ClientNonexistentException();
            }
            stmt.close();
            PreparedStatement deleteGrantsStmt = jdbcHelper.getPreparedStatement(deleteAllExtStmt);
            deleteGrantsStmt.setString(1, clientId);
            deleteGrantsStmt.execute();
            deleteGrantsStmt.close();
            jdbcHelper.commit();
        }
        catch (ClientManager.ClientNonexistentException ne) {
            this.setAuditLogParams();
            try {
                if (jdbcHelper != null) {
                    jdbcHelper.rollback();
                }
            }
            catch (SQLException e1) {
                throw ne;
            }
            throw ne;
        }
        catch (Exception e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            try {
                if (jdbcHelper != null) {
                    jdbcHelper.rollback();
                }
            }
            catch (SQLException e1) {
                throw new ClientManager.ClientManagementException(e);
            }
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public Collection<Client> doGetClients() {
        HashMap<String, Client> clientsMap = new HashMap<String, Client>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            if (this.isOracleDatastore == null) {
                this.isOracleDatastore = jdbcHelper.isOracle();
            }
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmt);
            if (this.isOracleDatastore.booleanValue()) {
                stmt.setFetchSize(this.configStore.getIntValue(ORACLE_FETCH_SIZE, 1000));
            }
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                Client tempClient = this.clientFromResultSet(resultSet);
                clientsMap.put(tempClient.getClientId(), tempClient);
            }
            resultSet.close();
            PreparedStatement extStmt = jdbcHelper.getPreparedStatement(selectExtStmt);
            if (this.isOracleDatastore.booleanValue()) {
                extStmt.setFetchSize(this.configStore.getIntValue(ORACLE_FETCH_SIZE, 1000));
            }
            ResultSet extResultSet = jdbcHelper.getResultSet();
            HashMap<String, StringBuilder> jwks = new HashMap<String, StringBuilder>();
            HashMap<String, MultipartSupplementalInfoFields> multiPartFields = new HashMap<String, MultipartSupplementalInfoFields>();
            this.processExtResultSet(extResultSet, clientsMap, jwks, multiPartFields);
            this.setSupplementalInfoForClients(multiPartFields, clientsMap);
            this.setJsonWebKeyset(jwks, clientsMap);
            extResultSet.close();
            extStmt.close();
        }
        catch (Exception e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        ArrayList<Client> clientsList = new ArrayList<Client>(clientsMap.values());
        return clientsList;
    }

    @Override
    public int getDatastoreSearchClientCount() {
        return this.queryClientCount;
    }

    @Override
    public Client doGetClient(String clientId) {
        JDBCHelper jdbcHelper = null;
        Client client = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtUserId);
            stmt.setString(1, clientId);
            ResultSet clientResultSet = jdbcHelper.getResultSet();
            boolean multipleMatchesFound = false;
            while (clientResultSet.next()) {
                Client resultSetClient = this.clientFromResultSet(clientResultSet);
                if (!StringUtils.equals((String)resultSetClient.getClientId(), (String)clientId)) continue;
                multipleMatchesFound = client != null;
                client = resultSetClient;
            }
            if (multipleMatchesFound && log.isErrorEnabled()) {
                log.error((Object)("Multiple matches for OAuth client with ID \"" + clientId + "\" in data store. Please remove duplicates."));
            }
            if (client != null) {
                PreparedStatement extStmt = jdbcHelper.getPreparedStatement(selectExtStmtByClientId);
                extStmt.setString(1, clientId);
                ResultSet extResultSet = jdbcHelper.getResultSet();
                HashMap<String, StringBuilder> jwks = new HashMap<String, StringBuilder>();
                HashMap<String, MultipartSupplementalInfoFields> multiPartFields = new HashMap<String, MultipartSupplementalInfoFields>();
                while (extResultSet.next()) {
                    this.clientExtFromResultSet(extResultSet, client, jwks, multiPartFields);
                }
                if (multiPartFields.containsKey(client.getClientId())) {
                    this.buildSupplementalInfoFromMultiPartData(client, (MultipartSupplementalInfoFields)multiPartFields.get(client.getClientId()));
                }
                this.translator.copyExtendedParamsFromSupplementalInfo(client);
                this.doSanitize(client, new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
                if (jwks.containsKey(client.getClientId())) {
                    this.setJsonWebKeyset((StringBuilder)jwks.get(client.getClientId()), client);
                }
                extStmt.close();
                extResultSet.close();
            }
            clientResultSet.close();
            stmt.close();
        }
        catch (SQLException | NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return this.doSanitize(client, new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
    }

    private Client clientFromResultSet(ResultSet resultSet) throws SQLException {
        long expTime = resultSet.getLong(FIELDNAME_PERSISTENT_GRANT_EXPIRATION_TIME);
        String expType = this.translator.getPersistentGrantExpirationTimeType(expTime);
        String expTimeUnit = "d";
        if ("OVERRIDE_SERVER_DEFAULT".equals(expType)) {
            expTimeUnit = resultSet.getString(FIELDNAME_PERSISTENT_GRANT_EXPIRATION_TIME_UNIT);
        }
        Client client = new Client(resultSet.getString(FIELDNAME_CLIENT_ID), resultSet.getString("NAME"), resultSet.getString(FIELDNAME_REFRESH_ROLLING), resultSet.getString(FIELDNAME_LOGO), resultSet.getString(FIELDNAME_HASHED_SECRET), resultSet.getString(FIELDNAME_DESCRIPTION), expType, expTime, expTimeUnit, resultSet.getBoolean(FIELDNAME_BYPASS_APPROVAL_PAGE), null);
        return client;
    }

    private void clientExtFromResultSet(ResultSet resultSet, Client client, Map<String, StringBuilder> clientJwks, Map<String, MultipartSupplementalInfoFields> multiPartFields) throws SQLException {
        String name = resultSet.getString("NAME");
        String extValue = resultSet.getString(FIELDNAME_FIELD_VALUE);
        String clientId = client.getClientId();
        if (this.isJwkEntry(name.toUpperCase())) {
            if (clientJwks != null) {
                if (clientJwks.containsKey(clientId)) {
                    StringBuilder jwks = clientJwks.get(clientId);
                    clientJwks.put(clientId, jwks.append(extValue));
                } else {
                    StringBuilder jwks = new StringBuilder(extValue);
                    clientJwks.put(clientId, jwks);
                }
            }
        } else {
            try {
                ExtName extName = ExtName.valueOf(name.toUpperCase());
                switch (extName) {
                    case GRANT: {
                        Set<String> grants = client.getGrantTypes();
                        grants.add(extValue);
                        client.setGrantTypes(grants);
                        break;
                    }
                    case REDIRECT_URI: {
                        List<String> redirectUris = client.getRedirectUris();
                        redirectUris.add(extValue);
                        client.setRedirectUris(redirectUris);
                        break;
                    }
                    case RESTRICT_SCOPES: {
                        client.setRestrictScopes(Boolean.valueOf(extValue));
                        break;
                    }
                    case RESTRICTED_SCOPES: {
                        List<String> restrictedScopes = client.getRestrictedScopes();
                        restrictedScopes.add(extValue);
                        client.setRestrictedScopes(restrictedScopes);
                        break;
                    }
                    case LOGOUT_URI: {
                        List<String> logoutUris = client.getLogoutUris();
                        logoutUris.add(extValue);
                        client.setLogoutUris(logoutUris);
                        break;
                    }
                    case CLIENT_CERT_ISSUER_DN: {
                        client.setClientCertIssuerDn(extValue);
                        break;
                    }
                    case CLIENT_CERT_SUBJECT_DN: {
                        client.setClientCertSubjectDn(extValue);
                        break;
                    }
                    case LAST_MODIFIED: {
                        client.setLastModified(this.translateTimestamp(extValue));
                        break;
                    }
                    case CREATION_TIME: {
                        client.setCreationTime(this.translateTimestamp(extValue));
                        break;
                    }
                    case REQUIRE_SIGNED_REQUESTS: {
                        client.setRequireSignedRequests(Boolean.valueOf(extValue));
                        break;
                    }
                    case JWKS_URL: {
                        client.setJwksUrl(extValue);
                        break;
                    }
                    case JWKS: {
                        break;
                    }
                    case AUTHN_TYPE: {
                        if (!StringUtils.isNotEmpty((String)extValue)) break;
                        client.setClientAuthnType(ClientAuthenticationType.valueOf((String)extValue));
                        break;
                    }
                    case ENFORCE_ONE_TIME_JWT: {
                        client.setEnforceReplayPrevention(Boolean.valueOf(extValue));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                String[] parts = name.split("\\.");
                if (parts.length > 1) {
                    if (multiPartFields != null) {
                        String supplementalInfoName = parts[0];
                        try {
                            int index = Integer.parseInt(parts[1]);
                            if (multiPartFields.get(clientId) == null) {
                                multiPartFields.put(clientId, new MultipartSupplementalInfoFields());
                            }
                            multiPartFields.get(clientId).addPart(supplementalInfoName, extValue, index);
                        }
                        catch (NumberFormatException nfe) {
                            client.setSupplementalInfo(name, extValue);
                        }
                    }
                }
                client.setSupplementalInfo(name, extValue);
            }
        }
    }

    private boolean isJwkEntry(String extNameField) {
        return StringUtils.isNotBlank((String)extNameField) && extNameField.startsWith(this.getJwkNamePrefix()) && !ExtName.JWKS_URL.toString().equals(extNameField);
    }

    private String getJwkNamePrefix() {
        return ExtName.JWKS.toString();
    }

    private void setPersistentGrantExpirationFields(PreparedStatement stmt, Client client, int expTimeIndex, int expTypeIndex) throws SQLException {
        stmt.setLong(expTimeIndex, this.translator.getPersistentGrantExpirationTimeValueToStore(client));
        stmt.setString(expTypeIndex, client.getPersistentGrantExpirationTimeUnit());
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.getJndiName());
    }

    @Override
    public boolean isBackendDatabase() {
        return true;
    }

    protected JDBCHelper getJDBCHelper() throws NamingException, SQLException {
        return new JDBCHelper(this.getJndiName(), this);
    }

    private void setAuditLogParams() {
        AsAuditLogger.setDescription("Database Exception");
        AuditLogger.setStatus("failure");
    }

    @Override
    public Collection<String> getValidClients(List<String> clientIds) {
        if (clientIds == null || clientIds.isEmpty()) {
            return Collections.emptySet();
        }
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            if (this.isOracleDatastore == null) {
                this.isOracleDatastore = jdbcHelper.isOracle();
            }
            HashSet<String> result = new HashSet<String>();
            for (int partition = 0; partition <= (clientIds.size() - 1) / this.MAX_ITEMS_REQUESTED_LIMIT; ++partition) {
                boolean isLastPartition = partition == (clientIds.size() - 1) / this.MAX_ITEMS_REQUESTED_LIMIT;
                LinkedList<String> clients = new LinkedList<String>();
                for (int i = 0; i < (isLastPartition ? clientIds.size() - partition * this.MAX_ITEMS_REQUESTED_LIMIT : this.MAX_ITEMS_REQUESTED_LIMIT); ++i) {
                    clients.add("?");
                }
                String selectStmt = String.format(selectStmtUserIdOnly, StringUtils.join(clients, (String)" , "));
                PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmt);
                if (this.isOracleDatastore.booleanValue()) {
                    stmt.setFetchSize(this.configStore.getIntValue(ORACLE_FETCH_SIZE, 1000));
                }
                for (int i = 0; i < (isLastPartition ? clientIds.size() - partition * this.MAX_ITEMS_REQUESTED_LIMIT : this.MAX_ITEMS_REQUESTED_LIMIT); ++i) {
                    stmt.setString(i + 1, clientIds.get(partition * this.MAX_ITEMS_REQUESTED_LIMIT + i));
                }
                ResultSet resultSet = jdbcHelper.getResultSet();
                while (resultSet.next()) {
                    result.add(resultSet.getString(FIELDNAME_CLIENT_ID));
                }
                resultSet.close();
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        catch (SQLException | NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public SearchResult<Client> search(SearchCriteria searchCriteria) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            int itemsRequested = searchCriteria.getItemsRequested();
            if (itemsRequested > this.MAX_ITEMS_REQUESTED_LIMIT) {
                ArrayList<Client> searchResult = new ArrayList<Client>();
                for (int pageNumberIndex = 0; pageNumberIndex <= itemsRequested / this.MAX_ITEMS_REQUESTED_LIMIT; ++pageNumberIndex) {
                    SearchCriteria.Builder builder = new SearchCriteria.Builder(searchCriteria);
                    builder.setStartIndex(searchCriteria.getStartIndex() + pageNumberIndex * this.MAX_ITEMS_REQUESTED_LIMIT);
                    builder.setItemsRequested(this.MAX_ITEMS_REQUESTED_LIMIT);
                    SearchResult<Client> intermediateResult = this.doSearch(jdbcHelper, builder.build());
                    if (intermediateResult.getResultCount() <= 0) break;
                    searchResult.addAll(intermediateResult.getResults());
                }
                SearchResult<Client> searchResult2 = new SearchResult<Client>(0, searchResult);
                return searchResult2;
            }
            SearchResult<Client> searchResult = this.doSearch(jdbcHelper, searchCriteria);
            return searchResult;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                log.error((Object)e.getMessage());
            }
            log.debug((Object)"Failed to determine the datastore type", (Throwable)e);
            throw new ClientManager.ClientManagementException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public Client getCachedClient(String clientId) {
        try {
            return clientId != null ? (Client)((Optional)this.engineClientsCache.get((Object)clientId)).orElse(null) : null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new ClientManager.ClientManagementException(e.getCause());
        }
    }

    private SearchResult<Client> doSearch(JDBCHelper jdbcHelper, SearchCriteria searchCriteria) throws SQLException {
        if (jdbcHelper.isMySql() || jdbcHelper.isHypersonicHql()) {
            return this.searchMySQL(searchCriteria, jdbcHelper);
        }
        if (jdbcHelper.isOracle()) {
            return this.searchOracle(searchCriteria, jdbcHelper);
        }
        if (jdbcHelper.isSqlServer()) {
            return this.searchMsSQLServer(searchCriteria, jdbcHelper);
        }
        if (jdbcHelper.isPostgres()) {
            return this.searchPostgres(searchCriteria, jdbcHelper);
        }
        return new SearchResult<Client>(0, Collections.emptyList());
    }

    private SearchResult<Client> searchPostgres(SearchCriteria searchCriteria, JDBCHelper jdbcHelper) {
        return this.searchMySQL(searchCriteria, jdbcHelper);
    }

    private String generateGrantTypeFilterSubQuery(List<SearchCriteria.FilterItem> searchFilterList) {
        TreeSet<String> grantTypes = this.getTargetGrantTypeSet(searchFilterList);
        if (!grantTypes.isEmpty()) {
            String subQueryFormat = " EXISTS (SELECT pingfederate_oauth_clients_ext.CLIENT_ID FROM pingfederate_oauth_clients_ext WHERE NAME = 'GRANT' AND (%s) AND pingfederate_oauth_clients_ext.CLIENT_ID = pingfederate_oauth_clients.CLIENT_ID)";
            Object[] grantTypeConditions = new String[grantTypes.size()];
            Arrays.fill(grantTypeConditions, "VALUE = ?");
            return String.format(subQueryFormat, String.join((CharSequence)" OR ", (CharSequence[])grantTypeConditions));
        }
        return "";
    }

    private String generateExtTableFilterSubQuery(List<SearchCriteria.FilterItem> searchFilterList) {
        ArrayList conditionQueryStringList = new ArrayList();
        searchFilterList.forEach(searchFilter -> {
            String jdbcFieldName = this.getJdbcExtFieldNameForFilter(searchFilter.getFieldName());
            if (StringUtils.isNotBlank((String)jdbcFieldName)) {
                String subQueryFormat = " EXISTS (SELECT pingfederate_oauth_clients_ext.CLIENT_ID FROM pingfederate_oauth_clients_ext WHERE NAME = '" + jdbcFieldName + "' AND (%s) AND pingfederate_oauth_clients_ext.CLIENT_ID = pingfederate_oauth_clients.CLIENT_ID)";
                String value = searchFilter.getValue() == null ? "VALUE IS NULL" : "VALUE = ?";
                conditionQueryStringList.add(String.format(subQueryFormat, value));
            }
        });
        return StringUtils.join(conditionQueryStringList, (String)" AND ");
    }

    private String generateCreationOrModificationFilter(String orderBy) {
        String orderByColumnName = this.mapDbColumnName(orderBy);
        return String.format("pingfederate_oauth_clients_ext.NAME = '%s'", orderByColumnName);
    }

    private String getJdbcExtFieldNameForFilter(String searchFieldName) {
        String jdbcFieldName = "";
        switch (AbstractClientManagerImpl.FilterableField.valueOf(searchFieldName)) {
            case OIDC_POLICY_ID: {
                return ClientRegistrationParameters.PING_POLICY_GROUP_ID;
            }
            case CIBA_POLICY_ID: {
                return "CIBA_POLICY_ID";
            }
            case TEPP_ID: {
                return "TOKEN_EXCHANGE_PROCESSOR_POLICY_ID";
            }
            case DEFAULT_ATM_ID: {
                return "DEFAULT_ATM_ID";
            }
            case CERT_ISSUER_ID: {
                return ExtName.CLIENT_CERT_ISSUER_DN.toString();
            }
        }
        return jdbcFieldName;
    }

    private String generateQueryCondition() {
        return String.format("(UPPER(%s) LIKE UPPER(?) OR UPPER(%s) LIKE UPPER(?))", "pingfederate_oauth_clients.CLIENT_ID", "pingfederate_oauth_clients.NAME");
    }

    private String generateWhereClause(SearchCriteria searchCriteria) {
        ArrayList<String> conditionQueryStringList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)searchCriteria.getQuery())) {
            conditionQueryStringList.add(this.generateQueryCondition());
        }
        if (searchCriteria.getFilterBy() != null && !searchCriteria.getFilterBy().isEmpty()) {
            String extTableFilter;
            String grantFilter = this.generateGrantTypeFilterSubQuery(searchCriteria.getFilterBy());
            if (StringUtils.isNotBlank((String)grantFilter)) {
                conditionQueryStringList.add(grantFilter);
            }
            if (StringUtils.isNotBlank((String)(extTableFilter = this.generateExtTableFilterSubQuery(searchCriteria.getFilterBy())))) {
                conditionQueryStringList.add(extTableFilter);
            }
        }
        if (this.isSearchingForCreationOrModificationTime(searchCriteria)) {
            String timeFilter = this.generateCreationOrModificationFilter(searchCriteria.getOrderBy());
            conditionQueryStringList.add(timeFilter);
        }
        if (!conditionQueryStringList.isEmpty()) {
            return String.format(" WHERE %s", StringUtils.join(conditionQueryStringList, (String)" AND "));
        }
        return "";
    }

    private SearchResult<Client> searchMsSQLServer(SearchCriteria searchCriteria, JDBCHelper jdbcHelper) {
        StringBuilder searchQuery = new StringBuilder(this.getMsSQLSearchStmt(this.getSearchStatement(searchCriteria)));
        TreeSet<String> targetGrantTypes = this.getTargetGrantTypeSet(searchCriteria.getFilterBy());
        searchQuery.append(this.generateWhereClause(searchCriteria));
        if (StringUtils.isNotBlank((String)searchCriteria.getOrderBy())) {
            this.appendOrderBy(searchCriteria, searchQuery);
        } else {
            searchQuery.append(" ORDER BY DUMMY");
        }
        searchQuery.append(" OFFSET ? ROWS ").append(" FETCH NEXT ? ROWS ONLY");
        LinkedHashMap<String, Client> clientsMap = new LinkedHashMap<String, Client>();
        PreparedStatement searchClientsStmt = null;
        ResultSet resultSet = null;
        try {
            int index = 1;
            searchClientsStmt = jdbcHelper.getPreparedStatement(searchQuery.toString());
            if (StringUtils.isNotBlank((String)searchCriteria.getQuery())) {
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
            }
            for (String grantType : targetGrantTypes) {
                searchClientsStmt.setString(index++, grantType);
            }
            if (searchCriteria.getFilterBy() != null) {
                for (SearchCriteria.FilterItem filterItem : searchCriteria.getFilterBy()) {
                    if (!StringUtils.isNotBlank((String)this.getJdbcExtFieldNameForFilter(filterItem.getFieldName())) || filterItem.getValue() == null) continue;
                    searchClientsStmt.setString(index++, filterItem.getValue().toString());
                }
            }
            searchClientsStmt.setInt(index++, searchCriteria.getStartIndex());
            searchClientsStmt.setInt(index++, searchCriteria.getItemsRequested());
            resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                Client tempClient = this.clientFromResultSet(resultSet);
                clientsMap.put(tempClient.getClientId(), tempClient);
            }
            this.processClientsExtQuery(jdbcHelper, clientsMap);
            this.close(resultSet, searchClientsStmt);
        }
        catch (Exception e) {
            try {
                this.setAuditLogParams();
                log.error((Object)e.getMessage());
                throw new ClientManager.ClientManagementException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, searchClientsStmt);
                throw throwable;
            }
        }
        ArrayList clientsList = new ArrayList(clientsMap.values());
        return new SearchResult<Client>(0, clientsList);
    }

    private String getMsSQLSearchStmt(String statement) {
        return statement.replaceAll("^SELECT", "SELECT 0 AS DUMMY, ");
    }

    private String getSearchStatement(SearchCriteria searchCriteria) {
        if (this.isSearchingForCreationOrModificationTime(searchCriteria)) {
            String orderByColumnName = this.mapDbColumnName(searchCriteria.getOrderBy());
            return searchStmtWithoutFrom + String.format(", pingfederate_oauth_clients_ext.VALUE as %s FROM pingfederate_oauth_clients LEFT JOIN pingfederate_oauth_clients_ext ON pingfederate_oauth_clients.CLIENT_ID=pingfederate_oauth_clients_ext.CLIENT_ID", orderByColumnName);
        }
        return searchStmt;
    }

    private boolean isSearchingForCreationOrModificationTime(SearchCriteria searchCriteria) {
        return AbstractClientManagerImpl.SORT_BY.CreationTime.name().equals(searchCriteria.getOrderBy()) || AbstractClientManagerImpl.SORT_BY.ModificationTime.name().equals(searchCriteria.getOrderBy());
    }

    private void close(ResultSet resultSet, PreparedStatement preparedStatement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The reported findbug issue is a requirement for this method")
    private void processClientsExtQuery(JDBCHelper jdbcHelper, Map<String, Client> clientsMap) throws SQLException {
        StringBuilder extQuery = new StringBuilder(searchExtStmt);
        if (clientsMap.keySet().size() > 0) {
            StringJoiner commaJoiner = new StringJoiner(", ");
            extQuery.append(" WHERE CLIENT_ID IN (");
            for (int i = 0; i < clientsMap.keySet().size(); ++i) {
                commaJoiner.add("?");
            }
            extQuery.append(commaJoiner.toString());
            extQuery.append(")");
            PreparedStatement extStmt = null;
            ResultSet extResultSet = null;
            try {
                extStmt = jdbcHelper.getPreparedStatement(extQuery.toString());
                if (clientsMap.keySet().size() > 0) {
                    int extIndex = 1;
                    for (String key : clientsMap.keySet()) {
                        extStmt.setString(extIndex++, key);
                    }
                }
                extResultSet = jdbcHelper.getResultSet();
                HashMap<String, StringBuilder> jwks = new HashMap<String, StringBuilder>();
                HashMap<String, MultipartSupplementalInfoFields> multiPartFields = new HashMap<String, MultipartSupplementalInfoFields>();
                this.processExtResultSet(extResultSet, clientsMap, jwks, multiPartFields);
                this.setJsonWebKeyset(jwks, clientsMap);
                this.setSupplementalInfoForClients(multiPartFields, clientsMap);
                this.close(extResultSet, extStmt);
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    this.close(extResultSet, extStmt);
                    throw throwable;
                }
            }
        }
    }

    private void processExtResultSet(ResultSet extResultSet, Map<String, Client> clientsMap, Map<String, StringBuilder> jwks, Map<String, MultipartSupplementalInfoFields> multiPartFields) throws SQLException {
        while (extResultSet.next()) {
            String clientId = extResultSet.getString(FIELDNAME_CLIENT_ID);
            Client client = clientsMap.get(clientId);
            this.clientExtFromResultSet(extResultSet, client, jwks, multiPartFields);
        }
        for (Map.Entry<String, Client> clientEntry : clientsMap.entrySet()) {
            this.translator.copyExtendedParamsFromSupplementalInfo(clientEntry.getValue());
            this.doSanitize(clientEntry.getValue(), new ClientScopeSanitizer(), new ClientFieldsSanitizer(), new ClientAuthorizationDetailTypesSanitizer());
        }
    }

    private SearchResult<Client> searchOracle(SearchCriteria searchCriteria, JDBCHelper jdbcHelper) {
        StringBuilder searchQuery = new StringBuilder(this.getSearchStatement(searchCriteria));
        TreeSet<String> targetGrantTypes = this.getTargetGrantTypeSet(searchCriteria.getFilterBy());
        searchQuery.append(this.generateWhereClause(searchCriteria));
        this.appendOrderBy(searchCriteria, searchQuery);
        StringBuilder outerQuery = new StringBuilder("SELECT * FROM (SELECT ROWNUM RNUM, SUBQ.* FROM (");
        outerQuery.append(searchQuery.toString()).append(") SUBQ ").append(" WHERE ROWNUM <= ?)").append("WHERE RNUM > ?");
        LinkedHashMap<String, Client> clientsMap = new LinkedHashMap<String, Client>();
        PreparedStatement searchClientsStmt = null;
        ResultSet resultSet = null;
        try {
            int index = 1;
            searchClientsStmt = jdbcHelper.getPreparedStatement(outerQuery.toString());
            if (StringUtils.isNotBlank((String)searchCriteria.getQuery())) {
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
            }
            for (String grantType : targetGrantTypes) {
                searchClientsStmt.setString(index++, grantType);
            }
            if (searchCriteria.getFilterBy() != null) {
                for (SearchCriteria.FilterItem filterItem : searchCriteria.getFilterBy()) {
                    if (!StringUtils.isNotBlank((String)this.getJdbcExtFieldNameForFilter(filterItem.getFieldName())) || filterItem.getValue() == null) continue;
                    searchClientsStmt.setString(index++, filterItem.getValue().toString());
                }
            }
            searchClientsStmt.setInt(index++, searchCriteria.getStartIndex() + searchCriteria.getItemsRequested());
            searchClientsStmt.setInt(index++, searchCriteria.getStartIndex());
            resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                Client tempClient = this.clientFromResultSet(resultSet);
                clientsMap.put(tempClient.getClientId(), tempClient);
            }
            this.processClientsExtQuery(jdbcHelper, clientsMap);
            this.close(resultSet, searchClientsStmt);
        }
        catch (Exception e) {
            try {
                this.setAuditLogParams();
                log.error((Object)e.getMessage());
                throw new ClientManager.ClientManagementException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, searchClientsStmt);
                throw throwable;
            }
        }
        ArrayList clientsList = new ArrayList(clientsMap.values());
        return new SearchResult<Client>(0, clientsList);
    }

    private SearchResult<Client> searchMySQL(SearchCriteria searchCriteria, JDBCHelper jdbcHelper) {
        StringBuilder searchQuery = new StringBuilder(this.getSearchStatement(searchCriteria));
        TreeSet<String> targetGrantTypes = this.getTargetGrantTypeSet(searchCriteria.getFilterBy());
        searchQuery.append(this.generateWhereClause(searchCriteria));
        this.appendOrderBy(searchCriteria, searchQuery);
        searchQuery.append(" LIMIT ? OFFSET ?");
        LinkedHashMap<String, Client> clientsMap = new LinkedHashMap<String, Client>();
        PreparedStatement searchClientsStmt = null;
        ResultSet resultSet = null;
        try {
            int index = 1;
            searchClientsStmt = jdbcHelper.getPreparedStatement(searchQuery.toString());
            if (StringUtils.isNotBlank((String)searchCriteria.getQuery())) {
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
                searchClientsStmt.setString(index++, "%" + searchCriteria.getQuery() + "%");
            }
            for (String grantType : targetGrantTypes) {
                searchClientsStmt.setString(index++, grantType);
            }
            if (searchCriteria.getFilterBy() != null) {
                for (SearchCriteria.FilterItem filterItem : searchCriteria.getFilterBy()) {
                    if (!StringUtils.isNotBlank((String)this.getJdbcExtFieldNameForFilter(filterItem.getFieldName())) || filterItem.getValue() == null) continue;
                    searchClientsStmt.setString(index++, filterItem.getValue().toString());
                }
            }
            searchClientsStmt.setInt(index++, searchCriteria.getItemsRequested());
            searchClientsStmt.setInt(index++, searchCriteria.getStartIndex());
            resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                Client tempClient = this.clientFromResultSet(resultSet);
                clientsMap.put(tempClient.getClientId(), tempClient);
            }
            this.processClientsExtQuery(jdbcHelper, clientsMap);
            this.close(resultSet, searchClientsStmt);
        }
        catch (Exception e) {
            try {
                this.setAuditLogParams();
                log.error((Object)e.getMessage());
                throw new ClientManager.ClientManagementException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, searchClientsStmt);
                throw throwable;
            }
        }
        ArrayList clientsList = new ArrayList(clientsMap.values());
        return new SearchResult<Client>(0, clientsList);
    }

    private String mapDbColumnName(String orderBy) {
        AbstractClientManagerImpl.SORT_BY sort_by = (AbstractClientManagerImpl.SORT_BY)((Object)Enums.getIfPresent(AbstractClientManagerImpl.SORT_BY.class, (String)orderBy).orNull());
        if (sort_by != null) {
            switch (sort_by) {
                case Id: {
                    return FIELDNAME_CLIENT_ID;
                }
                case Name: {
                    return "NAME";
                }
                case ModificationTime: {
                    return ExtName.LAST_MODIFIED.name();
                }
                case CreationTime: {
                    return ExtName.CREATION_TIME.name();
                }
            }
        }
        throw new IllegalArgumentException("field name does not match db column name");
    }

    private void appendOrderBy(SearchCriteria searchCriteria, StringBuilder searchQuery) {
        if (StringUtils.isNotBlank((String)searchCriteria.getOrderBy())) {
            String columnName = this.mapDbColumnName(searchCriteria.getOrderBy());
            if (this.isSearchingForCreationOrModificationTime(searchCriteria)) {
                searchQuery.append(" ORDER BY ").append(columnName).append(" ").append((Object)searchCriteria.getOrder());
            } else {
                searchQuery.append(" ORDER BY ").append(" UPPER(").append(columnName).append(") ").append((Object)searchCriteria.getOrder());
            }
        }
    }

    private void setJsonWebKeyset(Map<String, StringBuilder> jwks, Map<String, Client> clients) {
        if (jwks != null) {
            jwks.forEach((k, v) -> {
                if (clients.containsKey(k)) {
                    StringBuilder clientJwks = (StringBuilder)jwks.get(k);
                    Client client = (Client)clients.get(k);
                    this.setJsonWebKeyset(clientJwks, client);
                }
            });
        }
    }

    private void setJsonWebKeyset(StringBuilder clientJwks, Client client) {
        try {
            if (clientJwks != null) {
                JsonWebKeySet jsonKeySet = new JsonWebKeySet(clientJwks.toString());
                client.setJwks(jsonKeySet.toJson());
                client.setJsonWebKeys(jsonKeySet.getJsonWebKeys());
            }
        }
        catch (JoseException e) {
            log.debug((Object)e.getStackTrace());
            log.error((Object)e.getMessage());
        }
    }

    public String getJndiName() {
        return this.configStore.getStringValue("PingFederateDSJNDIName", "PFDefaultDS");
    }

    private void setSupplementalInfoForClients(Map<String, MultipartSupplementalInfoFields> multipartSupplementalInfoFieldsMap, Map<String, Client> clients) {
        multipartSupplementalInfoFieldsMap.forEach((clientId, multipartSupplementalInfoFields) -> {
            if (clients.containsKey(clientId)) {
                Client client = (Client)clients.get(clientId);
                this.buildSupplementalInfoFromMultiPartData(client, (MultipartSupplementalInfoFields)multipartSupplementalInfoFields);
                this.translator.copyExtendedParamsFromSupplementalInfo(client);
            }
        });
    }

    private void buildSupplementalInfoFromMultiPartData(Client client, MultipartSupplementalInfoFields multiParts) {
        List<String> supplementalInfoNames = multiParts.getSupplementalInfoNames();
        for (String supplementalInfoName : supplementalInfoNames) {
            String value = multiParts.buildValue(supplementalInfoName);
            if (this.isJwkEntry(supplementalInfoName)) {
                try {
                    JsonWebKeySet jsonKeySet = new JsonWebKeySet(value);
                    client.setJwks(jsonKeySet.toJson());
                    client.setJsonWebKeys(jsonKeySet.getJsonWebKeys());
                }
                catch (JoseException e) {
                    log.debug((Object)e);
                    log.error((Object)e.getMessage());
                }
                continue;
            }
            client.setSupplementalInfo(supplementalInfoName, value);
        }
    }

    static {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        dsMgr.getJdbcDataSources();
    }

    private static class MultipartSupplementalInfoFields {
        Map<String, TreeMap<Integer, String>> data = new TreeMap<String, TreeMap<Integer, String>>();

        public void addPart(String supplementalInfoName, String value, int index) {
            if (this.data.containsKey(supplementalInfoName)) {
                this.data.get(supplementalInfoName).put(index, value);
            } else {
                TreeMap<Integer, String> contents = new TreeMap<Integer, String>();
                contents.put(index, value);
                this.data.put(supplementalInfoName, contents);
            }
        }

        public String buildValue(String supplementalInfoName) {
            TreeMap<Integer, String> partsMap = this.data.get(supplementalInfoName);
            StringBuilder value = new StringBuilder();
            if (partsMap != null) {
                for (Map.Entry<Integer, String> entry : partsMap.entrySet()) {
                    value.append(entry.getValue());
                }
            }
            return value.toString();
        }

        public List<String> getSupplementalInfoNames() {
            return new ArrayList<String>(this.data.keySet());
        }
    }

    private static enum ExtName {
        GRANT,
        REDIRECT_URI,
        RESTRICT_SCOPES,
        RESTRICTED_SCOPES,
        CLIENT_CERT_SUBJECT_DN,
        CLIENT_CERT_ISSUER_DN,
        LOGOUT_URI,
        LAST_MODIFIED,
        CREATION_TIME,
        REQUIRE_SIGNED_REQUESTS,
        JWKS_URL,
        JWKS,
        AUTHN_TYPE,
        ENFORCE_ONE_TIME_JWT;

    }
}

