/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPCrudHelper;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pingcommons.util.DNUtil;
import com.sun.jndi.ldap.LdapName;
import java.util.Collection;
import java.util.Collections;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientManagerBaseLdapImpl;

public abstract class ClientManagerLdapODSBase
extends ClientManagerBaseLdapImpl {
    private static final Log log = LogFactory.getLog(ClientManagerLdapODSBase.class);

    ClientManagerLdapODSBase() {
    }

    @Override
    int getSupplementalInfoAttributeSize() {
        return 2048;
    }

    @Override
    public void doAddClient(Client client) {
        this.addClients(Collections.singletonList(client));
    }

    @Override
    public void doAddClients(Collection<Client> clients) {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            for (Client client : clients) {
                StringBuilder s = new StringBuilder();
                s.append(this.getAttributeClientId()).append("=").append(DNUtil.escapeDN((String)client.getClientId()));
                if (StringUtils.isNotBlank((String)this.getSearchBase())) {
                    s.append(",").append(this.getSearchBase());
                }
                LdapName ldapName = new LdapName(s.toString());
                Attributes attributes = this.getAttributes(client);
                ldapCrudHelper.createEntry(ldapName, attributes);
            }
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    @Override
    protected void doDeleteClient(String clientId) {
        try {
            StringBuilder s = new StringBuilder();
            s.append(this.getAttributeClientId()).append("=").append(DNUtil.escapeDN((String)clientId));
            if (StringUtils.isNotBlank((String)this.getSearchBase())) {
                s.append(",").append(this.getSearchBase());
            }
            LdapName ldapName = new LdapName(s.toString());
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            ldapCrudHelper.deleteEntry(ldapName);
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }

    @Override
    public Client doUpdateClient(Client client) {
        try {
            StringBuilder s = new StringBuilder();
            s.append(this.getAttributeClientId()).append("=").append(DNUtil.escapeDN((String)client.getClientId()));
            if (StringUtils.isNotBlank((String)this.getSearchBase())) {
                s.append(",").append(this.getSearchBase());
            }
            LdapName ldapName = new LdapName(s.toString());
            Attributes attributes = this.getAttributes(client);
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
            return client;
        }
        catch (NamingException e) {
            this.setAuditLogParams();
            log.error((Object)e.getMessage());
            throw new ClientManager.ClientManagementException(e);
        }
    }
}

