/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.oauth20.domain.ScopeUtil;

public class ClientScopeSanitizer
implements Sanitizer<Client> {
    private Set<String> availableScopesAndGroups;
    private Set<String> availableExclusiveScopesAndGroups;

    ClientScopeSanitizer() {
        this.availableScopesAndGroups = ScopeUtil.getScopeAndGroupNames();
        this.availableExclusiveScopesAndGroups = ScopeUtil.getExclusiveScopeAndGroupNames();
    }

    ClientScopeSanitizer(Set<String> availableScopesAndGroups, Set<String> availableExclusiveScopesAndGroups) {
        this.availableScopesAndGroups = availableScopesAndGroups;
        this.availableExclusiveScopesAndGroups = availableExclusiveScopesAndGroups;
    }

    @Override
    public Client sanitize(Client client) {
        if (client == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(client.getRestrictedScopes())) {
            client.setRestrictedScopes(client.getRestrictedScopes().stream().filter(this.availableScopesAndGroups::contains).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(client.getExclusiveScopes())) {
            client.setExclusiveScopes(client.getExclusiveScopes().stream().filter(this.availableExclusiveScopesAndGroups::contains).collect(Collectors.toList()));
        }
        return client;
    }
}

