/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.time.Duration;
import java.time.Instant;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientSecretRetentionHelper {
    public static Instant getExpiryTimeForSecondarySecret(Client client) {
        int retentionPeriodInMinutes = 0;
        if ("SERVER_DEFAULT".equals(client.getSecondarySecretRetentionPeriodType())) {
            AuthzServerManager manager = MgmtFactory.getAuthzServerManager();
            retentionPeriodInMinutes = manager.getClientSecretRetentionPeriod();
        } else {
            retentionPeriodInMinutes = Integer.parseInt(client.getSecondarySecretRetentionPeriod());
        }
        Instant currentTime = Instant.now();
        Instant expiryTime = currentTime.plus(Duration.ofMinutes(retentionPeriodInMinutes));
        return expiryTime;
    }

    public static int getSecondarySecretRetentionPeriod(Client client) {
        if ("SERVER_DEFAULT".equals(client.getSecondarySecretRetentionPeriodType())) {
            AuthzServerManager manager = MgmtFactory.getAuthzServerManager();
            return manager.getClientSecretRetentionPeriod();
        }
        String retentionPeriodString = client.getSecondarySecretRetentionPeriod();
        int retentionPeriodInMinutes = retentionPeriodString == null ? 0 : Integer.parseInt(retentionPeriodString);
        return retentionPeriodInMinutes;
    }

    public static boolean isRetainClientSecret(Client client) {
        int retentionPeriodInMinutes = 0;
        if ("SERVER_DEFAULT".equals(client.getSecondarySecretRetentionPeriodType())) {
            AuthzServerManager manager = MgmtFactory.getAuthzServerManager();
            retentionPeriodInMinutes = manager.getClientSecretRetentionPeriod();
        } else {
            retentionPeriodInMinutes = Integer.parseInt(client.getSecondarySecretRetentionPeriod());
        }
        return retentionPeriodInMinutes > 0;
    }

    public static int getMaxRetainedClientSecondarySecrets() {
        AuthzServerManager manager = MgmtFactory.getAuthzServerManager();
        return manager.getMaxRetainedClientSecondarySecrets();
    }
}

