/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.Sanitizer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientSettingsAuthorizationDetailTypesSanitizer
implements Sanitizer<ClientSetting> {
    private final Set<String> availableAuthorizationDetailTypes = MgmtFactory.getAuthorizationDetailTypesManager().getTypes();

    @Override
    public ClientSetting sanitize(ClientSetting clientSetting) {
        if (clientSetting == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(clientSetting.getAllowedAuthorizationDetailTypes())) {
            clientSetting.setAllowedAuthorizationDetailTypes(clientSetting.getAllowedAuthorizationDetailTypes().stream().filter(this.availableAuthorizationDetailTypes::contains).collect(Collectors.toSet()));
        }
        return clientSetting;
    }
}

