/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.DynamicOAuthClient;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientUtil {
    public static final List<String> RESPONSE_TYPES = Collections.unmodifiableList(Arrays.asList("code", "code id_token", "code id_token token", "code token", "id_token", "id_token token", "token"));

    public static void setScopes(List<String> scopes, Client client) {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        ArrayList<String> originalRequestedScopes = new ArrayList<String>(scopes);
        if (scopes.size() > 0) {
            if (clientSetting.getAllowedExclusiveScopes() != null && clientSetting.getAllowedExclusiveScopes().size() > 0) {
                Scope allowedExclusiveScopes = new Scope(clientSetting.getAllowedExclusiveScopes());
                HashSet<String> allowedExclusiveScopesSet = new HashSet<String>(clientSetting.getAllowedExclusiveScopes());
                allowedExclusiveScopesSet.addAll(allowedExclusiveScopes.expanded().getScopeSet());
                List<String> requestedExclusiveScopes = scopes.stream().filter(allowedExclusiveScopesSet::contains).collect(Collectors.toList());
                if (requestedExclusiveScopes.size() > 0) {
                    client.setAllowedExcludedScopes(true);
                    client.setExclusiveScopes(requestedExclusiveScopes);
                    scopes.removeAll(requestedExclusiveScopes);
                    if (scopes.size() == 0) {
                        client.setRestrictScopes(true);
                    }
                }
            }
            if (scopes.size() > 0) {
                client.setRestrictScopes(true);
                if (clientSetting.isRestrictCommonScopes()) {
                    scopes.removeIf(scope -> !clientSetting.getRestrictedCommonScopes().contains(scope));
                } else {
                    scopes.removeIf(scope -> !ScopeUtil.getScopeAndGroupNames().contains(scope));
                }
                if (scopes.size() > 0) {
                    client.setRestrictedScopes(scopes);
                }
            }
            if (client.getExclusiveScopes().size() == 0 && client.getRestrictedScopes().size() == 0) {
                client.setRestrictScopes(true);
                client.setRestrictedScopes(originalRequestedScopes);
            }
        } else if (clientSetting.isRestrictCommonScopes()) {
            client.setRestrictScopes(true);
            client.setRestrictedScopes(new ArrayList<String>(clientSetting.getRestrictedCommonScopes()));
        }
    }

    public static Set<String> getResponseTypes(String responseTypeStr) {
        ResponseType responseType = new ResponseType(responseTypeStr, null);
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(responseType.getParts())));
    }

    public static void setDefaultClientRegistrationGrantTypesAndResponseTypes(Client client) {
        if (client.getGrantTypes().size() == 0) {
            client.setGrantTypes(new HashSet<String>(Arrays.asList("authorization_code")));
        }
        if (client.getRestrictedResponseTypes().size() == 0 && client.getGrantTypes().size() == 1 && client.getGrantTypes().contains("authorization_code")) {
            client.setRestrictResponseTypes(true);
            client.setRestrictedResponseTypes(Arrays.asList("code"));
        }
    }

    public static void setClientAuthnSource(DynamicOAuthClient client) {
        if (ClientUtil.isGenerateSecret(client)) {
            client.setForceSecretChange(true);
            client.generateSecret(22);
        }
        if (ClientAuthenticationType.CLIENT_CERT != client.getClientAuthnType()) {
            client.setClientCertSubjectDn(null);
            client.setClientCertIssuerDn(null);
        }
        if (ClientAuthenticationType.PRIVATE_KEY_JWT != client.getClientAuthnType() && ClientAuthenticationType.CLIENT_SECRET_JWT != client.getClientAuthnType()) {
            client.setTokenEndpointAuthSigningAlgorithm(null);
        }
    }

    public static boolean isGenerateSecret(DynamicOAuthClient client) {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        return !(!clientSetting.isRotateClientSecret() && !StringUtils.isBlank((String)client.getEncodedSecret()) || client.getClientAuthnType() != ClientAuthenticationType.SECRET && !client.needReversibleSecret());
    }

    public static void setIdTokenSigningAlgo(DynamicOAuthClient client) {
        OpenIdConnectProviderPolicyManager policyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (policyManager.getPolicy().isEnabled()) {
            if (StringUtils.isBlank((String)client.getIdTokenSigningAlgorithm()) && StringUtils.isNotBlank((String)clientSetting.getIdTokenSigningAlgorithm())) {
                client.setIdTokenSigningAlgorithm(clientSetting.getIdTokenSigningAlgorithm());
            }
            client.setPolicyGroupId(clientSetting.getPolicyGroupId());
        }
    }

    public static void setCibaDefaults(DynamicOAuthClient client) {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (client.getGrantTypes().contains("urn:openid:params:grant-type:ciba")) {
            client.setCibaPollingInterval(clientSetting.getCibaPollingInterval());
            client.setCibaPolicyId(clientSetting.getCibaPolicyId());
            client.setCibaRequireSignedRequests(clientSetting.isCibaRequireSignedRequests());
            if (StringUtils.isNotBlank((String)client.getCibaRequestObjectSigningAlgorithm())) {
                client.setCibaRequireSignedRequests(true);
            }
            client.setCibaUserCodeSupported(BooleanUtils.isTrue((Boolean)client.isCibaSupportUserCode()));
        } else {
            client.setCibaPollingInterval(null);
            client.setCibaPolicyId(null);
            client.setCibaRequireSignedRequests(null);
            client.setCibaUserCodeSupported(null);
        }
    }

    public static void setAuthorizationDetailsTypes(List<String> authorizationDetailTypes, Client client) {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (authorizationDetailTypes.size() > 0 && clientSetting.getAllowedAuthorizationDetailTypes() != null && clientSetting.getAllowedAuthorizationDetailTypes().size() > 0) {
            Set activeAuthorizationDetailTypes = MgmtFactory.getAuthorizationDetailTypesManager().getAllAuthorizationDetailTypes().stream().filter(AuthorizationDetailType::isActive).map(AuthorizationDetailType::getType).collect(Collectors.toSet());
            client.setAuthorizationDetailTypes(authorizationDetailTypes.stream().map(StringUtils::trim).filter(clientSetting.getAllowedAuthorizationDetailTypes()::contains).filter(activeAuthorizationDetailTypes::contains).collect(Collectors.toList()));
        }
    }
}

