/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.security.Key;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.protocol.HttpsJwksCache;

public class ClientVerificationKeyResolver
implements VerificationKeyResolver {
    private final Client client;
    private final boolean disambiguateWithVerifySignature;
    private final HttpsJwksCache httpsJwksCache;

    public ClientVerificationKeyResolver(Client client, boolean disambiguateWithVerifySignature) {
        this(client, disambiguateWithVerifySignature, HttpsJwksCache.getInstance());
    }

    public ClientVerificationKeyResolver(Client client, boolean disambiguateWithVerifySignature, HttpsJwksCache httpsJwksCache) {
        this.client = client;
        this.disambiguateWithVerifySignature = disambiguateWithVerifySignature;
        this.httpsJwksCache = httpsJwksCache;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        String jwksUri = this.client.getJwksUrl();
        List<JsonWebKey> jwks = this.client.getJsonWebKeys();
        if (StringUtils.isNotEmpty((String)jwksUri)) {
            HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(jwksUri);
            HttpsJwksVerificationKeyResolver httpsJwksResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
            httpsJwksResolver.setDisambiguateWithVerifySignature(this.disambiguateWithVerifySignature);
            return httpsJwksResolver.resolveKey(jws, nestingContext);
        }
        if (jwks != null) {
            JwksVerificationKeyResolver jwksResolver = new JwksVerificationKeyResolver(jwks);
            jwksResolver.setDisambiguateWithVerifySignature(this.disambiguateWithVerifySignature);
            return jwksResolver.resolveKey(jws, nestingContext);
        }
        throw new UnresolvableKeyException("No verification keys configured (JWKS or JWKS URL) for client " + this.client.getClientId());
    }
}

