/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.StringUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.oauth20.domain.CorsSettings;

public class CorsSettingsUtil {
    private static final Log log = LogFactory.getLog(CorsSettingsUtil.class);
    private ConfigStore corsConfig;
    private static final String urlPatterns = "urlPatterns";
    private List<String> defaultUrlPatterns;
    private static final List<String> DEFAULT_ALLOWED_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private static final List<String> DEFAULT_ALLOWED_HEADERS = Arrays.asList("X-Requested-With", "Content-Type", "Accept", "Origin");
    public static final String ALLOWED_HEADERS_PARAM = "allowedHeaders";
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    private static final String DEFAULT_PREFLIGHT_MAX_AGE = "600";
    public static final String PREFLIGHT_MAX_AGE_PARAM = "preflightMaxAge";
    private CorsSettings corsSettings;

    public CorsSettings getCorsSettings(String configStore, List<String> defaultUrlPatterns, List<String> allowedOrigins) {
        this.corsConfig = ConfigStoreFarm.getConfig(configStore);
        this.defaultUrlPatterns = defaultUrlPatterns;
        this.corsSettings = new CorsSettings();
        this.corsSettings.setUrlPatterns(this.fetchUrlPatterns());
        this.corsSettings.setAllowedOriginsList(allowedOrigins);
        this.corsSettings.setAllowedMethods(this.fetchAllowedMethods());
        this.corsSettings.setAllowedHeaders(this.fetchAllowedHeaders());
        this.corsSettings.setPreflightMaxAge(this.fetchPreflightMaxAge());
        return this.corsSettings;
    }

    private List<String> fetchUrlPatterns() {
        ArrayList<String> urlPatterns = new ArrayList<String>();
        try {
            String urlPatternsConfig = this.corsConfig.getStringValue(urlPatterns);
            if (urlPatternsConfig == null || urlPatternsConfig.isEmpty()) {
                urlPatterns.addAll(this.defaultUrlPatterns);
            } else {
                urlPatterns.addAll(Arrays.asList(StringUtil.csvSplit((String)urlPatternsConfig)));
            }
        }
        catch (NoSuchValueException e) {
            urlPatterns.addAll(this.defaultUrlPatterns);
        }
        return urlPatterns;
    }

    private List<String> fetchAllowedMethods() {
        ArrayList<String> allowedMethods = new ArrayList<String>();
        try {
            String allowedMethodsConfig = this.corsConfig.getStringValue(ALLOWED_METHODS_PARAM);
            if (allowedMethodsConfig == null) {
                allowedMethods.addAll(DEFAULT_ALLOWED_METHODS);
            } else {
                allowedMethods.addAll(Arrays.asList(StringUtil.csvSplit((String)allowedMethodsConfig)));
            }
        }
        catch (NoSuchValueException e) {
            allowedMethods.addAll(DEFAULT_ALLOWED_METHODS);
        }
        return allowedMethods;
    }

    private List<String> fetchAllowedHeaders() {
        ArrayList<String> allowedHeaders = new ArrayList<String>();
        try {
            String allowedHeadersConfig = this.corsConfig.getStringValue(ALLOWED_HEADERS_PARAM);
            if (allowedHeadersConfig == null) {
                allowedHeaders.addAll(DEFAULT_ALLOWED_HEADERS);
            } else {
                allowedHeaders.addAll(Arrays.asList(StringUtil.csvSplit((String)allowedHeadersConfig)));
            }
        }
        catch (NoSuchValueException e) {
            allowedHeaders.addAll(DEFAULT_ALLOWED_HEADERS);
        }
        return allowedHeaders;
    }

    private int fetchPreflightMaxAge() {
        int preflightMaxAge = 0;
        try {
            String preflightMaxAgeConfig = this.corsConfig.getStringValue(PREFLIGHT_MAX_AGE_PARAM);
            if (preflightMaxAgeConfig == null) {
                preflightMaxAgeConfig = DEFAULT_PREFLIGHT_MAX_AGE;
            }
            try {
                preflightMaxAge = Integer.parseInt(preflightMaxAgeConfig);
            }
            catch (NumberFormatException x) {
                log.info((Object)("Cross-origin filter, could not parse 'preflightMaxAge' parameter as integer: " + preflightMaxAgeConfig));
            }
        }
        catch (NoSuchValueException e) {
            preflightMaxAge = Integer.parseInt(DEFAULT_PREFLIGHT_MAX_AGE);
        }
        return preflightMaxAge;
    }
}

