/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class DeviceFlowSettings {
    public static final String CONFIG_STORE_FILE_NAME = "oauth-device-flow";
    public static final int DEFAULT_DEVICE_CODE_LENGTH = 42;
    public static final String DEFAULT_CHARACTER_SET = "0123456789";
    public static final int DEFAULT_CODE_LENGTH = 9;
    public static final int DEFAULT_SEGMENT_LENGTH = 3;
    public static final String DEFAULT_SEGMENT_SEPARATOR = "-";
    public static final boolean DEFAULT_CASE_SENSITIVE_VERIFICATION = false;
    private static final String CFG_KEY_DEVICE_CODE_LENGTH = "device-code-code-length";
    private static final String CFG_KEY_CHARACTER_SET = "user-code-character-set";
    private static final String CFG_KEY_CODE_LENGTH = "user-code-code-length";
    private static final String CFG_KEY_SEGMENT_LENGTH = "user-code-segment-length";
    private static final String CFG_KEY_SEGMENT_SEPARATOR = "user-code-segment-separator";
    private static final String CFG_KEY_CASE_SENSITIVE_VERIFICATION = "user-code-case-sensitive-verification";
    private static final Log LOG = LogFactory.getLog(DeviceFlowSettings.class);
    private char[] characterSet;
    private int codeLength;
    private int segmentLength;
    private char segmentSeparator;
    private boolean caseSensitiveVerification;
    private int deviceCodeLength;

    public static DeviceFlowSettings makeInstance() {
        ConfigStore config = ConfigStoreFarm.getConfig(CONFIG_STORE_FILE_NAME);
        DeviceFlowSettings setting = new DeviceFlowSettings();
        String characterSet = config.getStringValue(CFG_KEY_CHARACTER_SET, DEFAULT_CHARACTER_SET);
        setting.setCharacterSet(characterSet.toCharArray());
        setting.setCodeLength(config.getIntValue(CFG_KEY_CODE_LENGTH, 9));
        setting.setSegmentLength(config.getIntValue(CFG_KEY_SEGMENT_LENGTH, 3));
        String segmentSeparator = config.getStringValue(CFG_KEY_SEGMENT_SEPARATOR, DEFAULT_SEGMENT_SEPARATOR);
        if (segmentSeparator.length() > 1 || characterSet.contains(String.valueOf(segmentSeparator.charAt(0)))) {
            LOG.warn((Object)"user-code-segment-separator value provided by the config file is invalid, using the default value");
            segmentSeparator = DEFAULT_SEGMENT_SEPARATOR;
        }
        setting.setSegmentSeparator(segmentSeparator.charAt(0));
        setting.setCaseSensitiveVerification(config.getBooleanValue(CFG_KEY_CASE_SENSITIVE_VERIFICATION, false));
        setting.setDeviceCodeLength(config.getIntValue(CFG_KEY_DEVICE_CODE_LENGTH, 42));
        return setting;
    }

    public char[] getCharacterSet() {
        return Arrays.copyOf(this.characterSet, this.characterSet.length);
    }

    public void setCharacterSet(char[] characterSet) {
        this.characterSet = Arrays.copyOf(characterSet, characterSet.length);
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(int segmentLength) {
        this.segmentLength = segmentLength;
    }

    public char getSegmentSeparator() {
        return this.segmentSeparator;
    }

    public void setSegmentSeparator(char segmentSeparator) {
        this.segmentSeparator = segmentSeparator;
    }

    public boolean isCaseSensitiveVerification() {
        return this.caseSensitiveVerification;
    }

    public void setCaseSensitiveVerification(boolean caseSensitiveVerification) {
        this.caseSensitiveVerification = caseSensitiveVerification;
    }

    public int getDeviceCodeLength() {
        return this.deviceCodeLength;
    }

    public void setDeviceCodeLength(int deviceCodeLength) {
        this.deviceCodeLength = deviceCodeLength;
    }
}

