/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.x2017.x07.jwksEndpoint.CustomRSAKeyIdsType;
import com.pingidentity.x2017.x07.jwksEndpoint.JWKSEndpointConfigType;
import com.pingidentity.x2017.x07.jwksEndpoint.JWKSEndpointConfigTypeDocument;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.JWKSEndpointDynamicKeysSetting;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.oauth20.domain.JwksRsaManagerHelper;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class JWKSEndpointManagerImpl
implements JWKSEndpointManager,
AutoReloadable {
    private static final String FILENAME = "jwks-endpoint.xml";
    private JWKSEndpointSetting setting;
    private final XmlLoader xmlLoader;
    private final SysDirInfo sysDirInfo;

    public JWKSEndpointManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.sysDirInfo = sysDirInfo;
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        JWKSEndpointConfigTypeDocument doc = this.getClientSettingDoc();
        JWKSEndpointConfigType configType = doc.getJWKSEndpointConfigType();
        this.setting = new JWKSEndpointSetting();
        this.setting.setEnableStaticKeys(configType.getEnableStaticKeys());
        this.setting.setP256ActiveId(configType.getP256ActiveKey());
        this.setting.setP256PreviousId(configType.getP256PreviousKey());
        this.setting.setP256PublishX5cParameter(configType.getP256PublishX5CParameter());
        this.setting.setP256ActiveKeyId(configType.getP256ActiveKeyId());
        this.setting.setP256PreviousKeyId(configType.getP256PreviousKeyId());
        this.setting.setP384ActiveId(configType.getP384ActiveKey());
        this.setting.setP384PreviousId(configType.getP384PreviousKey());
        this.setting.setP384PublishX5cParameter(configType.getP384PublishX5CParameter());
        this.setting.setP384ActiveKeyId(configType.getP384ActiveKeyId());
        this.setting.setP384PreviousKeyId(configType.getP384PreviousKeyId());
        this.setting.setP521ActiveId(configType.getP521ActiveKey());
        this.setting.setP521PreviousId(configType.getP521PreviousKey());
        this.setting.setP521PublishX5cParameter(configType.getP521PublishX5CParameter());
        this.setting.setP521ActiveKeyId(configType.getP521ActiveKeyId());
        this.setting.setP521PreviousKeyId(configType.getP521PreviousKeyId());
        this.setting.setRsaActiveId(configType.getRsaActiveKey());
        this.setting.setRsaPreviousId(configType.getRsaPreviousKey());
        this.setting.setRsaPublishX5cParameter(configType.getRsaPublishX5CParameter());
        this.setting.setRsaActiveKeyId(configType.getRsaActiveKeyId());
        this.setting.setRsaPreviousKeyId(configType.getRsaPreviousKeyId());
        this.setting.setP256DecryptionActiveId(configType.getP256DecryptionActiveKey());
        this.setting.setP256DecryptionPreviousId(configType.getP256DecryptionPreviousKey());
        this.setting.setP256DecryptionPublishX5cParameter(configType.getP256DecryptionPublishX5CParameter());
        this.setting.setP256DecryptionActiveKeyId(configType.getP256DecryptionActiveKeyId());
        this.setting.setP256DecryptionPreviousKeyId(configType.getP256DecryptionPreviousKeyId());
        this.setting.setP384DecryptionActiveId(configType.getP384DecryptionActiveKey());
        this.setting.setP384DecryptionPreviousId(configType.getP384DecryptionPreviousKey());
        this.setting.setP384DecryptionPublishX5cParameter(configType.getP384DecryptionPublishX5CParameter());
        this.setting.setP384DecryptionActiveKeyId(configType.getP384DecryptionActiveKeyId());
        this.setting.setP384DecryptionPreviousKeyId(configType.getP384DecryptionPreviousKeyId());
        this.setting.setP521DecryptionActiveId(configType.getP521DecryptionActiveKey());
        this.setting.setP521DecryptionPreviousId(configType.getP521DecryptionPreviousKey());
        this.setting.setP521DecryptionPublishX5cParameter(configType.getP521DecryptionPublishX5CParameter());
        this.setting.setP521DecryptionActiveKeyId(configType.getP521DecryptionActiveKeyId());
        this.setting.setP521DecryptionPreviousKeyId(configType.getP521DecryptionPreviousKeyId());
        this.setting.setRsaDecryptionActiveId(configType.getRsaDecryptionActiveKey());
        this.setting.setRsaDecryptionPreviousId(configType.getRsaDecryptionPreviousKey());
        this.setting.setRsaDecryptionPublishX5cParameter(configType.getRsaDecryptionPublishX5CParameter());
        this.setting.setRsaDecryptionActiveKeyId(configType.getRsaDecryptionActiveKeyId());
        this.setting.setRsaDecryptionPreviousKeyId(configType.getRsaDecryptionPreviousKeyId());
        this.setting.setRsaAlgTypesActiveCustomKeyIds(JwksRsaManagerHelper.populateRsaAlgKeyIdMap(configType.getCustomRsaActiveKeyIds()));
        this.setting.setRsaAlgTypesPreviousCustomKeyIds(JwksRsaManagerHelper.populateRsaAlgKeyIdMap(configType.getCustomRsaPreviousKeyIds()));
        JWKSEndpointDynamicKeysSetting dynamicKeys = new JWKSEndpointDynamicKeysSetting.Builder(configType.getPublishCertificateForDynamicKeys()).certOrgName(configType.getCertOrgName()).certOrgUnitName(configType.getCertOrgUnitName()).certCountry(configType.getCertCountry()).certState(configType.getCertState()).certCity(configType.getCertCity()).build();
        this.setting.setDynamicKeys(dynamicKeys);
    }

    @Override
    public synchronized void save(JWKSEndpointSetting setting) {
        JWKSEndpointConfigTypeDocument doc = this.getClientSettingDoc();
        JWKSEndpointConfigType configType = doc.getJWKSEndpointConfigType();
        configType.setEnableStaticKeys(setting.isEnableStaticKeys());
        configType.setP256ActiveKey(setting.getP256ActiveId());
        configType.setP256PreviousKey(setting.getP256PreviousId());
        configType.setP256PublishX5CParameter(setting.isP256PublishX5cParameter());
        configType.setP256ActiveKeyId(setting.getP256ActiveKeyId());
        configType.setP256PreviousKeyId(setting.getP256PreviousKeyId());
        configType.setP384ActiveKey(setting.getP384ActiveId());
        configType.setP384PreviousKey(setting.getP384PreviousId());
        configType.setP384PublishX5CParameter(setting.isP384PublishX5cParameter());
        configType.setP384ActiveKeyId(setting.getP384ActiveKeyId());
        configType.setP384PreviousKeyId(setting.getP384PreviousKeyId());
        configType.setP521ActiveKey(setting.getP521ActiveId());
        configType.setP521PreviousKey(setting.getP521PreviousId());
        configType.setP521PublishX5CParameter(setting.isP521PublishX5cParameter());
        configType.setP521ActiveKeyId(setting.getP521ActiveKeyId());
        configType.setP521PreviousKeyId(setting.getP521PreviousKeyId());
        configType.setRsaActiveKey(setting.getRsaActiveId());
        configType.setRsaPreviousKey(setting.getRsaPreviousId());
        configType.setRsaPublishX5CParameter(setting.isRsaPublishX5cParameter());
        configType.setRsaActiveKeyId(setting.getRsaActiveKeyId());
        configType.setRsaPreviousKeyId(setting.getRsaPreviousKeyId());
        configType.setP256DecryptionActiveKey(setting.getP256DecryptionActiveId());
        configType.setP256DecryptionPreviousKey(setting.getP256DecryptionPreviousId());
        configType.setP256DecryptionPublishX5CParameter(setting.isP256DecryptionPublishX5cParameter());
        configType.setP256DecryptionActiveKeyId(setting.getP256DecryptionActiveKeyId());
        configType.setP256DecryptionPreviousKeyId(setting.getP256DecryptionPreviousKeyId());
        configType.setP384DecryptionActiveKey(setting.getP384DecryptionActiveId());
        configType.setP384DecryptionPreviousKey(setting.getP384DecryptionPreviousId());
        configType.setP384DecryptionPublishX5CParameter(setting.isP384DecryptionPublishX5cParameter());
        configType.setP384DecryptionActiveKeyId(setting.getP384DecryptionActiveKeyId());
        configType.setP384DecryptionPreviousKeyId(setting.getP384DecryptionPreviousKeyId());
        configType.setP521DecryptionActiveKey(setting.getP521DecryptionActiveId());
        configType.setP521DecryptionPreviousKey(setting.getP521DecryptionPreviousId());
        configType.setP521DecryptionPublishX5CParameter(setting.isP521DecryptionPublishX5cParameter());
        configType.setP521DecryptionActiveKeyId(setting.getP521DecryptionActiveKeyId());
        configType.setP521DecryptionPreviousKeyId(setting.getP521DecryptionPreviousKeyId());
        configType.setRsaDecryptionActiveKey(setting.getRsaDecryptionActiveId());
        configType.setRsaDecryptionPreviousKey(setting.getRsaDecryptionPreviousId());
        configType.setRsaDecryptionPublishX5CParameter(setting.isRsaDecryptionPublishX5cParameter());
        configType.setRsaDecryptionActiveKeyId(setting.getRsaDecryptionActiveKeyId());
        configType.setRsaDecryptionPreviousKeyId(setting.getRsaDecryptionPreviousKeyId());
        CustomRSAKeyIdsType customRsaPreviousKeyIdsType = configType.getCustomRsaPreviousKeyIds() == null ? configType.addNewCustomRsaPreviousKeyIds() : configType.getCustomRsaPreviousKeyIds();
        CustomRSAKeyIdsType customRsaActiveKeyIdsType = configType.getCustomRsaActiveKeyIds() == null ? configType.addNewCustomRsaActiveKeyIds() : configType.getCustomRsaActiveKeyIds();
        JwksRsaManagerHelper.addRsaCustomAlgToKeyIdMap(customRsaActiveKeyIdsType, customRsaPreviousKeyIdsType, setting);
        configType.setPublishCertificateForDynamicKeys(setting.getDynamicKeys().isPublishCertificates());
        configType.setCertOrgName(setting.getDynamicKeys().getCertOrgName());
        configType.setCertOrgUnitName(setting.getDynamicKeys().getCertOrgUnitName());
        configType.setCertCountry(setting.getDynamicKeys().getCertCountry());
        configType.setCertState(setting.getDynamicKeys().getCertState());
        configType.setCertCity(setting.getDynamicKeys().getCertCity());
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), FILENAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_OIDC_KEYS, AdminAuditLogger.Event.MODIFY);
        }
        this.loadConfig();
        GlobalRegistry.getService(JwkFacilitator.class).createKeys(this.setting);
    }

    private synchronized JWKSEndpointConfigTypeDocument getClientSettingDoc() {
        JWKSEndpointConfigTypeDocument doc;
        if (this.xmlLoader.xmlExists(this.sysDirInfo.getDataDirectory(), FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.sysDirInfo.getDataDirectory(), FILENAME);
            doc = (JWKSEndpointConfigTypeDocument)xmlObject;
        } else {
            doc = JWKSEndpointConfigTypeDocument.Factory.newInstance();
            doc.addNewJWKSEndpointConfigType();
        }
        return doc;
    }

    @Override
    public synchronized JWKSEndpointSetting getSetting() {
        return this.setting;
    }
}

