/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sourceid.oauth20.domain.JWKSEndpointDynamicKeysSetting;
import org.sourceid.oauth20.domain.OidcJwksSet;

public class JWKSEndpointSetting
extends OidcJwksSet {
    private boolean enableStaticKeys;
    private String p256DecryptionActiveId;
    private String p256DecryptionPreviousId;
    private boolean p256DecryptionPublishX5cParameter;
    private String p256DecryptionActiveKeyId;
    private String p256DecryptionPreviousKeyId;
    private String p384DecryptionActiveId;
    private String p384DecryptionPreviousId;
    private boolean p384DecryptionPublishX5cParameter;
    private String p384DecryptionActiveKeyId;
    private String p384DecryptionPreviousKeyId;
    private String p521DecryptionActiveId;
    private String p521DecryptionPreviousId;
    private boolean p521DecryptionPublishX5cParameter;
    private String p521DecryptionActiveKeyId;
    private String p521DecryptionPreviousKeyId;
    private String rsaDecryptionActiveId;
    private String rsaDecryptionPreviousId;
    private boolean rsaDecryptionPublishX5cParameter;
    private String rsaDecryptionActiveKeyId;
    private String rsaDecryptionPreviousKeyId;
    private JWKSEndpointDynamicKeysSetting dynamicKeys;

    public JWKSEndpointSetting() {
    }

    public JWKSEndpointSetting(JWKSEndpointSetting jwksEndpointSetting) {
        super(jwksEndpointSetting);
        this.enableStaticKeys = jwksEndpointSetting.enableStaticKeys;
        this.p256DecryptionActiveId = jwksEndpointSetting.p256DecryptionActiveId;
        this.p256DecryptionPreviousId = jwksEndpointSetting.p256DecryptionPreviousId;
        this.p256DecryptionPublishX5cParameter = jwksEndpointSetting.p256DecryptionPublishX5cParameter;
        this.p256DecryptionActiveKeyId = jwksEndpointSetting.p256DecryptionActiveKeyId;
        this.p256DecryptionPreviousKeyId = jwksEndpointSetting.p256DecryptionPreviousKeyId;
        this.p384DecryptionActiveId = jwksEndpointSetting.p384DecryptionActiveId;
        this.p384DecryptionPreviousId = jwksEndpointSetting.p384DecryptionPreviousId;
        this.p384DecryptionPublishX5cParameter = jwksEndpointSetting.p384DecryptionPublishX5cParameter;
        this.p384DecryptionActiveKeyId = jwksEndpointSetting.p384DecryptionActiveKeyId;
        this.p384DecryptionPreviousKeyId = jwksEndpointSetting.p384DecryptionPreviousKeyId;
        this.p521DecryptionActiveId = jwksEndpointSetting.p521DecryptionActiveId;
        this.p521DecryptionPreviousId = jwksEndpointSetting.p521DecryptionPreviousId;
        this.p521DecryptionPublishX5cParameter = jwksEndpointSetting.p521DecryptionPublishX5cParameter;
        this.p521DecryptionActiveKeyId = jwksEndpointSetting.p521DecryptionActiveKeyId;
        this.p521DecryptionPreviousKeyId = jwksEndpointSetting.p521DecryptionPreviousKeyId;
        this.rsaDecryptionActiveId = jwksEndpointSetting.rsaDecryptionActiveId;
        this.rsaDecryptionPreviousId = jwksEndpointSetting.rsaDecryptionPreviousId;
        this.rsaDecryptionPublishX5cParameter = jwksEndpointSetting.rsaDecryptionPublishX5cParameter;
        this.rsaDecryptionActiveKeyId = jwksEndpointSetting.rsaDecryptionActiveKeyId;
        this.rsaDecryptionPreviousKeyId = jwksEndpointSetting.rsaDecryptionPreviousKeyId;
        if (jwksEndpointSetting.dynamicKeys != null) {
            this.dynamicKeys = new JWKSEndpointDynamicKeysSetting.Builder(jwksEndpointSetting.dynamicKeys).build();
        }
    }

    public boolean isEnableStaticKeys() {
        return this.enableStaticKeys;
    }

    public void setEnableStaticKeys(boolean enableStaticKeys) {
        this.enableStaticKeys = enableStaticKeys;
    }

    public String getP256DecryptionActiveId() {
        return this.p256DecryptionActiveId;
    }

    public void setP256DecryptionActiveId(String p256DecryptionActiveId) {
        this.p256DecryptionActiveId = p256DecryptionActiveId;
    }

    public String getP256DecryptionPreviousId() {
        return this.p256DecryptionPreviousId;
    }

    public void setP256DecryptionPreviousId(String p256DecryptionPreviousId) {
        this.p256DecryptionPreviousId = p256DecryptionPreviousId;
    }

    public boolean isP256DecryptionPublishX5cParameter() {
        return this.p256DecryptionPublishX5cParameter;
    }

    public void setP256DecryptionPublishX5cParameter(boolean p256DecryptionPublishX5cParameter) {
        this.p256DecryptionPublishX5cParameter = p256DecryptionPublishX5cParameter;
    }

    public String getP384DecryptionActiveId() {
        return this.p384DecryptionActiveId;
    }

    public void setP384DecryptionActiveId(String p384DecryptionActiveId) {
        this.p384DecryptionActiveId = p384DecryptionActiveId;
    }

    public String getP384DecryptionPreviousId() {
        return this.p384DecryptionPreviousId;
    }

    public void setP384DecryptionPreviousId(String p384DecryptionPreviousId) {
        this.p384DecryptionPreviousId = p384DecryptionPreviousId;
    }

    public boolean isP384DecryptionPublishX5cParameter() {
        return this.p384DecryptionPublishX5cParameter;
    }

    public void setP384DecryptionPublishX5cParameter(boolean p384DecryptionPublishX5cParameter) {
        this.p384DecryptionPublishX5cParameter = p384DecryptionPublishX5cParameter;
    }

    public String getP521DecryptionActiveId() {
        return this.p521DecryptionActiveId;
    }

    public void setP521DecryptionActiveId(String p521DecryptionActiveId) {
        this.p521DecryptionActiveId = p521DecryptionActiveId;
    }

    public String getP521DecryptionPreviousId() {
        return this.p521DecryptionPreviousId;
    }

    public void setP521DecryptionPreviousId(String p521DecryptionPreviousId) {
        this.p521DecryptionPreviousId = p521DecryptionPreviousId;
    }

    public boolean isP521DecryptionPublishX5cParameter() {
        return this.p521DecryptionPublishX5cParameter;
    }

    public void setP521DecryptionPublishX5cParameter(boolean p521DecryptionPublishX5cParameter) {
        this.p521DecryptionPublishX5cParameter = p521DecryptionPublishX5cParameter;
    }

    public String getRsaDecryptionActiveId() {
        return this.rsaDecryptionActiveId;
    }

    public void setRsaDecryptionActiveId(String rsaDecryptionActiveId) {
        this.rsaDecryptionActiveId = rsaDecryptionActiveId;
    }

    public String getRsaDecryptionPreviousId() {
        return this.rsaDecryptionPreviousId;
    }

    public void setRsaDecryptionPreviousId(String rsaDecryptionPreviousId) {
        this.rsaDecryptionPreviousId = rsaDecryptionPreviousId;
    }

    public boolean isRsaDecryptionPublishX5cParameter() {
        return this.rsaDecryptionPublishX5cParameter;
    }

    public void setRsaDecryptionPublishX5cParameter(boolean rsaDecryptionPublishX5cParameter) {
        this.rsaDecryptionPublishX5cParameter = rsaDecryptionPublishX5cParameter;
    }

    @Override
    public Set<String> getActiveIds() {
        HashSet<String> ids = new HashSet<String>(super.getActiveIds());
        if (this.p256DecryptionActiveId != null) {
            ids.add(this.p256DecryptionActiveId);
        }
        if (this.p384DecryptionActiveId != null) {
            ids.add(this.p384DecryptionActiveId);
        }
        if (this.p521DecryptionActiveId != null) {
            ids.add(this.p521DecryptionActiveId);
        }
        if (this.rsaDecryptionActiveId != null) {
            ids.add(this.rsaDecryptionActiveId);
        }
        return Collections.unmodifiableSet(ids);
    }

    @Override
    public Set<String> getPreviousIds() {
        HashSet<String> ids = new HashSet<String>(super.getPreviousIds());
        if (this.p256DecryptionPreviousId != null) {
            ids.add(this.p256DecryptionPreviousId);
        }
        if (this.p384DecryptionPreviousId != null) {
            ids.add(this.p384DecryptionPreviousId);
        }
        if (this.p521DecryptionPreviousId != null) {
            ids.add(this.p521DecryptionPreviousId);
        }
        if (this.rsaDecryptionPreviousId != null) {
            ids.add(this.rsaDecryptionPreviousId);
        }
        return Collections.unmodifiableSet(ids);
    }

    public String getP256DecryptionActiveKeyId() {
        return this.p256DecryptionActiveKeyId;
    }

    public void setP256DecryptionActiveKeyId(String p256DecryptionActiveKeyId) {
        this.p256DecryptionActiveKeyId = p256DecryptionActiveKeyId;
    }

    public String getP256DecryptionPreviousKeyId() {
        return this.p256DecryptionPreviousKeyId;
    }

    public void setP256DecryptionPreviousKeyId(String p256DecryptionPreviousKeyId) {
        this.p256DecryptionPreviousKeyId = p256DecryptionPreviousKeyId;
    }

    public String getP384DecryptionActiveKeyId() {
        return this.p384DecryptionActiveKeyId;
    }

    public void setP384DecryptionActiveKeyId(String p384DecryptionActiveKeyId) {
        this.p384DecryptionActiveKeyId = p384DecryptionActiveKeyId;
    }

    public String getP384DecryptionPreviousKeyId() {
        return this.p384DecryptionPreviousKeyId;
    }

    public void setP384DecryptionPreviousKeyId(String p384DecryptionPreviousKeyId) {
        this.p384DecryptionPreviousKeyId = p384DecryptionPreviousKeyId;
    }

    public String getP521DecryptionActiveKeyId() {
        return this.p521DecryptionActiveKeyId;
    }

    public void setP521DecryptionActiveKeyId(String p521DecryptionActiveKeyId) {
        this.p521DecryptionActiveKeyId = p521DecryptionActiveKeyId;
    }

    public String getP521DecryptionPreviousKeyId() {
        return this.p521DecryptionPreviousKeyId;
    }

    public void setP521DecryptionPreviousKeyId(String p521DecryptionPreviousKeyId) {
        this.p521DecryptionPreviousKeyId = p521DecryptionPreviousKeyId;
    }

    public String getRsaDecryptionActiveKeyId() {
        return this.rsaDecryptionActiveKeyId;
    }

    public void setRsaDecryptionActiveKeyId(String rsaDecryptionActiveKeyId) {
        this.rsaDecryptionActiveKeyId = rsaDecryptionActiveKeyId;
    }

    public String getRsaDecryptionPreviousKeyId() {
        return this.rsaDecryptionPreviousKeyId;
    }

    public void setRsaDecryptionPreviousKeyId(String rsaDecryptionPreviousKeyId) {
        this.rsaDecryptionPreviousKeyId = rsaDecryptionPreviousKeyId;
    }

    public JWKSEndpointDynamicKeysSetting getDynamicKeys() {
        return this.dynamicKeys;
    }

    public void setDynamicKeys(JWKSEndpointDynamicKeysSetting dynamicKeys) {
        this.dynamicKeys = dynamicKeys;
    }

    @Override
    public String toString() {
        return "JWKSEndpointSetting{enableStaticKeys=" + this.enableStaticKeys + ", p256DecryptionActiveId='" + this.p256DecryptionActiveId + "', p256DecryptionPreviousId='" + this.p256DecryptionPreviousId + "', p256DecryptionPublishX5cParameter=" + this.p256DecryptionPublishX5cParameter + ", p256DecryptionActiveKeyId='" + this.p256DecryptionActiveKeyId + "', p256DecryptionPreviousKeyId='" + this.p256DecryptionPreviousKeyId + "', p384DecryptionActiveId='" + this.p384DecryptionActiveId + "', p384DecryptionPreviousId='" + this.p384DecryptionPreviousId + "', p384DecryptionPublishX5cParameter=" + this.p384DecryptionPublishX5cParameter + ", p384DecryptionActiveKeyId='" + this.p384DecryptionActiveKeyId + "', p384DecryptionPreviousKeyId='" + this.p384DecryptionPreviousKeyId + "', p521DecryptionActiveId='" + this.p521DecryptionActiveId + "', p521DecryptionPreviousId='" + this.p521DecryptionPreviousId + "', p521DecryptionPublishX5cParameter=" + this.p521DecryptionPublishX5cParameter + ", p521DecryptionActiveKeyId='" + this.p521DecryptionActiveKeyId + "', p521DecryptionPreviousKeyId='" + this.p521DecryptionPreviousKeyId + "', rsaDecryptionActiveId='" + this.rsaDecryptionActiveId + "', rsaDecryptionPreviousId='" + this.rsaDecryptionPreviousId + "', rsaDecryptionPublishX5cParameter=" + this.rsaDecryptionPublishX5cParameter + ", rsaDecryptionActiveKeyId='" + this.rsaDecryptionActiveKeyId + "', rsaDecryptionPreviousKeyId='" + this.rsaDecryptionPreviousKeyId + "', dynamicKeys=" + this.dynamicKeys + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWKSEndpointSetting that = (JWKSEndpointSetting)o;
        return this.enableStaticKeys == that.enableStaticKeys && this.p256DecryptionPublishX5cParameter == that.p256DecryptionPublishX5cParameter && this.p384DecryptionPublishX5cParameter == that.p384DecryptionPublishX5cParameter && this.p521DecryptionPublishX5cParameter == that.p521DecryptionPublishX5cParameter && this.rsaDecryptionPublishX5cParameter == that.rsaDecryptionPublishX5cParameter && Objects.equals(this.p256DecryptionActiveId, that.p256DecryptionActiveId) && Objects.equals(this.p256DecryptionPreviousId, that.p256DecryptionPreviousId) && Objects.equals(this.p256DecryptionActiveKeyId, that.p256DecryptionActiveKeyId) && Objects.equals(this.p256DecryptionPreviousKeyId, that.p256DecryptionPreviousKeyId) && Objects.equals(this.p384DecryptionActiveId, that.p384DecryptionActiveId) && Objects.equals(this.p384DecryptionPreviousId, that.p384DecryptionPreviousId) && Objects.equals(this.p384DecryptionActiveKeyId, that.p384DecryptionActiveKeyId) && Objects.equals(this.p384DecryptionPreviousKeyId, that.p384DecryptionPreviousKeyId) && Objects.equals(this.p521DecryptionActiveId, that.p521DecryptionActiveId) && Objects.equals(this.p521DecryptionPreviousId, that.p521DecryptionPreviousId) && Objects.equals(this.p521DecryptionActiveKeyId, that.p521DecryptionActiveKeyId) && Objects.equals(this.p521DecryptionPreviousKeyId, that.p521DecryptionPreviousKeyId) && Objects.equals(this.rsaDecryptionActiveId, that.rsaDecryptionActiveId) && Objects.equals(this.rsaDecryptionPreviousId, that.rsaDecryptionPreviousId) && Objects.equals(this.rsaDecryptionActiveKeyId, that.rsaDecryptionActiveKeyId) && Objects.equals(this.rsaDecryptionPreviousKeyId, that.rsaDecryptionPreviousKeyId) && Objects.equals(this.dynamicKeys, that.dynamicKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enableStaticKeys, this.p256DecryptionActiveId, this.p256DecryptionPreviousId, this.p256DecryptionPublishX5cParameter, this.p256DecryptionActiveKeyId, this.p256DecryptionPreviousKeyId, this.p384DecryptionActiveId, this.p384DecryptionPreviousId, this.p384DecryptionPublishX5cParameter, this.p384DecryptionActiveKeyId, this.p384DecryptionPreviousKeyId, this.p521DecryptionActiveId, this.p521DecryptionPreviousId, this.p521DecryptionPublishX5cParameter, this.p521DecryptionActiveKeyId, this.p521DecryptionPreviousKeyId, this.rsaDecryptionActiveId, this.rsaDecryptionPreviousId, this.rsaDecryptionPublishX5cParameter, this.rsaDecryptionActiveKeyId, this.rsaDecryptionPreviousKeyId, this.dynamicKeys);
    }
}

