/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.x2017.x07.jwksEndpoint.CustomKeyIdType;
import com.pingidentity.x2017.x07.jwksEndpoint.CustomRSAKeyIdsType;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.oauth20.domain.OidcJwksSet;

public final class JwksRsaManagerHelper {
    private JwksRsaManagerHelper() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static Map<String, String> populateRsaAlgKeyIdMap(CustomRSAKeyIdsType customRsaKeyIdsType) {
        HashMap<String, String> algTypeToKid = new HashMap<String, String>();
        if (customRsaKeyIdsType == null) {
            return algTypeToKid;
        }
        CustomKeyIdType[] customRsaActiveKeyIds = customRsaKeyIdsType.getAlgToKeyIdMapArray();
        if (customRsaActiveKeyIds != null) {
            for (CustomKeyIdType algKeyIdEntry : customRsaActiveKeyIds) {
                String algType = algKeyIdEntry.getAlgType();
                String keyId = algKeyIdEntry.getKeyId();
                algTypeToKid.put(algType, keyId);
            }
        }
        return algTypeToKid;
    }

    public static void addRsaCustomAlgToKeyIdMap(CustomRSAKeyIdsType customRsaActiveKeyIdsType, CustomRSAKeyIdsType customRsaPreviousKeyIdsType, OidcJwksSet instance) {
        CustomKeyIdType[] algToPreviousKeyIdMapArray = JwksRsaManagerHelper.populateRsaCustomKeyIdTypeArray(instance.getRsaAlgTypesPreviousCustomKeyIds());
        customRsaPreviousKeyIdsType.setAlgToKeyIdMapArray(algToPreviousKeyIdMapArray);
        CustomKeyIdType[] algToActiveKeyIdMapArray = JwksRsaManagerHelper.populateRsaCustomKeyIdTypeArray(instance.getRsaAlgTypesActiveCustomKeyIds());
        customRsaActiveKeyIdsType.setAlgToKeyIdMapArray(algToActiveKeyIdMapArray);
    }

    private static CustomKeyIdType[] populateRsaCustomKeyIdTypeArray(Map<String, String> algTypeToKids) {
        if (algTypeToKids == null) {
            return null;
        }
        CustomKeyIdType[] algToKeyIdMapArray = new CustomKeyIdType[algTypeToKids.size()];
        int i = 0;
        for (Map.Entry<String, String> algKeyIdEntry : algTypeToKids.entrySet()) {
            CustomKeyIdType customKeyIdType = CustomKeyIdType.Factory.newInstance();
            customKeyIdType.setAlgType(algKeyIdEntry.getKey());
            customKeyIdType.setKeyId(algKeyIdEntry.getValue());
            algToKeyIdMapArray[i] = customKeyIdType;
            ++i;
        }
        return algToKeyIdMapArray;
    }
}

