/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OidcJwksSet {
    private String p256ActiveId;
    private String p256PreviousId;
    private boolean p256PublishX5cParameter;
    private String p256ActiveKeyId;
    private String p256PreviousKeyId;
    private String p384ActiveId;
    private String p384PreviousId;
    private boolean p384PublishX5cParameter;
    private String p384ActiveKeyId;
    private String p384PreviousKeyId;
    private String p521ActiveId;
    private String p521PreviousId;
    private boolean p521PublishX5cParameter;
    private String p521ActiveKeyId;
    private String p521PreviousKeyId;
    private String rsaActiveId;
    private String rsaPreviousId;
    private boolean rsaPublishX5cParameter;
    private String rsaActiveKeyId;
    private String rsaPreviousKeyId;
    private Map<String, String> rsaAlgTypesActiveCustomKeyIds = new HashMap<String, String>();
    private Map<String, String> rsaAlgTypesPreviousCustomKeyIds = new HashMap<String, String>();

    public OidcJwksSet() {
    }

    public OidcJwksSet(OidcJwksSet oidcJwksSet) {
        this.p256ActiveId = oidcJwksSet.p256ActiveId;
        this.p256PreviousId = oidcJwksSet.p256PreviousId;
        this.p256PublishX5cParameter = oidcJwksSet.p256PublishX5cParameter;
        this.p256ActiveKeyId = oidcJwksSet.p256ActiveKeyId;
        this.p256PreviousKeyId = oidcJwksSet.p256PreviousKeyId;
        this.p384ActiveId = oidcJwksSet.p384ActiveId;
        this.p384PreviousId = oidcJwksSet.p384PreviousId;
        this.p384PublishX5cParameter = oidcJwksSet.p384PublishX5cParameter;
        this.p384ActiveKeyId = oidcJwksSet.p384ActiveKeyId;
        this.p384PreviousKeyId = oidcJwksSet.p384PreviousKeyId;
        this.p521ActiveId = oidcJwksSet.p521ActiveId;
        this.p521PreviousId = oidcJwksSet.p521PreviousId;
        this.p521PublishX5cParameter = oidcJwksSet.p521PublishX5cParameter;
        this.p521ActiveKeyId = oidcJwksSet.p521ActiveKeyId;
        this.p521PreviousKeyId = oidcJwksSet.p521PreviousKeyId;
        this.rsaActiveId = oidcJwksSet.rsaActiveId;
        this.rsaPreviousId = oidcJwksSet.rsaPreviousId;
        this.rsaPublishX5cParameter = oidcJwksSet.rsaPublishX5cParameter;
        this.rsaActiveKeyId = oidcJwksSet.rsaActiveKeyId;
        this.rsaPreviousKeyId = oidcJwksSet.rsaPreviousKeyId;
        this.rsaAlgTypesActiveCustomKeyIds = new HashMap<String, String>(oidcJwksSet.rsaAlgTypesActiveCustomKeyIds);
        this.rsaAlgTypesPreviousCustomKeyIds = new HashMap<String, String>(oidcJwksSet.rsaAlgTypesPreviousCustomKeyIds);
    }

    public String getP256ActiveId() {
        return this.p256ActiveId;
    }

    public void setP256ActiveId(String p256ActiveId) {
        this.p256ActiveId = p256ActiveId;
    }

    public String getP256PreviousId() {
        return this.p256PreviousId;
    }

    public void setP256PreviousId(String p256PreviousId) {
        this.p256PreviousId = p256PreviousId;
    }

    public boolean isP256PublishX5cParameter() {
        return this.p256PublishX5cParameter;
    }

    public void setP256PublishX5cParameter(boolean p256PublishX5cParameter) {
        this.p256PublishX5cParameter = p256PublishX5cParameter;
    }

    public String getP384ActiveId() {
        return this.p384ActiveId;
    }

    public void setP384ActiveId(String p384ActiveId) {
        this.p384ActiveId = p384ActiveId;
    }

    public String getP384PreviousId() {
        return this.p384PreviousId;
    }

    public void setP384PreviousId(String p384PreviousId) {
        this.p384PreviousId = p384PreviousId;
    }

    public boolean isP384PublishX5cParameter() {
        return this.p384PublishX5cParameter;
    }

    public void setP384PublishX5cParameter(boolean p384PublishX5cParameter) {
        this.p384PublishX5cParameter = p384PublishX5cParameter;
    }

    public String getP521ActiveId() {
        return this.p521ActiveId;
    }

    public void setP521ActiveId(String p521ActiveId) {
        this.p521ActiveId = p521ActiveId;
    }

    public String getP521PreviousId() {
        return this.p521PreviousId;
    }

    public void setP521PreviousId(String p521PreviousId) {
        this.p521PreviousId = p521PreviousId;
    }

    public boolean isP521PublishX5cParameter() {
        return this.p521PublishX5cParameter;
    }

    public void setP521PublishX5cParameter(boolean p521PublishX5cParameter) {
        this.p521PublishX5cParameter = p521PublishX5cParameter;
    }

    public String getRsaActiveId() {
        return this.rsaActiveId;
    }

    public void setRsaActiveId(String rsaActiveId) {
        this.rsaActiveId = rsaActiveId;
    }

    public String getRsaPreviousId() {
        return this.rsaPreviousId;
    }

    public void setRsaPreviousId(String rsaPreviousId) {
        this.rsaPreviousId = rsaPreviousId;
    }

    public boolean isRsaPublishX5cParameter() {
        return this.rsaPublishX5cParameter;
    }

    public void setRsaPublishX5cParameter(boolean rsaPublishX5cParameter) {
        this.rsaPublishX5cParameter = rsaPublishX5cParameter;
    }

    public Set<String> getPreviousIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.p256PreviousId != null) {
            ids.add(this.p256PreviousId);
        }
        if (this.p384PreviousId != null) {
            ids.add(this.p384PreviousId);
        }
        if (this.p521PreviousId != null) {
            ids.add(this.p521PreviousId);
        }
        if (this.rsaPreviousId != null) {
            ids.add(this.rsaPreviousId);
        }
        return Collections.unmodifiableSet(ids);
    }

    public Set<String> getActiveIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.p256ActiveId != null) {
            ids.add(this.p256ActiveId);
        }
        if (this.p384ActiveId != null) {
            ids.add(this.p384ActiveId);
        }
        if (this.p521ActiveId != null) {
            ids.add(this.p521ActiveId);
        }
        if (this.rsaActiveId != null) {
            ids.add(this.rsaActiveId);
        }
        return Collections.unmodifiableSet(ids);
    }

    public String getP256ActiveKeyId() {
        return this.p256ActiveKeyId;
    }

    public void setP256ActiveKeyId(String p256ActiveKeyId) {
        this.p256ActiveKeyId = p256ActiveKeyId;
    }

    public String getP256PreviousKeyId() {
        return this.p256PreviousKeyId;
    }

    public void setP256PreviousKeyId(String p256PreviousKeyId) {
        this.p256PreviousKeyId = p256PreviousKeyId;
    }

    public String getP384ActiveKeyId() {
        return this.p384ActiveKeyId;
    }

    public void setP384ActiveKeyId(String p384ActiveKeyId) {
        this.p384ActiveKeyId = p384ActiveKeyId;
    }

    public String getP384PreviousKeyId() {
        return this.p384PreviousKeyId;
    }

    public void setP384PreviousKeyId(String p384PreviousKeyId) {
        this.p384PreviousKeyId = p384PreviousKeyId;
    }

    public String getP521ActiveKeyId() {
        return this.p521ActiveKeyId;
    }

    public void setP521ActiveKeyId(String p521ActiveKeyId) {
        this.p521ActiveKeyId = p521ActiveKeyId;
    }

    public String getP521PreviousKeyId() {
        return this.p521PreviousKeyId;
    }

    public void setP521PreviousKeyId(String p521PreviousKeyId) {
        this.p521PreviousKeyId = p521PreviousKeyId;
    }

    public String getRsaActiveKeyId() {
        return this.rsaActiveKeyId;
    }

    public void setRsaActiveKeyId(String rsaActiveKeyId) {
        this.rsaActiveKeyId = rsaActiveKeyId;
    }

    public String getRsaPreviousKeyId() {
        return this.rsaPreviousKeyId;
    }

    public void setRsaPreviousKeyId(String rsaPreviousKeyId) {
        this.rsaPreviousKeyId = rsaPreviousKeyId;
    }

    public Map<String, String> getRsaAlgTypesActiveCustomKeyIds() {
        return this.rsaAlgTypesActiveCustomKeyIds;
    }

    public void setRsaAlgTypesActiveCustomKeyIds(Map<String, String> rsaAlgTypesActiveCustomKeyIds) {
        this.rsaAlgTypesActiveCustomKeyIds = rsaAlgTypesActiveCustomKeyIds;
    }

    public Map<String, String> getRsaAlgTypesPreviousCustomKeyIds() {
        return this.rsaAlgTypesPreviousCustomKeyIds;
    }

    public void setRsaAlgTypesPreviousCustomKeyIds(Map<String, String> rsaAlgTypPreviousCustomKeyId) {
        this.rsaAlgTypesPreviousCustomKeyIds = rsaAlgTypPreviousCustomKeyId;
    }

    public String toString() {
        return "OidcJwksSet{p256ActiveId='" + this.p256ActiveId + "', p256PreviousId='" + this.p256PreviousId + "', p256PublishX5cParameter=" + this.p256PublishX5cParameter + ", p256ActiveKeyId='" + this.p256ActiveKeyId + "', p256PreviousKeyId='" + this.p256PreviousKeyId + "', p384ActiveId='" + this.p384ActiveId + "', p384PreviousId='" + this.p384PreviousId + "', p384PublishX5cParameter=" + this.p384PublishX5cParameter + ", p384ActiveKeyId='" + this.p384ActiveKeyId + "', p384PreviousKeyId='" + this.p384PreviousKeyId + "', p521ActiveId='" + this.p521ActiveId + "', p521PreviousId='" + this.p521PreviousId + "', p521PublishX5cParameter=" + this.p521PublishX5cParameter + ", p521ActiveKeyId='" + this.p521ActiveKeyId + "', p521PreviousKeyId='" + this.p521PreviousKeyId + "', rsaActiveId='" + this.rsaActiveId + "', rsaPreviousId='" + this.rsaPreviousId + "', rsaPublishX5cParameter=" + this.rsaPublishX5cParameter + ", rsaActiveKeyId='" + this.rsaActiveKeyId + "', rsaPreviousKeyId='" + this.rsaPreviousKeyId + "', rsaAlgTypesActiveCustomKeyIds=" + this.rsaAlgTypesActiveCustomKeyIds + ", rsaAlgTypesPreviousCustomKeyIds=" + this.rsaAlgTypesPreviousCustomKeyIds + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OidcJwksSet that = (OidcJwksSet)o;
        return this.p256PublishX5cParameter == that.p256PublishX5cParameter && this.p384PublishX5cParameter == that.p384PublishX5cParameter && this.p521PublishX5cParameter == that.p521PublishX5cParameter && this.rsaPublishX5cParameter == that.rsaPublishX5cParameter && Objects.equals(this.p256ActiveId, that.p256ActiveId) && Objects.equals(this.p256PreviousId, that.p256PreviousId) && Objects.equals(this.p256ActiveKeyId, that.p256ActiveKeyId) && Objects.equals(this.p256PreviousKeyId, that.p256PreviousKeyId) && Objects.equals(this.p384ActiveId, that.p384ActiveId) && Objects.equals(this.p384PreviousId, that.p384PreviousId) && Objects.equals(this.p384ActiveKeyId, that.p384ActiveKeyId) && Objects.equals(this.p384PreviousKeyId, that.p384PreviousKeyId) && Objects.equals(this.p521ActiveId, that.p521ActiveId) && Objects.equals(this.p521PreviousId, that.p521PreviousId) && Objects.equals(this.p521ActiveKeyId, that.p521ActiveKeyId) && Objects.equals(this.p521PreviousKeyId, that.p521PreviousKeyId) && Objects.equals(this.rsaActiveId, that.rsaActiveId) && Objects.equals(this.rsaPreviousId, that.rsaPreviousId) && Objects.equals(this.rsaActiveKeyId, that.rsaActiveKeyId) && Objects.equals(this.rsaPreviousKeyId, that.rsaPreviousKeyId) && Objects.equals(this.rsaAlgTypesActiveCustomKeyIds, that.rsaAlgTypesActiveCustomKeyIds) && Objects.equals(this.rsaAlgTypesPreviousCustomKeyIds, that.rsaAlgTypesPreviousCustomKeyIds);
    }

    public int hashCode() {
        return Objects.hash(this.p256ActiveId, this.p256PreviousId, this.p256PublishX5cParameter, this.p256ActiveKeyId, this.p256PreviousKeyId, this.p384ActiveId, this.p384PreviousId, this.p384PublishX5cParameter, this.p384ActiveKeyId, this.p384PreviousKeyId, this.p521ActiveId, this.p521PreviousId, this.p521PublishX5cParameter, this.p521ActiveKeyId, this.p521PreviousKeyId, this.rsaActiveId, this.rsaPreviousId, this.rsaPublishX5cParameter, this.rsaActiveKeyId, this.rsaPreviousKeyId, this.rsaAlgTypesActiveCustomKeyIds, this.rsaAlgTypesPreviousCustomKeyIds);
    }
}

