/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import java.util.Map;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.util.log.AttributeMap;

public final class PersistentGrantHelper {
    private PersistentGrantHelper() {
    }

    public static AttributeMap getGrantAttributeMap(String userKey, AccessGrantAttributesHolder holder, AccessGrant accessGrant, Client client, AuthzServerManager authzServerManager) {
        UserKeyAttributes accessGrantAttrs = new UserKeyAttributes(userKey);
        if (holder.getExtendedGrantAttrs() != null) {
            accessGrantAttrs.putAll((Map)holder.getExtendedGrantAttrs());
        }
        PersistentGrantHelper.addExpiresAtToAttributeMap(accessGrant, client, authzServerManager, accessGrantAttrs);
        return accessGrantAttrs;
    }

    public static void addExpiresAtToAttributeMap(AccessGrant accessGrant, Client client, AuthzServerManager authzServerManager, AttributeMap accessGrantAttrs) {
        Long expiresAt = PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeInSeconds(accessGrant, client, authzServerManager);
        if (expiresAt != null) {
            accessGrantAttrs.put("EXPIRES_AT", AttrValueSupport.make((Object)expiresAt));
        }
    }
}

