/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.ValidationUtil;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class PersistentGrantLifetimeHelper {
    private static final Logger log = LogManager.getLogger(PersistentGrantLifetimeHelper.class);
    public static final String PERSISTENT_GRANT_SETTING_TYPE_NONE = "NONE";
    public static final String PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT = "SERVER_DEFAULT";
    public static final String PERSISTENT_GRANT_SETTING_TYPE_OVERRIDE_SERVER_DEFAULT = "OVERRIDE_SERVER_DEFAULT";
    static final String PERSISTENT_GRANT_EXPIRATION_ATTRIBUTE = "PERSISTENT_GRANT_LIFETIME";
    public static final String PERSISTENT_GRANT_SETTING_TIME_UNIT_MINUTES_LEGACY = "min";
    public static final String PERSISTENT_GRANT_SETTING_TIME_UNIT_MINUTES = "n";
    public static final String PERSISTENT_GRANT_SETTING_TIME_UNIT_HOURS = "h";
    public static final String PERSISTENT_GRANT_SETTING_TIME_UNIT_DAYS = "d";
    public static final String PERSISTENT_GRANT_SETTING_TIME_UNIT_MILLISECONDS = "m";
    private static final ClientManager CLIENT_MGR = MgmtFactory.getClientManager();
    private static final AuthzServerManager AUTHZ_SERVER_MGR = MgmtFactory.getAuthzServerManager();

    public static void setExpirationOnGrant(AccessGrant accessGrant, Client client, String timeInMins) {
        long expirationTimeInMinsLong;
        long idleTimeInMinsLong = -1L;
        boolean valid = ValidationUtil.isValidLong(timeInMins, -1L);
        if (!valid) {
            expirationTimeInMinsLong = PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, AUTHZ_SERVER_MGR);
            idleTimeInMinsLong = PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutSettingInMins(client, AUTHZ_SERVER_MGR);
            if (timeInMins != null) {
                log.warn("Persistent Grant Lifetime is invalid (in minutes): " + timeInMins);
            }
        } else {
            expirationTimeInMinsLong = Long.parseLong(timeInMins);
        }
        if (!AUTHZ_SERVER_MGR.isPersistentGrantExpiryBasedOnIdleTimeout()) {
            if (expirationTimeInMinsLong > 0L) {
                long expirationTimeMillis = PersistentGrantLifetimeHelper.getPersistentGrantExpirationDateFromMinsToMilli(expirationTimeInMinsLong, new Date());
                accessGrant.setExpires(Long.valueOf(expirationTimeMillis));
            }
        } else if (expirationTimeInMinsLong > 0L || idleTimeInMinsLong > 0L) {
            long expirationTimeMillis = expirationTimeInMinsLong > 0L ? PersistentGrantLifetimeHelper.getPersistentGrantExpirationDateFromMinsToMilli(expirationTimeInMinsLong, new Date()) : Long.MAX_VALUE;
            long idleTimeoutMillis = idleTimeInMinsLong > 0L ? PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutDateFromMinsToMilli(idleTimeInMinsLong, new Date()) : Long.MAX_VALUE;
            accessGrant.setExpires(Long.valueOf(Math.min(expirationTimeMillis, idleTimeoutMillis)));
        }
    }

    public static Set<String> getPersistentGrantSettingTimeUnits() {
        HashSet<String> persistentGrantExpirationTimeUnits = new HashSet<String>();
        persistentGrantExpirationTimeUnits.add(PERSISTENT_GRANT_SETTING_TIME_UNIT_MINUTES);
        persistentGrantExpirationTimeUnits.add(PERSISTENT_GRANT_SETTING_TIME_UNIT_HOURS);
        persistentGrantExpirationTimeUnits.add(PERSISTENT_GRANT_SETTING_TIME_UNIT_DAYS);
        if (Boolean.parseBoolean(System.getProperty("enablePersistentGrantExpirationTimeUnitMilli", "false"))) {
            persistentGrantExpirationTimeUnits.add(PERSISTENT_GRANT_SETTING_TIME_UNIT_MILLISECONDS);
        }
        return persistentGrantExpirationTimeUnits;
    }

    public static Set<String> getPersistentGrantSettingTypes() {
        return new HashSet<String>(Arrays.asList(PERSISTENT_GRANT_SETTING_TYPE_NONE, PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT, PERSISTENT_GRANT_SETTING_TYPE_OVERRIDE_SERVER_DEFAULT));
    }

    private static long getPersistentGrantExpirationDateFromMinsToMilli(Long persistentGrantExpirationTime, Date startDate) {
        long expTime = TimeUnit.MINUTES.toMillis(persistentGrantExpirationTime);
        return startDate.getTime() + expTime;
    }

    private static long getPersistentGrantIdleTimeoutDateFromMinsToMilli(Long persistentGrantIdleTimeout, Date startDate) {
        long expTime = TimeUnit.MINUTES.toMillis(persistentGrantIdleTimeout);
        return startDate.getTime() + expTime;
    }

    public static String getPersistentGrantLifetimeInContextOverride(AccessGrantAttributesHolder holder) {
        if (holder == null) {
            return null;
        }
        AttributeValue persistentGrantLifetimeAttributeValue = (AttributeValue)holder.getExtendedGrantAttrs().get((Object)PERSISTENT_GRANT_EXPIRATION_ATTRIBUTE);
        if (persistentGrantLifetimeAttributeValue != null) {
            return persistentGrantLifetimeAttributeValue.getValue();
        }
        return null;
    }

    public static boolean isIssuePersistentGrantInContextOverride(AccessGrantAttributesHolder holder) {
        return !"0".equals(PersistentGrantLifetimeHelper.getPersistentGrantLifetimeInContextOverride(holder));
    }

    public static boolean isWithinIdleTimeoutWindow(AccessGrant accessGrant) {
        Client client = CLIENT_MGR.getCachedClient(accessGrant.getClientId());
        long idleTimeoutWindowInMinutes = PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutSettingInMins(client, AUTHZ_SERVER_MGR);
        return idleTimeoutWindowInMinutes < 0L || PersistentGrantLifetimeHelper.getPersistentGrantExpirationDateFromMinsToMilli(idleTimeoutWindowInMinutes, new Date(accessGrant.getUpdated())) > System.currentTimeMillis();
    }

    public static void updateExpiryBasedOnIdleTimeout(AccessGrant accessGrant, Client client) {
        long idleTimeoutMillis;
        long idleTimeoutInMinsLong = PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutSettingInMins(client, AUTHZ_SERVER_MGR);
        long expirationTimeInMinsLong = PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, AUTHZ_SERVER_MGR);
        if (expirationTimeInMinsLong < 0L && idleTimeoutInMinsLong > 0L) {
            idleTimeoutMillis = PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutDateFromMinsToMilli(idleTimeoutInMinsLong, new Date());
            accessGrant.setExpires(Long.valueOf(idleTimeoutMillis));
        }
        if (expirationTimeInMinsLong > 0L && idleTimeoutInMinsLong > 0L) {
            long expirationTimeMillis = PersistentGrantLifetimeHelper.getPersistentGrantExpirationDateFromMinsToMilli(expirationTimeInMinsLong, new Date(accessGrant.getIssued()));
            idleTimeoutMillis = PersistentGrantLifetimeHelper.getPersistentGrantIdleTimeoutDateFromMinsToMilli(idleTimeoutInMinsLong, new Date());
            accessGrant.setExpires(Long.valueOf(Math.min(expirationTimeMillis, idleTimeoutMillis)));
        }
    }

    public static Long getPersistentGrantExpirationTimeInSeconds(AccessGrant accessGrant, Client client, AuthzServerManager authzServerManager) {
        long lifetime;
        if (accessGrant != null && accessGrant.getExpires() != null) {
            return TimeUnit.MILLISECONDS.toSeconds(accessGrant.getExpires());
        }
        Long result = null;
        if (client != null && client.getGrantTypes() != null && client.getGrantTypes().contains("refresh_token") && (lifetime = PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, authzServerManager)) != -1L) {
            result = new Date().toInstant().plusSeconds(lifetime *= 60L).getEpochSecond();
        }
        return result;
    }

    public static long getPersistentGrantExpirationTimeSettingInMins(Client client, AuthzServerManager authzServerManager) {
        return PersistentGrantLifetimeHelper.getPersistentGrantTimeSettingInMins(client.getPersistentGrantExpirationType(), client.getPersistentGrantExpirationTime(), client.getPersistentGrantExpirationTimeUnit(), authzServerManager.getGlobalPersistentGrantExpirationTime(), authzServerManager.getGlobalPersistentGrantExpirationTimeUnit());
    }

    public static long getPersistentGrantIdleTimeoutSettingInMins(Client client, AuthzServerManager authzServerManager) {
        return PersistentGrantLifetimeHelper.getPersistentGrantTimeSettingInMins(client.getPersistentGrantIdleTimeoutType(), client.getPersistentGrantIdleTimeout(), client.getPersistentGrantIdleTimeoutTimeUnit(), authzServerManager.getGlobalPersistentGrantIdleTimeout(), authzServerManager.getGlobalPersistentGrantIdleTimeoutTimeUnit());
    }

    public static long getPersistentGrantTimeSettingInMins(String timeSettingType, Long timeSetting, String timeSettingUnit, Long globalTimeSetting, String globalTimeSettingUnit) {
        long timeSettingValueInMins = -1L;
        Long persistentGrantTimeSettingValue = null;
        String persistentGrantTimeSettingUnit = null;
        if (PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(timeSettingType)) {
            if (globalTimeSetting != null && globalTimeSetting > 0L) {
                persistentGrantTimeSettingValue = globalTimeSetting;
                persistentGrantTimeSettingUnit = globalTimeSettingUnit;
            }
        } else if (PERSISTENT_GRANT_SETTING_TYPE_OVERRIDE_SERVER_DEFAULT.equals(timeSettingType)) {
            persistentGrantTimeSettingValue = timeSetting;
            persistentGrantTimeSettingUnit = timeSettingUnit;
        }
        if (persistentGrantTimeSettingValue != null && persistentGrantTimeSettingUnit != null) {
            return PersistentGrantLifetimeHelper.convertPersistentGrantTimeSettingValueToMinutes(persistentGrantTimeSettingValue, persistentGrantTimeSettingUnit);
        }
        return timeSettingValueInMins;
    }

    private static long convertPersistentGrantTimeSettingValueToMinutes(Long timeSettingValue, String timeSettingUnit) {
        if (PERSISTENT_GRANT_SETTING_TIME_UNIT_MILLISECONDS.equalsIgnoreCase(timeSettingUnit)) {
            return 1L;
        }
        if (PERSISTENT_GRANT_SETTING_TIME_UNIT_MINUTES.equalsIgnoreCase(timeSettingUnit)) {
            return timeSettingValue;
        }
        if (PERSISTENT_GRANT_SETTING_TIME_UNIT_HOURS.equalsIgnoreCase(timeSettingUnit)) {
            return TimeUnit.HOURS.toMinutes(timeSettingValue);
        }
        if (PERSISTENT_GRANT_SETTING_TIME_UNIT_DAYS.equalsIgnoreCase(timeSettingUnit)) {
            return TimeUnit.DAYS.toMinutes(timeSettingValue);
        }
        return -1L;
    }

    public static long getGlobalTimeSettingInMinutes(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
        return new GlobalGrantTimeSetting(timeSettingType, timeSettingValue, timeSettingUnit).getTimeSettingValueInMinutes();
    }

    private static long getLocalMaxLifetimeInMinutes(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
        return new LocalMaxLifetimeSetting(timeSettingType, timeSettingValue, timeSettingUnit).getTimeSettingValueInMinutes();
    }

    private static long getLocalIdleTimeoutInMinutes(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
        return new LocalIdleTimeoutSetting(timeSettingType, timeSettingValue, timeSettingUnit).getTimeSettingValueInMinutes();
    }

    private static boolean isGlobalIdleTimeoutDisabled() {
        return AUTHZ_SERVER_MGR.getGlobalPersistentGrantIdleTimeout() == null || AUTHZ_SERVER_MGR.getGlobalPersistentGrantIdleTimeout() <= 0L;
    }

    private static boolean isLocalIdleTimeoutDisabled(String idleTimeoutType) {
        return PERSISTENT_GRANT_SETTING_TYPE_NONE.equals(idleTimeoutType) || PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(idleTimeoutType) && PersistentGrantLifetimeHelper.isGlobalIdleTimeoutDisabled();
    }

    public static boolean isInvalidLocalIdleTimeoutSetting(String maxLifetimeType, String maxLifetime, String maxLifetimeUnit, String idleTimeoutType, String idleTimeout, String idleTimeoutUnit) {
        return !PersistentGrantLifetimeHelper.isLocalIdleTimeoutDisabled(idleTimeoutType) && !PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(maxLifetimeType) && !PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(idleTimeoutType) && PersistentGrantLifetimeHelper.getLocalIdleTimeoutInMinutes(idleTimeoutType, idleTimeout, idleTimeoutUnit) > PersistentGrantLifetimeHelper.getLocalMaxLifetimeInMinutes(maxLifetimeType, maxLifetime, maxLifetimeUnit);
    }

    private static class LocalIdleTimeoutSetting
    extends LocalGrantTimeSetting {
        LocalIdleTimeoutSetting(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
            super(timeSettingType, timeSettingValue, timeSettingUnit);
        }

        @Override
        Long getDefaultTimeSettingValue() {
            return AUTHZ_SERVER_MGR.getGlobalPersistentGrantIdleTimeout();
        }

        @Override
        String getDefaultTimeSettingUnit() {
            return AUTHZ_SERVER_MGR.getGlobalPersistentGrantIdleTimeoutTimeUnit();
        }
    }

    private static class LocalMaxLifetimeSetting
    extends LocalGrantTimeSetting {
        LocalMaxLifetimeSetting(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
            super(timeSettingType, timeSettingValue, timeSettingUnit);
        }

        @Override
        Long getDefaultTimeSettingValue() {
            return AUTHZ_SERVER_MGR.getGlobalPersistentGrantExpirationTime();
        }

        @Override
        String getDefaultTimeSettingUnit() {
            return AUTHZ_SERVER_MGR.getGlobalPersistentGrantExpirationTimeUnit();
        }
    }

    private static abstract class LocalGrantTimeSetting
    extends GrantTimeSetting {
        LocalGrantTimeSetting(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
            super(timeSettingType, timeSettingValue, timeSettingUnit);
        }

        @Override
        boolean isValidType() {
            return PersistentGrantLifetimeHelper.getPersistentGrantSettingTypes().contains(this.timeSettingType);
        }

        @Override
        boolean isValidValue() {
            return !PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_OVERRIDE_SERVER_DEFAULT.equals(this.timeSettingType) || ValidationUtil.isValidLong(this.timeSettingValue);
        }

        @Override
        long getTimeSettingValueInMinutes() {
            if (!this.isValid() || PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_NONE.equals(this.timeSettingType)) {
                return Long.MAX_VALUE;
            }
            if (PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(this.timeSettingType)) {
                return this.getServerDefaultTimeSettingValueInMinutes();
            }
            long minutes = PersistentGrantLifetimeHelper.convertPersistentGrantTimeSettingValueToMinutes(Long.valueOf(this.timeSettingValue), this.timeSettingUnit);
            return minutes <= 0L ? Long.MAX_VALUE : minutes;
        }

        long getServerDefaultTimeSettingValueInMinutes() {
            Long defaultValue = this.getDefaultTimeSettingValue();
            String defaultUnit = this.getDefaultTimeSettingUnit();
            return defaultValue == null || defaultValue <= 0L ? Long.MAX_VALUE : PersistentGrantLifetimeHelper.convertPersistentGrantTimeSettingValueToMinutes(defaultValue, defaultUnit);
        }

        abstract Long getDefaultTimeSettingValue();

        abstract String getDefaultTimeSettingUnit();
    }

    private static class GlobalGrantTimeSetting
    extends GrantTimeSetting {
        GlobalGrantTimeSetting(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
            super(timeSettingType, timeSettingValue, timeSettingUnit);
        }

        @Override
        boolean isValidType() {
            return PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_NONE.equals(this.timeSettingType) || PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(this.timeSettingType);
        }

        @Override
        boolean isValidValue() {
            return !PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(this.timeSettingType) || ValidationUtil.isValidLong(this.timeSettingValue);
        }

        @Override
        long getTimeSettingValueInMinutes() {
            if (!this.isValid() || PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_NONE.equals(this.timeSettingType)) {
                return Long.MAX_VALUE;
            }
            long minutes = PersistentGrantLifetimeHelper.convertPersistentGrantTimeSettingValueToMinutes(Long.valueOf(this.timeSettingValue), this.timeSettingUnit);
            return minutes <= 0L ? Long.MAX_VALUE : minutes;
        }
    }

    private static abstract class GrantTimeSetting {
        String timeSettingType;
        String timeSettingValue;
        String timeSettingUnit;

        GrantTimeSetting(String timeSettingType, String timeSettingValue, String timeSettingUnit) {
            this.timeSettingType = timeSettingType;
            this.timeSettingValue = timeSettingValue;
            this.timeSettingUnit = timeSettingUnit;
        }

        abstract boolean isValidType();

        boolean isValidUnit() {
            return PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_SERVER_DEFAULT.equals(this.timeSettingType) || PersistentGrantLifetimeHelper.PERSISTENT_GRANT_SETTING_TYPE_NONE.equals(this.timeSettingType) || PersistentGrantLifetimeHelper.getPersistentGrantSettingTimeUnits().contains(this.timeSettingUnit);
        }

        abstract boolean isValidValue();

        abstract long getTimeSettingValueInMinutes();

        boolean isValid() {
            return this.isValidType() && this.isValidUnit() && this.isValidValue();
        }
    }
}

