/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RefreshTokenRollingIntervalHelper {
    public static final String REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_SECONDS = "s";
    public static final String REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_MINUTES = "m";
    public static final String REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_HOURS = "h";
    public static final String REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_DEFAULT = "h";
    public static final int REFRESH_TOKEN_ROLLING_INTERVAL_MAX_HOURS = 8760;
    public static final int REFRESH_TOKEN_ROLLING_INTERVAL_MIN = 0;
    private static final Set<String> TIME_UNITS = Set.of("s", "m", "h");

    public static long getMaxIntervalForUnit(String timeUnit) {
        if (REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_SECONDS.equalsIgnoreCase(timeUnit)) {
            return 31536000L;
        }
        if (REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_MINUTES.equalsIgnoreCase(timeUnit)) {
            return 525600L;
        }
        if ("h".equalsIgnoreCase(timeUnit)) {
            return 8760L;
        }
        throw new IllegalArgumentException("Unsupported refresh token rolling time unit: " + timeUnit);
    }

    public static long convertIntervalToMilliSeconds(long interval, String timeUnit) {
        return RefreshTokenRollingIntervalHelper.convertIntervalToSeconds(interval, timeUnit) * 1000L;
    }

    public static long convertIntervalToSeconds(long interval, String timeUnit) {
        if (REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_SECONDS.equalsIgnoreCase(timeUnit)) {
            return interval;
        }
        if (REFRESH_TOKEN_ROLLING_INTERVAL_TIME_UNIT_MINUTES.equalsIgnoreCase(timeUnit)) {
            return TimeUnit.MINUTES.toSeconds(interval);
        }
        if ("h".equalsIgnoreCase(timeUnit)) {
            return TimeUnit.HOURS.toSeconds(interval);
        }
        throw new IllegalArgumentException("Unsupported refresh token rolling time unit: " + timeUnit);
    }

    public static boolean isValidTimeUnit(String timeUnit) {
        return TIME_UNITS.contains(timeUnit);
    }
}

