/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.ScopeManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;

public class ScopeManagerImpl
implements ScopeManager,
AutoReloadable {
    private final ConfigStore config = ConfigStoreFarm.getConfig("oauth-scope-policy");
    private static final String DEFAULT_SCOPE_DESCRIPTION = "default-scope-description";
    private static final String SCOPE_DESCRIPTIONS = "scope-descriptions";
    private static final String SCOPE_GROUP_DESCRIPTIONS = "scope-group-descriptions";
    private static final String SCOPE_GROUP_MAPPINGS = "scope-group-mappings";
    private static final String EXCLUSIVE_SCOPE_DESCRIPTIONS = "exclusive-scope-descriptions";
    private static final String EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS = "exclusive-scope-group-descriptions";
    private static final String EXCLUSIVE_SCOPE_GROUP_MAPPINGS = "exclusive-scope-group-mappings";
    private static final String SCOPE_MODIFIED_TIME = "lastUpdated";
    private static final String DYNAMIC_COMMON_SCOPES = "dynamic-common-scopes";
    private static final String DYNAMIC_EXCLUSIVE_SCOPES = "dynamic-exclusive-scopes";
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\A(.+):\\d+\\Z");
    private Map<String, Set<String>> scopeGroupMappings = null;
    private Map<String, Set<String>> exclusiveScopeGroupMappings = null;
    private Map<String, Scope> configuredScopes = null;
    private Map<String, List<String>> implicitScopeGroupMappings = this.getImplicitGroupMappings(this.getScopeGroupMappings());
    private Map<String, List<String>> implicitExclusiveScopeGroupMappings = this.getImplicitGroupMappings(this.getExclusiveScopeGroupMappings());

    public ScopeManagerImpl() {
        this.initConfiguredScopes();
    }

    @Override
    public synchronized String getDefaultScopeDescription() {
        return this.config.getStringValue(DEFAULT_SCOPE_DESCRIPTION, null);
    }

    @Override
    public synchronized void setDefaultScopeDescription(String defaultScopeDescription) {
        this.saveStringValue(DEFAULT_SCOPE_DESCRIPTION, defaultScopeDescription);
    }

    @Override
    public synchronized Map<String, String> getScopeDescriptions() {
        return this.config.getMapValue(SCOPE_DESCRIPTIONS, Collections.emptyMap());
    }

    @Override
    public synchronized void setScopeDescriptions(Map<String, String> scopeDescriptions) {
        this.saveMapValue(SCOPE_DESCRIPTIONS, scopeDescriptions);
    }

    @Override
    public synchronized Set<String> getDynamicCommonScopes() {
        return new HashSet<String>(this.config.getListValue(DYNAMIC_COMMON_SCOPES, Collections.emptyList()));
    }

    @Override
    public synchronized void setDynamicCommonScopes(Set<String> dynamicScopes) {
        this.saveListValue(DYNAMIC_COMMON_SCOPES, new ArrayList<String>(dynamicScopes));
    }

    @Override
    public synchronized void addDynamicCommonScope(String scope) {
        Set<String> dynamicCommonScopes = this.getDynamicCommonScopes();
        dynamicCommonScopes.add(scope);
        this.setDynamicCommonScopes(dynamicCommonScopes);
    }

    @Override
    public synchronized boolean removeDynamicCommonScope(String scope) {
        Set<String> dynamicCommonScopes = this.getDynamicCommonScopes();
        boolean removed = dynamicCommonScopes.remove(scope);
        this.setDynamicCommonScopes(dynamicCommonScopes);
        return removed;
    }

    @Override
    public synchronized Map<String, String> getExclusiveScopeDescriptions() {
        return this.config.getMapValue(EXCLUSIVE_SCOPE_DESCRIPTIONS, Collections.emptyMap());
    }

    @Override
    public synchronized void setExclusiveScopeDescriptions(Map<String, String> scopeDescriptions) {
        this.saveMapValue(EXCLUSIVE_SCOPE_DESCRIPTIONS, scopeDescriptions);
    }

    @Override
    public synchronized Set<String> getDynamicExclusiveScopes() {
        return new HashSet<String>(this.config.getListValue(DYNAMIC_EXCLUSIVE_SCOPES, Collections.emptyList()));
    }

    @Override
    public synchronized void setDynamicExclusiveScopes(Set<String> dynamicScopes) {
        this.saveListValue(DYNAMIC_EXCLUSIVE_SCOPES, new ArrayList<String>(dynamicScopes));
    }

    @Override
    public synchronized void addDynamicExclusiveScope(String scope) {
        Set<String> dynamicExclusiveScopes = this.getDynamicExclusiveScopes();
        dynamicExclusiveScopes.add(scope);
        this.setDynamicExclusiveScopes(dynamicExclusiveScopes);
    }

    @Override
    public synchronized boolean removeDynamicExclusiveScope(String scope) {
        Set<String> dynamicExclusiveScopes = this.getDynamicExclusiveScopes();
        boolean removed = dynamicExclusiveScopes.remove(scope);
        this.setDynamicExclusiveScopes(dynamicExclusiveScopes);
        return removed;
    }

    @Override
    public synchronized Map<String, String> getScopeGroupDescriptions() {
        return this.config.getMapValue(SCOPE_GROUP_DESCRIPTIONS, Collections.emptyMap());
    }

    @Override
    public synchronized void setScopeGroupDescriptions(Map<String, String> scopeGroupDescriptions) {
        this.saveMapValue(SCOPE_GROUP_DESCRIPTIONS, scopeGroupDescriptions);
    }

    @Override
    public synchronized Map<String, String> getExclusiveScopeGroupDescriptions() {
        return this.config.getMapValue(EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS, Collections.emptyMap());
    }

    @Override
    public synchronized void setExclusiveScopeGroupDescriptions(Map<String, String> scopeGroupDescriptions) {
        this.saveMapValue(EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS, scopeGroupDescriptions);
    }

    @Override
    public synchronized Map<String, Set<String>> getScopeGroupMappings() {
        if (this.scopeGroupMappings == null) {
            this.scopeGroupMappings = ScopeManagerImpl.deserializeGroupMappings(this.config.getMapValue(SCOPE_GROUP_MAPPINGS, Collections.emptyMap()));
        }
        return new HashMap<String, Set<String>>(this.scopeGroupMappings);
    }

    @Override
    public synchronized void setScopeGroupMappings(Map<String, Set<String>> mappings) {
        this.saveMapValue(SCOPE_GROUP_MAPPINGS, ScopeManagerImpl.serializeGroupMappings(mappings));
    }

    @Override
    public synchronized Map<String, Set<String>> getExclusiveScopeGroupMappings() {
        if (this.exclusiveScopeGroupMappings == null) {
            this.exclusiveScopeGroupMappings = ScopeManagerImpl.deserializeGroupMappings(this.config.getMapValue(EXCLUSIVE_SCOPE_GROUP_MAPPINGS, Collections.emptyMap()));
        }
        return new HashMap<String, Set<String>>(this.exclusiveScopeGroupMappings);
    }

    @Override
    public synchronized void setExclusiveScopeGroupMappings(Map<String, Set<String>> mappings) {
        this.saveMapValue(EXCLUSIVE_SCOPE_GROUP_MAPPINGS, ScopeManagerImpl.serializeGroupMappings(mappings));
    }

    static Map<String, String> serializeGroupMappings(Map<String, Set<String>> groups) {
        HashMap<String, String> scopeGroups = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : groups.entrySet()) {
            String groupName = entry.getKey();
            ScopeManagerImpl.serializeGroupScopes(scopeGroups, entry.getValue(), groupName);
        }
        return scopeGroups;
    }

    private static void serializeGroupScopes(Map<String, String> scopeGroups, Set<String> scopes, String groupName) {
        if (scopes == null) {
            return;
        }
        Iterator<String> it = scopes.iterator();
        int index = 1;
        while (it.hasNext()) {
            String key = groupName + ":" + index++;
            scopeGroups.put(key, it.next());
        }
    }

    static Map<String, Set<String>> deserializeGroupMappings(Map<String, String> entries) {
        HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            Matcher matcher = GROUP_PATTERN.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            String groupName = matcher.group(1);
            if (!groups.containsKey(groupName)) {
                groups.put(groupName, new HashSet());
            }
            ((Set)groups.get(groupName)).add(entry.getValue());
        }
        return groups;
    }

    static Map<String, String> removeGroupSerializeMappings(Map<String, String> entries, String groupName) {
        HashMap<String, String> groups = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            String name;
            Matcher matcher = GROUP_PATTERN.matcher(entry.getKey());
            if (!matcher.matches() || groupName.equals(name = matcher.group(1))) continue;
            groups.put(entry.getKey(), entry.getValue());
        }
        return groups;
    }

    static Map<String, String> updateSerializeGroupMappings(Map<String, String> entries, String groupName, Set<String> newScopes) {
        HashMap<String, String> groups = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            String name;
            Matcher matcher = GROUP_PATTERN.matcher(entry.getKey());
            if (!matcher.matches() || groupName.equals(name = matcher.group(1))) continue;
            groups.put(entry.getKey(), entry.getValue());
        }
        ScopeManagerImpl.serializeGroupScopes(groups, newScopes, groupName);
        return groups;
    }

    @Override
    public synchronized Date getLastModified() {
        Long value = this.config.getLongValue(SCOPE_MODIFIED_TIME, 0L);
        return new Date(value);
    }

    private synchronized void saveMapValue(String name, Map<String, String> mappings) {
        this.config.setMapValue(name, mappings);
        this.config.setLongValue(SCOPE_MODIFIED_TIME, Calendar.getInstance().getTimeInMillis());
        if (SCOPE_DESCRIPTIONS.equals(name) || SCOPE_GROUP_DESCRIPTIONS.equals(name) || EXCLUSIVE_SCOPE_DESCRIPTIONS.equals(name) || EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS.equals(name)) {
            this.configuredScopes = null;
        } else if (SCOPE_GROUP_MAPPINGS.equals(name) || EXCLUSIVE_SCOPE_GROUP_MAPPINGS.equals(name)) {
            this.scopeGroupMappings = null;
            this.exclusiveScopeGroupMappings = null;
            this.implicitScopeGroupMappings = null;
            this.implicitExclusiveScopeGroupMappings = null;
        }
        this.clearClientsCache();
    }

    private synchronized void saveListValue(String name, List<String> list) {
        this.config.setListValue(name, list);
        this.config.setLongValue(SCOPE_MODIFIED_TIME, Calendar.getInstance().getTimeInMillis());
        this.clearClientsCache();
    }

    private void clearClientsCache() {
        MgmtFactory.getSingleThreadedExecutor().execute(() -> MgmtFactory.getClientManager().reload());
    }

    private synchronized void saveStringValue(String name, String value) {
        this.config.setStringValue(name, value);
        this.config.setLongValue(SCOPE_MODIFIED_TIME, Calendar.getInstance().getTimeInMillis());
    }

    private synchronized void addScope(String name, String description, boolean isCommon) {
        String key = isCommon ? SCOPE_DESCRIPTIONS : EXCLUSIVE_SCOPE_DESCRIPTIONS;
        Map existingScopes = this.config.getMapValue(key, Collections.emptyMap());
        HashMap<String, String> newScopes = new HashMap<String, String>(existingScopes);
        newScopes.put(name, description);
        this.saveMapValue(key, newScopes);
    }

    private synchronized void removeScope(String name, boolean isCommon) {
        String groupKey;
        String key;
        if (isCommon) {
            key = SCOPE_DESCRIPTIONS;
            groupKey = SCOPE_GROUP_MAPPINGS;
        } else {
            key = EXCLUSIVE_SCOPE_DESCRIPTIONS;
            groupKey = EXCLUSIVE_SCOPE_GROUP_MAPPINGS;
        }
        Map existingScopes = this.config.getMapValue(key, Collections.emptyMap());
        HashMap<String, String> newScopes = new HashMap<String, String>(existingScopes);
        newScopes.remove(name);
        Map groupScopes = this.config.getMapValue(groupKey, Collections.emptyMap());
        HashMap<String, String> newScopeGroups = new HashMap<String, String>(groupScopes);
        newScopeGroups.values().removeIf(val -> name.equals(val));
        this.saveMapValue(key, newScopes);
        this.saveMapValue(groupKey, newScopeGroups);
    }

    private synchronized void updateScope(String name, String description, boolean isCommon) {
        String key = isCommon ? SCOPE_DESCRIPTIONS : EXCLUSIVE_SCOPE_DESCRIPTIONS;
        Map existingScopes = this.config.getMapValue(key, Collections.emptyMap());
        HashMap<String, String> newScopes = new HashMap<String, String>(existingScopes);
        if (newScopes.containsKey(name)) {
            newScopes.put(name, description);
            this.saveMapValue(key, newScopes);
        }
    }

    private synchronized void addScopeGroup(String name, String description, Set<String> scopeNames, boolean isCommon) {
        String scopeMapKey;
        String descKey;
        if (isCommon) {
            descKey = SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = SCOPE_GROUP_MAPPINGS;
        } else {
            descKey = EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = EXCLUSIVE_SCOPE_GROUP_MAPPINGS;
        }
        Map existingDesc = this.config.getMapValue(descKey, Collections.emptyMap());
        HashMap<String, String> newDescs = new HashMap<String, String>(existingDesc);
        newDescs.put(name, description);
        this.saveMapValue(descKey, newDescs);
        Map scopes = this.config.getMapValue(scopeMapKey, Collections.emptyMap());
        HashMap<String, String> newScopes = new HashMap<String, String>(scopes);
        ScopeManagerImpl.serializeGroupScopes(newScopes, scopeNames, name);
        this.saveMapValue(scopeMapKey, newScopes);
    }

    private synchronized void removeScopeGroup(String name, boolean isCommon) {
        String scopeMapKey;
        String descKey;
        if (isCommon) {
            descKey = SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = SCOPE_GROUP_MAPPINGS;
        } else {
            descKey = EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = EXCLUSIVE_SCOPE_GROUP_MAPPINGS;
        }
        Map existingDesc = this.config.getMapValue(descKey, Collections.emptyMap());
        HashMap<String, String> newDesc = new HashMap<String, String>(existingDesc);
        newDesc.remove(name);
        this.saveMapValue(descKey, newDesc);
        Map existingScopes = this.config.getMapValue(scopeMapKey, Collections.emptyMap());
        HashMap<String, String> newScopes = new HashMap<String, String>(existingScopes);
        this.saveMapValue(scopeMapKey, ScopeManagerImpl.removeGroupSerializeMappings(newScopes, name));
    }

    private synchronized void updateScopeGroup(String name, String description, Set<String> scopeNames, boolean isCommon) {
        String scopeMapKey;
        String descKey;
        if (isCommon) {
            descKey = SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = SCOPE_GROUP_MAPPINGS;
        } else {
            descKey = EXCLUSIVE_SCOPE_GROUP_DESCRIPTIONS;
            scopeMapKey = EXCLUSIVE_SCOPE_GROUP_MAPPINGS;
        }
        Map existingDesc = this.config.getMapValue(descKey, Collections.emptyMap());
        HashMap<String, String> newDesc = new HashMap<String, String>(existingDesc);
        if (newDesc.containsKey(name)) {
            newDesc.put(name, description);
            this.saveMapValue(descKey, newDesc);
            Map scopes = this.config.getMapValue(scopeMapKey, Collections.emptyMap());
            this.saveMapValue(scopeMapKey, ScopeManagerImpl.updateSerializeGroupMappings(scopes, name, scopeNames));
        }
    }

    @Override
    public synchronized void addCommonScope(String name, String description) {
        this.addScope(name, description, true);
    }

    @Override
    public synchronized void removeCommonScope(String name) {
        this.removeScope(name, true);
    }

    @Override
    public synchronized void updateCommonScope(String name, String description) {
        this.updateScope(name, description, true);
    }

    @Override
    public synchronized void addExclusiveScope(String name, String description) {
        this.addScope(name, description, false);
    }

    @Override
    public synchronized void removeExclusiveScope(String name) {
        this.removeScope(name, false);
    }

    @Override
    public synchronized void updateExclusiveScope(String name, String description) {
        this.updateScope(name, description, false);
    }

    @Override
    public synchronized void addCommonScopeGroup(String name, String description, Set<String> scopes) {
        this.addScopeGroup(name, description, scopes, true);
    }

    @Override
    public synchronized void removeCommonScopeGroup(String name) {
        this.removeScopeGroup(name, true);
    }

    @Override
    public synchronized void updateCommonScopeGroup(String name, String description, Set<String> scopes) {
        this.updateScopeGroup(name, description, scopes, true);
    }

    @Override
    public synchronized void addExclusiveScopeGroup(String name, String description, Set<String> scopes) {
        this.addScopeGroup(name, description, scopes, false);
    }

    @Override
    public synchronized void removeExclusiveScopeGroup(String name) {
        this.removeScopeGroup(name, false);
    }

    @Override
    public synchronized void updateExclusiveScopeGroup(String name, String description, Set<String> scopes) {
        this.updateScopeGroup(name, description, scopes, false);
    }

    private synchronized void initConfiguredScopes() {
        this.configuredScopes = new HashMap<String, Scope>();
        for (String scopeStr : this.getScopeDescriptions().keySet()) {
            this.configuredScopes.put(scopeStr, new Scope(scopeStr));
        }
        for (String scopeGroupStr : this.getScopeGroupDescriptions().keySet()) {
            this.configuredScopes.put(scopeGroupStr, new Scope(scopeGroupStr));
        }
        for (String exclusiveScopeStr : this.getExclusiveScopeDescriptions().keySet()) {
            this.configuredScopes.put(exclusiveScopeStr, new Scope(exclusiveScopeStr));
        }
        for (String exclusiveScopeGroupStr : this.getExclusiveScopeGroupDescriptions().keySet()) {
            this.configuredScopes.put(exclusiveScopeGroupStr, new Scope(exclusiveScopeGroupStr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scope getScope(String scopeStr) {
        ScopeManagerImpl scopeManagerImpl = this;
        synchronized (scopeManagerImpl) {
            if (this.configuredScopes == null) {
                this.initConfiguredScopes();
            }
            if (this.configuredScopes.containsKey(scopeStr)) {
                return this.configuredScopes.get(scopeStr);
            }
        }
        return new Scope(scopeStr);
    }

    @Override
    public synchronized List<String> getImplicitScopeGroups(String scopeGroup) {
        if (this.implicitScopeGroupMappings == null) {
            this.implicitScopeGroupMappings = this.getImplicitGroupMappings(this.getScopeGroupMappings());
        }
        if (this.implicitScopeGroupMappings.containsKey(scopeGroup)) {
            return new ArrayList<String>((Collection)this.implicitScopeGroupMappings.get(scopeGroup));
        }
        return Collections.emptyList();
    }

    private synchronized Map<String, List<String>> getImplicitGroupMappings(Map<String, Set<String>> mappings) {
        HashMap<String, List<String>> implicitMappings = new HashMap<String, List<String>>();
        for (Map.Entry<String, Set<String>> scopeGroup1 : mappings.entrySet()) {
            for (Map.Entry<String, Set<String>> scopeGroup2 : mappings.entrySet()) {
                if (scopeGroup1.getKey().equals(scopeGroup2.getKey()) || !scopeGroup1.getValue().containsAll((Collection)scopeGroup2.getValue())) continue;
                if (!implicitMappings.containsKey(scopeGroup1.getKey())) {
                    implicitMappings.put(scopeGroup1.getKey(), new ArrayList());
                }
                ((List)implicitMappings.get(scopeGroup1.getKey())).add(scopeGroup2.getKey());
            }
        }
        return implicitMappings;
    }

    @Override
    public synchronized List<String> getImplicitExclusiveScopeGroups(String exclusiveScopeGroup) {
        if (this.implicitExclusiveScopeGroupMappings == null) {
            this.implicitExclusiveScopeGroupMappings = this.getImplicitGroupMappings(this.getExclusiveScopeGroupMappings());
        }
        if (this.implicitExclusiveScopeGroupMappings.containsKey(exclusiveScopeGroup)) {
            return new ArrayList<String>((Collection)this.implicitExclusiveScopeGroupMappings.get(exclusiveScopeGroup));
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized SearchResult<String> searchScopes(SearchCriteria searchCriteria, boolean isCommon, boolean includeDefaultOpenId) {
        Set<String> scopes;
        Set<String> set = scopes = isCommon ? this.getScopeDescriptions().keySet() : this.getExclusiveScopeDescriptions().keySet();
        if (isCommon && includeDefaultOpenId) {
            scopes = new HashSet<String>(scopes);
            scopes.add("openid");
        }
        return this.searchScopes(scopes, searchCriteria);
    }

    @Override
    public synchronized SearchResult<String> searchScopeGroups(SearchCriteria searchCriteria, boolean isCommon) {
        Set<String> scopes = isCommon ? this.getScopeGroupDescriptions().keySet() : this.getExclusiveScopeGroupDescriptions().keySet();
        return this.searchScopes(scopes, searchCriteria);
    }

    private SearchResult<String> searchScopes(Set<String> scopes, SearchCriteria searchCriteria) {
        List searchResult = scopes.parallelStream().filter(scopeName -> !StringUtils.isNotEmpty((String)searchCriteria.getQuery()) || scopeName.toLowerCase().contains(searchCriteria.getQuery().toLowerCase())).sorted(SearchCriteria.Order.DESC.equals((Object)searchCriteria.getOrder()) ? String.CASE_INSENSITIVE_ORDER.reversed() : String::compareToIgnoreCase).collect(Collectors.toList());
        if (searchCriteria.getStartIndex() >= searchResult.size()) {
            return new SearchResult<String>(searchCriteria.getStartIndex(), Collections.emptyList(), searchResult.size());
        }
        int searchEndIndex = Math.min(searchCriteria.getStartIndex() + searchCriteria.getItemsRequested(), searchResult.size());
        List scopesResult = searchResult.subList(searchCriteria.getStartIndex(), searchEndIndex);
        return new SearchResult<String>(searchCriteria.getStartIndex(), scopesResult, searchResult.size());
    }
}

