/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.InvalidDynamicScopeException;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ScopeUtil {
    private ScopeUtil() {
    }

    public static void validateRequestedScope(Scope requestedScope, Client client) throws InvalidRequestedScopeException {
        block5: {
            block4: {
                if (client.isRestrictScopes() && client.getRestrictedScopes().size() == 0 && requestedScope.getScopeSet().size() > 0 && client.getExclusiveScopes().size() == 0) {
                    String msg = "The client contains a restricted scope. Only the default scope can be requested";
                    throw new InvalidRequestedScopeException(msg);
                }
                Scope localScope = ScopeUtil.getSupportedLocalScope(client, requestedScope);
                Set dynamicScopeSet = Stream.concat(MgmtFactory.getScopeManager().getDynamicCommonScopes().stream(), MgmtFactory.getScopeManager().getDynamicExclusiveScopes().stream()).collect(Collectors.toSet());
                if (!requestedScope.isEqualOrLesserThan(localScope) || ScopeUtil.isRequestedScopeContainScopeGroupsNotExplicitlyAllowed(requestedScope.getScopeSet(), localScope.getScopeSet())) break block4;
                if (!requestedScope.expanded().getScopeSet().stream().anyMatch(dynamicScopeSet::contains)) break block5;
            }
            String msg = "The requested scope is invalid, unknown, malformed, or exceeds that which the client is permitted to request.";
            throw new InvalidRequestedScopeException(msg);
        }
    }

    private static boolean isRequestedScopeContainScopeGroupsNotExplicitlyAllowed(Set<String> requestedScopeSet, Set<String> explicitlyAllowedScopeSet) {
        Set allScopeGroups = Stream.concat(ScopeUtil.getCommonScopeGroupDescriptions().keySet().stream(), ScopeUtil.getExclusiveScopeGroupDescriptions().keySet().stream()).collect(Collectors.toSet());
        for (String requested : requestedScopeSet) {
            if (!allScopeGroups.contains(requested) || explicitlyAllowedScopeSet.contains(requested)) continue;
            return true;
        }
        return false;
    }

    public static Scope getSupportedLocalScope(Client client) {
        return ScopeUtil.getSupportedLocalScope(client, null);
    }

    public static Scope getSupportedLocalScope(Client client, Scope requestedScope) {
        Set<String> allScopeGroups = Stream.concat(ScopeUtil.getCommonScopeGroupDescriptions().keySet().stream(), ScopeUtil.getExclusiveScopeGroupDescriptions().keySet().stream()).collect(Collectors.toSet());
        Set<String> allStaticScopes = Stream.concat(ScopeUtil.getStaticCommonScopeDescriptions().keySet().stream(), ScopeUtil.getStaticExclusiveScopeDescriptions().keySet().stream()).collect(Collectors.toSet());
        Set<String> allDynamicScopes = Stream.concat(ScopeUtil.getDynamicCommonScopeDescriptions().keySet().stream(), ScopeUtil.getDynamicExclusiveScopeDescriptions().keySet().stream()).collect(Collectors.toSet());
        HashSet<String> supportedScopes = new HashSet<String>(ScopeUtil.getAllCommonScopeDescriptions().keySet());
        HashSet<String> supportedScopeGroups = new HashSet<String>(ScopeUtil.getCommonScopeGroupDescriptions().keySet());
        if (client.isRestrictScopes()) {
            supportedScopes.retainAll(client.getRestrictedScopes());
            supportedScopeGroups.retainAll(client.getRestrictedScopes());
        }
        if (client.isAllowedExclusiveScopes()) {
            for (String string : client.getExclusiveScopes()) {
                if (!allScopeGroups.contains(string)) {
                    supportedScopes.add(string);
                    continue;
                }
                supportedScopeGroups.add(string);
            }
        }
        if (!supportedScopeGroups.isEmpty()) {
            HashSet<String> implicitlyAllowedScopeGroups = new HashSet<String>();
            for (String supportedScopeGroup : supportedScopeGroups) {
                implicitlyAllowedScopeGroups.addAll(MgmtFactory.getScopeManager().getImplicitScopeGroups(supportedScopeGroup));
                implicitlyAllowedScopeGroups.addAll(MgmtFactory.getScopeManager().getImplicitExclusiveScopeGroups(supportedScopeGroup));
            }
            supportedScopeGroups.addAll(implicitlyAllowedScopeGroups);
        }
        if (requestedScope != null) {
            if (!client.isAllowedExclusiveScopes()) {
                allStaticScopes.removeAll(ScopeUtil.getStaticExclusiveScopeDescriptions().keySet());
                allScopeGroups.removeAll(ScopeUtil.getExclusiveScopeGroupDescriptions().keySet());
                allDynamicScopes.removeAll(ScopeUtil.getDynamicExclusiveScopeDescriptions().keySet());
            }
            for (String string : requestedScope.getScopeSet()) {
                String bestMatch = ScopeUtil.getBestMatchingScope(allStaticScopes, allScopeGroups, allDynamicScopes, string);
                if (supportedScopes.contains(bestMatch) || supportedScopeGroups.contains(bestMatch)) continue;
                supportedScopes.removeIf(supported -> Scope.getScope((String)requested).hasAllScopes(Scope.getScope((String)supported)));
            }
        }
        return new Scope(Stream.concat(supportedScopes.stream(), supportedScopeGroups.stream()).collect(Collectors.toSet()));
    }

    private static String getBestMatchingScope(Set<String> staticScopes, Set<String> scopeGroups, Set<String> dynamicScopes, String requestedScope) {
        if (staticScopes.contains(requestedScope)) {
            return requestedScope;
        }
        if (scopeGroups.contains(requestedScope)) {
            return requestedScope;
        }
        DynamicScope bestMatchedDynamicScope = DynamicScope.getBestMatchingDynamicScope(dynamicScopes, requestedScope);
        return bestMatchedDynamicScope != null ? bestMatchedDynamicScope.dynamicScope : null;
    }

    public static Map<String, String> getDescriptionsForRequestedScope(Client client, Scope requestedScope, Locale locale) {
        LanguagePackMessages languagePackMessages = new LanguagePackMessages("pingfederate-messages", locale);
        LinkedHashMap<String, String> requestedDescriptions = new LinkedHashMap<String, String>();
        HashSet supportedScopes = new HashSet();
        if (client != null) {
            Scope supportedLocalScope = ScopeUtil.getSupportedLocalScope(client, requestedScope);
            supportedScopes.addAll(supportedLocalScope.getScopeSet());
            supportedScopes.addAll(supportedLocalScope.expanded().getScopeSet());
        }
        Scope supportedScope = new Scope(supportedScopes);
        Map<String, String> staticCommonScopeDescriptions = ScopeUtil.getFilteredScopeDescriptions(ScopeUtil.getStaticCommonScopeDescriptions(), entry -> supportedScopes.contains(entry.getKey()));
        Map<String, String> staticExclusivesScopeDescriptions = ScopeUtil.getFilteredScopeDescriptions(ScopeUtil.getStaticExclusiveScopeDescriptions(), entry -> supportedScopes.contains(entry.getKey()));
        Map<String, String> scopeGroupDescriptions = ScopeUtil.getFilteredScopeDescriptions(ScopeUtil.getCommonScopeGroupDescriptions(), entry -> supportedScope.hasAllScopes(Scope.getScope((String)((String)entry.getKey()))));
        Map<String, String> exclusiveScopeGroupDescriptions = ScopeUtil.getFilteredScopeDescriptions(ScopeUtil.getExclusiveScopeGroupDescriptions(), entry -> supportedScope.hasAllScopes(Scope.getScope((String)((String)entry.getKey()))));
        Map<String, String> dynamicScopeDescriptions = ScopeUtil.getFilteredScopeDescriptions(Stream.concat(ScopeUtil.getDynamicCommonScopeDescriptions().entrySet().stream(), ScopeUtil.getDynamicExclusiveScopeDescriptions().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), entry -> supportedScopes.contains(entry.getKey()));
        ScopeUtil.updateRequestedDescriptions(requestedScope, requestedDescriptions, staticCommonScopeDescriptions, languagePackMessages);
        ScopeUtil.updateRequestedDescriptions(requestedScope, requestedDescriptions, staticExclusivesScopeDescriptions, languagePackMessages);
        ScopeUtil.updateRequestedDescriptions(requestedScope, requestedDescriptions, scopeGroupDescriptions, languagePackMessages);
        ScopeUtil.updateRequestedDescriptions(requestedScope, requestedDescriptions, exclusiveScopeGroupDescriptions, languagePackMessages);
        for (String requestedScopeValue : requestedScope.getScopeSet()) {
            String bestMatchingDynamicScopeDescription = DynamicScope.getBestMatchingDynamicScopeDescription(dynamicScopeDescriptions, requestedScopeValue, languagePackMessages);
            if (bestMatchingDynamicScopeDescription == null) continue;
            requestedDescriptions.putIfAbsent(requestedScopeValue, bestMatchingDynamicScopeDescription);
        }
        return requestedDescriptions;
    }

    private static Map<String, String> getFilteredScopeDescriptions(Map<String, String> scopeDescriptions, Predicate<Map.Entry<String, String>> filterPredicate) {
        return scopeDescriptions.entrySet().stream().filter(filterPredicate).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void updateRequestedDescriptions(Scope requestedScope, Map<String, String> requestedScopeDescriptions, Map<String, String> supportedScopeDescriptions, LanguagePackMessages languagePackMessages) {
        for (String scopeValue : requestedScope.getScopeSet()) {
            if (!supportedScopeDescriptions.containsKey(scopeValue)) continue;
            requestedScopeDescriptions.put(scopeValue, languagePackMessages.getMessage(supportedScopeDescriptions.get(scopeValue)));
        }
    }

    public static String getDefaultScopeDescription(Locale locale) {
        LanguagePackMessages languagePackMessages = new LanguagePackMessages("pingfederate-messages", locale);
        return StringUtils.isNotBlank((String)MgmtFactory.getScopeManager().getDefaultScopeDescription()) ? MgmtFactory.getScopeManager().getDefaultScopeDescription() : languagePackMessages.getMessage("oauth.approval.page.template.defaultScopeDescription");
    }

    public static Map<String, String> getAllCommonScopeDescriptions() {
        Map<String, String> scopeDescriptions = MgmtFactory.getScopeManager().getScopeDescriptions();
        if (MgmtFactory.getOIDCProviderPolicyManager().getPolicy().isEnabled() && !ScopeUtil.getAllExclusiveScopeDescriptions().containsKey("openid") && !scopeDescriptions.containsKey("openid")) {
            scopeDescriptions = new LinkedHashMap<String, String>(scopeDescriptions);
            scopeDescriptions.put("openid", "Sign in with OpenID Connect");
        }
        return scopeDescriptions;
    }

    public static Map<String, String> getAllExclusiveScopeDescriptions() {
        return MgmtFactory.getScopeManager().getExclusiveScopeDescriptions();
    }

    public static Map<String, String> getStaticCommonScopeDescriptions() {
        Set<String> dynamicScopes = MgmtFactory.getScopeManager().getDynamicCommonScopes();
        return ScopeUtil.getAllCommonScopeDescriptions().entrySet().stream().filter(entry -> !dynamicScopes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getStaticExclusiveScopeDescriptions() {
        Set<String> dynamicScopes = MgmtFactory.getScopeManager().getDynamicExclusiveScopes();
        return ScopeUtil.getAllExclusiveScopeDescriptions().entrySet().stream().filter(entry -> !dynamicScopes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getDynamicCommonScopeDescriptions() {
        Set<String> dynamicScopes = MgmtFactory.getScopeManager().getDynamicCommonScopes();
        return ScopeUtil.getAllCommonScopeDescriptions().entrySet().stream().filter(entry -> dynamicScopes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getDynamicExclusiveScopeDescriptions() {
        Set<String> dynamicScopes = MgmtFactory.getScopeManager().getDynamicExclusiveScopes();
        return ScopeUtil.getAllExclusiveScopeDescriptions().entrySet().stream().filter(entry -> dynamicScopes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getCommonScopeGroupDescriptions() {
        return MgmtFactory.getScopeManager().getScopeGroupDescriptions();
    }

    public static Map<String, String> getExclusiveScopeGroupDescriptions() {
        return MgmtFactory.getScopeManager().getExclusiveScopeGroupDescriptions();
    }

    public static Set<String> getScopeAndGroupNames() {
        HashSet<String> scopeAndGroups = new HashSet<String>();
        scopeAndGroups.addAll(ScopeUtil.getAllCommonScopeDescriptions().keySet());
        scopeAndGroups.addAll(ScopeUtil.getCommonScopeGroupDescriptions().keySet());
        return scopeAndGroups;
    }

    public static Set<String> getExclusiveScopeAndGroupNames() {
        HashSet<String> scopeAndGroups = new HashSet<String>();
        scopeAndGroups.addAll(ScopeUtil.getAllExclusiveScopeDescriptions().keySet());
        scopeAndGroups.addAll(ScopeUtil.getExclusiveScopeGroupDescriptions().keySet());
        return scopeAndGroups;
    }

    public static Set<String> getAllScopeNames() {
        HashSet<String> allNames = new HashSet<String>();
        allNames.addAll(ScopeUtil.getScopeAndGroupNames());
        allNames.addAll(ScopeUtil.getExclusiveScopeAndGroupNames());
        return allNames;
    }

    public static class DynamicScope {
        private String dynamicScope;
        private String prefix = "";
        private String suffix = "";
        private Pattern pattern;

        private DynamicScope(String dynamicScope) {
            if (!DynamicScope.isValid(dynamicScope)) {
                throw new InvalidDynamicScopeException("A dynamic scope value must contain one and only wildcard and must either be prefixed, suffixed (or both) by static part.");
            }
            this.dynamicScope = dynamicScope;
            String[] parsed = dynamicScope.split("\\*");
            String string = this.prefix = dynamicScope.startsWith("*") ? "" : parsed[0];
            this.suffix = dynamicScope.startsWith("*") ? parsed[1] : (dynamicScope.endsWith("*") ? "" : parsed[1]);
            this.pattern = Pattern.compile("^" + Pattern.quote(this.prefix) + "(.+)" + Pattern.quote(this.suffix) + "$");
        }

        public static boolean isValid(String scope) {
            return !DynamicScope.isWildcardOnly(scope) && DynamicScope.containOnlyOneWildcard(scope);
        }

        public static boolean validateRequestedScope(String dynamicScope, String requestedScope) {
            return DynamicScope.validateRequestedScope(Stream.of(dynamicScope).collect(Collectors.toSet()), requestedScope);
        }

        public static boolean validateRequestedScope(Set<String> dynamicScopeSet, String requestedScope) {
            return dynamicScopeSet != null && !dynamicScopeSet.isEmpty() && dynamicScopeSet.stream().anyMatch(dynamicScope -> new DynamicScope((String)dynamicScope).validate(requestedScope));
        }

        public static String getBestMatchingDynamicScopeDescription(Map<String, String> dynamicScopeDescriptions, String requestedScope, LanguagePackMessages languagePackMessages) {
            DynamicScope bestMatch = DynamicScope.getBestMatchingDynamicScope(dynamicScopeDescriptions.keySet(), requestedScope);
            return bestMatch == null ? null : bestMatch.getDynamicDescription(requestedScope, dynamicScopeDescriptions.get(bestMatch.dynamicScope), languagePackMessages);
        }

        public static String getBestMatchingDynamicScopeValue(Set<String> dynamicScopes, String requestedScope) {
            DynamicScope bestMatch = DynamicScope.getBestMatchingDynamicScope(dynamicScopes, requestedScope);
            return bestMatch == null ? "" : bestMatch.dynamicScope;
        }

        private static DynamicScope getBestMatchingDynamicScope(Set<String> dynamicScopes, String requestedScope) {
            List matchingDynamicScopes = dynamicScopes.stream().map(DynamicScope::new).filter(dynamicScope -> dynamicScope.validate(requestedScope)).sorted((scope1, scope2) -> {
                if (scope1.dynamicScope.length() != scope2.dynamicScope.length()) {
                    return scope2.dynamicScope.length() - scope1.dynamicScope.length();
                }
                return scope2.prefix.length() - scope1.prefix.length();
            }).collect(Collectors.toList());
            return matchingDynamicScopes.isEmpty() ? null : (DynamicScope)matchingDynamicScopes.get(0);
        }

        public static boolean containsAll(Set<String> pfDynamicScopeSets, Set<String> requestedScopeSet) {
            for (String scopeB : requestedScopeSet) {
                boolean hasValidPair = false;
                for (String scopeA : pfDynamicScopeSets) {
                    if (!DynamicScope.isValidDynamicPair(scopeA, scopeB)) continue;
                    hasValidPair = true;
                    break;
                }
                if (hasValidPair) continue;
                return false;
            }
            return true;
        }

        public static boolean isValidDynamicPair(String pfDynamicScope, String requestedScope) {
            return DynamicScope.isValid(pfDynamicScope) && new DynamicScope(pfDynamicScope).validate(requestedScope);
        }

        private String getDynamicDescription(String scopeValue, String description, LanguagePackMessages languagePackMessages) {
            description = languagePackMessages.getMessage(description);
            return description.replaceAll("\\$\\{scope}", scopeValue).replaceAll("\\$\\{scope-var}", this.getMatchingDynamicPart(scopeValue));
        }

        private String getMatchingDynamicPart(String scopeValue) {
            Matcher matcher = this.pattern.matcher(scopeValue);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return "";
        }

        private boolean validate(String requestedScopeValue) {
            return this.pattern.matcher(requestedScopeValue).matches();
        }

        private static boolean isWildcardOnly(String dynamicScope) {
            return dynamicScope.equals("*");
        }

        private static boolean containOnlyOneWildcard(String dynamicScope) {
            return dynamicScope.length() - dynamicScope.replace("*", "").length() == 1;
        }
    }
}

