/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SupplementalInfoHelper {
    private static final Pattern PATTERN = Pattern.compile("([1-9][0-9]*):(.*)");
    private static final Pattern CHUNKED_PATTERN = Pattern.compile("([1-9][0-9]*):((.*)__([0-9][0-9][0-9])):(.*)");

    private SupplementalInfoHelper() {
    }

    public static String encode(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        int keyLength = key.length();
        return String.format("%s:%s:%s", keyLength, key, value);
    }

    public static List<String> encode(String key, String value, int maxLength) {
        boolean chunkRequired;
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        int keyLength = key.length();
        String encodedKey = String.format("%s:%s", keyLength, key);
        int valueLength = value != null ? value.length() : 5;
        boolean bl = chunkRequired = encodedKey.length() + 1 + valueLength > maxLength;
        if (chunkRequired) {
            ArrayList<String> result = new ArrayList<String>();
            int chunkKeyLength = keyLength + 2 + 3;
            int bufferForLeyLengthStorage = SupplementalInfoHelper.getIntegerLength(chunkKeyLength) + 1 + chunkKeyLength + 1;
            int chunkSize = maxLength - bufferForLeyLengthStorage;
            int chunks = valueLength / chunkSize + 1;
            for (int i = 0; i < chunks; ++i) {
                int beginIndex = i * chunkSize;
                int endIndex = (i + 1) * chunkSize;
                if (endIndex >= valueLength) {
                    endIndex = valueLength;
                }
                result.add(String.format("%d:%s__%03d:%s", chunkKeyLength, key, i, value.substring(beginIndex, endIndex)));
            }
            return result;
        }
        return Collections.singletonList(SupplementalInfoHelper.encode(key, value));
    }

    public static String[] decode(String encodedSupplementalInfo) {
        if (!SupplementalInfoHelper.validateEncodedSupplementalInfoValue(encodedSupplementalInfo)) {
            return null;
        }
        int firstColonIndex = encodedSupplementalInfo.indexOf(":");
        int keyLength = Integer.parseInt(encodedSupplementalInfo.substring(0, firstColonIndex));
        int keyStartIndex = firstColonIndex + 1;
        int keyEndIndex = keyStartIndex + keyLength;
        String key = encodedSupplementalInfo.substring(keyStartIndex, keyEndIndex);
        int valueStartIndex = keyEndIndex + 1;
        String value = encodedSupplementalInfo.substring(valueStartIndex);
        return new String[]{key, value};
    }

    public static Map<String, String> decode(List<String> encodedValues) {
        if (encodedValues == null || encodedValues.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap chunkEntries = new HashMap();
        for (String string : encodedValues) {
            Matcher chunkedPatternMatcher = CHUNKED_PATTERN.matcher(string);
            if (chunkedPatternMatcher.matches()) {
                int nameLength = Integer.parseInt(chunkedPatternMatcher.group(1));
                String fullName = chunkedPatternMatcher.group(2);
                String name = chunkedPatternMatcher.group(3);
                int chunkIndex = Integer.parseInt(chunkedPatternMatcher.group(4));
                String value = chunkedPatternMatcher.group(5);
                if (fullName == null || fullName.length() != nameLength) continue;
                chunkEntries.putIfAbsent(name, new TreeMap());
                ((Map)chunkEntries.get(name)).put(chunkIndex, value);
                continue;
            }
            String[] decodedPair = SupplementalInfoHelper.decode(string);
            if (decodedPair == null) continue;
            result.putIfAbsent(decodedPair[0], decodedPair[1]);
        }
        if (!chunkEntries.isEmpty()) {
            for (Map.Entry entry : chunkEntries.entrySet()) {
                String joinedValues = String.join((CharSequence)"", ((Map)entry.getValue()).values());
                result.putIfAbsent((String)entry.getKey(), joinedValues);
            }
        }
        return result;
    }

    private static boolean validateEncodedSupplementalInfoValue(String encodedSupplementalInfo) {
        Matcher matcher = PATTERN.matcher(encodedSupplementalInfo);
        if (matcher.matches()) {
            int groupOneValue = Integer.parseInt(matcher.group(1));
            if (matcher.group(2).length() >= groupOneValue) {
                char keyValueSeparator = matcher.group(2).charAt(groupOneValue);
                return ':' == keyValueSeparator;
            }
        }
        return false;
    }

    private static int getIntegerLength(int a) {
        if (a < 100000) {
            if (a < 100) {
                if (a < 10) {
                    return 1;
                }
                return 2;
            }
            if (a < 1000) {
                return 3;
            }
            if (a < 10000) {
                return 4;
            }
            return 5;
        }
        if (a < 10000000) {
            if (a < 1000000) {
                return 6;
            }
            return 7;
        }
        if (a < 100000000) {
            return 8;
        }
        if (a < 1000000000) {
            return 9;
        }
        return 10;
    }
}

