/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class UserKeyAttrMapping
extends AttributeMapping {
    private static final long serialVersionUID = 1L;
    protected AttributeContract targetContract;

    public UserKeyAttrMapping() {
        super(new AttributeMapping());
    }

    public UserKeyAttrMapping(UserKeyAttrMapping copy) {
        super(copy);
        this.targetContract = copy.targetContract != null ? new AttributeContract(copy.targetContract) : null;
    }

    public UserKeyAttrMapping(AttributeMapping mapping, AttributeContract contract) {
        super(mapping);
        this.targetContract = contract;
    }

    public UserKeyAttributes execMapping(AttributeMap srcAttributes, AttributeMap contextAttributes) throws AttrLookupException, AuthorizationException, ProcessRuntimeException {
        return this.execMapping(srcAttributes, contextAttributes, false);
    }

    public UserKeyAttributes execMapping(AttributeMap srcAttributes, AttributeMap contextAttributes, boolean skipAuthorization) throws AttrLookupException, AuthorizationException, ProcessRuntimeException {
        AttributeMap attrs = this.executeMapping(srcAttributes, this.targetContract.getImmutableAttributeNames(), contextAttributes, skipAuthorization);
        UserKeyAttributes userKeyAttributes = new UserKeyAttributes(attrs);
        if (StringUtils.isBlank((String)userKeyAttributes.getUserKeyValue())) {
            throw new ProcessRuntimeException("Mapping into unique user key resulted in null or empty value from source attributes");
        }
        return userKeyAttributes;
    }
}

