/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.PersistentGrantHelper;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class UserKeyToAccessTokenMapping
extends AccessTokenMapping {
    public static final String EXPIRES_AT = "EXPIRES_AT";
    private static final long serialVersionUID = 1L;

    public UserKeyToAccessTokenMapping() {
        this.setContextId("default");
    }

    public UserKeyToAccessTokenMapping(AccessTokenMapping other) {
        super(other);
        this.setContextId(other.getContextId());
        this.setTokenManagerId(other.getTokenManagerId());
    }

    public static String getContextId(String id) {
        return StringUtils.substringBeforeLast((String)id, (String)"|");
    }

    public static String getTokenManagerId(String id) {
        return StringUtils.substringAfterLast((String)id, (String)"|");
    }

    public AttributeMap execMapping(String userKey, AccessGrantAttributesHolder grantAttrsHolder, AttributeMap contextMap, AccessGrant accessGrant, String grantType) throws AttrLookupException, AuthorizationException {
        UserKeyAttributes completeSourceAttrs = new UserKeyAttributes(userKey);
        if (grantAttrsHolder.getExtendedGrantAttrs() != null) {
            completeSourceAttrs.putAll((Map)grantAttrsHolder.getExtendedGrantAttrs());
        }
        if (!this.isDefaultContextMapping() && grantAttrsHolder.getAuthnContextAttrs() != null) {
            for (Map.Entry entry : grantAttrsHolder.getAuthnContextAttrs().entrySet()) {
                completeSourceAttrs.put(this.getContextAttrPrefix() + "." + (String)entry.getKey(), (AttributeValue)entry.getValue());
            }
        }
        if (!"implicit".equals(grantType)) {
            Client client = this.extractClient(contextMap);
            AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
            PersistentGrantHelper.addExpiresAtToAttributeMap(accessGrant, client, authzServerManager, completeSourceAttrs);
        }
        return super.executeMapping(completeSourceAttrs, null, contextMap);
    }

    private Client extractClient(AttributeMap contextMap) {
        Client result = null;
        AttributeValue clientIdAttributeValue = (AttributeValue)contextMap.get((Object)SourceContextType.OAUTH_CLIENT.getId());
        if (clientIdAttributeValue != null) {
            String clientId = clientIdAttributeValue.getValue();
            result = MgmtFactory.getClientManager().getCachedClient(clientId);
        }
        return result;
    }

    public static AttributeMap pruneUnreferencedAttrs(AttributeMap userAttrs, String contextId) {
        if (userAttrs == null) {
            return null;
        }
        AttributeMap result = new AttributeMap();
        HashSet<String> referencedContextAttrs = new HashSet<String>();
        for (AccessTokenMapping accessTokenMapping : MgmtFactory.getAuthzServerManager().getUserKeyToAccessTokenMappingsForContext(contextId)) {
            referencedContextAttrs.addAll(accessTokenMapping.getReferencedContextAttrs());
        }
        for (Map.Entry entry : userAttrs.entrySet()) {
            if (!referencedContextAttrs.contains(entry.getKey())) continue;
            result.put((String)entry.getKey(), (AttributeValue)entry.getValue());
        }
        return result;
    }

    public static void determineAllowedContexts(Client client, MutableBoolean allowAllContexts, Set<String> allowedContextIds) {
        Collection<UserKeyToAccessTokenMapping> mappings = MgmtFactory.getAuthzServerManager().getUserKeyToAccessTokenMappings();
        for (UserKeyToAccessTokenMapping mapping : mappings) {
            BearerAccessTokenMgmtPluginInstance atmInstance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(mapping.getTokenManagerId());
            if (!atmInstance.isClientAllowed(client.getClientId())) continue;
            if (mapping.isDefaultContextMapping()) {
                allowAllContexts.setValue(true);
                return;
            }
            allowedContextIds.add(mapping.getContextId());
        }
    }

    @Override
    public String getAttrValueForDisplay(AttrMappingValue value) {
        switch (value.getType()) {
            case ADAPTER: 
            case IDP_CONNECTION: 
            case PASSWORD_CREDENTIAL_VALIDATOR: 
            case AUTHENTICATION_POLICY_CONTRACT: {
                return StringUtils.substringAfter((String)value.getValue(), (String)".");
            }
        }
        return value.getValue();
    }
}

